(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Stmt.i3                                               *)
(* Last Modified On Fri Aug 23 00:01:12 1991 By kalsow         *)
(*      Modified On Tue Jan 16 06:44:23 1990 By muller         *)

INTERFACE Stmt;

IMPORT M3, Token;

TYPE
  T = M3.Stmt;
  CheckState = M3.CheckState;

TYPE
  Outcome = {FallThrough, Exits, Returns};
  Outcomes = SET OF Outcome;

PROCEDURE Parse (READONLY fail: Token.Set): T;

PROCEDURE TypeCheck (t: T;  VAR cs: CheckState);

PROCEDURE Compile (t: T): Outcomes;

PROCEDURE GetOutcome (t: T): Outcomes;

END Stmt.




