(* Copyright (C) 1992, Digital Equipment Corporation                *)
(* All rights reserved.                                             *)
(* See the file COPYRIGHT for a full description.                   *)

(* Created by stolfi on Thu Sep 15 02:51:58 1988                    *)
(* Last modified on Tue Jun  2 13:51:19 PDT 1992 by stolfi          *)
(*      modified on Tue Feb 11 21:39:45 PST 1992 by muller          *)

UNSAFE MODULE Intensity;

PROCEDURE Equal (
    a, b: T; 
    err: REAL := 1.0e-06; 
    small: REAL := 1.0e-30;
  ): BOOLEAN =
  VAR m: REAL;
  BEGIN
    m := MAX (ABS (a), MAX (ABS (b), small));
    RETURN ABS (a / m - b / m) <= err
  END Equal;

PROCEDURE ToBytes (x: T): Bytes = 
  BEGIN 
    RETURN LOOPHOLE (x, Bytes) 
  END ToBytes;

BEGIN
  <* ASSERT BITSIZE(T) MOD 8 = 0 *>    (* Assumed by ToBytes, Hash *)
END Intensity.

