(*
   ComplexClient.m3
   Example Sun RPC program.
   Marvin Theimer, Xerox PARC
   March, 1992

   $Id: ComplexClient.m3,v 1.2 1992/04/01 02:16:23 nichols Exp $
*)

(* Copyright (c) 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

MODULE Main;

IMPORT RPC, RPCSun, fortytwo, fourtwo, Ctypes, ParseParams, Scan;
IMPORT Wr, Fmt, Thread;
FROM Stdio IMPORT stdout, stderr;

<* FATAL Wr.Failure, Thread.Alerted *>

VAR
  hostName := "localhost";
  protocol := RPCSun.Protocol.UDP;

  b1             : RPCSun.BindingInfo;
  cl1            : fortytwo.FORTY_TWO_VERS_1;
  b2             : RPCSun.BindingInfo;
  cl2            : fortytwo.FORTY_TWO_VERS_2;
  b3             : RPCSun.BindingInfo;
  cl3            : fortytwo.TEST_TYPES_3;
  host           : INTEGER;
  anotherQuestion: REF ARRAY OF CHAR;
  ar             : fourtwo.answerRec;
  randomNumbers  : REF ARRAY OF INTEGER;
  tar            : fortytwo.trueAnswerRec;
  iVal           : INTEGER;
  Ar             : fortytwo.AnswerRec;
  k              : REF ARRAY OF fortytwo.tuple;
  l              : ARRAY [0 .. 2] OF CHAR;
  m              : REF ARRAY OF Ctypes.unsigned_char;
  rta            : fortytwo.randomTypes;

BEGIN
  TRY
    ParseParams.BeginParsing(stderr);
    IF ParseParams.KeywordPresent("-host") OR
	ParseParams.KeywordPresent("-h") THEN
      hostName := ParseParams.GetNext();
    END;
    IF ParseParams.KeywordPresent("-tcp") THEN
      protocol := RPCSun.Protocol.TCP;
    END;
    IF ParseParams.KeywordPresent("-udp") THEN
      protocol := RPCSun.Protocol.UDP;
    END;
    ParseParams.EndParsing();
    Wr.PutText(stdout, "Start of fortytwoClient\n");

    host := RPCSun.LookupHost(hostName);
    b1 := RPCSun.CreateBindingInfo(
            host, fortytwo.FORTY_TWO_PROG_prognum,
            fortytwo.FORTY_TWO_VERS_1_versnum, 0, protocol);
    cl1 := fortytwo.ImportFORTY_TWO_VERS_1(b1);

    b2 := RPCSun.CreateBindingInfo(
            host, fortytwo.FORTY_TWO_PROG_prognum,
            fortytwo.FORTY_TWO_VERS_2_versnum, 0, protocol);
    cl2 := fortytwo.ImportFORTY_TWO_VERS_2(b2);

    b3 :=
      RPCSun.CreateBindingInfo(host, fortytwo.TEST_TYPES_PROG_prognum,
                               fortytwo.TEST_TYPES_3_versnum, 0, protocol);
    cl3 := fortytwo.ImportTEST_TYPES_3(b3);


    Wr.PutText(stdout, "\nAbout to call cl1.get_answer\n");
    anotherQuestion := NEW(REF ARRAY OF CHAR, 5);
    anotherQuestion^[0] := '7';
    anotherQuestion^[1] := 'x';
    anotherQuestion^[2] := '1';
    anotherQuestion^[3] := '0';
    anotherQuestion^[4] := '\000';
    ar := cl1.GET_ANSWER("6x9", 13, anotherQuestion);
    Wr.PutText(stdout, Fmt.F("theAnswer: %s\n", Fmt.Int(ar.theAnswer)));
    Wr.PutText(
      stdout, Fmt.F("aDifferentAnswer: %s\n", ar.aDifferentAnswer));
    Wr.PutText(stdout, Fmt.F("anotherAnswer: (%s) %s%s%s\n",
                             Fmt.Int(NUMBER(ar.anotherAnswer^)),
                             Fmt.Char(ar.anotherAnswer^[0]),
                             Fmt.Char(ar.anotherAnswer^[1]),
                             Fmt.Char(ar.anotherAnswer^[2])));
    Wr.PutText(stdout, Fmt.F("anotherDifferentAnswer: %s\n",
                             Fmt.Int(ar.anotherDifferentAnswer^)));

    Wr.PutText(stdout, "\nAbout to call cl1.get_true_answer\n");
    randomNumbers := NEW(REF ARRAY OF INTEGER, 1);
    randomNumbers[0] := 17;
    tar :=
      cl1.GET_TRUE_ANSWER(fortytwo.QuestionType_cosmic, randomNumbers);
    Wr.PutText(stdout, Fmt.F("tellingTheTruth: %s\n",
                             Fmt.Bool(tar.tellingTheTruth)));
    Wr.PutText(
      stdout, Fmt.F("theTruth: (%s, %s, %s)\n", Fmt.Int(tar.theTruth[0]),
                    Fmt.Int(tar.theTruth[1]), Fmt.Int(tar.theTruth[2])));
    Wr.PutText(
      stdout, Fmt.F("theTRUTH (%s) ", Fmt.Int(tar.theTRUTH.truthType)));
    TYPECASE tar.theTRUTH OF
      fortytwo.TheANSWER_cosmic (v) =>
        Wr.PutText(stdout, Fmt.F("{%s}\n", Fmt.Int(v.c)));
    ELSE
      Wr.PutText(stdout, "***ERROR***: theTRUTH isnt!!!\n");
    END;

    Wr.PutText(stdout, "\nAbout to call cl1.get_bogus_answer\n");
    iVal := cl1.GET_BOGUS_ANSWER();
    Wr.PutText(stdout, Fmt.F("return val: %s\n", Fmt.Int(iVal)));

    Wr.PutText(stdout, "\nAbout to call cl1.dont_answer\n");
    iVal := 10;
    cl1.DONT_ANSWER(iVal);

    Wr.PutText(stdout, "\nAbout to call cl2.get_the_answer\n");
    randomNumbers := NEW(REF ARRAY OF INTEGER, 2);
    randomNumbers[0] := 512;
    randomNumbers[1] := 513;
    Ar := cl2.GET_THE_ANSWER(fortytwo.QuestionType_silly, randomNumbers);
    Wr.PutText(
      stdout, Fmt.F("tellingTheTruth: %s\n", Fmt.Bool(Ar.tellingTheTruth)));
    Wr.PutText(
      stdout, Fmt.F("theTruth: (%s, %s, %s)\n", Fmt.Int(Ar.theTruth[0]),
                    Fmt.Int(Ar.theTruth[1]), Fmt.Int(Ar.theTruth[2])));
    Wr.PutText(
      stdout, Fmt.F("theTRUTH (%s) ", Fmt.Int(Ar.theTRUTH.truthType)));
    TYPECASE Ar.theTRUTH OF
      fortytwo.TheANSWER_Default (v) =>
        Wr.PutText(stdout,
                   Fmt.F("{%s, %s, ..., %s}\n", Fmt.Int(v.d.theAnswer),
                         v.d.aDifferentAnswer,
                         Fmt.Int(v.d.anotherDifferentAnswer^)));
    ELSE
      Wr.PutText(stdout, "***ERROR***: theTRUTH isnt!!!\n");
    END;

    Wr.PutText(stdout, "\nAbout to call cl3.do_test\n");
    k := NEW(REF ARRAY OF fortytwo.tuple, 2);
    k^[0].x := -1;
    k^[0].y := -1;
    k^[1].x := 1;
    k^[1].y := 1;
    l[0] := 'x';
    l[1] := 'x';
    l[2] := 'x';
    m := NEW(REF ARRAY OF Ctypes.unsigned_char, 2);
    m^[0] := 81;
    m^[1] := 82;
    rta := cl3.DO_TEST(3.1416E0, 2.71828D0, 'c', 13, 42, 137, 129, 14, 43,
                       138, k, l, m);
    Wr.PutText(stdout, Fmt.F("a: %s\n", Fmt.Real(rta.a)));
    Wr.PutText(stdout, Fmt.F("b: %s\n", Fmt.LongReal(rta.b)));
    Wr.PutText(stdout, Fmt.F("c: %s\n", Fmt.Char(rta.c)));
    Wr.PutText(stdout, Fmt.F("d: %s\n", Fmt.Int(rta.d)));
    Wr.PutText(stdout, Fmt.F("e: %s\n", Fmt.Int(rta.e)));
    Wr.PutText(stdout, Fmt.F("f: %s\n", Fmt.Int(rta.f)));
    Wr.PutText(stdout, Fmt.F("g: %s\n", Fmt.Int(rta.g)));
    Wr.PutText(stdout, Fmt.F("h: %s\n", Fmt.Int(rta.h)));
    Wr.PutText(stdout, Fmt.F("i: %s\n", Fmt.Int(rta.i)));
    Wr.PutText(stdout, Fmt.F("j: %s\n", Fmt.Int(rta.j)));
    Wr.PutText(stdout, Fmt.F("k: (%s) {(%s, %s), (%s, %s)}\n",
                             Fmt.Int(NUMBER(rta.k^)), Fmt.Int(rta.k^[0].x),
                             Fmt.Int(rta.k^[0].y), Fmt.Int(rta.k^[1].x),
                             Fmt.Int(rta.k^[1].y)));
    Wr.PutText(stdout, Fmt.F("l: {%s%s%s}\n", Fmt.Char(rta.l[0]),
                             Fmt.Char(rta.l[1]), Fmt.Char(rta.l[2])));
    Wr.PutText(stdout, Fmt.F("m: (%s) {%s, %s}\n", Fmt.Int(NUMBER(rta.m^)),
                             Fmt.Int(rta.m^[0]), Fmt.Int(rta.m^[1])));

  EXCEPT
    Scan.BadFormat =>
      Wr.PutText(stderr, "Usage: SimpleClient -h host [ -tcp | -udp ]\n");
  | RPC.Failed (e) => Wr.PutText(stderr, "RPC failure: " & e.info & "\n");
  END;
END Main.
