(*
   RPCSunPriv.i3
   SunRPC internal stuff.
   David Nichols, Xerox PARC
   July, 1991

   $Id: RPCSunPriv.i3,v 1.4 1992/05/20 22:11:15 nichols Exp $
*)

(* Copyright (c) 1991, 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

INTERFACE RPCSunPriv;

IMPORT RPC, RPCSun, Thread, Uin, XDR;

CONST
  (* Current RPC version. *)
  RPCVERS = 2;
  (* Messages types. *)
  CALLMSG  = 0;
  REPLYMSG = 1;
  (* Reply types. *)
  MSG_ACCEPTED = 0;
  MSG_DENIED   = 1;
  (* Accepted return codes. *)
  ACCEPT_SUCCESS       = 0;     (* RPC executed successfully *)
  ACCEPT_PROG_UNAVAIL  = 1;     (* remote hasn't exported program *)
  ACCEPT_PROG_MISMATCH = 2;     (* remote can't support version # *)
  ACCEPT_PROC_UNAVAIL  = 3;     (* program can't support procedure *)
  ACCEPT_GARBAGE_ARGS  = 4;     (* procedure can't decode params *)
  (* Rejection return codes *)
  REJECT_RPC_MISMATCH = 0;      (* RPC version number # 2 *)
  REJECT_AUTH_ERROR   = 1;      (* remote can't authenticate caller *)
  (* Auth failure reasons. *)
  AUTH_BADCRED       = 1;       (* bad credentials *)
  AUTH_REJECTEDCRED  = 2;       (* client must begin new session *)
  AUTH_BADVERF       = 3;       (* bad verifier *)
  AUTH_REJECTED_VERF = 4;       (* verifier expired or replayed *)
  AUTH_TOOWEAK       = 5;       (* rejected for security reasons *)
  (* Authentication types. *)
  AUTH_NULL  = 0;
  AUTH_UNIX  = 1;
  AUTH_SHORT = 2;
  AUTH_DES   = 3;
  (* Port mapper constants. *)
  PMProg = 100000;
  PMVers = 2;

REVEAL
  RPCSun.BindingInfo = BRANDED REF RECORD
                                     hostAddr   : INTEGER;
                                     port       : INTEGER;
                                     progNum    : INTEGER;
                                     progVersion: INTEGER;
                                     proto      : RPCSun.Protocol;
                                   END;

TYPE Credentials = BRANDED OBJECT END;

(* Header marshalling routines. *)
PROCEDURE PutCallHeader (s                    : XDR.Sink;
                         xid, prog, vers, proc: INTEGER;
                         cred, verf           : Credentials)
  RAISES {XDR.Failed, Thread.Alerted};
PROCEDURE GetCallHeader (    s                    : XDR.Source;
                         VAR xid, prog, vers, proc: INTEGER;
                         VAR cred, verf           : Credentials )
  RAISES {RPC.Failed, XDR.Failed, Thread.Alerted, HeaderError};
EXCEPTION HeaderError;

PROCEDURE PutReplyHeader (s                 : XDR.Sink;
                          xid, accept, code : INTEGER;
                          authWhy, low, high              := 0;
                          verf              : Credentials := NIL)
  RAISES {XDR.Failed, Thread.Alerted};
PROCEDURE GetReplyHeader (    s                    : XDR.Source;
                          VAR xid                  : INTEGER;
                          VAR accept, code, authWhy: INTEGER;
                          VAR low, high            : INTEGER;
                          VAR verf                 : Credentials )
  RAISES {RPC.Failed, XDR.Failed, Thread.Alerted};

(* Import a service. *)
PROCEDURE TCPImportService (bi: RPCSun.BindingInfo): RPCSun.Client
  RAISES {RPC.Failed};
PROCEDURE UDPImportService (bi: RPCSun.BindingInfo): RPCSun.Client
  RAISES {RPC.Failed};

(* Initialize a struct_sockaddr_in. *)
PROCEDURE SetAddr (VAR addr: Uin.struct_sockaddr_in; host, port: INTEGER);

(* Deduce port number from a socket. *)
PROCEDURE GetHostPortFromSocket (s: INTEGER; VAR host, port: INTEGER)
  RAISES {RPCSun.Erred, RPC.Failed};

(* Get a listing TCP socket at a particular port. *)
PROCEDURE GetListeningSocket (port: INTEGER): INTEGER RAISES {RPC.Failed};

(* Get a generic UDP socket. *)
PROCEDURE GetUDPSocket (port := 0): INTEGER RAISES {RPC.Failed};

(* Register with the port mapper.  If prog is RPCSun.TransientProgram, then
   pick a transient program number and return its value in prog. *)
PROCEDURE PortMapperRegister (VAR (*in/out*) prog      : INTEGER;
                                             vers, port: INTEGER;
                                             protocol  : RPCSun.Protocol)
  RAISES {RPCSun.Erred, RPC.Failed, Thread.Alerted};

(* Find our local internet address. *)
<*EXTERNAL*> PROCEDURE GetLocalInetAddr (): INTEGER;

END RPCSunPriv.
