(*
   MultiClient.m3
   Example Sun RPC program.
   Marvin Theimer, Xerox PARC
   March, 1992

   $Id: MultiClient.m3,v 1.2 1992/04/01 02:16:23 nichols Exp $
*)

(* Copyright (c) 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

MODULE Main;

(*
 * MultiClient:
 *   Used with stub files generated from
 *       m3rpcgen [-f] multiprog.x
 *       m3rpcgen [-f] multidefns.x
 *)

IMPORT RPC, RPCSun, multiprog, multidefns, Thread;

IMPORT ParseParams, Scan, Wr, Fmt;
FROM Stdio IMPORT stdout, stderr;

<* FATAL Wr.Failure, Thread.Alerted *>

VAR
  b1, b2: RPCSun.BindingInfo;
  cl1   : multiprog.multiprog_Vers_1;
  cl2   : multiprog.multiprog_Vers_2;

  HostName: TEXT := "localhost";

  l      : INTEGER := 13;
  m      : INTEGER := 42;
  addList          := NEW(multidefns.multidefns_IntList, 3);
  n      : INTEGER;

BEGIN
  TRY
    Wr.PutText(stdout, "Start of MultiClient\n");

    ParseParams.BeginParsing(stderr);
    IF ParseParams.KeywordPresent("-h") THEN
      HostName := ParseParams.GetNext();
    END;
    ParseParams.EndParsing();

    b1 :=
      RPCSun.CreateBindingInfo(
        RPCSun.LookupHost(HostName), multiprog.multiprog_MultiProg_prognum,
        multiprog.multiprog_Vers_1_versnum, 0, RPCSun.Protocol.UDP);
    cl1 := multiprog.Importmultiprog_Vers_1(b1);

    n := cl1.multiprog_Add(multidefns.multidefns_TwoInts{l, m});
    Wr.PutText(stdout, Fmt.F("multiprog_Add1(%s, %s) -> %s\n", Fmt.Int(l),
                             Fmt.Int(m), Fmt.Int(n)));

    b2 :=
      RPCSun.CreateBindingInfo(
        RPCSun.LookupHost(HostName), multiprog.multiprog_MultiProg_prognum,
        multiprog.multiprog_Vers_2_versnum, 0, RPCSun.Protocol.UDP);
    cl2 := multiprog.Importmultiprog_Vers_2(b2);

    n := cl2.multiprog_Add(multidefns.multidefns_TwoInts{l, m});
    Wr.PutText(stdout, Fmt.F("multiprog_Add2(%s, %s) -> %s\n", Fmt.Int(l),
                             Fmt.Int(m), Fmt.Int(n)));

    addList[0] := 1;
    addList[1] := 3;
    addList[2] := 7;
    n := cl2.multiprog_AddList(addList);
    Wr.PutText(stdout, Fmt.F("multiprog_Add2(%s, %s, %s) -> %s\n",
                             Fmt.Int(addList[0]), Fmt.Int(addList[1]),
                             Fmt.Int(addList[2]), Fmt.Int(n)));

    Wr.PutText(stdout, "End of MultiClient\n");
  EXCEPT
    Scan.BadFormat => Wr.PutText(stderr, "Usage: MultiClient -h host\n");
  | RPC.Failed (e) => Wr.PutText(stderr, "RPC failure: " & e.info & "\n");
  END;
END Main.
