(*
   StripMultiClient.m3
   Example Sun RPC program.
   Marvin Theimer, Xerox PARC
   March, 1992

   $Id: StripMultiClient.m3,v 1.2 1992/04/01 02:16:23 nichols Exp $
*)

(* Copyright (c) 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

MODULE Main;

(*
 * StripMultiClient:
 *   Used with stub files generated from
 *       m3rpcgen -p [-f] stripmultiprog.x
 *       m3rpcgen -p [-f] stripmultidefns.x
 *)

IMPORT RPC, RPCSun, stripmultiprog, stripmultidefns, Thread;

IMPORT ParseParams, Scan, Wr, Fmt;
FROM Stdio IMPORT stdout, stderr;

<* FATAL Wr.Failure, Thread.Alerted *>

VAR
  b1, b2: RPCSun.BindingInfo;
  cl1   : stripmultiprog.Vers_1;
  cl2   : stripmultiprog.Vers_2;

  HostName: TEXT := "localhost";

  l      : INTEGER := 13;
  m      : INTEGER := 42;
  addList          := NEW(stripmultidefns.IntList, 3);
  n      : INTEGER;

BEGIN
  TRY
    Wr.PutText(stdout, "Start of StripMultiClient\n");

    ParseParams.BeginParsing(stderr);
    IF ParseParams.KeywordPresent("-h") THEN
      HostName := ParseParams.GetNext();
    END;
    ParseParams.EndParsing();

    b1 := RPCSun.CreateBindingInfo(
            RPCSun.LookupHost(HostName), stripmultiprog.MultiProg_prognum,
            stripmultiprog.Vers_1_versnum, 0, RPCSun.Protocol.UDP);
    cl1 := stripmultiprog.ImportVers_1(b1);

    n := cl1.Add(stripmultidefns.TwoInts{l, m});
    Wr.PutText(stdout, Fmt.F("Add1(%s, %s) -> %s\n", Fmt.Int(l),
                             Fmt.Int(m), Fmt.Int(n)));

    b2 := RPCSun.CreateBindingInfo(
            RPCSun.LookupHost(HostName), stripmultiprog.MultiProg_prognum,
            stripmultiprog.Vers_2_versnum, 0, RPCSun.Protocol.UDP);
    cl2 := stripmultiprog.ImportVers_2(b2);

    n := cl2.Add(stripmultidefns.TwoInts{l, m});
    Wr.PutText(stdout, Fmt.F("Add2(%s, %s) -> %s\n", Fmt.Int(l),
                             Fmt.Int(m), Fmt.Int(n)));

    addList[0] := 1;
    addList[1] := 3;
    addList[2] := 7;
    n := cl2.AddList(addList);
    Wr.PutText(
      stdout, Fmt.F("Add2(%s, %s, %s) -> %s\n", Fmt.Int(addList[0]),
                    Fmt.Int(addList[1]), Fmt.Int(addList[2]), Fmt.Int(n)));

    Wr.PutText(stdout, "End of StripMultiClient\n");

  EXCEPT
    Scan.BadFormat =>
      Wr.PutText(stderr, "Usage: StripMultiClient -h host\n");
  | RPC.Failed (e) => Wr.PutText(stderr, "RPC failure: " & e.info & "\n");
  END;
END Main.
