/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.EnumSet;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.AddStyle;
import net.sourceforge.plantuml.graphic.ColorAndSizeChange;
import net.sourceforge.plantuml.graphic.ColorChange;
import net.sourceforge.plantuml.graphic.ExposantChange;
import net.sourceforge.plantuml.graphic.FontFamilyChange;
import net.sourceforge.plantuml.graphic.FontPosition;
import net.sourceforge.plantuml.graphic.FontStyle;
import net.sourceforge.plantuml.graphic.HtmlCommand;
import net.sourceforge.plantuml.graphic.Img;
import net.sourceforge.plantuml.graphic.RemoveStyle;
import net.sourceforge.plantuml.graphic.ResetFont;
import net.sourceforge.plantuml.graphic.SizeChange;
import net.sourceforge.plantuml.graphic.Splitter;
import net.sourceforge.plantuml.graphic.SpriteCommand;
import net.sourceforge.plantuml.graphic.SvgAttributesChange;
import net.sourceforge.plantuml.graphic.Text;
import net.sourceforge.plantuml.graphic.TextLink;

class HtmlCommandFactory {
    static final Pattern addStyle;
    static final Pattern removeStyle;
    private Pattern htmlTag = MyPattern.cmpile(Splitter.htmlTag, 2);

    HtmlCommandFactory() {
    }

    HtmlCommand getHtmlCommand(String string) {
        if (!this.htmlTag.matcher(string).matches()) {
            return new Text(string);
        }
        if (MyPattern.mtches(string, "\\<img\\s+(src[%s]*=[%s]*[%q%g]?[^\\s%g>]+[%q%g]?[%s]*|vspace\\s*=\\s*[%q%g]?\\d+[%q%g]?\\s*|valign[%s]*=[%s]*[%q%g]?(top|middle|bottom)[%q%g]?[%s]*)+\\>")) {
            return Img.getInstance(string, true);
        }
        if (MyPattern.mtches(string, "\\<img[\\s:]+([^>]+)/?\\>")) {
            return Img.getInstance(string, false);
        }
        if (addStyle.matcher(string).matches()) {
            return new AddStyle(string);
        }
        if (removeStyle.matcher(string).matches()) {
            return new RemoveStyle(FontStyle.getStyle(string));
        }
        if (MyPattern.mtches(string, "\\<font(\\s+size[%s]*=[%s]*[%g]?\\d+[%g]?|[%s]+color[%s]*=\\s*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?)+[%s]*\\>")) {
            return new ColorAndSizeChange(string);
        }
        if (MyPattern.mtches(string, "\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>")) {
            return new ColorChange(string);
        }
        if (MyPattern.mtches(string, "\\<size[\\s:]+(\\d+)[%s]*\\>")) {
            return new SizeChange(string);
        }
        if (MyPattern.mtches(string, "\\<sup\\>")) {
            return new ExposantChange(FontPosition.EXPOSANT);
        }
        if (MyPattern.mtches(string, "\\<sub\\>")) {
            return new ExposantChange(FontPosition.INDICE);
        }
        if (MyPattern.mtches(string, "\\</font\\>|\\</color\\>|\\</size\\>|\\</text\\>")) {
            return new ResetFont();
        }
        if (MyPattern.mtches(string, "\\</sup\\>|\\</sub\\>")) {
            return new ExposantChange(FontPosition.NORMAL);
        }
        if (MyPattern.mtches(string, "\\<font[\\s:]+([^>]+)/?\\>")) {
            return new FontFamilyChange(string);
        }
        if (MyPattern.mtches(string, "\\<\\$[\\p{L}0-9_]+\\>")) {
            return new SpriteCommand(string);
        }
        if (MyPattern.mtches(string, "\\[\\[([^\\[\\]]+)\\]\\]")) {
            UrlBuilder urlBuilder = new UrlBuilder(null, UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(string);
            url.setMember(true);
            return new TextLink(url);
        }
        if (MyPattern.mtches(string, "\\<text[\\s:]+([^>]+)/?\\>")) {
            return new SvgAttributesChange(string);
        }
        return null;
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (FontStyle fontStyle : EnumSet.allOf(FontStyle.class)) {
            if (fontStyle == FontStyle.PLAIN) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('|');
                stringBuilder2.append('|');
            }
            stringBuilder.append(fontStyle.getActivationPattern());
            stringBuilder2.append(fontStyle.getDeactivationPattern());
        }
        addStyle = MyPattern.cmpile(stringBuilder.toString(), 2);
        removeStyle = MyPattern.cmpile(stringBuilder2.toString(), 2);
    }
}

