# Generated by default/object.tt
package Paws::ConnectContactLens::CharacterOffsets;
  use Moose;
  has BeginOffsetChar => (is => 'ro', isa => 'Int', required => 1);
  has EndOffsetChar => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ConnectContactLens::CharacterOffsets

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ConnectContactLens::CharacterOffsets object:

  $service_obj->Method(Att1 => { BeginOffsetChar => $value, ..., EndOffsetChar => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ConnectContactLens::CharacterOffsets object:

  $result = $service_obj->Method(...);
  $result->Att1->BeginOffsetChar

=head1 DESCRIPTION

For characters that were detected as issues, where they occur in the
transcript.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BeginOffsetChar => Int

The beginning of the issue.


=head2 B<REQUIRED> EndOffsetChar => Int

The end of the issue.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ConnectContactLens>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

