package Bundle::MMS::Mail::Parser;

use warnings;
use strict;

our $VERSION = '0.03';

1; # End of Bundle::MMS::Mail::Parser

__END__

=head1 NAME

Bundle::MMS::Mail::Parser - Bundle of MMS parsing modules

=head1 SYNOPSIS

C<perl -MCPAN -e 'install Bundle::MMS::Mail::Parser'>

=head1 CONTENTS

MMS::Mail::Message
MMS::Mail::Message::Parsed
MMS::Mail::Provider
MMS::Mail::Provider::UKVodafone
MMS::Mail::Provider::UK02
MMS::Mail::Provider::UKOrange
MMS::Mail::Provider::UKTMobile
MMS::Mail::Provider::UKVirgin
MMS::Mail::Parser

=head1 DESCRIPTION

The complete set of modules required to parse MMS mail messages.

=head1 AUTHOR

Rob Lee C<<robl at robl.co.uk>>

=head1 LICENSE

Copyright 2005 Rob Lee, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

To quote the perl artistic license ('perldoc perlartistic') :

10. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
    WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES
    OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

=cut



