# Generated by default/object.tt
package Paws::Appflow::GoogleAnalyticsConnectorProfileCredentials;
  use Moose;
  has AccessToken => (is => 'ro', isa => 'Str', request_name => 'accessToken', traits => ['NameInRequest']);
  has ClientId => (is => 'ro', isa => 'Str', request_name => 'clientId', traits => ['NameInRequest'], required => 1);
  has ClientSecret => (is => 'ro', isa => 'Str', request_name => 'clientSecret', traits => ['NameInRequest'], required => 1);
  has OAuthRequest => (is => 'ro', isa => 'Paws::Appflow::ConnectorOAuthRequest', request_name => 'oAuthRequest', traits => ['NameInRequest']);
  has RefreshToken => (is => 'ro', isa => 'Str', request_name => 'refreshToken', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::GoogleAnalyticsConnectorProfileCredentials

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::GoogleAnalyticsConnectorProfileCredentials object:

  $service_obj->Method(Att1 => { AccessToken => $value, ..., RefreshToken => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::GoogleAnalyticsConnectorProfileCredentials object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessToken

=head1 DESCRIPTION

The connector-specific profile credentials required by Google
Analytics.

=head1 ATTRIBUTES


=head2 AccessToken => Str

The credentials used to access protected Google Analytics resources.


=head2 B<REQUIRED> ClientId => Str

The identifier for the desired client.


=head2 B<REQUIRED> ClientSecret => Str

The client secret used by the OAuth client to authenticate to the
authorization server.


=head2 OAuthRequest => L<Paws::Appflow::ConnectorOAuthRequest>

The OAuth requirement needed to request security tokens from the
connector endpoint.


=head2 RefreshToken => Str

The credentials used to acquire new access tokens. This is required
only for OAuth2 access tokens, and is not required for OAuth1 access
tokens.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

