/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.db;

import java.sql.SQLException;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;

public class OnlineCompress {
    private OnlineCompress() {
    }

    public static void compressTable(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        try {
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            if (bl) {
                OnlineCompress.purgeRows(string, string2, dataDictionary, transactionController);
            }
            if (bl2) {
                OnlineCompress.defragmentRows(string, string2, dataDictionary, transactionController);
            }
            if (bl3) {
                OnlineCompress.truncateEnd(string, string2, dataDictionary, transactionController);
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void defragmentRows(String var0, String var1_1, DataDictionary var2_2, TransactionController var3_3) throws SQLException {
        block28: {
            block27: {
                var4_4 = null;
                var5_5 = 0;
                var6_6 /* !! */  = null;
                var7_7 = null;
                var8_8 = null;
                var9_9 = null;
                var10_10 = ConnectionUtil.getCurrentLCC();
                var11_11 = null;
                try {
                    try {
                        var12_12 = var2_2.getSchemaDescriptor(var0, var11_11, true);
                        var13_14 = var2_2.getTableDescriptor(var1_1, var12_12);
                        var11_11 = var3_3.startNestedUserTransaction(false);
                        if (var13_14 == null) {
                            throw StandardException.newException("42X05", var0 + "." + var1_1);
                        }
                        if (var13_14.getTableType() == 2) {
                            var26_15 = null;
                            break block27;
                        }
                        var14_24 = var13_14.getConglomerateDescriptor(var13_14.getHeapConglomerateId());
                        var15_25 = var10_10.getExecutionContext().getExecutionFactory().getValueRow(var13_14.getNumberOfColumns());
                        var16_26 = var13_14.getColumnDescriptorList();
                        var17_27 = var16_26.size();
                        for (var18_28 = 0; var18_28 < var17_27; ++var18_28) {
                            var19_30 = var16_26.elementAt(var18_28);
                            var15_25.setColumn(var19_30.getPosition(), var19_30.getType().getNull());
                        }
                        var18_29 = new DataValueDescriptor[100][];
                        var18_29[0] = var15_25.getRowArray();
                        var19_30 = new RowLocation[100];
                        var20_31 = new RowLocation[100];
                        var21_32 = var13_14.getConglomerateDescriptors();
                        var5_5 = var21_32.length - 1;
                        if (var5_5 > 0) {
                            var6_6 /* !! */  = new int[var5_5][];
                            var7_7 = new ScanController[var5_5];
                            var8_8 = new ConglomerateController[var5_5];
                            var9_9 = new DataValueDescriptor[var5_5][];
                            OnlineCompress.setup_indexes(var11_11, var13_14, var6_6 /* !! */ , var7_7, var8_8, var9_9);
                        }
                        var4_4 = var11_11.defragmentConglomerate(var13_14.getHeapConglomerateId(), false, true, 4, 7, 5);
                        var22_33 = 0;
                        while ((var22_33 = var4_4.fetchNextGroup(var18_29, var19_30, var20_31)) != 0) {
                            if (var5_5 <= 0) continue;
                            for (var23_34 = 0; var23_34 < var22_33; ++var23_34) {
                                for (var24_35 = 0; var24_35 < var5_5; ++var24_35) {
                                    OnlineCompress.fixIndex(var18_29[var23_34], var9_9[var24_35], var19_30[var23_34], var20_31[var23_34], var8_8[var24_35], var7_7[var24_35], var6_6 /* !! */ [var24_35]);
                                }
                            }
                        }
                        break block28;
                    }
                    catch (StandardException var12_13) {
                        throw PublicAPI.wrapStandardException(var12_13);
                    }
                }
                catch (Throwable var25_36) {
                    var26_17 = null;
                    try {
                        if (var4_4 != null) {
                            var4_4.close();
                            var4_4 = null;
                        }
                        if (var5_5 > 0) {
                            for (var27_22 = 0; var27_22 < var5_5; ++var27_22) {
                                if (var7_7 != null && var7_7[var27_22] != null) {
                                    var7_7[var27_22].close();
                                    var7_7[var27_22] = null;
                                }
                                if (var8_8 == null || var8_8[var27_22] == null) continue;
                                var8_8[var27_22].close();
                                var8_8[var27_22] = null;
                            }
                        }
                        if (var11_11 == null) throw var25_36;
                        var11_11.destroy();
                        throw var25_36;
                    }
                    catch (StandardException var27_23) {
                        throw PublicAPI.wrapStandardException(var27_23);
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 441->550)] { 
lbl76:
            // 1 sources

            if (var4_4 != null) {
                var4_4.close();
                var4_4 = null;
            }
            if (var5_5 > 0) {
                for (var27_18 = 0; var27_18 < var5_5; ++var27_18) {
                    if (var7_7 != null && var7_7[var27_18] != null) {
                        var7_7[var27_18].close();
                        var7_7[var27_18] = null;
                    }
                    if (var8_8 == null || var8_8[var27_18] == null) continue;
                    var8_8[var27_18].close();
                    var8_8[var27_18] = null;
                }
            }
            if (var11_11 == null) return;
            var11_11.destroy();
            return;
lbl91:
            // 1 sources

            catch (StandardException var27_19) {
                throw PublicAPI.wrapStandardException(var27_19);
            }
        }
        var26_16 = null;
        ** try [egrp 2[TRYBLOCK] [5 : 441->550)] { 
lbl96:
        // 1 sources

        if (var4_4 != null) {
            var4_4.close();
            var4_4 = null;
        }
        if (var5_5 > 0) {
            for (var27_20 = 0; var27_20 < var5_5; ++var27_20) {
                if (var7_7 != null && var7_7[var27_20] != null) {
                    var7_7[var27_20].close();
                    var7_7[var27_20] = null;
                }
                if (var8_8 == null || var8_8[var27_20] == null) continue;
                var8_8[var27_20].close();
                var8_8[var27_20] = null;
            }
        }
        if (var11_11 == null) return;
        var11_11.destroy();
        return;
lbl111:
        // 1 sources

        catch (StandardException var27_21) {
            throw PublicAPI.wrapStandardException(var27_21);
        }
    }

    private static void purgeRows(String string, String string2, DataDictionary dataDictionary, TransactionController transactionController) throws StandardException {
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, true);
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(string2, schemaDescriptor);
        if (tableDescriptor == null) {
            throw StandardException.newException("42X05", string + "." + string2);
        }
        if (tableDescriptor.getTableType() != 2) {
            ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
            for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
                ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i];
                transactionController.purgeConglomerate(conglomerateDescriptor.getConglomerateNumber());
            }
        }
    }

    private static void truncateEnd(String string, String string2, DataDictionary dataDictionary, TransactionController transactionController) throws StandardException {
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, true);
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(string2, schemaDescriptor);
        if (tableDescriptor == null) {
            throw StandardException.newException("42X05", string + "." + string2);
        }
        if (tableDescriptor.getTableType() != 2) {
            ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
            for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
                ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i];
                transactionController.compressConglomerate(conglomerateDescriptor.getConglomerateNumber());
            }
        }
    }

    private static void setup_indexes(TransactionController transactionController, TableDescriptor tableDescriptor, int[][] nArray, ScanController[] scanControllerArray, ConglomerateController[] conglomerateControllerArray, DataValueDescriptor[][] dataValueDescriptorArray) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        int n = 0;
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i];
            if (!conglomerateDescriptor.isIndex()) continue;
            scanControllerArray[n] = transactionController.openScan(conglomerateDescriptor.getConglomerateNumber(), true, 4, 7, 5, null, null, 0, null, null, 0);
            conglomerateControllerArray[n] = transactionController.openConglomerate(conglomerateDescriptor.getConglomerateNumber(), true, 4, 7, 5);
            int[] nArray2 = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
            int[] nArray3 = new int[nArray2.length];
            for (int j = 0; j < nArray2.length; ++j) {
                nArray3[j] = nArray2[j] - 1;
            }
            nArray[n] = nArray3;
            dataValueDescriptorArray[n] = new DataValueDescriptor[nArray2.length + 1];
            ++n;
        }
    }

    private static void fixIndex(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, RowLocation rowLocation, RowLocation rowLocation2, ConglomerateController conglomerateController, ScanController scanController, int[] nArray) throws StandardException {
        for (int i = 0; i < nArray.length; ++i) {
            dataValueDescriptorArray2[i] = dataValueDescriptorArray[nArray[i]];
        }
        dataValueDescriptorArray2[dataValueDescriptorArray2.length - 1] = rowLocation;
        scanController.reopenScan(dataValueDescriptorArray2, 1, null, dataValueDescriptorArray2, -1);
        if (scanController.next()) {
            scanController.delete();
        }
        dataValueDescriptorArray2[dataValueDescriptorArray2.length - 1] = rowLocation2;
        conglomerateController.insert(dataValueDescriptorArray2);
    }
}

