use utf8;
use strict;

use Test::More 'no_plan';
use lib 't/lib';

use TreePath;

my $conf = 't/conf/treewithrules.yml';

ok( my $tp = TreePath->new(  conf  => $conf, debug => 0  ),
    "New TreePath ( conf => $conf)");

ok($tp->add({ name => '/', type => 'type1'}, 0), 'add root');

my $roottype1 = $tp->root;
is($roottype1,$tp->tree->{1}, 'retrieve root');
isa_ok($roottype1, 'HASH', "root" );

ok(my $Atype1 = $tp->add({name => 'A1', type => 'type1'}, $roottype1), 'add Atype1 to root (type1)');

ok(my $Atype2 = $tp->add({name => 'A2', type => 'type2'}, $roottype1), 'add Atype2 to root (type1)');

my $Btype1 = {name => 'B1', type => 'type1'};
ok( ! $tp->add($Btype1, $Atype2), 'can not add Btype1 to Atype2 (see rules)');
ok( $Btype1 = $tp->add($Btype1, $Atype1), 'but can add Btype1 to Atype1');

my $Btype2 = {name => 'B2', type => 'type2'};
ok( $Btype2 = $tp->add($Btype2, $Atype2), 'can add Btype2 to Atype2 (see rules)');


ok( ! $tp->update($Btype2, { type => 'type1'} ), 'can not update Btype2 type');
is($Btype2->{type}, 'type2', 'Btype2 still has the type type2');


ok( ! $tp->move($Btype1, $Btype2 ), 'can not move Btype1 to Btype2');
ok( $Btype2 = $tp->move($Btype2, $Btype1 ), 'but can move Btype2 to Btype1');



unlink 't/test.db';
