#!perl -w
#
# Test file mode strings from Solaris /usr/xpg4/bin/ls.

use strict;
use Test::More;
plan tests => 4096;

use File::Listing;

while (<DATA>) {
    chomp;

    # Expected output value.

    my $expected = $. - 1;

    # This version of `ls' does not show whether the sticky bit (file mode bit
    # 01000 ) is set, so remove it from the expected output.

    $expected &= 06777;

    # Information text.

    my $text = sprintf('"%s" -> "%05o"', $_, $expected);

    # Get output and keep only permission (no file type info).

    my $got = File::Listing::file_mode($_);
    $got &= 07777;

    cmp_ok($got, '==', $expected, $text);
}

__DATA__
----------
---------x
--------w-
--------wx
-------r--
-------r-x
-------rw-
-------rwx
------x---
------x--x
------x-w-
------x-wx
------xr--
------xr-x
------xrw-
------xrwx
-----w----
-----w---x
-----w--w-
-----w--wx
-----w-r--
-----w-r-x
-----w-rw-
-----w-rwx
-----wx---
-----wx--x
-----wx-w-
-----wx-wx
-----wxr--
-----wxr-x
-----wxrw-
-----wxrwx
----r-----
----r----x
----r---w-
----r---wx
----r--r--
----r--r-x
----r--rw-
----r--rwx
----r-x---
----r-x--x
----r-x-w-
----r-x-wx
----r-xr--
----r-xr-x
----r-xrw-
----r-xrwx
----rw----
----rw---x
----rw--w-
----rw--wx
----rw-r--
----rw-r-x
----rw-rw-
----rw-rwx
----rwx---
----rwx--x
----rwx-w-
----rwx-wx
----rwxr--
----rwxr-x
----rwxrw-
----rwxrwx
---x------
---x-----x
---x----w-
---x----wx
---x---r--
---x---r-x
---x---rw-
---x---rwx
---x--x---
---x--x--x
---x--x-w-
---x--x-wx
---x--xr--
---x--xr-x
---x--xrw-
---x--xrwx
---x-w----
---x-w---x
---x-w--w-
---x-w--wx
---x-w-r--
---x-w-r-x
---x-w-rw-
---x-w-rwx
---x-wx---
---x-wx--x
---x-wx-w-
---x-wx-wx
---x-wxr--
---x-wxr-x
---x-wxrw-
---x-wxrwx
---xr-----
---xr----x
---xr---w-
---xr---wx
---xr--r--
---xr--r-x
---xr--rw-
---xr--rwx
---xr-x---
---xr-x--x
---xr-x-w-
---xr-x-wx
---xr-xr--
---xr-xr-x
---xr-xrw-
---xr-xrwx
---xrw----
---xrw---x
---xrw--w-
---xrw--wx
---xrw-r--
---xrw-r-x
---xrw-rw-
---xrw-rwx
---xrwx---
---xrwx--x
---xrwx-w-
---xrwx-wx
---xrwxr--
---xrwxr-x
---xrwxrw-
---xrwxrwx
--w-------
--w------x
--w-----w-
--w-----wx
--w----r--
--w----r-x
--w----rw-
--w----rwx
--w---x---
--w---x--x
--w---x-w-
--w---x-wx
--w---xr--
--w---xr-x
--w---xrw-
--w---xrwx
--w--w----
--w--w---x
--w--w--w-
--w--w--wx
--w--w-r--
--w--w-r-x
--w--w-rw-
--w--w-rwx
--w--wx---
--w--wx--x
--w--wx-w-
--w--wx-wx
--w--wxr--
--w--wxr-x
--w--wxrw-
--w--wxrwx
--w-r-----
--w-r----x
--w-r---w-
--w-r---wx
--w-r--r--
--w-r--r-x
--w-r--rw-
--w-r--rwx
--w-r-x---
--w-r-x--x
--w-r-x-w-
--w-r-x-wx
--w-r-xr--
--w-r-xr-x
--w-r-xrw-
--w-r-xrwx
--w-rw----
--w-rw---x
--w-rw--w-
--w-rw--wx
--w-rw-r--
--w-rw-r-x
--w-rw-rw-
--w-rw-rwx
--w-rwx---
--w-rwx--x
--w-rwx-w-
--w-rwx-wx
--w-rwxr--
--w-rwxr-x
--w-rwxrw-
--w-rwxrwx
--wx------
--wx-----x
--wx----w-
--wx----wx
--wx---r--
--wx---r-x
--wx---rw-
--wx---rwx
--wx--x---
--wx--x--x
--wx--x-w-
--wx--x-wx
--wx--xr--
--wx--xr-x
--wx--xrw-
--wx--xrwx
--wx-w----
--wx-w---x
--wx-w--w-
--wx-w--wx
--wx-w-r--
--wx-w-r-x
--wx-w-rw-
--wx-w-rwx
--wx-wx---
--wx-wx--x
--wx-wx-w-
--wx-wx-wx
--wx-wxr--
--wx-wxr-x
--wx-wxrw-
--wx-wxrwx
--wxr-----
--wxr----x
--wxr---w-
--wxr---wx
--wxr--r--
--wxr--r-x
--wxr--rw-
--wxr--rwx
--wxr-x---
--wxr-x--x
--wxr-x-w-
--wxr-x-wx
--wxr-xr--
--wxr-xr-x
--wxr-xrw-
--wxr-xrwx
--wxrw----
--wxrw---x
--wxrw--w-
--wxrw--wx
--wxrw-r--
--wxrw-r-x
--wxrw-rw-
--wxrw-rwx
--wxrwx---
--wxrwx--x
--wxrwx-w-
--wxrwx-wx
--wxrwxr--
--wxrwxr-x
--wxrwxrw-
--wxrwxrwx
-r--------
-r-------x
-r------w-
-r------wx
-r-----r--
-r-----r-x
-r-----rw-
-r-----rwx
-r----x---
-r----x--x
-r----x-w-
-r----x-wx
-r----xr--
-r----xr-x
-r----xrw-
-r----xrwx
-r---w----
-r---w---x
-r---w--w-
-r---w--wx
-r---w-r--
-r---w-r-x
-r---w-rw-
-r---w-rwx
-r---wx---
-r---wx--x
-r---wx-w-
-r---wx-wx
-r---wxr--
-r---wxr-x
-r---wxrw-
-r---wxrwx
-r--r-----
-r--r----x
-r--r---w-
-r--r---wx
-r--r--r--
-r--r--r-x
-r--r--rw-
-r--r--rwx
-r--r-x---
-r--r-x--x
-r--r-x-w-
-r--r-x-wx
-r--r-xr--
-r--r-xr-x
-r--r-xrw-
-r--r-xrwx
-r--rw----
-r--rw---x
-r--rw--w-
-r--rw--wx
-r--rw-r--
-r--rw-r-x
-r--rw-rw-
-r--rw-rwx
-r--rwx---
-r--rwx--x
-r--rwx-w-
-r--rwx-wx
-r--rwxr--
-r--rwxr-x
-r--rwxrw-
-r--rwxrwx
-r-x------
-r-x-----x
-r-x----w-
-r-x----wx
-r-x---r--
-r-x---r-x
-r-x---rw-
-r-x---rwx
-r-x--x---
-r-x--x--x
-r-x--x-w-
-r-x--x-wx
-r-x--xr--
-r-x--xr-x
-r-x--xrw-
-r-x--xrwx
-r-x-w----
-r-x-w---x
-r-x-w--w-
-r-x-w--wx
-r-x-w-r--
-r-x-w-r-x
-r-x-w-rw-
-r-x-w-rwx
-r-x-wx---
-r-x-wx--x
-r-x-wx-w-
-r-x-wx-wx
-r-x-wxr--
-r-x-wxr-x
-r-x-wxrw-
-r-x-wxrwx
-r-xr-----
-r-xr----x
-r-xr---w-
-r-xr---wx
-r-xr--r--
-r-xr--r-x
-r-xr--rw-
-r-xr--rwx
-r-xr-x---
-r-xr-x--x
-r-xr-x-w-
-r-xr-x-wx
-r-xr-xr--
-r-xr-xr-x
-r-xr-xrw-
-r-xr-xrwx
-r-xrw----
-r-xrw---x
-r-xrw--w-
-r-xrw--wx
-r-xrw-r--
-r-xrw-r-x
-r-xrw-rw-
-r-xrw-rwx
-r-xrwx---
-r-xrwx--x
-r-xrwx-w-
-r-xrwx-wx
-r-xrwxr--
-r-xrwxr-x
-r-xrwxrw-
-r-xrwxrwx
-rw-------
-rw------x
-rw-----w-
-rw-----wx
-rw----r--
-rw----r-x
-rw----rw-
-rw----rwx
-rw---x---
-rw---x--x
-rw---x-w-
-rw---x-wx
-rw---xr--
-rw---xr-x
-rw---xrw-
-rw---xrwx
-rw--w----
-rw--w---x
-rw--w--w-
-rw--w--wx
-rw--w-r--
-rw--w-r-x
-rw--w-rw-
-rw--w-rwx
-rw--wx---
-rw--wx--x
-rw--wx-w-
-rw--wx-wx
-rw--wxr--
-rw--wxr-x
-rw--wxrw-
-rw--wxrwx
-rw-r-----
-rw-r----x
-rw-r---w-
-rw-r---wx
-rw-r--r--
-rw-r--r-x
-rw-r--rw-
-rw-r--rwx
-rw-r-x---
-rw-r-x--x
-rw-r-x-w-
-rw-r-x-wx
-rw-r-xr--
-rw-r-xr-x
-rw-r-xrw-
-rw-r-xrwx
-rw-rw----
-rw-rw---x
-rw-rw--w-
-rw-rw--wx
-rw-rw-r--
-rw-rw-r-x
-rw-rw-rw-
-rw-rw-rwx
-rw-rwx---
-rw-rwx--x
-rw-rwx-w-
-rw-rwx-wx
-rw-rwxr--
-rw-rwxr-x
-rw-rwxrw-
-rw-rwxrwx
-rwx------
-rwx-----x
-rwx----w-
-rwx----wx
-rwx---r--
-rwx---r-x
-rwx---rw-
-rwx---rwx
-rwx--x---
-rwx--x--x
-rwx--x-w-
-rwx--x-wx
-rwx--xr--
-rwx--xr-x
-rwx--xrw-
-rwx--xrwx
-rwx-w----
-rwx-w---x
-rwx-w--w-
-rwx-w--wx
-rwx-w-r--
-rwx-w-r-x
-rwx-w-rw-
-rwx-w-rwx
-rwx-wx---
-rwx-wx--x
-rwx-wx-w-
-rwx-wx-wx
-rwx-wxr--
-rwx-wxr-x
-rwx-wxrw-
-rwx-wxrwx
-rwxr-----
-rwxr----x
-rwxr---w-
-rwxr---wx
-rwxr--r--
-rwxr--r-x
-rwxr--rw-
-rwxr--rwx
-rwxr-x---
-rwxr-x--x
-rwxr-x-w-
-rwxr-x-wx
-rwxr-xr--
-rwxr-xr-x
-rwxr-xrw-
-rwxr-xrwx
-rwxrw----
-rwxrw---x
-rwxrw--w-
-rwxrw--wx
-rwxrw-r--
-rwxrw-r-x
-rwxrw-rw-
-rwxrw-rwx
-rwxrwx---
-rwxrwx--x
-rwxrwx-w-
-rwxrwx-wx
-rwxrwxr--
-rwxrwxr-x
-rwxrwxrw-
-rwxrwxrwx
----------
---------x
--------w-
--------wx
-------r--
-------r-x
-------rw-
-------rwx
------x---
------x--x
------x-w-
------x-wx
------xr--
------xr-x
------xrw-
------xrwx
-----w----
-----w---x
-----w--w-
-----w--wx
-----w-r--
-----w-r-x
-----w-rw-
-----w-rwx
-----wx---
-----wx--x
-----wx-w-
-----wx-wx
-----wxr--
-----wxr-x
-----wxrw-
-----wxrwx
----r-----
----r----x
----r---w-
----r---wx
----r--r--
----r--r-x
----r--rw-
----r--rwx
----r-x---
----r-x--x
----r-x-w-
----r-x-wx
----r-xr--
----r-xr-x
----r-xrw-
----r-xrwx
----rw----
----rw---x
----rw--w-
----rw--wx
----rw-r--
----rw-r-x
----rw-rw-
----rw-rwx
----rwx---
----rwx--x
----rwx-w-
----rwx-wx
----rwxr--
----rwxr-x
----rwxrw-
----rwxrwx
---x------
---x-----x
---x----w-
---x----wx
---x---r--
---x---r-x
---x---rw-
---x---rwx
---x--x---
---x--x--x
---x--x-w-
---x--x-wx
---x--xr--
---x--xr-x
---x--xrw-
---x--xrwx
---x-w----
---x-w---x
---x-w--w-
---x-w--wx
---x-w-r--
---x-w-r-x
---x-w-rw-
---x-w-rwx
---x-wx---
---x-wx--x
---x-wx-w-
---x-wx-wx
---x-wxr--
---x-wxr-x
---x-wxrw-
---x-wxrwx
---xr-----
---xr----x
---xr---w-
---xr---wx
---xr--r--
---xr--r-x
---xr--rw-
---xr--rwx
---xr-x---
---xr-x--x
---xr-x-w-
---xr-x-wx
---xr-xr--
---xr-xr-x
---xr-xrw-
---xr-xrwx
---xrw----
---xrw---x
---xrw--w-
---xrw--wx
---xrw-r--
---xrw-r-x
---xrw-rw-
---xrw-rwx
---xrwx---
---xrwx--x
---xrwx-w-
---xrwx-wx
---xrwxr--
---xrwxr-x
---xrwxrw-
---xrwxrwx
--w-------
--w------x
--w-----w-
--w-----wx
--w----r--
--w----r-x
--w----rw-
--w----rwx
--w---x---
--w---x--x
--w---x-w-
--w---x-wx
--w---xr--
--w---xr-x
--w---xrw-
--w---xrwx
--w--w----
--w--w---x
--w--w--w-
--w--w--wx
--w--w-r--
--w--w-r-x
--w--w-rw-
--w--w-rwx
--w--wx---
--w--wx--x
--w--wx-w-
--w--wx-wx
--w--wxr--
--w--wxr-x
--w--wxrw-
--w--wxrwx
--w-r-----
--w-r----x
--w-r---w-
--w-r---wx
--w-r--r--
--w-r--r-x
--w-r--rw-
--w-r--rwx
--w-r-x---
--w-r-x--x
--w-r-x-w-
--w-r-x-wx
--w-r-xr--
--w-r-xr-x
--w-r-xrw-
--w-r-xrwx
--w-rw----
--w-rw---x
--w-rw--w-
--w-rw--wx
--w-rw-r--
--w-rw-r-x
--w-rw-rw-
--w-rw-rwx
--w-rwx---
--w-rwx--x
--w-rwx-w-
--w-rwx-wx
--w-rwxr--
--w-rwxr-x
--w-rwxrw-
--w-rwxrwx
--wx------
--wx-----x
--wx----w-
--wx----wx
--wx---r--
--wx---r-x
--wx---rw-
--wx---rwx
--wx--x---
--wx--x--x
--wx--x-w-
--wx--x-wx
--wx--xr--
--wx--xr-x
--wx--xrw-
--wx--xrwx
--wx-w----
--wx-w---x
--wx-w--w-
--wx-w--wx
--wx-w-r--
--wx-w-r-x
--wx-w-rw-
--wx-w-rwx
--wx-wx---
--wx-wx--x
--wx-wx-w-
--wx-wx-wx
--wx-wxr--
--wx-wxr-x
--wx-wxrw-
--wx-wxrwx
--wxr-----
--wxr----x
--wxr---w-
--wxr---wx
--wxr--r--
--wxr--r-x
--wxr--rw-
--wxr--rwx
--wxr-x---
--wxr-x--x
--wxr-x-w-
--wxr-x-wx
--wxr-xr--
--wxr-xr-x
--wxr-xrw-
--wxr-xrwx
--wxrw----
--wxrw---x
--wxrw--w-
--wxrw--wx
--wxrw-r--
--wxrw-r-x
--wxrw-rw-
--wxrw-rwx
--wxrwx---
--wxrwx--x
--wxrwx-w-
--wxrwx-wx
--wxrwxr--
--wxrwxr-x
--wxrwxrw-
--wxrwxrwx
-r--------
-r-------x
-r------w-
-r------wx
-r-----r--
-r-----r-x
-r-----rw-
-r-----rwx
-r----x---
-r----x--x
-r----x-w-
-r----x-wx
-r----xr--
-r----xr-x
-r----xrw-
-r----xrwx
-r---w----
-r---w---x
-r---w--w-
-r---w--wx
-r---w-r--
-r---w-r-x
-r---w-rw-
-r---w-rwx
-r---wx---
-r---wx--x
-r---wx-w-
-r---wx-wx
-r---wxr--
-r---wxr-x
-r---wxrw-
-r---wxrwx
-r--r-----
-r--r----x
-r--r---w-
-r--r---wx
-r--r--r--
-r--r--r-x
-r--r--rw-
-r--r--rwx
-r--r-x---
-r--r-x--x
-r--r-x-w-
-r--r-x-wx
-r--r-xr--
-r--r-xr-x
-r--r-xrw-
-r--r-xrwx
-r--rw----
-r--rw---x
-r--rw--w-
-r--rw--wx
-r--rw-r--
-r--rw-r-x
-r--rw-rw-
-r--rw-rwx
-r--rwx---
-r--rwx--x
-r--rwx-w-
-r--rwx-wx
-r--rwxr--
-r--rwxr-x
-r--rwxrw-
-r--rwxrwx
-r-x------
-r-x-----x
-r-x----w-
-r-x----wx
-r-x---r--
-r-x---r-x
-r-x---rw-
-r-x---rwx
-r-x--x---
-r-x--x--x
-r-x--x-w-
-r-x--x-wx
-r-x--xr--
-r-x--xr-x
-r-x--xrw-
-r-x--xrwx
-r-x-w----
-r-x-w---x
-r-x-w--w-
-r-x-w--wx
-r-x-w-r--
-r-x-w-r-x
-r-x-w-rw-
-r-x-w-rwx
-r-x-wx---
-r-x-wx--x
-r-x-wx-w-
-r-x-wx-wx
-r-x-wxr--
-r-x-wxr-x
-r-x-wxrw-
-r-x-wxrwx
-r-xr-----
-r-xr----x
-r-xr---w-
-r-xr---wx
-r-xr--r--
-r-xr--r-x
-r-xr--rw-
-r-xr--rwx
-r-xr-x---
-r-xr-x--x
-r-xr-x-w-
-r-xr-x-wx
-r-xr-xr--
-r-xr-xr-x
-r-xr-xrw-
-r-xr-xrwx
-r-xrw----
-r-xrw---x
-r-xrw--w-
-r-xrw--wx
-r-xrw-r--
-r-xrw-r-x
-r-xrw-rw-
-r-xrw-rwx
-r-xrwx---
-r-xrwx--x
-r-xrwx-w-
-r-xrwx-wx
-r-xrwxr--
-r-xrwxr-x
-r-xrwxrw-
-r-xrwxrwx
-rw-------
-rw------x
-rw-----w-
-rw-----wx
-rw----r--
-rw----r-x
-rw----rw-
-rw----rwx
-rw---x---
-rw---x--x
-rw---x-w-
-rw---x-wx
-rw---xr--
-rw---xr-x
-rw---xrw-
-rw---xrwx
-rw--w----
-rw--w---x
-rw--w--w-
-rw--w--wx
-rw--w-r--
-rw--w-r-x
-rw--w-rw-
-rw--w-rwx
-rw--wx---
-rw--wx--x
-rw--wx-w-
-rw--wx-wx
-rw--wxr--
-rw--wxr-x
-rw--wxrw-
-rw--wxrwx
-rw-r-----
-rw-r----x
-rw-r---w-
-rw-r---wx
-rw-r--r--
-rw-r--r-x
-rw-r--rw-
-rw-r--rwx
-rw-r-x---
-rw-r-x--x
-rw-r-x-w-
-rw-r-x-wx
-rw-r-xr--
-rw-r-xr-x
-rw-r-xrw-
-rw-r-xrwx
-rw-rw----
-rw-rw---x
-rw-rw--w-
-rw-rw--wx
-rw-rw-r--
-rw-rw-r-x
-rw-rw-rw-
-rw-rw-rwx
-rw-rwx---
-rw-rwx--x
-rw-rwx-w-
-rw-rwx-wx
-rw-rwxr--
-rw-rwxr-x
-rw-rwxrw-
-rw-rwxrwx
-rwx------
-rwx-----x
-rwx----w-
-rwx----wx
-rwx---r--
-rwx---r-x
-rwx---rw-
-rwx---rwx
-rwx--x---
-rwx--x--x
-rwx--x-w-
-rwx--x-wx
-rwx--xr--
-rwx--xr-x
-rwx--xrw-
-rwx--xrwx
-rwx-w----
-rwx-w---x
-rwx-w--w-
-rwx-w--wx
-rwx-w-r--
-rwx-w-r-x
-rwx-w-rw-
-rwx-w-rwx
-rwx-wx---
-rwx-wx--x
-rwx-wx-w-
-rwx-wx-wx
-rwx-wxr--
-rwx-wxr-x
-rwx-wxrw-
-rwx-wxrwx
-rwxr-----
-rwxr----x
-rwxr---w-
-rwxr---wx
-rwxr--r--
-rwxr--r-x
-rwxr--rw-
-rwxr--rwx
-rwxr-x---
-rwxr-x--x
-rwxr-x-w-
-rwxr-x-wx
-rwxr-xr--
-rwxr-xr-x
-rwxr-xrw-
-rwxr-xrwx
-rwxrw----
-rwxrw---x
-rwxrw--w-
-rwxrw--wx
-rwxrw-r--
-rwxrw-r-x
-rwxrw-rw-
-rwxrw-rwx
-rwxrwx---
-rwxrwx--x
-rwxrwx-w-
-rwxrwx-wx
-rwxrwxr--
-rwxrwxr-x
-rwxrwxrw-
-rwxrwxrwx
------L---
------L--x
------L-w-
------L-wx
------Lr--
------Lr-x
------Lrw-
------Lrwx
------s---
------s--x
------s-w-
------s-wx
------sr--
------sr-x
------srw-
------srwx
-----wL---
-----wL--x
-----wL-w-
-----wL-wx
-----wLr--
-----wLr-x
-----wLrw-
-----wLrwx
-----ws---
-----ws--x
-----ws-w-
-----ws-wx
-----wsr--
-----wsr-x
-----wsrw-
-----wsrwx
----r-L---
----r-L--x
----r-L-w-
----r-L-wx
----r-Lr--
----r-Lr-x
----r-Lrw-
----r-Lrwx
----r-s---
----r-s--x
----r-s-w-
----r-s-wx
----r-sr--
----r-sr-x
----r-srw-
----r-srwx
----rwL---
----rwL--x
----rwL-w-
----rwL-wx
----rwLr--
----rwLr-x
----rwLrw-
----rwLrwx
----rws---
----rws--x
----rws-w-
----rws-wx
----rwsr--
----rwsr-x
----rwsrw-
----rwsrwx
---x--L---
---x--L--x
---x--L-w-
---x--L-wx
---x--Lr--
---x--Lr-x
---x--Lrw-
---x--Lrwx
---x--s---
---x--s--x
---x--s-w-
---x--s-wx
---x--sr--
---x--sr-x
---x--srw-
---x--srwx
---x-wL---
---x-wL--x
---x-wL-w-
---x-wL-wx
---x-wLr--
---x-wLr-x
---x-wLrw-
---x-wLrwx
---x-ws---
---x-ws--x
---x-ws-w-
---x-ws-wx
---x-wsr--
---x-wsr-x
---x-wsrw-
---x-wsrwx
---xr-L---
---xr-L--x
---xr-L-w-
---xr-L-wx
---xr-Lr--
---xr-Lr-x
---xr-Lrw-
---xr-Lrwx
---xr-s---
---xr-s--x
---xr-s-w-
---xr-s-wx
---xr-sr--
---xr-sr-x
---xr-srw-
---xr-srwx
---xrwL---
---xrwL--x
---xrwL-w-
---xrwL-wx
---xrwLr--
---xrwLr-x
---xrwLrw-
---xrwLrwx
---xrws---
---xrws--x
---xrws-w-
---xrws-wx
---xrwsr--
---xrwsr-x
---xrwsrw-
---xrwsrwx
--w---L---
--w---L--x
--w---L-w-
--w---L-wx
--w---Lr--
--w---Lr-x
--w---Lrw-
--w---Lrwx
--w---s---
--w---s--x
--w---s-w-
--w---s-wx
--w---sr--
--w---sr-x
--w---srw-
--w---srwx
--w--wL---
--w--wL--x
--w--wL-w-
--w--wL-wx
--w--wLr--
--w--wLr-x
--w--wLrw-
--w--wLrwx
--w--ws---
--w--ws--x
--w--ws-w-
--w--ws-wx
--w--wsr--
--w--wsr-x
--w--wsrw-
--w--wsrwx
--w-r-L---
--w-r-L--x
--w-r-L-w-
--w-r-L-wx
--w-r-Lr--
--w-r-Lr-x
--w-r-Lrw-
--w-r-Lrwx
--w-r-s---
--w-r-s--x
--w-r-s-w-
--w-r-s-wx
--w-r-sr--
--w-r-sr-x
--w-r-srw-
--w-r-srwx
--w-rwL---
--w-rwL--x
--w-rwL-w-
--w-rwL-wx
--w-rwLr--
--w-rwLr-x
--w-rwLrw-
--w-rwLrwx
--w-rws---
--w-rws--x
--w-rws-w-
--w-rws-wx
--w-rwsr--
--w-rwsr-x
--w-rwsrw-
--w-rwsrwx
--wx--L---
--wx--L--x
--wx--L-w-
--wx--L-wx
--wx--Lr--
--wx--Lr-x
--wx--Lrw-
--wx--Lrwx
--wx--s---
--wx--s--x
--wx--s-w-
--wx--s-wx
--wx--sr--
--wx--sr-x
--wx--srw-
--wx--srwx
--wx-wL---
--wx-wL--x
--wx-wL-w-
--wx-wL-wx
--wx-wLr--
--wx-wLr-x
--wx-wLrw-
--wx-wLrwx
--wx-ws---
--wx-ws--x
--wx-ws-w-
--wx-ws-wx
--wx-wsr--
--wx-wsr-x
--wx-wsrw-
--wx-wsrwx
--wxr-L---
--wxr-L--x
--wxr-L-w-
--wxr-L-wx
--wxr-Lr--
--wxr-Lr-x
--wxr-Lrw-
--wxr-Lrwx
--wxr-s---
--wxr-s--x
--wxr-s-w-
--wxr-s-wx
--wxr-sr--
--wxr-sr-x
--wxr-srw-
--wxr-srwx
--wxrwL---
--wxrwL--x
--wxrwL-w-
--wxrwL-wx
--wxrwLr--
--wxrwLr-x
--wxrwLrw-
--wxrwLrwx
--wxrws---
--wxrws--x
--wxrws-w-
--wxrws-wx
--wxrwsr--
--wxrwsr-x
--wxrwsrw-
--wxrwsrwx
-r----L---
-r----L--x
-r----L-w-
-r----L-wx
-r----Lr--
-r----Lr-x
-r----Lrw-
-r----Lrwx
-r----s---
-r----s--x
-r----s-w-
-r----s-wx
-r----sr--
-r----sr-x
-r----srw-
-r----srwx
-r---wL---
-r---wL--x
-r---wL-w-
-r---wL-wx
-r---wLr--
-r---wLr-x
-r---wLrw-
-r---wLrwx
-r---ws---
-r---ws--x
-r---ws-w-
-r---ws-wx
-r---wsr--
-r---wsr-x
-r---wsrw-
-r---wsrwx
-r--r-L---
-r--r-L--x
-r--r-L-w-
-r--r-L-wx
-r--r-Lr--
-r--r-Lr-x
-r--r-Lrw-
-r--r-Lrwx
-r--r-s---
-r--r-s--x
-r--r-s-w-
-r--r-s-wx
-r--r-sr--
-r--r-sr-x
-r--r-srw-
-r--r-srwx
-r--rwL---
-r--rwL--x
-r--rwL-w-
-r--rwL-wx
-r--rwLr--
-r--rwLr-x
-r--rwLrw-
-r--rwLrwx
-r--rws---
-r--rws--x
-r--rws-w-
-r--rws-wx
-r--rwsr--
-r--rwsr-x
-r--rwsrw-
-r--rwsrwx
-r-x--L---
-r-x--L--x
-r-x--L-w-
-r-x--L-wx
-r-x--Lr--
-r-x--Lr-x
-r-x--Lrw-
-r-x--Lrwx
-r-x--s---
-r-x--s--x
-r-x--s-w-
-r-x--s-wx
-r-x--sr--
-r-x--sr-x
-r-x--srw-
-r-x--srwx
-r-x-wL---
-r-x-wL--x
-r-x-wL-w-
-r-x-wL-wx
-r-x-wLr--
-r-x-wLr-x
-r-x-wLrw-
-r-x-wLrwx
-r-x-ws---
-r-x-ws--x
-r-x-ws-w-
-r-x-ws-wx
-r-x-wsr--
-r-x-wsr-x
-r-x-wsrw-
-r-x-wsrwx
-r-xr-L---
-r-xr-L--x
-r-xr-L-w-
-r-xr-L-wx
-r-xr-Lr--
-r-xr-Lr-x
-r-xr-Lrw-
-r-xr-Lrwx
-r-xr-s---
-r-xr-s--x
-r-xr-s-w-
-r-xr-s-wx
-r-xr-sr--
-r-xr-sr-x
-r-xr-srw-
-r-xr-srwx
-r-xrwL---
-r-xrwL--x
-r-xrwL-w-
-r-xrwL-wx
-r-xrwLr--
-r-xrwLr-x
-r-xrwLrw-
-r-xrwLrwx
-r-xrws---
-r-xrws--x
-r-xrws-w-
-r-xrws-wx
-r-xrwsr--
-r-xrwsr-x
-r-xrwsrw-
-r-xrwsrwx
-rw---L---
-rw---L--x
-rw---L-w-
-rw---L-wx
-rw---Lr--
-rw---Lr-x
-rw---Lrw-
-rw---Lrwx
-rw---s---
-rw---s--x
-rw---s-w-
-rw---s-wx
-rw---sr--
-rw---sr-x
-rw---srw-
-rw---srwx
-rw--wL---
-rw--wL--x
-rw--wL-w-
-rw--wL-wx
-rw--wLr--
-rw--wLr-x
-rw--wLrw-
-rw--wLrwx
-rw--ws---
-rw--ws--x
-rw--ws-w-
-rw--ws-wx
-rw--wsr--
-rw--wsr-x
-rw--wsrw-
-rw--wsrwx
-rw-r-L---
-rw-r-L--x
-rw-r-L-w-
-rw-r-L-wx
-rw-r-Lr--
-rw-r-Lr-x
-rw-r-Lrw-
-rw-r-Lrwx
-rw-r-s---
-rw-r-s--x
-rw-r-s-w-
-rw-r-s-wx
-rw-r-sr--
-rw-r-sr-x
-rw-r-srw-
-rw-r-srwx
-rw-rwL---
-rw-rwL--x
-rw-rwL-w-
-rw-rwL-wx
-rw-rwLr--
-rw-rwLr-x
-rw-rwLrw-
-rw-rwLrwx
-rw-rws---
-rw-rws--x
-rw-rws-w-
-rw-rws-wx
-rw-rwsr--
-rw-rwsr-x
-rw-rwsrw-
-rw-rwsrwx
-rwx--L---
-rwx--L--x
-rwx--L-w-
-rwx--L-wx
-rwx--Lr--
-rwx--Lr-x
-rwx--Lrw-
-rwx--Lrwx
-rwx--s---
-rwx--s--x
-rwx--s-w-
-rwx--s-wx
-rwx--sr--
-rwx--sr-x
-rwx--srw-
-rwx--srwx
-rwx-wL---
-rwx-wL--x
-rwx-wL-w-
-rwx-wL-wx
-rwx-wLr--
-rwx-wLr-x
-rwx-wLrw-
-rwx-wLrwx
-rwx-ws---
-rwx-ws--x
-rwx-ws-w-
-rwx-ws-wx
-rwx-wsr--
-rwx-wsr-x
-rwx-wsrw-
-rwx-wsrwx
-rwxr-L---
-rwxr-L--x
-rwxr-L-w-
-rwxr-L-wx
-rwxr-Lr--
-rwxr-Lr-x
-rwxr-Lrw-
-rwxr-Lrwx
-rwxr-s---
-rwxr-s--x
-rwxr-s-w-
-rwxr-s-wx
-rwxr-sr--
-rwxr-sr-x
-rwxr-srw-
-rwxr-srwx
-rwxrwL---
-rwxrwL--x
-rwxrwL-w-
-rwxrwL-wx
-rwxrwLr--
-rwxrwLr-x
-rwxrwLrw-
-rwxrwLrwx
-rwxrws---
-rwxrws--x
-rwxrws-w-
-rwxrws-wx
-rwxrwsr--
-rwxrwsr-x
-rwxrwsrw-
-rwxrwsrwx
------L---
------L--x
------L-w-
------L-wx
------Lr--
------Lr-x
------Lrw-
------Lrwx
------s---
------s--x
------s-w-
------s-wx
------sr--
------sr-x
------srw-
------srwx
-----wL---
-----wL--x
-----wL-w-
-----wL-wx
-----wLr--
-----wLr-x
-----wLrw-
-----wLrwx
-----ws---
-----ws--x
-----ws-w-
-----ws-wx
-----wsr--
-----wsr-x
-----wsrw-
-----wsrwx
----r-L---
----r-L--x
----r-L-w-
----r-L-wx
----r-Lr--
----r-Lr-x
----r-Lrw-
----r-Lrwx
----r-s---
----r-s--x
----r-s-w-
----r-s-wx
----r-sr--
----r-sr-x
----r-srw-
----r-srwx
----rwL---
----rwL--x
----rwL-w-
----rwL-wx
----rwLr--
----rwLr-x
----rwLrw-
----rwLrwx
----rws---
----rws--x
----rws-w-
----rws-wx
----rwsr--
----rwsr-x
----rwsrw-
----rwsrwx
---x--L---
---x--L--x
---x--L-w-
---x--L-wx
---x--Lr--
---x--Lr-x
---x--Lrw-
---x--Lrwx
---x--s---
---x--s--x
---x--s-w-
---x--s-wx
---x--sr--
---x--sr-x
---x--srw-
---x--srwx
---x-wL---
---x-wL--x
---x-wL-w-
---x-wL-wx
---x-wLr--
---x-wLr-x
---x-wLrw-
---x-wLrwx
---x-ws---
---x-ws--x
---x-ws-w-
---x-ws-wx
---x-wsr--
---x-wsr-x
---x-wsrw-
---x-wsrwx
---xr-L---
---xr-L--x
---xr-L-w-
---xr-L-wx
---xr-Lr--
---xr-Lr-x
---xr-Lrw-
---xr-Lrwx
---xr-s---
---xr-s--x
---xr-s-w-
---xr-s-wx
---xr-sr--
---xr-sr-x
---xr-srw-
---xr-srwx
---xrwL---
---xrwL--x
---xrwL-w-
---xrwL-wx
---xrwLr--
---xrwLr-x
---xrwLrw-
---xrwLrwx
---xrws---
---xrws--x
---xrws-w-
---xrws-wx
---xrwsr--
---xrwsr-x
---xrwsrw-
---xrwsrwx
--w---L---
--w---L--x
--w---L-w-
--w---L-wx
--w---Lr--
--w---Lr-x
--w---Lrw-
--w---Lrwx
--w---s---
--w---s--x
--w---s-w-
--w---s-wx
--w---sr--
--w---sr-x
--w---srw-
--w---srwx
--w--wL---
--w--wL--x
--w--wL-w-
--w--wL-wx
--w--wLr--
--w--wLr-x
--w--wLrw-
--w--wLrwx
--w--ws---
--w--ws--x
--w--ws-w-
--w--ws-wx
--w--wsr--
--w--wsr-x
--w--wsrw-
--w--wsrwx
--w-r-L---
--w-r-L--x
--w-r-L-w-
--w-r-L-wx
--w-r-Lr--
--w-r-Lr-x
--w-r-Lrw-
--w-r-Lrwx
--w-r-s---
--w-r-s--x
--w-r-s-w-
--w-r-s-wx
--w-r-sr--
--w-r-sr-x
--w-r-srw-
--w-r-srwx
--w-rwL---
--w-rwL--x
--w-rwL-w-
--w-rwL-wx
--w-rwLr--
--w-rwLr-x
--w-rwLrw-
--w-rwLrwx
--w-rws---
--w-rws--x
--w-rws-w-
--w-rws-wx
--w-rwsr--
--w-rwsr-x
--w-rwsrw-
--w-rwsrwx
--wx--L---
--wx--L--x
--wx--L-w-
--wx--L-wx
--wx--Lr--
--wx--Lr-x
--wx--Lrw-
--wx--Lrwx
--wx--s---
--wx--s--x
--wx--s-w-
--wx--s-wx
--wx--sr--
--wx--sr-x
--wx--srw-
--wx--srwx
--wx-wL---
--wx-wL--x
--wx-wL-w-
--wx-wL-wx
--wx-wLr--
--wx-wLr-x
--wx-wLrw-
--wx-wLrwx
--wx-ws---
--wx-ws--x
--wx-ws-w-
--wx-ws-wx
--wx-wsr--
--wx-wsr-x
--wx-wsrw-
--wx-wsrwx
--wxr-L---
--wxr-L--x
--wxr-L-w-
--wxr-L-wx
--wxr-Lr--
--wxr-Lr-x
--wxr-Lrw-
--wxr-Lrwx
--wxr-s---
--wxr-s--x
--wxr-s-w-
--wxr-s-wx
--wxr-sr--
--wxr-sr-x
--wxr-srw-
--wxr-srwx
--wxrwL---
--wxrwL--x
--wxrwL-w-
--wxrwL-wx
--wxrwLr--
--wxrwLr-x
--wxrwLrw-
--wxrwLrwx
--wxrws---
--wxrws--x
--wxrws-w-
--wxrws-wx
--wxrwsr--
--wxrwsr-x
--wxrwsrw-
--wxrwsrwx
-r----L---
-r----L--x
-r----L-w-
-r----L-wx
-r----Lr--
-r----Lr-x
-r----Lrw-
-r----Lrwx
-r----s---
-r----s--x
-r----s-w-
-r----s-wx
-r----sr--
-r----sr-x
-r----srw-
-r----srwx
-r---wL---
-r---wL--x
-r---wL-w-
-r---wL-wx
-r---wLr--
-r---wLr-x
-r---wLrw-
-r---wLrwx
-r---ws---
-r---ws--x
-r---ws-w-
-r---ws-wx
-r---wsr--
-r---wsr-x
-r---wsrw-
-r---wsrwx
-r--r-L---
-r--r-L--x
-r--r-L-w-
-r--r-L-wx
-r--r-Lr--
-r--r-Lr-x
-r--r-Lrw-
-r--r-Lrwx
-r--r-s---
-r--r-s--x
-r--r-s-w-
-r--r-s-wx
-r--r-sr--
-r--r-sr-x
-r--r-srw-
-r--r-srwx
-r--rwL---
-r--rwL--x
-r--rwL-w-
-r--rwL-wx
-r--rwLr--
-r--rwLr-x
-r--rwLrw-
-r--rwLrwx
-r--rws---
-r--rws--x
-r--rws-w-
-r--rws-wx
-r--rwsr--
-r--rwsr-x
-r--rwsrw-
-r--rwsrwx
-r-x--L---
-r-x--L--x
-r-x--L-w-
-r-x--L-wx
-r-x--Lr--
-r-x--Lr-x
-r-x--Lrw-
-r-x--Lrwx
-r-x--s---
-r-x--s--x
-r-x--s-w-
-r-x--s-wx
-r-x--sr--
-r-x--sr-x
-r-x--srw-
-r-x--srwx
-r-x-wL---
-r-x-wL--x
-r-x-wL-w-
-r-x-wL-wx
-r-x-wLr--
-r-x-wLr-x
-r-x-wLrw-
-r-x-wLrwx
-r-x-ws---
-r-x-ws--x
-r-x-ws-w-
-r-x-ws-wx
-r-x-wsr--
-r-x-wsr-x
-r-x-wsrw-
-r-x-wsrwx
-r-xr-L---
-r-xr-L--x
-r-xr-L-w-
-r-xr-L-wx
-r-xr-Lr--
-r-xr-Lr-x
-r-xr-Lrw-
-r-xr-Lrwx
-r-xr-s---
-r-xr-s--x
-r-xr-s-w-
-r-xr-s-wx
-r-xr-sr--
-r-xr-sr-x
-r-xr-srw-
-r-xr-srwx
-r-xrwL---
-r-xrwL--x
-r-xrwL-w-
-r-xrwL-wx
-r-xrwLr--
-r-xrwLr-x
-r-xrwLrw-
-r-xrwLrwx
-r-xrws---
-r-xrws--x
-r-xrws-w-
-r-xrws-wx
-r-xrwsr--
-r-xrwsr-x
-r-xrwsrw-
-r-xrwsrwx
-rw---L---
-rw---L--x
-rw---L-w-
-rw---L-wx
-rw---Lr--
-rw---Lr-x
-rw---Lrw-
-rw---Lrwx
-rw---s---
-rw---s--x
-rw---s-w-
-rw---s-wx
-rw---sr--
-rw---sr-x
-rw---srw-
-rw---srwx
-rw--wL---
-rw--wL--x
-rw--wL-w-
-rw--wL-wx
-rw--wLr--
-rw--wLr-x
-rw--wLrw-
-rw--wLrwx
-rw--ws---
-rw--ws--x
-rw--ws-w-
-rw--ws-wx
-rw--wsr--
-rw--wsr-x
-rw--wsrw-
-rw--wsrwx
-rw-r-L---
-rw-r-L--x
-rw-r-L-w-
-rw-r-L-wx
-rw-r-Lr--
-rw-r-Lr-x
-rw-r-Lrw-
-rw-r-Lrwx
-rw-r-s---
-rw-r-s--x
-rw-r-s-w-
-rw-r-s-wx
-rw-r-sr--
-rw-r-sr-x
-rw-r-srw-
-rw-r-srwx
-rw-rwL---
-rw-rwL--x
-rw-rwL-w-
-rw-rwL-wx
-rw-rwLr--
-rw-rwLr-x
-rw-rwLrw-
-rw-rwLrwx
-rw-rws---
-rw-rws--x
-rw-rws-w-
-rw-rws-wx
-rw-rwsr--
-rw-rwsr-x
-rw-rwsrw-
-rw-rwsrwx
-rwx--L---
-rwx--L--x
-rwx--L-w-
-rwx--L-wx
-rwx--Lr--
-rwx--Lr-x
-rwx--Lrw-
-rwx--Lrwx
-rwx--s---
-rwx--s--x
-rwx--s-w-
-rwx--s-wx
-rwx--sr--
-rwx--sr-x
-rwx--srw-
-rwx--srwx
-rwx-wL---
-rwx-wL--x
-rwx-wL-w-
-rwx-wL-wx
-rwx-wLr--
-rwx-wLr-x
-rwx-wLrw-
-rwx-wLrwx
-rwx-ws---
-rwx-ws--x
-rwx-ws-w-
-rwx-ws-wx
-rwx-wsr--
-rwx-wsr-x
-rwx-wsrw-
-rwx-wsrwx
-rwxr-L---
-rwxr-L--x
-rwxr-L-w-
-rwxr-L-wx
-rwxr-Lr--
-rwxr-Lr-x
-rwxr-Lrw-
-rwxr-Lrwx
-rwxr-s---
-rwxr-s--x
-rwxr-s-w-
-rwxr-s-wx
-rwxr-sr--
-rwxr-sr-x
-rwxr-srw-
-rwxr-srwx
-rwxrwL---
-rwxrwL--x
-rwxrwL-w-
-rwxrwL-wx
-rwxrwLr--
-rwxrwLr-x
-rwxrwLrw-
-rwxrwLrwx
-rwxrws---
-rwxrws--x
-rwxrws-w-
-rwxrws-wx
-rwxrwsr--
-rwxrwsr-x
-rwxrwsrw-
-rwxrwsrwx
---S------
---S-----x
---S----w-
---S----wx
---S---r--
---S---r-x
---S---rw-
---S---rwx
---S--x---
---S--x--x
---S--x-w-
---S--x-wx
---S--xr--
---S--xr-x
---S--xrw-
---S--xrwx
---S-w----
---S-w---x
---S-w--w-
---S-w--wx
---S-w-r--
---S-w-r-x
---S-w-rw-
---S-w-rwx
---S-wx---
---S-wx--x
---S-wx-w-
---S-wx-wx
---S-wxr--
---S-wxr-x
---S-wxrw-
---S-wxrwx
---Sr-----
---Sr----x
---Sr---w-
---Sr---wx
---Sr--r--
---Sr--r-x
---Sr--rw-
---Sr--rwx
---Sr-x---
---Sr-x--x
---Sr-x-w-
---Sr-x-wx
---Sr-xr--
---Sr-xr-x
---Sr-xrw-
---Sr-xrwx
---Srw----
---Srw---x
---Srw--w-
---Srw--wx
---Srw-r--
---Srw-r-x
---Srw-rw-
---Srw-rwx
---Srwx---
---Srwx--x
---Srwx-w-
---Srwx-wx
---Srwxr--
---Srwxr-x
---Srwxrw-
---Srwxrwx
---s------
---s-----x
---s----w-
---s----wx
---s---r--
---s---r-x
---s---rw-
---s---rwx
---s--x---
---s--x--x
---s--x-w-
---s--x-wx
---s--xr--
---s--xr-x
---s--xrw-
---s--xrwx
---s-w----
---s-w---x
---s-w--w-
---s-w--wx
---s-w-r--
---s-w-r-x
---s-w-rw-
---s-w-rwx
---s-wx---
---s-wx--x
---s-wx-w-
---s-wx-wx
---s-wxr--
---s-wxr-x
---s-wxrw-
---s-wxrwx
---sr-----
---sr----x
---sr---w-
---sr---wx
---sr--r--
---sr--r-x
---sr--rw-
---sr--rwx
---sr-x---
---sr-x--x
---sr-x-w-
---sr-x-wx
---sr-xr--
---sr-xr-x
---sr-xrw-
---sr-xrwx
---srw----
---srw---x
---srw--w-
---srw--wx
---srw-r--
---srw-r-x
---srw-rw-
---srw-rwx
---srwx---
---srwx--x
---srwx-w-
---srwx-wx
---srwxr--
---srwxr-x
---srwxrw-
---srwxrwx
--wS------
--wS-----x
--wS----w-
--wS----wx
--wS---r--
--wS---r-x
--wS---rw-
--wS---rwx
--wS--x---
--wS--x--x
--wS--x-w-
--wS--x-wx
--wS--xr--
--wS--xr-x
--wS--xrw-
--wS--xrwx
--wS-w----
--wS-w---x
--wS-w--w-
--wS-w--wx
--wS-w-r--
--wS-w-r-x
--wS-w-rw-
--wS-w-rwx
--wS-wx---
--wS-wx--x
--wS-wx-w-
--wS-wx-wx
--wS-wxr--
--wS-wxr-x
--wS-wxrw-
--wS-wxrwx
--wSr-----
--wSr----x
--wSr---w-
--wSr---wx
--wSr--r--
--wSr--r-x
--wSr--rw-
--wSr--rwx
--wSr-x---
--wSr-x--x
--wSr-x-w-
--wSr-x-wx
--wSr-xr--
--wSr-xr-x
--wSr-xrw-
--wSr-xrwx
--wSrw----
--wSrw---x
--wSrw--w-
--wSrw--wx
--wSrw-r--
--wSrw-r-x
--wSrw-rw-
--wSrw-rwx
--wSrwx---
--wSrwx--x
--wSrwx-w-
--wSrwx-wx
--wSrwxr--
--wSrwxr-x
--wSrwxrw-
--wSrwxrwx
--ws------
--ws-----x
--ws----w-
--ws----wx
--ws---r--
--ws---r-x
--ws---rw-
--ws---rwx
--ws--x---
--ws--x--x
--ws--x-w-
--ws--x-wx
--ws--xr--
--ws--xr-x
--ws--xrw-
--ws--xrwx
--ws-w----
--ws-w---x
--ws-w--w-
--ws-w--wx
--ws-w-r--
--ws-w-r-x
--ws-w-rw-
--ws-w-rwx
--ws-wx---
--ws-wx--x
--ws-wx-w-
--ws-wx-wx
--ws-wxr--
--ws-wxr-x
--ws-wxrw-
--ws-wxrwx
--wsr-----
--wsr----x
--wsr---w-
--wsr---wx
--wsr--r--
--wsr--r-x
--wsr--rw-
--wsr--rwx
--wsr-x---
--wsr-x--x
--wsr-x-w-
--wsr-x-wx
--wsr-xr--
--wsr-xr-x
--wsr-xrw-
--wsr-xrwx
--wsrw----
--wsrw---x
--wsrw--w-
--wsrw--wx
--wsrw-r--
--wsrw-r-x
--wsrw-rw-
--wsrw-rwx
--wsrwx---
--wsrwx--x
--wsrwx-w-
--wsrwx-wx
--wsrwxr--
--wsrwxr-x
--wsrwxrw-
--wsrwxrwx
-r-S------
-r-S-----x
-r-S----w-
-r-S----wx
-r-S---r--
-r-S---r-x
-r-S---rw-
-r-S---rwx
-r-S--x---
-r-S--x--x
-r-S--x-w-
-r-S--x-wx
-r-S--xr--
-r-S--xr-x
-r-S--xrw-
-r-S--xrwx
-r-S-w----
-r-S-w---x
-r-S-w--w-
-r-S-w--wx
-r-S-w-r--
-r-S-w-r-x
-r-S-w-rw-
-r-S-w-rwx
-r-S-wx---
-r-S-wx--x
-r-S-wx-w-
-r-S-wx-wx
-r-S-wxr--
-r-S-wxr-x
-r-S-wxrw-
-r-S-wxrwx
-r-Sr-----
-r-Sr----x
-r-Sr---w-
-r-Sr---wx
-r-Sr--r--
-r-Sr--r-x
-r-Sr--rw-
-r-Sr--rwx
-r-Sr-x---
-r-Sr-x--x
-r-Sr-x-w-
-r-Sr-x-wx
-r-Sr-xr--
-r-Sr-xr-x
-r-Sr-xrw-
-r-Sr-xrwx
-r-Srw----
-r-Srw---x
-r-Srw--w-
-r-Srw--wx
-r-Srw-r--
-r-Srw-r-x
-r-Srw-rw-
-r-Srw-rwx
-r-Srwx---
-r-Srwx--x
-r-Srwx-w-
-r-Srwx-wx
-r-Srwxr--
-r-Srwxr-x
-r-Srwxrw-
-r-Srwxrwx
-r-s------
-r-s-----x
-r-s----w-
-r-s----wx
-r-s---r--
-r-s---r-x
-r-s---rw-
-r-s---rwx
-r-s--x---
-r-s--x--x
-r-s--x-w-
-r-s--x-wx
-r-s--xr--
-r-s--xr-x
-r-s--xrw-
-r-s--xrwx
-r-s-w----
-r-s-w---x
-r-s-w--w-
-r-s-w--wx
-r-s-w-r--
-r-s-w-r-x
-r-s-w-rw-
-r-s-w-rwx
-r-s-wx---
-r-s-wx--x
-r-s-wx-w-
-r-s-wx-wx
-r-s-wxr--
-r-s-wxr-x
-r-s-wxrw-
-r-s-wxrwx
-r-sr-----
-r-sr----x
-r-sr---w-
-r-sr---wx
-r-sr--r--
-r-sr--r-x
-r-sr--rw-
-r-sr--rwx
-r-sr-x---
-r-sr-x--x
-r-sr-x-w-
-r-sr-x-wx
-r-sr-xr--
-r-sr-xr-x
-r-sr-xrw-
-r-sr-xrwx
-r-srw----
-r-srw---x
-r-srw--w-
-r-srw--wx
-r-srw-r--
-r-srw-r-x
-r-srw-rw-
-r-srw-rwx
-r-srwx---
-r-srwx--x
-r-srwx-w-
-r-srwx-wx
-r-srwxr--
-r-srwxr-x
-r-srwxrw-
-r-srwxrwx
-rwS------
-rwS-----x
-rwS----w-
-rwS----wx
-rwS---r--
-rwS---r-x
-rwS---rw-
-rwS---rwx
-rwS--x---
-rwS--x--x
-rwS--x-w-
-rwS--x-wx
-rwS--xr--
-rwS--xr-x
-rwS--xrw-
-rwS--xrwx
-rwS-w----
-rwS-w---x
-rwS-w--w-
-rwS-w--wx
-rwS-w-r--
-rwS-w-r-x
-rwS-w-rw-
-rwS-w-rwx
-rwS-wx---
-rwS-wx--x
-rwS-wx-w-
-rwS-wx-wx
-rwS-wxr--
-rwS-wxr-x
-rwS-wxrw-
-rwS-wxrwx
-rwSr-----
-rwSr----x
-rwSr---w-
-rwSr---wx
-rwSr--r--
-rwSr--r-x
-rwSr--rw-
-rwSr--rwx
-rwSr-x---
-rwSr-x--x
-rwSr-x-w-
-rwSr-x-wx
-rwSr-xr--
-rwSr-xr-x
-rwSr-xrw-
-rwSr-xrwx
-rwSrw----
-rwSrw---x
-rwSrw--w-
-rwSrw--wx
-rwSrw-r--
-rwSrw-r-x
-rwSrw-rw-
-rwSrw-rwx
-rwSrwx---
-rwSrwx--x
-rwSrwx-w-
-rwSrwx-wx
-rwSrwxr--
-rwSrwxr-x
-rwSrwxrw-
-rwSrwxrwx
-rws------
-rws-----x
-rws----w-
-rws----wx
-rws---r--
-rws---r-x
-rws---rw-
-rws---rwx
-rws--x---
-rws--x--x
-rws--x-w-
-rws--x-wx
-rws--xr--
-rws--xr-x
-rws--xrw-
-rws--xrwx
-rws-w----
-rws-w---x
-rws-w--w-
-rws-w--wx
-rws-w-r--
-rws-w-r-x
-rws-w-rw-
-rws-w-rwx
-rws-wx---
-rws-wx--x
-rws-wx-w-
-rws-wx-wx
-rws-wxr--
-rws-wxr-x
-rws-wxrw-
-rws-wxrwx
-rwsr-----
-rwsr----x
-rwsr---w-
-rwsr---wx
-rwsr--r--
-rwsr--r-x
-rwsr--rw-
-rwsr--rwx
-rwsr-x---
-rwsr-x--x
-rwsr-x-w-
-rwsr-x-wx
-rwsr-xr--
-rwsr-xr-x
-rwsr-xrw-
-rwsr-xrwx
-rwsrw----
-rwsrw---x
-rwsrw--w-
-rwsrw--wx
-rwsrw-r--
-rwsrw-r-x
-rwsrw-rw-
-rwsrw-rwx
-rwsrwx---
-rwsrwx--x
-rwsrwx-w-
-rwsrwx-wx
-rwsrwxr--
-rwsrwxr-x
-rwsrwxrw-
-rwsrwxrwx
---S------
---S-----x
---S----w-
---S----wx
---S---r--
---S---r-x
---S---rw-
---S---rwx
---S--x---
---S--x--x
---S--x-w-
---S--x-wx
---S--xr--
---S--xr-x
---S--xrw-
---S--xrwx
---S-w----
---S-w---x
---S-w--w-
---S-w--wx
---S-w-r--
---S-w-r-x
---S-w-rw-
---S-w-rwx
---S-wx---
---S-wx--x
---S-wx-w-
---S-wx-wx
---S-wxr--
---S-wxr-x
---S-wxrw-
---S-wxrwx
---Sr-----
---Sr----x
---Sr---w-
---Sr---wx
---Sr--r--
---Sr--r-x
---Sr--rw-
---Sr--rwx
---Sr-x---
---Sr-x--x
---Sr-x-w-
---Sr-x-wx
---Sr-xr--
---Sr-xr-x
---Sr-xrw-
---Sr-xrwx
---Srw----
---Srw---x
---Srw--w-
---Srw--wx
---Srw-r--
---Srw-r-x
---Srw-rw-
---Srw-rwx
---Srwx---
---Srwx--x
---Srwx-w-
---Srwx-wx
---Srwxr--
---Srwxr-x
---Srwxrw-
---Srwxrwx
---s------
---s-----x
---s----w-
---s----wx
---s---r--
---s---r-x
---s---rw-
---s---rwx
---s--x---
---s--x--x
---s--x-w-
---s--x-wx
---s--xr--
---s--xr-x
---s--xrw-
---s--xrwx
---s-w----
---s-w---x
---s-w--w-
---s-w--wx
---s-w-r--
---s-w-r-x
---s-w-rw-
---s-w-rwx
---s-wx---
---s-wx--x
---s-wx-w-
---s-wx-wx
---s-wxr--
---s-wxr-x
---s-wxrw-
---s-wxrwx
---sr-----
---sr----x
---sr---w-
---sr---wx
---sr--r--
---sr--r-x
---sr--rw-
---sr--rwx
---sr-x---
---sr-x--x
---sr-x-w-
---sr-x-wx
---sr-xr--
---sr-xr-x
---sr-xrw-
---sr-xrwx
---srw----
---srw---x
---srw--w-
---srw--wx
---srw-r--
---srw-r-x
---srw-rw-
---srw-rwx
---srwx---
---srwx--x
---srwx-w-
---srwx-wx
---srwxr--
---srwxr-x
---srwxrw-
---srwxrwx
--wS------
--wS-----x
--wS----w-
--wS----wx
--wS---r--
--wS---r-x
--wS---rw-
--wS---rwx
--wS--x---
--wS--x--x
--wS--x-w-
--wS--x-wx
--wS--xr--
--wS--xr-x
--wS--xrw-
--wS--xrwx
--wS-w----
--wS-w---x
--wS-w--w-
--wS-w--wx
--wS-w-r--
--wS-w-r-x
--wS-w-rw-
--wS-w-rwx
--wS-wx---
--wS-wx--x
--wS-wx-w-
--wS-wx-wx
--wS-wxr--
--wS-wxr-x
--wS-wxrw-
--wS-wxrwx
--wSr-----
--wSr----x
--wSr---w-
--wSr---wx
--wSr--r--
--wSr--r-x
--wSr--rw-
--wSr--rwx
--wSr-x---
--wSr-x--x
--wSr-x-w-
--wSr-x-wx
--wSr-xr--
--wSr-xr-x
--wSr-xrw-
--wSr-xrwx
--wSrw----
--wSrw---x
--wSrw--w-
--wSrw--wx
--wSrw-r--
--wSrw-r-x
--wSrw-rw-
--wSrw-rwx
--wSrwx---
--wSrwx--x
--wSrwx-w-
--wSrwx-wx
--wSrwxr--
--wSrwxr-x
--wSrwxrw-
--wSrwxrwx
--ws------
--ws-----x
--ws----w-
--ws----wx
--ws---r--
--ws---r-x
--ws---rw-
--ws---rwx
--ws--x---
--ws--x--x
--ws--x-w-
--ws--x-wx
--ws--xr--
--ws--xr-x
--ws--xrw-
--ws--xrwx
--ws-w----
--ws-w---x
--ws-w--w-
--ws-w--wx
--ws-w-r--
--ws-w-r-x
--ws-w-rw-
--ws-w-rwx
--ws-wx---
--ws-wx--x
--ws-wx-w-
--ws-wx-wx
--ws-wxr--
--ws-wxr-x
--ws-wxrw-
--ws-wxrwx
--wsr-----
--wsr----x
--wsr---w-
--wsr---wx
--wsr--r--
--wsr--r-x
--wsr--rw-
--wsr--rwx
--wsr-x---
--wsr-x--x
--wsr-x-w-
--wsr-x-wx
--wsr-xr--
--wsr-xr-x
--wsr-xrw-
--wsr-xrwx
--wsrw----
--wsrw---x
--wsrw--w-
--wsrw--wx
--wsrw-r--
--wsrw-r-x
--wsrw-rw-
--wsrw-rwx
--wsrwx---
--wsrwx--x
--wsrwx-w-
--wsrwx-wx
--wsrwxr--
--wsrwxr-x
--wsrwxrw-
--wsrwxrwx
-r-S------
-r-S-----x
-r-S----w-
-r-S----wx
-r-S---r--
-r-S---r-x
-r-S---rw-
-r-S---rwx
-r-S--x---
-r-S--x--x
-r-S--x-w-
-r-S--x-wx
-r-S--xr--
-r-S--xr-x
-r-S--xrw-
-r-S--xrwx
-r-S-w----
-r-S-w---x
-r-S-w--w-
-r-S-w--wx
-r-S-w-r--
-r-S-w-r-x
-r-S-w-rw-
-r-S-w-rwx
-r-S-wx---
-r-S-wx--x
-r-S-wx-w-
-r-S-wx-wx
-r-S-wxr--
-r-S-wxr-x
-r-S-wxrw-
-r-S-wxrwx
-r-Sr-----
-r-Sr----x
-r-Sr---w-
-r-Sr---wx
-r-Sr--r--
-r-Sr--r-x
-r-Sr--rw-
-r-Sr--rwx
-r-Sr-x---
-r-Sr-x--x
-r-Sr-x-w-
-r-Sr-x-wx
-r-Sr-xr--
-r-Sr-xr-x
-r-Sr-xrw-
-r-Sr-xrwx
-r-Srw----
-r-Srw---x
-r-Srw--w-
-r-Srw--wx
-r-Srw-r--
-r-Srw-r-x
-r-Srw-rw-
-r-Srw-rwx
-r-Srwx---
-r-Srwx--x
-r-Srwx-w-
-r-Srwx-wx
-r-Srwxr--
-r-Srwxr-x
-r-Srwxrw-
-r-Srwxrwx
-r-s------
-r-s-----x
-r-s----w-
-r-s----wx
-r-s---r--
-r-s---r-x
-r-s---rw-
-r-s---rwx
-r-s--x---
-r-s--x--x
-r-s--x-w-
-r-s--x-wx
-r-s--xr--
-r-s--xr-x
-r-s--xrw-
-r-s--xrwx
-r-s-w----
-r-s-w---x
-r-s-w--w-
-r-s-w--wx
-r-s-w-r--
-r-s-w-r-x
-r-s-w-rw-
-r-s-w-rwx
-r-s-wx---
-r-s-wx--x
-r-s-wx-w-
-r-s-wx-wx
-r-s-wxr--
-r-s-wxr-x
-r-s-wxrw-
-r-s-wxrwx
-r-sr-----
-r-sr----x
-r-sr---w-
-r-sr---wx
-r-sr--r--
-r-sr--r-x
-r-sr--rw-
-r-sr--rwx
-r-sr-x---
-r-sr-x--x
-r-sr-x-w-
-r-sr-x-wx
-r-sr-xr--
-r-sr-xr-x
-r-sr-xrw-
-r-sr-xrwx
-r-srw----
-r-srw---x
-r-srw--w-
-r-srw--wx
-r-srw-r--
-r-srw-r-x
-r-srw-rw-
-r-srw-rwx
-r-srwx---
-r-srwx--x
-r-srwx-w-
-r-srwx-wx
-r-srwxr--
-r-srwxr-x
-r-srwxrw-
-r-srwxrwx
-rwS------
-rwS-----x
-rwS----w-
-rwS----wx
-rwS---r--
-rwS---r-x
-rwS---rw-
-rwS---rwx
-rwS--x---
-rwS--x--x
-rwS--x-w-
-rwS--x-wx
-rwS--xr--
-rwS--xr-x
-rwS--xrw-
-rwS--xrwx
-rwS-w----
-rwS-w---x
-rwS-w--w-
-rwS-w--wx
-rwS-w-r--
-rwS-w-r-x
-rwS-w-rw-
-rwS-w-rwx
-rwS-wx---
-rwS-wx--x
-rwS-wx-w-
-rwS-wx-wx
-rwS-wxr--
-rwS-wxr-x
-rwS-wxrw-
-rwS-wxrwx
-rwSr-----
-rwSr----x
-rwSr---w-
-rwSr---wx
-rwSr--r--
-rwSr--r-x
-rwSr--rw-
-rwSr--rwx
-rwSr-x---
-rwSr-x--x
-rwSr-x-w-
-rwSr-x-wx
-rwSr-xr--
-rwSr-xr-x
-rwSr-xrw-
-rwSr-xrwx
-rwSrw----
-rwSrw---x
-rwSrw--w-
-rwSrw--wx
-rwSrw-r--
-rwSrw-r-x
-rwSrw-rw-
-rwSrw-rwx
-rwSrwx---
-rwSrwx--x
-rwSrwx-w-
-rwSrwx-wx
-rwSrwxr--
-rwSrwxr-x
-rwSrwxrw-
-rwSrwxrwx
-rws------
-rws-----x
-rws----w-
-rws----wx
-rws---r--
-rws---r-x
-rws---rw-
-rws---rwx
-rws--x---
-rws--x--x
-rws--x-w-
-rws--x-wx
-rws--xr--
-rws--xr-x
-rws--xrw-
-rws--xrwx
-rws-w----
-rws-w---x
-rws-w--w-
-rws-w--wx
-rws-w-r--
-rws-w-r-x
-rws-w-rw-
-rws-w-rwx
-rws-wx---
-rws-wx--x
-rws-wx-w-
-rws-wx-wx
-rws-wxr--
-rws-wxr-x
-rws-wxrw-
-rws-wxrwx
-rwsr-----
-rwsr----x
-rwsr---w-
-rwsr---wx
-rwsr--r--
-rwsr--r-x
-rwsr--rw-
-rwsr--rwx
-rwsr-x---
-rwsr-x--x
-rwsr-x-w-
-rwsr-x-wx
-rwsr-xr--
-rwsr-xr-x
-rwsr-xrw-
-rwsr-xrwx
-rwsrw----
-rwsrw---x
-rwsrw--w-
-rwsrw--wx
-rwsrw-r--
-rwsrw-r-x
-rwsrw-rw-
-rwsrw-rwx
-rwsrwx---
-rwsrwx--x
-rwsrwx-w-
-rwsrwx-wx
-rwsrwxr--
-rwsrwxr-x
-rwsrwxrw-
-rwsrwxrwx
---S--L---
---S--L--x
---S--L-w-
---S--L-wx
---S--Lr--
---S--Lr-x
---S--Lrw-
---S--Lrwx
---S--s---
---S--s--x
---S--s-w-
---S--s-wx
---S--sr--
---S--sr-x
---S--srw-
---S--srwx
---S-wL---
---S-wL--x
---S-wL-w-
---S-wL-wx
---S-wLr--
---S-wLr-x
---S-wLrw-
---S-wLrwx
---S-ws---
---S-ws--x
---S-ws-w-
---S-ws-wx
---S-wsr--
---S-wsr-x
---S-wsrw-
---S-wsrwx
---Sr-L---
---Sr-L--x
---Sr-L-w-
---Sr-L-wx
---Sr-Lr--
---Sr-Lr-x
---Sr-Lrw-
---Sr-Lrwx
---Sr-s---
---Sr-s--x
---Sr-s-w-
---Sr-s-wx
---Sr-sr--
---Sr-sr-x
---Sr-srw-
---Sr-srwx
---SrwL---
---SrwL--x
---SrwL-w-
---SrwL-wx
---SrwLr--
---SrwLr-x
---SrwLrw-
---SrwLrwx
---Srws---
---Srws--x
---Srws-w-
---Srws-wx
---Srwsr--
---Srwsr-x
---Srwsrw-
---Srwsrwx
---s--L---
---s--L--x
---s--L-w-
---s--L-wx
---s--Lr--
---s--Lr-x
---s--Lrw-
---s--Lrwx
---s--s---
---s--s--x
---s--s-w-
---s--s-wx
---s--sr--
---s--sr-x
---s--srw-
---s--srwx
---s-wL---
---s-wL--x
---s-wL-w-
---s-wL-wx
---s-wLr--
---s-wLr-x
---s-wLrw-
---s-wLrwx
---s-ws---
---s-ws--x
---s-ws-w-
---s-ws-wx
---s-wsr--
---s-wsr-x
---s-wsrw-
---s-wsrwx
---sr-L---
---sr-L--x
---sr-L-w-
---sr-L-wx
---sr-Lr--
---sr-Lr-x
---sr-Lrw-
---sr-Lrwx
---sr-s---
---sr-s--x
---sr-s-w-
---sr-s-wx
---sr-sr--
---sr-sr-x
---sr-srw-
---sr-srwx
---srwL---
---srwL--x
---srwL-w-
---srwL-wx
---srwLr--
---srwLr-x
---srwLrw-
---srwLrwx
---srws---
---srws--x
---srws-w-
---srws-wx
---srwsr--
---srwsr-x
---srwsrw-
---srwsrwx
--wS--L---
--wS--L--x
--wS--L-w-
--wS--L-wx
--wS--Lr--
--wS--Lr-x
--wS--Lrw-
--wS--Lrwx
--wS--s---
--wS--s--x
--wS--s-w-
--wS--s-wx
--wS--sr--
--wS--sr-x
--wS--srw-
--wS--srwx
--wS-wL---
--wS-wL--x
--wS-wL-w-
--wS-wL-wx
--wS-wLr--
--wS-wLr-x
--wS-wLrw-
--wS-wLrwx
--wS-ws---
--wS-ws--x
--wS-ws-w-
--wS-ws-wx
--wS-wsr--
--wS-wsr-x
--wS-wsrw-
--wS-wsrwx
--wSr-L---
--wSr-L--x
--wSr-L-w-
--wSr-L-wx
--wSr-Lr--
--wSr-Lr-x
--wSr-Lrw-
--wSr-Lrwx
--wSr-s---
--wSr-s--x
--wSr-s-w-
--wSr-s-wx
--wSr-sr--
--wSr-sr-x
--wSr-srw-
--wSr-srwx
--wSrwL---
--wSrwL--x
--wSrwL-w-
--wSrwL-wx
--wSrwLr--
--wSrwLr-x
--wSrwLrw-
--wSrwLrwx
--wSrws---
--wSrws--x
--wSrws-w-
--wSrws-wx
--wSrwsr--
--wSrwsr-x
--wSrwsrw-
--wSrwsrwx
--ws--L---
--ws--L--x
--ws--L-w-
--ws--L-wx
--ws--Lr--
--ws--Lr-x
--ws--Lrw-
--ws--Lrwx
--ws--s---
--ws--s--x
--ws--s-w-
--ws--s-wx
--ws--sr--
--ws--sr-x
--ws--srw-
--ws--srwx
--ws-wL---
--ws-wL--x
--ws-wL-w-
--ws-wL-wx
--ws-wLr--
--ws-wLr-x
--ws-wLrw-
--ws-wLrwx
--ws-ws---
--ws-ws--x
--ws-ws-w-
--ws-ws-wx
--ws-wsr--
--ws-wsr-x
--ws-wsrw-
--ws-wsrwx
--wsr-L---
--wsr-L--x
--wsr-L-w-
--wsr-L-wx
--wsr-Lr--
--wsr-Lr-x
--wsr-Lrw-
--wsr-Lrwx
--wsr-s---
--wsr-s--x
--wsr-s-w-
--wsr-s-wx
--wsr-sr--
--wsr-sr-x
--wsr-srw-
--wsr-srwx
--wsrwL---
--wsrwL--x
--wsrwL-w-
--wsrwL-wx
--wsrwLr--
--wsrwLr-x
--wsrwLrw-
--wsrwLrwx
--wsrws---
--wsrws--x
--wsrws-w-
--wsrws-wx
--wsrwsr--
--wsrwsr-x
--wsrwsrw-
--wsrwsrwx
-r-S--L---
-r-S--L--x
-r-S--L-w-
-r-S--L-wx
-r-S--Lr--
-r-S--Lr-x
-r-S--Lrw-
-r-S--Lrwx
-r-S--s---
-r-S--s--x
-r-S--s-w-
-r-S--s-wx
-r-S--sr--
-r-S--sr-x
-r-S--srw-
-r-S--srwx
-r-S-wL---
-r-S-wL--x
-r-S-wL-w-
-r-S-wL-wx
-r-S-wLr--
-r-S-wLr-x
-r-S-wLrw-
-r-S-wLrwx
-r-S-ws---
-r-S-ws--x
-r-S-ws-w-
-r-S-ws-wx
-r-S-wsr--
-r-S-wsr-x
-r-S-wsrw-
-r-S-wsrwx
-r-Sr-L---
-r-Sr-L--x
-r-Sr-L-w-
-r-Sr-L-wx
-r-Sr-Lr--
-r-Sr-Lr-x
-r-Sr-Lrw-
-r-Sr-Lrwx
-r-Sr-s---
-r-Sr-s--x
-r-Sr-s-w-
-r-Sr-s-wx
-r-Sr-sr--
-r-Sr-sr-x
-r-Sr-srw-
-r-Sr-srwx
-r-SrwL---
-r-SrwL--x
-r-SrwL-w-
-r-SrwL-wx
-r-SrwLr--
-r-SrwLr-x
-r-SrwLrw-
-r-SrwLrwx
-r-Srws---
-r-Srws--x
-r-Srws-w-
-r-Srws-wx
-r-Srwsr--
-r-Srwsr-x
-r-Srwsrw-
-r-Srwsrwx
-r-s--L---
-r-s--L--x
-r-s--L-w-
-r-s--L-wx
-r-s--Lr--
-r-s--Lr-x
-r-s--Lrw-
-r-s--Lrwx
-r-s--s---
-r-s--s--x
-r-s--s-w-
-r-s--s-wx
-r-s--sr--
-r-s--sr-x
-r-s--srw-
-r-s--srwx
-r-s-wL---
-r-s-wL--x
-r-s-wL-w-
-r-s-wL-wx
-r-s-wLr--
-r-s-wLr-x
-r-s-wLrw-
-r-s-wLrwx
-r-s-ws---
-r-s-ws--x
-r-s-ws-w-
-r-s-ws-wx
-r-s-wsr--
-r-s-wsr-x
-r-s-wsrw-
-r-s-wsrwx
-r-sr-L---
-r-sr-L--x
-r-sr-L-w-
-r-sr-L-wx
-r-sr-Lr--
-r-sr-Lr-x
-r-sr-Lrw-
-r-sr-Lrwx
-r-sr-s---
-r-sr-s--x
-r-sr-s-w-
-r-sr-s-wx
-r-sr-sr--
-r-sr-sr-x
-r-sr-srw-
-r-sr-srwx
-r-srwL---
-r-srwL--x
-r-srwL-w-
-r-srwL-wx
-r-srwLr--
-r-srwLr-x
-r-srwLrw-
-r-srwLrwx
-r-srws---
-r-srws--x
-r-srws-w-
-r-srws-wx
-r-srwsr--
-r-srwsr-x
-r-srwsrw-
-r-srwsrwx
-rwS--L---
-rwS--L--x
-rwS--L-w-
-rwS--L-wx
-rwS--Lr--
-rwS--Lr-x
-rwS--Lrw-
-rwS--Lrwx
-rwS--s---
-rwS--s--x
-rwS--s-w-
-rwS--s-wx
-rwS--sr--
-rwS--sr-x
-rwS--srw-
-rwS--srwx
-rwS-wL---
-rwS-wL--x
-rwS-wL-w-
-rwS-wL-wx
-rwS-wLr--
-rwS-wLr-x
-rwS-wLrw-
-rwS-wLrwx
-rwS-ws---
-rwS-ws--x
-rwS-ws-w-
-rwS-ws-wx
-rwS-wsr--
-rwS-wsr-x
-rwS-wsrw-
-rwS-wsrwx
-rwSr-L---
-rwSr-L--x
-rwSr-L-w-
-rwSr-L-wx
-rwSr-Lr--
-rwSr-Lr-x
-rwSr-Lrw-
-rwSr-Lrwx
-rwSr-s---
-rwSr-s--x
-rwSr-s-w-
-rwSr-s-wx
-rwSr-sr--
-rwSr-sr-x
-rwSr-srw-
-rwSr-srwx
-rwSrwL---
-rwSrwL--x
-rwSrwL-w-
-rwSrwL-wx
-rwSrwLr--
-rwSrwLr-x
-rwSrwLrw-
-rwSrwLrwx
-rwSrws---
-rwSrws--x
-rwSrws-w-
-rwSrws-wx
-rwSrwsr--
-rwSrwsr-x
-rwSrwsrw-
-rwSrwsrwx
-rws--L---
-rws--L--x
-rws--L-w-
-rws--L-wx
-rws--Lr--
-rws--Lr-x
-rws--Lrw-
-rws--Lrwx
-rws--s---
-rws--s--x
-rws--s-w-
-rws--s-wx
-rws--sr--
-rws--sr-x
-rws--srw-
-rws--srwx
-rws-wL---
-rws-wL--x
-rws-wL-w-
-rws-wL-wx
-rws-wLr--
-rws-wLr-x
-rws-wLrw-
-rws-wLrwx
-rws-ws---
-rws-ws--x
-rws-ws-w-
-rws-ws-wx
-rws-wsr--
-rws-wsr-x
-rws-wsrw-
-rws-wsrwx
-rwsr-L---
-rwsr-L--x
-rwsr-L-w-
-rwsr-L-wx
-rwsr-Lr--
-rwsr-Lr-x
-rwsr-Lrw-
-rwsr-Lrwx
-rwsr-s---
-rwsr-s--x
-rwsr-s-w-
-rwsr-s-wx
-rwsr-sr--
-rwsr-sr-x
-rwsr-srw-
-rwsr-srwx
-rwsrwL---
-rwsrwL--x
-rwsrwL-w-
-rwsrwL-wx
-rwsrwLr--
-rwsrwLr-x
-rwsrwLrw-
-rwsrwLrwx
-rwsrws---
-rwsrws--x
-rwsrws-w-
-rwsrws-wx
-rwsrwsr--
-rwsrwsr-x
-rwsrwsrw-
-rwsrwsrwx
---S--L---
---S--L--x
---S--L-w-
---S--L-wx
---S--Lr--
---S--Lr-x
---S--Lrw-
---S--Lrwx
---S--s---
---S--s--x
---S--s-w-
---S--s-wx
---S--sr--
---S--sr-x
---S--srw-
---S--srwx
---S-wL---
---S-wL--x
---S-wL-w-
---S-wL-wx
---S-wLr--
---S-wLr-x
---S-wLrw-
---S-wLrwx
---S-ws---
---S-ws--x
---S-ws-w-
---S-ws-wx
---S-wsr--
---S-wsr-x
---S-wsrw-
---S-wsrwx
---Sr-L---
---Sr-L--x
---Sr-L-w-
---Sr-L-wx
---Sr-Lr--
---Sr-Lr-x
---Sr-Lrw-
---Sr-Lrwx
---Sr-s---
---Sr-s--x
---Sr-s-w-
---Sr-s-wx
---Sr-sr--
---Sr-sr-x
---Sr-srw-
---Sr-srwx
---SrwL---
---SrwL--x
---SrwL-w-
---SrwL-wx
---SrwLr--
---SrwLr-x
---SrwLrw-
---SrwLrwx
---Srws---
---Srws--x
---Srws-w-
---Srws-wx
---Srwsr--
---Srwsr-x
---Srwsrw-
---Srwsrwx
---s--L---
---s--L--x
---s--L-w-
---s--L-wx
---s--Lr--
---s--Lr-x
---s--Lrw-
---s--Lrwx
---s--s---
---s--s--x
---s--s-w-
---s--s-wx
---s--sr--
---s--sr-x
---s--srw-
---s--srwx
---s-wL---
---s-wL--x
---s-wL-w-
---s-wL-wx
---s-wLr--
---s-wLr-x
---s-wLrw-
---s-wLrwx
---s-ws---
---s-ws--x
---s-ws-w-
---s-ws-wx
---s-wsr--
---s-wsr-x
---s-wsrw-
---s-wsrwx
---sr-L---
---sr-L--x
---sr-L-w-
---sr-L-wx
---sr-Lr--
---sr-Lr-x
---sr-Lrw-
---sr-Lrwx
---sr-s---
---sr-s--x
---sr-s-w-
---sr-s-wx
---sr-sr--
---sr-sr-x
---sr-srw-
---sr-srwx
---srwL---
---srwL--x
---srwL-w-
---srwL-wx
---srwLr--
---srwLr-x
---srwLrw-
---srwLrwx
---srws---
---srws--x
---srws-w-
---srws-wx
---srwsr--
---srwsr-x
---srwsrw-
---srwsrwx
--wS--L---
--wS--L--x
--wS--L-w-
--wS--L-wx
--wS--Lr--
--wS--Lr-x
--wS--Lrw-
--wS--Lrwx
--wS--s---
--wS--s--x
--wS--s-w-
--wS--s-wx
--wS--sr--
--wS--sr-x
--wS--srw-
--wS--srwx
--wS-wL---
--wS-wL--x
--wS-wL-w-
--wS-wL-wx
--wS-wLr--
--wS-wLr-x
--wS-wLrw-
--wS-wLrwx
--wS-ws---
--wS-ws--x
--wS-ws-w-
--wS-ws-wx
--wS-wsr--
--wS-wsr-x
--wS-wsrw-
--wS-wsrwx
--wSr-L---
--wSr-L--x
--wSr-L-w-
--wSr-L-wx
--wSr-Lr--
--wSr-Lr-x
--wSr-Lrw-
--wSr-Lrwx
--wSr-s---
--wSr-s--x
--wSr-s-w-
--wSr-s-wx
--wSr-sr--
--wSr-sr-x
--wSr-srw-
--wSr-srwx
--wSrwL---
--wSrwL--x
--wSrwL-w-
--wSrwL-wx
--wSrwLr--
--wSrwLr-x
--wSrwLrw-
--wSrwLrwx
--wSrws---
--wSrws--x
--wSrws-w-
--wSrws-wx
--wSrwsr--
--wSrwsr-x
--wSrwsrw-
--wSrwsrwx
--ws--L---
--ws--L--x
--ws--L-w-
--ws--L-wx
--ws--Lr--
--ws--Lr-x
--ws--Lrw-
--ws--Lrwx
--ws--s---
--ws--s--x
--ws--s-w-
--ws--s-wx
--ws--sr--
--ws--sr-x
--ws--srw-
--ws--srwx
--ws-wL---
--ws-wL--x
--ws-wL-w-
--ws-wL-wx
--ws-wLr--
--ws-wLr-x
--ws-wLrw-
--ws-wLrwx
--ws-ws---
--ws-ws--x
--ws-ws-w-
--ws-ws-wx
--ws-wsr--
--ws-wsr-x
--ws-wsrw-
--ws-wsrwx
--wsr-L---
--wsr-L--x
--wsr-L-w-
--wsr-L-wx
--wsr-Lr--
--wsr-Lr-x
--wsr-Lrw-
--wsr-Lrwx
--wsr-s---
--wsr-s--x
--wsr-s-w-
--wsr-s-wx
--wsr-sr--
--wsr-sr-x
--wsr-srw-
--wsr-srwx
--wsrwL---
--wsrwL--x
--wsrwL-w-
--wsrwL-wx
--wsrwLr--
--wsrwLr-x
--wsrwLrw-
--wsrwLrwx
--wsrws---
--wsrws--x
--wsrws-w-
--wsrws-wx
--wsrwsr--
--wsrwsr-x
--wsrwsrw-
--wsrwsrwx
-r-S--L---
-r-S--L--x
-r-S--L-w-
-r-S--L-wx
-r-S--Lr--
-r-S--Lr-x
-r-S--Lrw-
-r-S--Lrwx
-r-S--s---
-r-S--s--x
-r-S--s-w-
-r-S--s-wx
-r-S--sr--
-r-S--sr-x
-r-S--srw-
-r-S--srwx
-r-S-wL---
-r-S-wL--x
-r-S-wL-w-
-r-S-wL-wx
-r-S-wLr--
-r-S-wLr-x
-r-S-wLrw-
-r-S-wLrwx
-r-S-ws---
-r-S-ws--x
-r-S-ws-w-
-r-S-ws-wx
-r-S-wsr--
-r-S-wsr-x
-r-S-wsrw-
-r-S-wsrwx
-r-Sr-L---
-r-Sr-L--x
-r-Sr-L-w-
-r-Sr-L-wx
-r-Sr-Lr--
-r-Sr-Lr-x
-r-Sr-Lrw-
-r-Sr-Lrwx
-r-Sr-s---
-r-Sr-s--x
-r-Sr-s-w-
-r-Sr-s-wx
-r-Sr-sr--
-r-Sr-sr-x
-r-Sr-srw-
-r-Sr-srwx
-r-SrwL---
-r-SrwL--x
-r-SrwL-w-
-r-SrwL-wx
-r-SrwLr--
-r-SrwLr-x
-r-SrwLrw-
-r-SrwLrwx
-r-Srws---
-r-Srws--x
-r-Srws-w-
-r-Srws-wx
-r-Srwsr--
-r-Srwsr-x
-r-Srwsrw-
-r-Srwsrwx
-r-s--L---
-r-s--L--x
-r-s--L-w-
-r-s--L-wx
-r-s--Lr--
-r-s--Lr-x
-r-s--Lrw-
-r-s--Lrwx
-r-s--s---
-r-s--s--x
-r-s--s-w-
-r-s--s-wx
-r-s--sr--
-r-s--sr-x
-r-s--srw-
-r-s--srwx
-r-s-wL---
-r-s-wL--x
-r-s-wL-w-
-r-s-wL-wx
-r-s-wLr--
-r-s-wLr-x
-r-s-wLrw-
-r-s-wLrwx
-r-s-ws---
-r-s-ws--x
-r-s-ws-w-
-r-s-ws-wx
-r-s-wsr--
-r-s-wsr-x
-r-s-wsrw-
-r-s-wsrwx
-r-sr-L---
-r-sr-L--x
-r-sr-L-w-
-r-sr-L-wx
-r-sr-Lr--
-r-sr-Lr-x
-r-sr-Lrw-
-r-sr-Lrwx
-r-sr-s---
-r-sr-s--x
-r-sr-s-w-
-r-sr-s-wx
-r-sr-sr--
-r-sr-sr-x
-r-sr-srw-
-r-sr-srwx
-r-srwL---
-r-srwL--x
-r-srwL-w-
-r-srwL-wx
-r-srwLr--
-r-srwLr-x
-r-srwLrw-
-r-srwLrwx
-r-srws---
-r-srws--x
-r-srws-w-
-r-srws-wx
-r-srwsr--
-r-srwsr-x
-r-srwsrw-
-r-srwsrwx
-rwS--L---
-rwS--L--x
-rwS--L-w-
-rwS--L-wx
-rwS--Lr--
-rwS--Lr-x
-rwS--Lrw-
-rwS--Lrwx
-rwS--s---
-rwS--s--x
-rwS--s-w-
-rwS--s-wx
-rwS--sr--
-rwS--sr-x
-rwS--srw-
-rwS--srwx
-rwS-wL---
-rwS-wL--x
-rwS-wL-w-
-rwS-wL-wx
-rwS-wLr--
-rwS-wLr-x
-rwS-wLrw-
-rwS-wLrwx
-rwS-ws---
-rwS-ws--x
-rwS-ws-w-
-rwS-ws-wx
-rwS-wsr--
-rwS-wsr-x
-rwS-wsrw-
-rwS-wsrwx
-rwSr-L---
-rwSr-L--x
-rwSr-L-w-
-rwSr-L-wx
-rwSr-Lr--
-rwSr-Lr-x
-rwSr-Lrw-
-rwSr-Lrwx
-rwSr-s---
-rwSr-s--x
-rwSr-s-w-
-rwSr-s-wx
-rwSr-sr--
-rwSr-sr-x
-rwSr-srw-
-rwSr-srwx
-rwSrwL---
-rwSrwL--x
-rwSrwL-w-
-rwSrwL-wx
-rwSrwLr--
-rwSrwLr-x
-rwSrwLrw-
-rwSrwLrwx
-rwSrws---
-rwSrws--x
-rwSrws-w-
-rwSrws-wx
-rwSrwsr--
-rwSrwsr-x
-rwSrwsrw-
-rwSrwsrwx
-rws--L---
-rws--L--x
-rws--L-w-
-rws--L-wx
-rws--Lr--
-rws--Lr-x
-rws--Lrw-
-rws--Lrwx
-rws--s---
-rws--s--x
-rws--s-w-
-rws--s-wx
-rws--sr--
-rws--sr-x
-rws--srw-
-rws--srwx
-rws-wL---
-rws-wL--x
-rws-wL-w-
-rws-wL-wx
-rws-wLr--
-rws-wLr-x
-rws-wLrw-
-rws-wLrwx
-rws-ws---
-rws-ws--x
-rws-ws-w-
-rws-ws-wx
-rws-wsr--
-rws-wsr-x
-rws-wsrw-
-rws-wsrwx
-rwsr-L---
-rwsr-L--x
-rwsr-L-w-
-rwsr-L-wx
-rwsr-Lr--
-rwsr-Lr-x
-rwsr-Lrw-
-rwsr-Lrwx
-rwsr-s---
-rwsr-s--x
-rwsr-s-w-
-rwsr-s-wx
-rwsr-sr--
-rwsr-sr-x
-rwsr-srw-
-rwsr-srwx
-rwsrwL---
-rwsrwL--x
-rwsrwL-w-
-rwsrwL-wx
-rwsrwLr--
-rwsrwLr-x
-rwsrwLrw-
-rwsrwLrwx
-rwsrws---
-rwsrws--x
-rwsrws-w-
-rwsrws-wx
-rwsrwsr--
-rwsrwsr-x
-rwsrwsrw-
-rwsrwsrwx
