# -*- mode: perl; -*-

use strict;
use warnings;

use Test::More tests => 41897;

###############################################################################
# Read and load configuration file and backend library.

use Config::Tiny ();

my $config_file = 'xt/author/lib.ini';
my $config = Config::Tiny -> read('xt/author/lib.ini')
  or die Config::Tiny -> errstr();

# Read the library to test.

our $LIB = $config->{_}->{lib};

die "No library defined in file '$config_file'"
  unless defined $LIB;
die "Invalid library name '$LIB' in file '$config_file'"
  unless $LIB =~ /^[A-Za-z]\w*(::\w+)*\z/;

# Load the library.

eval "require $LIB";
die $@ if $@;

###############################################################################

can_ok($LIB, '_digit');

use lib 't';
use Math::BigInt::Lib::TestUtil qw< randstr >;

# Generate test data.

my @data;

sub add_test_cases {
    my $x = shift;
    my $n = length $x;

    # Digits from right to left (positive index 0 .. N-1).

    for (my $i = 0 ; $i < $n ; ++$i) {
        my $digit = substr $x, $n - 1 - $i, 1;
        push @data, [ $x, $i, $digit ];
    }

    # Digits from left to right (negative index -1 .. -N).

    for (my $i = -1 ; $i >= -$n ; --$i) {
        my $digit = substr $x, -1 - $i, 1;
        push @data, [ $x, $i, $digit ];
    }
}

for (my $x = 0 ; $x <= 100 ; ++ $x) {
    add_test_cases(sprintf "%u", $x);
}

for (my $n = 4 ; $n <= 100 ; ++ $n) {
    add_test_cases(randstr($n, 10));
}

# List context.

for (my $i = 0 ; $i <= $#data ; ++ $i) {
    my ($in0, $in1, $out0) = @{ $data[$i] };

    my ($x, @got);

    my $test = qq|\$x = $LIB->_new("$in0"); |
             . qq|\@got = $LIB->_digit(\$x, $in1);|;

    diag("\n$test\n\n") if $ENV{AUTHOR_DEBUGGING};

    eval $test;
    is($@, "", "'$test' gives emtpy \$\@");

    subtest "_digit() in list context: $test", sub {
        plan tests => 3,

        cmp_ok(scalar @got, "==", 1,
               "'$test' gives one output arg");

        is(ref($got[0]), "",
           "'$test' output arg is a scalar");

        is($got[0], $out0,
           "'$test' output arg has the right value");
    };
}

# Scalar context.

for (my $i = 0 ; $i <= $#data ; ++ $i) {
    my ($in0, $in1, $out0) = @{ $data[$i] };

    my ($x, $got);

    my $test = qq|\$x = $LIB->_new("$in0"); |
             . qq|\$got = $LIB->_digit(\$x, $in1);|;

    diag("\n$test\n\n") if $ENV{AUTHOR_DEBUGGING};

    eval $test;
    is($@, "", "'$test' gives emtpy \$\@");

    subtest "_digit() in scalar context: $test", sub {
        plan tests => 2,

        is(ref($got), "",
           "'$test' output arg is a scalar");

        is($got, $out0,
           "'$test' output arg has the right value");
    };
}
