package Toolforge::MixNMatch::Object;

use strict;
use warnings;

our $VERSION = 0.04;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Toolforge::MixNMatch::Object - Toolforge Mix'n'match tool objects.

=head1 DESCRIPTION

This distributions is set of basic objects from Toolforge Mix'n'match tool
(https://mix-n-match.toolforge.org/).

=head1 SEE ALSO

=over

=item L<Toolforge::MixNMatch::Object::Catalog>

Mix'n'match catalog datatype.

=item L<Toolforge::MixNMatch::Object::User>

Mix'n'match user datatype.

=item L<Toolforge::MixNMatch::Object::YearMonth>

Mix'n'match year/month datatype.

=back

=head1 REPOSITORY

L<https://github.com/michal-josef-spacek/Toolforge-MixNMatch-Object>

=head1 AUTHOR

Michal Josef Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

© Michal Josef Špaček 2020-2025

BSD 2-Clause License

=head1 VERSION

0.04

=cut
