use strict;
use warnings;
use Test::More;
use Digest::BLAKE qw(blake_256 blake_256_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::BLAKE->new(256)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            blake_256_hex($data), $digest,
            "blake_256_hex: $len bits of $msg"
        );
        ok(
            blake_256($data) eq pack('H*', $digest),
            "blake_256: $len bits of $msg"
        );
    }

    my $md = Digest::BLAKE->new(256)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|716f6e863f744b9ac22c97ec7b76ea5f5908bc5b2f67c61510bfc4751384ea7a
00|81a10984912cd57c12e923b46142b2b434dfe1a0ef29c03de05555f9f2fee9b4
C0|eae1614ea36088a8fd69a4614c2d98fada81134baa991aebfb743cd297669b01
C0|4ac92b8903f7076563a6309eb9bd386807d28fe721fc8128af86e88967739443
80|c575142b6e471398bf9fc90a5660bb97f24cb106443b76e22b58084e82667b5d
48|45bc790b0180778efe9fd0381528ba9e9ec4460685375e1283e519e338b4c55d
50|673acd73e1ea3c418e7707cf543155e9dc0c52c6d4aa8a9b0559680b06992d48
98|46bf46a9db7079a34f1b2b4ceffc8236730c2b5ec2a9f0d105ab5b66be9f6fd8
CC|e104256a2bc501f459d03fac96b9014f593e22d30f4de525fa680c3aa189eb4f
9800|1088da8ca79a1498f7d4629654307d63715f26edf916c8fb8c09d2039d28c8bc
9D40|1b34cb31b73d6966f038cdd3d93fe973776f9f4bd5bd9b1008ae105edc53add3
AA80|6df64c36384f863cbed1ccf0a615c04b808b73f35131e3f95adfcb93e54e8df0
9830|37e539c6dfb9c94bc392090a41ae4eca0fe3eff478ef401cf163a73486754ef4
5030|10ec14653844b6cbda11d908680f27de195a00446b773eb64480168074fb9439
4D24|8f9d0cb5d596260935d8057c260c218091ba666ac14b1a46f2d918484cfbe173
CBDE|891837f7f166cd0603379a2803fe27fed35853f5c4b6feed0fc74b4502d6105c
41FB|8f341148be7e354fdf38b693d8c6b4e0bd57301a734f6fd35cd85b8491c3ddcd
4FF400|ddfc63311a6e1996b257af4ec0750bcbe400d7d507eea84aee9fc44b88127236
FD0440|5b452b7b003fab1abe488ba0dca0a6f5945d797a94f52e93d6e921af1a157fc4
424D00|6733ca84f1652ff5d5252d4affa42d3ebda3fbd21a9a8fc07297dad28df7273c
3FDEE0|1e5c24058d33f16a7cef6ad102e3a19b59e595598dd4ddc2c9b8182abbb89b84
335768|29a77b3fa2b97407791da3fa792e40555a2cae9fa85d559ba633ac2e817d6b5e
051E7C|3ef17d53fb61fe2f543a935820f244e25cc8c0ae30d9774ff22427a3fb820d7a
717F8C|b2224450512df4c070084e17f6c8a423c5e22a66a77f4eb5792418832dcb05a0
1F877C|bc334d1069099f10c601883ac6f3e7e9787c6aa53171f76a21923cc5ad3ab937
EB35CF80|7360eb4415d316866b8a748fcd90b7a014c6d62a18218a48cdf681538dcac8ec
B406C480|9e4a8d15be6cfd06425f224035a90ccb5fc8bf92e4d315bc6efe3d9c93085943
CEE88040|643cf377e140bb1f5d2710927c84ab23b0c258b6c0ab47da4b592180086c24d2
C584DB70|94b4d7f4830fda2e6ba7346f38456d28346589dec8b7dc6e61e3ec3580243c5e
53587BC8|2d7508d69c7fb9bfacf35fafc118840b8ad42fabae5f27adc9d74154f2e3a78a
69A305B0|eec86da7600c3953f088084364b37a3d2bb6522876b82f9cf9cfed764746d53d
C9375ECE|7ff30cb54acd2e019c3664c42f37002d67132098d313525e5bced93470d19a56
C1ECFDFC|b672a16f53982bab1e77685b71c0a5f6703ffd46a1c834be69f614bd128d658e
8D73E8A280|3b171d80684fcbb88067e7519e0af3ab3d378254d36633b3eb8585553717ecf0
06F2522080|d71133d28291531730403dbc363bf3d5a4c3db80861b7c3afbc4c769fedfd3aa
3EF6C36F20|2e9830df74711da1a21e815aa6ab37013ebded7de7088ae8d5fdb5174440fe0b
0127A1D340|5ba9f0532fbd0b44f0f7efd9988aa2e062a813797c732242ea5239f571adfb0f
6A6AB6C210|e03567eefd4e515a73999fac87deb90726bdc488f4be6aa8a974c7b4ee13fc65
AF3175E160|238036d9eeb9b09d9c9703b484833cc88097f27e34b8a94bef9f5e121b6d5575
B66609ED86|284e01f8b5604db347cd9d4ab95cc8d62d3640aeaf7502a2439fe780c598ba39
21F134AC57|d9134b2899057a7d8d320cc99e3e116982bc99d3c69d260a7f1ed3da8be68d99
3DC2AADFFC80|3e64d5852d9a09ea76007a7b159430c3715598017850ec288316e13b80fd61c7
9202736D2240|95f5bcf07e8a6c02b26f9fe29a5deb7faa5c03ab0e6180239924f5d48c7125af
F219BD629820|0fcf4c343c9d94bf3dea22069a28d23ff953bde89cd0dee4d1a521d4a302f8a3
F3511EE2C4B0|c32364fa782462bc3a3af38e03fb4f052bd238ab756eaabdd5f8000006446184
3ECAB6BF7720|511150cbab4c6be4d59d926b093a2d10fb6d9fb06169f47af2f1d75c07463428
CD62F688F498|a08519ce60cfef0554e8cd1a4d3cbe82504fe97b8b933cfccff5faac85bc787b
C2CBAA33A9F8|cc8eb0c743b2440399632474ba84980bebc9f6eedbbce3e31fdc497e0ba32d9d
C6F50BB74E29|637923bd29a35aa3ecbbd2a50549fc32c14cf0fdcaf41c3194dd7414fd224815
79F1B4CCC62A00|106cd7e18e3bd16353cf561411d87b609536856d57180155b60d7bc0a73b9d45
