# Generated by default/object.tt
package Paws::DevOpsGuru::ProactiveInsightSummary;
  use Moose;
  has Id => (is => 'ro', isa => 'Str');
  has InsightTimeRange => (is => 'ro', isa => 'Paws::DevOpsGuru::InsightTimeRange');
  has Name => (is => 'ro', isa => 'Str');
  has PredictionTimeRange => (is => 'ro', isa => 'Paws::DevOpsGuru::PredictionTimeRange');
  has ResourceCollection => (is => 'ro', isa => 'Paws::DevOpsGuru::ResourceCollection');
  has ServiceCollection => (is => 'ro', isa => 'Paws::DevOpsGuru::ServiceCollection');
  has Severity => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::ProactiveInsightSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::ProactiveInsightSummary object:

  $service_obj->Method(Att1 => { Id => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::ProactiveInsightSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Id

=head1 DESCRIPTION

Details about a proactive insight. This object is returned by
C<DescribeInsight.>

=head1 ATTRIBUTES


=head2 Id => Str

The ID of the proactive insight.


=head2 InsightTimeRange => L<Paws::DevOpsGuru::InsightTimeRange>




=head2 Name => Str

The name of the proactive insight.


=head2 PredictionTimeRange => L<Paws::DevOpsGuru::PredictionTimeRange>




=head2 ResourceCollection => L<Paws::DevOpsGuru::ResourceCollection>




=head2 ServiceCollection => L<Paws::DevOpsGuru::ServiceCollection>

A collection of the names of AWS services.


=head2 Severity => Str

The severity of the proactive insight.


=head2 Status => Str

The status of the proactive insight.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

