/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.io.Serializable;
import org.apache.sis.internal.jdk8.Predicate;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.operation.CoordinateOperation;

public class CoordinateOperationContext
implements Serializable {
    private static final long serialVersionUID = -6944460471653277973L;
    private Extent areaOfInterest;
    private double desiredAccuracy;

    public CoordinateOperationContext() {
    }

    public CoordinateOperationContext(Extent extent, double d) {
        ArgumentChecks.ensurePositive("accuracy", d);
        this.areaOfInterest = extent;
        this.desiredAccuracy = d;
    }

    public Extent getAreaOfInterest() {
        return this.areaOfInterest;
    }

    public void setAreaOfInterest(Extent extent) {
        if (extent != null) {
            extent = new DefaultExtent(extent);
        }
        this.areaOfInterest = extent;
    }

    public void setAreaOfInterest(GeographicBoundingBox geographicBoundingBox) {
        this.areaOfInterest = CoordinateOperationContext.setGeographicBoundingBox(this.areaOfInterest, geographicBoundingBox);
    }

    static Extent setGeographicBoundingBox(Extent extent, GeographicBoundingBox geographicBoundingBox) {
        if (extent != null) {
            DefaultExtent defaultExtent = DefaultExtent.castOrCopy(extent);
            defaultExtent.setGeographicElements(CollectionsExt.singletonOrEmpty(geographicBoundingBox));
            extent = defaultExtent;
        } else if (geographicBoundingBox != null) {
            extent = new DefaultExtent(null, geographicBoundingBox, null, null);
        }
        return extent;
    }

    public double getDesiredAccuracy() {
        return this.desiredAccuracy;
    }

    public void setDesiredAccuracy(double d) {
        ArgumentChecks.ensurePositive("accuracy", d);
        this.desiredAccuracy = d;
    }

    Predicate<CoordinateOperation> getOperationFilter() {
        return null;
    }
}

