/*-
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 1996-2001
 *	Sleepycat Software.  All rights reserved.
 *
 * $Id: crypto.h,v 1.2 2002/01/08 18:52:11 sue Exp $
 */
#ifndef	_DB_CRYPTO_H_
#define	_DB_CRYPTO_H_

#include "rijndael/rijndael-api-fst.h"

#define DB_ENCRYPT_AES	0x00000001	/* AES, assumes SHA1 checksum */

#define DB_IV_BYTES	16

/*
 * !!!
 * These are the internal representations of the algorithm flags.
 * They are used in both the DB_CIPHER structure and the CIPHER
 * structure so we can tell if users specified both passwd and alg
 * correctly.
 *
 * CIPHER_ANY is used when an app joins an existing env but doesn't
 * know the algorithm originally used.  This is only valid in the
 * DB_CIPHER structure until we open and can set it.
 */
#define	CIPHER_AES	0x00000001	/* AES algorithm */
#define	CIPHER_ANY	0x10000000	/* Only for DB_CIPHER */

/*
 * This structure is per-process, not in shared memory.
 */
struct __db_cipher {
	int		(*close) __P((DB_ENV *, void *));
	int		(*decrypt) __P((DB_ENV *, void *, void *, u_int8_t *, size_t));
	int		(*encrypt) __P((DB_ENV *, void *, void *, u_int8_t *, size_t));
	int		(*init) __P((DB_ENV *, void *));
	void		*data;		/* Alg-specific information */
	u_int32_t	flags;		/* Algorithm used - See above */
};

/*
 * Shared ciphering structure
 * No DB_MUTEX needed because all information is read-only after creation.
 */
typedef struct __cipher {
	roff_t		passwd;		/* Offset to shared passwd */
	size_t		passwd_len;	/* Length of passwd */
	u_int32_t	flags;		/* Algorithm used - see above */
} CIPHER;

/*
 * Algorithm specific information.
 */
/*
 * SHA1 checksumming
 */
typedef struct {
	u_int32_t	state[5];
	u_int32_t	count[2];
	unsigned char	buffer[64];
} SHA1_CTX;

/*
 * AES assumes the SHA1 checksumming (also called MAC)
 */
#define DB_MAC_MAGIC	"mac derivation key magic value"
#define DB_ENC_MAGIC	"encryption and decryption key value magic"

#define	DB_MAC_KEY	20	/* Size of MAC key */
#define DB_AES_KEYLEN	128	/* AES key length */

typedef struct __aes_cipher {
	keyInstance	decrypt_ki;	/* Decryption key instance */
	keyInstance	encrypt_ki;	/* Encryption key instance */
	u_int8_t	mac_key[DB_MAC_KEY]; /* MAC key */
	u_int32_t	flags;		/* AES-specific flags */
} AES_CIPHER;

#endif /* !_DB_CRYPTO_H_ */
