package Perl::Dist::WiX::Files::Entry;

#####################################################################
# Perl::Dist::WiX::Files::Entry - Class for a <File> tag.
#
# Copyright 2009 Curtis Jewell
#
# License is the same as perl. See Wix.pm for details.
#
#<<<
use 5.006;
use strict;
use warnings;
use vars                  qw( $VERSION                              );
use Object::InsideOut     qw( Perl::Dist::WiX::Base::Entry Storable );
use Params::Util          qw( _IDENTIFIER _STRING                   );
use File::Spec::Functions qw( splitpath                             );

use version; $VERSION = qv('0.13_04');
#>>>
#####################################################################
# Accessors:
#   id: Returns the id parameter generated by new.
#   name, filename: Returns the name or filename parameter passed in to new.

my @name : Field : Arg(name) : Get(name);
my @id : Field : Arg(Name => 'id', Required => 1) : Get(id);

sub filename { return $_[0]->name; }

#####################################################################
# Constructor for Files::Entry
#
# Parameters: [pairs]
#   id: ID attribute to the <File> tag.
#   name: Name attribute to the <File> tag.

sub _pre_init : PreInit {
	my ( $self, $args ) = @_;

	# Check params
	unless ( _STRING( $args->{name} ) ) {
		PDWiX->throw('Missing or invalid name param');
	}

	# Create an ID and GUID.
	unless ( defined $args->{id} ) {
		$args->{id} = $self->generate_guid( $args->{name} );
		$args->{id} =~ s{-}{_}smg;
	}

	return;
} ## end sub _pre_init :

#####################################################################
# Main Methods

########################################
# as_string
# Parameters:
#   None
# Returns:
#   String representation of <File> tag represented by this object.

sub as_string {
	my $self      = shift;
	my $object_id = ${$self};
	my $answer;

	if ( $name[$object_id] =~ m{\.AAA\z}sm ) {

		# If the file is a .AAA file, drop it in the original file's place.
		my ( undef, undef, $filename ) = splitpath( $name[$object_id] );
		$filename = substr $filename, 0, -4;
#<<<
        $answer =
            q{<File Id='F_} . $id[$object_id]
          . q{' Name='}     . $filename
          . q{' Source='}   . $name[$object_id] . q{' />};
#>>>
	} else {

  # Name= parameter defults to the filename portion of the Source parameter,
  # so it isn't needed.
#<<<
        $answer =
            q{<File Id='F_} . $id[$object_id]
          . q{' Source='}   . $name[$object_id] . q{' />};
#>>>
	}

	return $answer;
} ## end sub as_string

1;
