use Stenciller::Standard;

our $VERSION = '0.1210'; # VERSION:
# PODNAME: Stenciller::Utils

role Stenciller::Utils using Moose {

    method eval_to_hashref(Str $possible_hash!, Path|Str $faulty_file! --> HashRef) {
        my $settings = eval $possible_hash;
        die sprintf "Can't parse stencil start: <%s> in %s: %s", $possible_hash, $faulty_file, $@ if $@;
        return $settings;
    }
    method eval(Str $string!) {
        eval $string;
        die sprintf "Can't parse %s: %s", $string, $@ if $@;
        return 1;
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Stenciller::Utils

=head1 VERSION

Version 0.1210, released 2015-02-09.

=head1 SOURCE

L<https://github.com/Csson/p5-Stenciller>

=head1 HOMEPAGE

L<https://metacpan.org/release/Stenciller>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
