#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for all tag names
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.03';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

my @tableList = (
    'Image::ExifTool::APP12',
    'Image::ExifTool::BMP::Main',
    'Image::ExifTool::Canon::CameraSettings',
    'Image::ExifTool::Canon::ColorInfo',
    'Image::ExifTool::Canon::ColorInfoD30',
    'Image::ExifTool::Canon::FileInfo',
    'Image::ExifTool::Canon::FocalLength',
    'Image::ExifTool::Canon::LensInfo1D',
    'Image::ExifTool::Canon::Main',
    'Image::ExifTool::Canon::Panorama',
    'Image::ExifTool::Canon::PictureInfo',
    'Image::ExifTool::Canon::PreviewImageInfo',
    'Image::ExifTool::Canon::ShotInfo',
    'Image::ExifTool::Canon::WhiteBalance',
    'Image::ExifTool::CanonCustom::Functions10D',
    'Image::ExifTool::CanonCustom::Functions1D',
    'Image::ExifTool::CanonCustom::Functions20D',
    'Image::ExifTool::CanonCustom::FunctionsD30',
    'Image::ExifTool::CanonRaw::ExposureInfo',
    'Image::ExifTool::CanonRaw::FlashInfo',
    'Image::ExifTool::CanonRaw::ImageFormat',
    'Image::ExifTool::CanonRaw::ImageInfo',
    'Image::ExifTool::CanonRaw::Main',
    'Image::ExifTool::CanonRaw::MakeModel',
    'Image::ExifTool::CanonRaw::SensorInfo',
    'Image::ExifTool::CanonRaw::TimeStamp',
    'Image::ExifTool::Casio::Main',
    'Image::ExifTool::Casio::Type2',
    'Image::ExifTool::Exif::Main',
    'Image::ExifTool::FujiFilm::Main',
    'Image::ExifTool::GPS::Main',
    'Image::ExifTool::GeoTiff::Main',
    'Image::ExifTool::ICC_Profile::Chromaticity',
    'Image::ExifTool::ICC_Profile::ColorantTable',
    'Image::ExifTool::ICC_Profile::Header',
    'Image::ExifTool::ICC_Profile::Main',
    'Image::ExifTool::ICC_Profile::Measurement',
    'Image::ExifTool::ICC_Profile::ViewingConditions',
    'Image::ExifTool::IPTC::ApplicationRecord',
    'Image::ExifTool::IPTC::EnvelopeRecord',
    'Image::ExifTool::IPTC::Main',
    'Image::ExifTool::IPTC::NewsPhoto',
    'Image::ExifTool::IPTC::ObjectData',
    'Image::ExifTool::IPTC::PostObjectData',
    'Image::ExifTool::IPTC::PreObjectData',
    'Image::ExifTool::Jpeg2000::CaptureResolution',
    'Image::ExifTool::Jpeg2000::DisplayResolution',
    'Image::ExifTool::Jpeg2000::ImageHeader',
    'Image::ExifTool::Jpeg2000::Main',
    'Image::ExifTool::Kodak::Borders',
    'Image::ExifTool::Kodak::Main',
    'Image::ExifTool::Kodak::SpecialEffects',
    'Image::ExifTool::Kodak::Type2',
    'Image::ExifTool::Kodak::Type3',
    'Image::ExifTool::Kodak::Type4',
    'Image::ExifTool::Kodak::Type5',
    'Image::ExifTool::Kodak::Type6',
    'Image::ExifTool::Kodak::Unknown',
    'Image::ExifTool::MIFF::Main',
    'Image::ExifTool::MNG::Background',
    'Image::ExifTool::MNG::BasisObject',
    'Image::ExifTool::MNG::ClipObjects',
    'Image::ExifTool::MNG::CloneObject',
    'Image::ExifTool::MNG::DefineObject',
    'Image::ExifTool::MNG::DeltaPNGHeader',
    'Image::ExifTool::MNG::ExportImage',
    'Image::ExifTool::MNG::FramePriority',
    'Image::ExifTool::MNG::JNGHeader',
    'Image::ExifTool::MNG::Loop',
    'Image::ExifTool::MNG::MNGHeader',
    'Image::ExifTool::MNG::MagnifyObject',
    'Image::ExifTool::MNG::Main',
    'Image::ExifTool::MNG::MoveObjects',
    'Image::ExifTool::MNG::PasteImage',
    'Image::ExifTool::MNG::PromoteParent',
    'Image::ExifTool::MNG::ShowObjects',
    'Image::ExifTool::MNG::TerminationAction',
    'Image::ExifTool::Minolta::CameraSettings',
    'Image::ExifTool::Minolta::Main',
    'Image::ExifTool::Nikon::ColorBalance0100',
    'Image::ExifTool::Nikon::ColorBalance0102',
    'Image::ExifTool::Nikon::ColorBalance0103',
    'Image::ExifTool::Nikon::LensData00',
    'Image::ExifTool::Nikon::LensData01',
    'Image::ExifTool::Nikon::Main',
    'Image::ExifTool::Nikon::MakerNotesB',
    'Image::ExifTool::Nikon::NikonCaptureOffsets',
    'Image::ExifTool::Nikon::PreviewImage',
    'Image::ExifTool::Olympus::CameraSettings',
    'Image::ExifTool::Olympus::Equipment',
    'Image::ExifTool::Olympus::FocusInfo',
    'Image::ExifTool::Olympus::ImageProcessing',
    'Image::ExifTool::Olympus::Main',
    'Image::ExifTool::Olympus::RawDevelopment',
    'Image::ExifTool::PDF::AdobePhotoshop',
    'Image::ExifTool::PDF::ColorSpace',
    'Image::ExifTool::PDF::DefaultRGB',
    'Image::ExifTool::PDF::ICCBased',
    'Image::ExifTool::PDF::ImageResources',
    'Image::ExifTool::PDF::Info',
    'Image::ExifTool::PDF::Kids',
    'Image::ExifTool::PDF::Main',
    'Image::ExifTool::PDF::Metadata',
    'Image::ExifTool::PDF::Pages',
    'Image::ExifTool::PDF::PieceInfo',
    'Image::ExifTool::PDF::Private',
    'Image::ExifTool::PDF::Resources',
    'Image::ExifTool::PDF::Root',
    'Image::ExifTool::PNG::ImageHeader',
    'Image::ExifTool::PNG::Main',
    'Image::ExifTool::PNG::PhysicalPixel',
    'Image::ExifTool::PNG::PrimaryChromaticities',
    'Image::ExifTool::PNG::TextualData',
    'Image::ExifTool::Panasonic::Main',
    'Image::ExifTool::Pentax::Main',
    'Image::ExifTool::Photoshop::JPEG_Quality',
    'Image::ExifTool::Photoshop::Main',
    'Image::ExifTool::PostScript::Main',
    'Image::ExifTool::PrintIM::Main',
    'Image::ExifTool::Ricoh::Main',
    'Image::ExifTool::Ricoh::Subdir',
    'Image::ExifTool::Ricoh::Text',
    'Image::ExifTool::Sanyo::Main',
    'Image::ExifTool::Sigma::Main',
    'Image::ExifTool::Sony::Main',
    'Image::ExifTool::Unknown::Main',
    'Image::ExifTool::XMP::Main',
    'Image::ExifTool::compositeTags',
    'Image::ExifTool::extraTags',
);

my %tagLookup = (
    'actionadvised' => { 38 => 0x2a },
    'addoriginaldecisiondata' => { 16 => 0x11 },
    'adjustmentmode' => { 123 => 0x15 },
    'adobephotoshop' => { 104 => 'AdobePhotoshop' },
    'advisory' => { 126 => 'Advisory' },
    'aebbracketvalue' => { 12 => 0x11 },
    'aebsequence' => { 14 => 0x9, 15 => 0x9, 16 => 0x8, 17 => 0x7 },
    'afaperture' => { 83 => 0x5 },
    'afareas' => { 88 => 0x304 },
    'afassist' => { 14 => 0x5, 17 => 0x5 },
    'afassistbeam' => { 16 => 0x4 },
    'afmode' => { 123 => 0x5 },
    'afpoint' => { 2 => 0x13, 84 => 0x88 },
    'afpointactivationarea' => { 15 => 0x11 },
    'afpointillumination' => { 15 => 0xa },
    'afpointregistration' => { 14 => 0x7 },
    'afpointselection' => { 15 => 0xb },
    'afpointselectionmethod' => { 16 => 0xc },
    'afpointspotmetering' => { 15 => 0xd },
    'afpointsused' => { 10 => 0x16 },
    'afsearch' => { 88 => 0x303 },
    'aiservotrackingsensitivity' => { 15 => 0x14 },
    'aliaslayermetadata' => { 28 => 0xc660 },
    'alphabitdepth' => { 67 => 0xc },
    'alphachannelsnames' => { 116 => 0x3ee },
    'alphacompression' => { 67 => 0xd },
    'alphafilter' => { 67 => 0xe },
    'alphaidentifiers' => { 116 => 0x41d },
    'alphainterlace' => { 67 => 0xf },
    'alphasample' => { 60 => 0x19 },
    'analogbalance' => { 28 => 0xc627 },
    'analogzoom' => { 53 => 0x1e },
    'annotations' => { 28 => 0xc44f },
    'antialiasstrength' => { 28 => 0xc632 },
    'aperture' => { 127 => 'Aperture' },
    'aperturevalue' => { 28 => 0x9202, 126 => 'ApertureValue' },
    'app1_profile' => { 58 => 'profile-APP1', 112 => 'Raw profile type APP1' },
    'applicationnotes' => { 28 => 0x2bc },
    'applicationrecordversion' => { 38 => 0x0 },
    'armidentifier' => { 39 => 0x78 },
    'armversion' => { 39 => 0x7a },
    'artist' => { 28 => 0x13b, 126 => 'Artist' },
    'asshotneutral' => { 28 => 0xc628 },
    'asshotwhitexy' => { 28 => 0xc629 },
    'assistbuttonfunction' => { 14 => 0xd },
    'association' => { 48 => 'asoc' },
    'atob0' => { 35 => 'A2B0' },
    'atob1' => { 35 => 'A2B1' },
    'atob2' => { 35 => 'A2B2' },
    'audio' => { 113 => 0x20 },
    'audioduration' => { 38 => 0x99 },
    'audiooutcue' => { 38 => 0x9a },
    'audiosamplingrate' => { 38 => 0x97 },
    'audiosamplingresolution' => { 38 => 0x98 },
    'audiotype' => { 38 => 0x96 },
    'author' => { 99 => 'Author', 112 => 'Author', 117 => 'Author', 126 => 'Author' },
    'authorsposition' => { 126 => 'AuthorsPosition' },
    'autoafpoint' => { 114 => 0xf },
    'autobracket' => { 123 => 0x19 },
    'autobracketing' => { 29 => 0x1100 },
    'autoexposurebracketing' => { 12 => 0x10 },
    'autofocus' => { 90 => 0x209 },
    'autorotate' => { 12 => 0x1b },
    'auxiliarylens' => { 84 => 0x82 },
    'avvalue' => { 18 => 0x2 },
    'background' => { 71 => 'BACK' },
    'backgroundcolor' => { 58 => 'background-color', 59 => 0x0, 109 => 'bKGD', 116 => 0x3f2 },
    'backgroundcolorindicator' => { 28 => 0x84e8 },
    'backgroundcolorvalue' => { 28 => 0x84ea },
    'backgroundimageid' => { 59 => 0x7 },
    'backgroundtiling' => { 59 => 0x9 },
    'badfaxlines' => { 28 => 0x146 },
    'baseiso' => { 22 => 0x101c },
    'baselineexposure' => { 28 => 0xc62a },
    'baselinenoise' => { 28 => 0xc62b },
    'baselinesharpness' => { 28 => 0xc62c },
    'baseurl' => { 126 => 'BaseURL' },
    'basisobject' => { 71 => 'BASI' },
    'batterylevel' => { 28 => 0x828f },
    'bayergreensplit' => { 28 => 0xc62d },
    'bestqualityscale' => { 28 => 0xc65c },
    'bestshotmode' => { 27 => 0x3007 },
    'binaryfilter' => { 48 => 'bfil' },
    'bitdepth' => { 1 => 0xe, 60 => 0x8, 67 => 0x9, 108 => 0x8 },
    'bitspercomponent' => { 41 => 0x87, 47 => 0xa, 48 => 'bpcc' },
    'bitsperextendedrunlength' => { 28 => 0x84e5 },
    'bitsperrunlength' => { 28 => 0x84e4 },
    'bitspersample' => { 28 => 0x102, 126 => 'BitsPerSample' },
    'blacklevel' => { 28 => 0xc61a, 92 => 0x1012 },
    'blackleveldeltah' => { 28 => 0xc61b },
    'blackleveldeltav' => { 28 => 0xc61c },
    'blacklevelrepeatdim' => { 28 => 0xc619 },
    'blackpoint' => { 114 => 0x200 },
    'blocklocation' => { 64 => 0xc },
    'blocksize' => { 64 => 0x4 },
    'bluebalance' => { 79 => 0x1, 80 => 0x1, 81 => 0x1, 92 => 0x1018, 114 => 0x1b },
    'bluebalanceauto' => { 13 => 0x1 },
    'bluebalanceb&w' => { 13 => 0xf },
    'bluebalancecloudy' => { 13 => 0x5 },
    'bluebalancecustom' => { 13 => 0xd },
    'bluebalancedaylight' => { 13 => 0x3 },
    'bluebalanceflash' => { 13 => 0xb },
    'bluebalancefluorescent' => { 13 => 0x9 },
    'bluebalanceshade' => { 13 => 0x11 },
    'bluebalancetungsten' => { 13 => 0x7 },
    'bluegain' => { 121 => 'Bg' },
    'bluehue' => { 126 => 'BlueHue' },
    'bluematrixcolumn' => { 35 => 'bXYZ' },
    'blueprimary' => { 58 => 'blue-primary' },
    'bluesample' => { 60 => 0x15 },
    'bluesaturation' => { 126 => 'BlueSaturation' },
    'bluetrc' => { 35 => 'bTRC' },
    'bluex' => { 111 => 0x6 },
    'bluey' => { 111 => 0x7 },
    'blurwarning' => { 29 => 0x1300 },
    'bodyfirmwareversion' => { 89 => 0x104 },
    'bordercolor' => { 58 => 'border-color' },
    'borderid' => { 49 => 0x2 },
    'borderinformation' => { 116 => 0x3f1 },
    'borderlocation' => { 49 => 0x3 },
    'bordername' => { 49 => 0x1 },
    'bordersversion' => { 49 => 0x0 },
    'bordertype' => { 49 => 0x4 },
    'bottommag' => { 70 => 0xf },
    'boundaryorigin' => { 73 => 0x18 },
    'bracket' => { 92 => 0x1006 },
    'bracketstep' => { 77 => 0xe },
    'brightness' => { 28 => 0xfe53, 77 => 0x2c, 126 => 'Brightness' },
    'brightnessvalue' => { 28 => 0x9203, 126 => 'BrightnessValue' },
    'btoa0' => { 35 => 'B2A0' },
    'btoa1' => { 35 => 'B2A1' },
    'btoa2' => { 35 => 'B2A2' },
    'bulbduration' => { 12 => 0x18 },
    'burstmode' => { 50 => 0xa },
    'burstmode2' => { 50 => 0x18 },
    'bw_halftoninginfo' => { 116 => 0x3f4 },
    'bw_transferfunc' => { 116 => 0x3f7 },
    'bwfilter' => { 77 => 0x2a },
    'bwmode' => { 92 => 0x203 },
    'by-line' => { 38 => 0x50 },
    'by-linetitle' => { 38 => 0x55 },
    'calibrationdatetime' => { 35 => 'calt' },
    'calibrationilluminant1' => { 28 => 0xc65a },
    'calibrationilluminant2' => { 28 => 0xc65b },
    'cameracalibration1' => { 28 => 0xc623 },
    'cameracalibration2' => { 28 => 0xc624 },
    'cameraid' => { 92 => 0x209, 122 => 0x209 },
    'cameraiso' => { 2 => 0x10 },
    'cameraobject' => { 22 => 0x2807 },
    'cameraowner' => { 28 => 0xc353 },
    'camerasettings' => { 92 => 0x2020 },
    'camerasettingsversion' => { 88 => 0x0 },
    'cameraspecification' => { 22 => 0x3004 },
    'canoncamerasettings' => { 8 => 0x1, 22 => 0x102d },
    'canoncolorinfo' => { 8 => 0xa0 },
    'canoncolorinfo1' => { 22 => 0x32 },
    'canoncolorinfo2' => { 22 => 0x102c },
    'canoncolorinfod30' => { 8 => 0xa },
    'canoncustomfunctions10d' => { 8 => 0xf, 22 => 0x1033 },
    'canoncustomfunctions1d' => { 8 => 0x90 },
    'canoncustomfunctions20d' => { 8 => 0xf, 22 => 0x1033 },
    'canoncustomfunctionsd30' => { 8 => 0xf, 22 => 0x1033 },
    'canonexposuremode' => { 2 => 0x14 },
    'canonfiledescription' => { 22 => 0x805 },
    'canonfileinfo' => { 8 => 0x93 },
    'canonfilelength' => { 8 => 0xe },
    'canonfirmwareversion' => { 8 => 0x7, 22 => 0x80b },
    'canonflashinfo' => { 8 => 0x3 },
    'canonflashmode' => { 2 => 0x4 },
    'canonfocallength' => { 8 => 0x2, 22 => 0x1029 },
    'canonimageheight' => { 10 => 0x3 },
    'canonimageheightasshot' => { 10 => 0x5 },
    'canonimagesize' => { 2 => 0xa },
    'canonimagetype' => { 8 => 0x6, 22 => 0x815 },
    'canonimagewidth' => { 10 => 0x2 },
    'canonimagewidthasshot' => { 10 => 0x4 },
    'canonlensinfo1d' => { 8 => 0xd },
    'canonpanorama' => { 8 => 0x5 },
    'canonpictureinfo' => { 8 => 0x12, 22 => 0x1038 },
    'canonrawmakemodel' => { 22 => 0x80a },
    'canonshotinfo' => { 8 => 0x4, 22 => 0x102a },
    'caption-abstract' => { 38 => 0x78 },
    'captionwriter' => { 126 => 'CaptionWriter' },
    'captureconditionspar' => { 28 => 0xc352 },
    'capturedevicefid' => { 28 => 0xc357 },
    'captureresolution' => { 48 => 'resc' },
    'capturexresolution' => { 45 => 0x4 },
    'capturexresolutionunit' => { 45 => 0x9 },
    'captureyresolution' => { 45 => 0x0 },
    'captureyresolutionunit' => { 45 => 0x8 },
    'casioimagesize' => { 27 => 0x9 },
    'category' => { 38 => 0xf, 126 => 'Category' },
    'ccdisosensitivity' => { 27 => 0x3014 },
    'ccdsensitivity' => { 26 => 0x14, 85 => 0x6 },
    'celllength' => { 28 => 0x109 },
    'cellwidth' => { 28 => 0x108 },
    'certificate' => { 126 => 'Certificate' },
    'cfalayout' => { 28 => 0xc617 },
    'cfapattern' => { 28 => 0xa302, 126 => 'CFAPattern', 127 => 'CFAPattern' },
    'cfapattern2' => { 28 => 0x828e },
    'cfapatterncolumns' => { 126 => 'CFAPatternColumns' },
    'cfapatternrows' => { 126 => 'CFAPatternRows' },
    'cfapatternvalues' => { 126 => 'CFAPatternValues' },
    'cfaplanecolor' => { 28 => 0xc616 },
    'cfarepeatpatterndim' => { 28 => 0x828d },
    'chartarget' => { 35 => 'targ' },
    'chromablurradius' => { 28 => 0xc631 },
    'chromaticaberrationb' => { 126 => 'ChromaticAberrationB' },
    'chromaticaberrationr' => { 126 => 'ChromaticAberrationR' },
    'chromaticadaptation' => { 35 => 'chad' },
    'chromaticity' => { 35 => 'chrm' },
    'chromaticitychannel1' => { 32 => 0xc },
    'chromaticitychannel2' => { 32 => 0x14 },
    'chromaticitychannel3' => { 32 => 0x1c },
    'chromaticitychannel4' => { 32 => 0x24 },
    'chromaticitychannels' => { 32 => 0x8 },
    'chromaticitycolorant' => { 32 => 0xa },
    'circleofconfusion' => { 127 => 'CircleOfConfusion' },
    'city' => { 38 => 0x5a, 126 => 'City' },
    'class' => { 58 => 'class' },
    'classifystate' => { 38 => 0xe1 },
    'cleanfaxdata' => { 28 => 0x147 },
    'clipboundary' => { 61 => 0x5 },
    'clipobjects' => { 71 => 'CLIP' },
    'clippath' => { 28 => 0x157 },
    'clippingboundary' => { 63 => 0xc },
    'clippingpathname' => { 116 => 0xbb7 },
    'cloneid' => { 62 => 0x2 },
    'cloneobject' => { 71 => 'CLON' },
    'clonetype' => { 62 => 0x4 },
    'cmmflags' => { 34 => 0x2c },
    'codedcharacterset' => { 39 => 0x5a },
    'codestreamheader' => { 48 => 'jpch' },
    'codestreamregistration' => { 48 => 'creg' },
    'codingmethods' => { 28 => 0x193 },
    'coloradjustment' => { 123 => 0x14 },
    'coloradjustmentmode' => { 122 => 0x210 },
    'colorant1coordinates' => { 33 => 0x2c },
    'colorant1name' => { 33 => 0xc },
    'colorant2coordinates' => { 33 => 0x52 },
    'colorant2name' => { 33 => 0x32 },
    'colorant3coordinates' => { 33 => 0x78 },
    'colorant3name' => { 33 => 0x58 },
    'colorantcount' => { 33 => 0x8 },
    'colorantorder' => { 35 => 'clro' },
    'coloranttable' => { 35 => 'clrt' },
    'colorbalance0100' => { 84 => 0x97 },
    'colorbalance0102' => { 84 => 0x97 },
    'colorbalance0103' => { 84 => 0x97 },
    'colorbalance1' => { 84 => 0xc },
    'colorbalanceblue' => { 77 => 0x1e },
    'colorbalancegreen' => { 77 => 0x1d },
    'colorbalancered' => { 77 => 0x1c },
    'colorbalanceunknown' => { 84 => 0x97 },
    'colorbitdepth' => { 21 => 0x5 },
    'colorbw' => { 21 => 0x6 },
    'colorcalibrationmatrix' => { 41 => 0x46 },
    'colorcharacterization' => { 28 => 0x84ed },
    'colorcontrol' => { 92 => 0x102b },
    'coloreffect' => { 113 => 0x28 },
    'colorfilter' => { 77 => 0x29 },
    'colorgroup' => { 48 => 'cgrp' },
    'colorhalftoninginfo' => { 116 => 0x3f5 },
    'colorhue' => { 84 => 0x8d },
    'colormap' => { 28 => 0x140 },
    'colormatrix' => { 4 => 0xa, 91 => 0x200, 92 => 0x1011 },
    'colormatrix1' => { 28 => 0xc621 },
    'colormatrix2' => { 28 => 0xc622 },
    'colormode' => { 27 => 0x3015, 50 => 0x66, 77 => 0x28, 78 => 0x101, 84 => 0x3, 85 => 0x4, 92 => 0x101 },
    'colornoisereduction' => { 126 => 'ColorNoiseReduction' },
    'colorpalette' => { 41 => 0x55 },
    'colorprofile' => { 77 => 0x33 },
    'colorrepresentation' => { 41 => 0x3c },
    'colorresponseunit' => { 28 => 0x12c },
    'colors' => { 58 => 'colors' },
    'colorsamplersresource' => { 116 => 0x40e },
    'colorsequence' => { 28 => 0x84e1, 41 => 0x41 },
    'colorspace' => { 22 => 0x10b4, 28 => 0xa001, 58 => 'colorspace', 88 => 0x507, 106 => 'ColorSpace', 123 => 0xb, 126 => 'ColorSpace' },
    'colorspacedata' => { 34 => 0x10 },
    'colorspecification' => { 48 => 'colr' },
    'colortable' => { 28 => 0x84e6 },
    'colortemperature' => { 3 => 0x9, 4 => 0x9, 8 => 0xae, 22 => 0x10ae },
    'colortone' => { 2 => 0x2a },
    'colortransferfuncs' => { 116 => 0x3f8 },
    'colortype' => { 60 => 0x9, 67 => 0x8, 108 => 0x9 },
    'comment' => { 112 => 'Comment', 128 => 'Comment' },
    'componentbitdepth' => { 21 => 0x4 },
    'componentdefinition' => { 48 => 'cdef' },
    'componentmapping' => { 48 => 'cmap' },
    'componentsconfiguration' => { 28 => 0x9101, 126 => 'ComponentsConfiguration' },
    'componentversion' => { 22 => 0x80c },
    'compositinglayerheader' => { 48 => 'jplh' },
    'composition' => { 48 => 'comp' },
    'compositionmode' => { 73 => 0xd },
    'compositionoptions' => { 48 => 'copt' },
    'compressedbitsperpixel' => { 28 => 0x9102, 126 => 'CompressedBitsPerPixel' },
    'compressedimagesize' => { 78 => 0x40, 92 => 0x40 },
    'compressedtext' => { 109 => 'zTXt' },
    'compression' => { 1 => 0x10, 28 => 0x103, 47 => 0xb, 58 => 'compression', 60 => 0xa, 67 => 0xa, 87 => 0x103, 108 => 0xa, 126 => 'Compression' },
    'compressionfactor' => { 88 => 0x50d },
    'compressionratio' => { 92 => 0x1034 },
    'concreteflag' => { 62 => 0x6, 63 => 0x3 },
    'conditionalfec' => { 127 => 'ConditionalFEC' },
    'confirmedobjectsize' => { 43 => 0xa },
    'consecutivebadfaxlines' => { 28 => 0x148 },
    'contact' => { 38 => 0x76 },
    'contentlocationcode' => { 38 => 0x1a },
    'contentlocationname' => { 38 => 0x1b },
    'contiguouscodestream' => { 48 => 'jp2c' },
    'continuousdrive' => { 2 => 0x5 },
    'contrast' => { 2 => 0xd, 26 => 0xc, 27 => 0x20, 28 => [0xa408,0xfe54], 29 => 0x1004, 77 => 0x20, 92 => 0x1029, 113 => 0x2c, 114 => 0x20, 123 => 0xd, 126 => 'Contrast' },
    'contrastsetting' => { 88 => 0x505 },
    'contributor' => { 126 => 'Contributor' },
    'converter' => { 28 => 0xfe4d, 85 => 0xb },
    'copyright' => { 28 => 0x8298, 35 => 'cprt', 112 => 'Copyright', 126 => 'Copyright' },
    'copyrightflag' => { 116 => 0x40a },
    'copyrightnotice' => { 38 => 0x74 },
    'coringfilter' => { 92 => 0x102d },
    'country' => { 126 => 'Country' },
    'country-primarylocationcode' => { 38 => 0x64 },
    'country-primarylocationname' => { 38 => 0x65 },
    'countrycode' => { 126 => 'CountryCode' },
    'coverage' => { 126 => 'Coverage' },
    'crdinfo' => { 35 => 'crdi' },
    'createdate' => { 28 => 0x9004, 99 => 'CreationDate', 117 => 'CreationDate', 126 => 'CreateDate' },
    'creationdate' => { 126 => 'CreationDate' },
    'creationtime' => { 112 => 'Creation Time' },
    'creator' => { 99 => 'Creator', 117 => 'Creator', 126 => 'Creator' },
    'creatorcontactinfo' => { 126 => 'CreatorContactInfo' },
    'creatorcontactinfociadrcity' => { 126 => 'CreatorContactInfoCiAdrCity' },
    'creatorcontactinfociadrctry' => { 126 => 'CreatorContactInfoCiAdrCtry' },
    'creatorcontactinfociadrextadr' => { 126 => 'CreatorContactInfoCiAdrExtadr' },
    'creatorcontactinfociadrpcode' => { 126 => 'CreatorContactInfoCiAdrPcode' },
    'creatorcontactinfociadrregion' => { 126 => 'CreatorContactInfoCiAdrRegion' },
    'creatorcontactinfociemailwork' => { 126 => 'CreatorContactInfoCiEmailWork' },
    'creatorcontactinfocitelwork' => { 126 => 'CreatorContactInfoCiTelWork' },
    'creatorcontactinfociurlwork' => { 126 => 'CreatorContactInfoCiUrlWork' },
    'creatortool' => { 126 => 'CreatorTool' },
    'credit' => { 38 => 0x6e, 126 => 'Credit' },
    'cross-reference' => { 48 => 'cref' },
    'customrendered' => { 28 => 0xa401, 126 => 'CustomRendered' },
    'customsaturation' => { 88 => 0x503 },
    'datacompressionmethod' => { 41 => 0x6e },
    'datadump' => { 84 => 0x10, 92 => 0xf00, 113 => 0x21, 114 => 0x3fe, 122 => 0xf00 },
    'datadump2' => { 92 => 0xf01 },
    'dataimprint' => { 77 => 0x34 },
    'datareference' => { 48 => 'dtbl' },
    'datatype' => { 28 => 0x80e4 },
    'date' => { 50 => 0x10, 53 => 0xc, 114 => 0x6, 126 => 'Date' },
    'datecreated' => { 38 => 0x37, 126 => 'DateCreated' },
    'datesent' => { 39 => 0x46 },
    'datetime' => { 126 => 'DateTime' },
    'datetimecreated' => { 127 => 'DateTimeCreated' },
    'datetimedigitized' => { 126 => 'DateTimeDigitized' },
    'datetimeoriginal' => { 25 => 0x0, 28 => 0x9003, 126 => 'DateTimeOriginal', 127 => 'DateTimeOriginal' },
    'datetimestamp' => { 50 => 0x64 },
    'dealeridnumber' => { 28 => 0xc356 },
    'decode' => { 28 => 0x1b1 },
    'decodertable' => { 22 => 0x1835 },
    'decposition' => { 77 => 0x32 },
    'defaultcroporigin' => { 28 => 0xc61f },
    'defaultcropsize' => { 28 => 0xc620 },
    'defaultimagecolor' => { 28 => 0x1b2 },
    'defaultrgb' => { 95 => 'DefaultRGB' },
    'defaultscale' => { 28 => 0xc61e },
    'defineobject' => { 71 => 'DEFI' },
    'delay' => { 58 => 'delay', 76 => 0x2 },
    'deltapngheader' => { 71 => 'DHDR' },
    'deltatype' => { 61 => 0x4, 64 => 0x3, 66 => 0x0, 72 => 0x4 },
    'deltaxy' => { 62 => 0x8, 72 => 0x5 },
    'depth' => { 58 => 'depth' },
    'derivedfrom' => { 126 => 'DerivedFrom' },
    'derivedfromdocumentid' => { 126 => 'DerivedFromDocumentID' },
    'derivedfrominstanceid' => { 126 => 'DerivedFromInstanceID' },
    'derivedfrommanager' => { 126 => 'DerivedFromManager' },
    'derivedfrommanagervariant' => { 126 => 'DerivedFromManagerVariant' },
    'derivedfrommanageto' => { 126 => 'DerivedFromManageTo' },
    'derivedfrommanageui' => { 126 => 'DerivedFromManageUI' },
    'derivedfromrenditionclass' => { 126 => 'DerivedFromRenditionClass' },
    'derivedfromrenditionparams' => { 126 => 'DerivedFromRenditionParams' },
    'derivedfromversionid' => { 126 => 'DerivedFromVersionID' },
    'description' => { 112 => 'Description', 126 => 'Description' },
    'desiredreproductions' => { 48 => 'drep' },
    'destination' => { 39 => 0x5 },
    'destinationcity' => { 114 => 0x24 },
    'destinationcitycode' => { 114 => 0x1001 },
    'destinationdst' => { 114 => 0x26 },
    'destinationid' => { 73 => 0x0 },
    'deviceattributes' => { 34 => 0x38 },
    'devicemanufacturer' => { 34 => 0x30 },
    'devicemfgdesc' => { 35 => 'dmnd' },
    'devicemodel' => { 34 => 0x34 },
    'devicemodeldesc' => { 35 => 'dmdd' },
    'devicesettingdescription' => { 28 => 0xa40b, 126 => 'DeviceSettingDescription' },
    'devicesettingdescriptioncolumns' => { 126 => 'DeviceSettingDescriptionColumns' },
    'devicesettingdescriptionrows' => { 126 => 'DeviceSettingDescriptionRows' },
    'devicesettingdescriptionsettings' => { 126 => 'DeviceSettingDescriptionSettings' },
    'devicesettings' => { 35 => 'devs' },
    'digitalcreationdate' => { 38 => 0x3e },
    'digitalcreationtime' => { 38 => 0x3f },
    'digitaleffectsname' => { 51 => 0x1 },
    'digitaleffectstype' => { 51 => 0x2 },
    'digitaleffectsversion' => { 51 => 0x0 },
    'digitalsignature' => { 48 => 'chck' },
    'digitalzoom' => { 2 => 0xc, 26 => 0xa, 50 => 0x68, 55 => 0x22, 56 => 0x1e, 77 => 0xc, 84 => 0x86, 85 => 0xa, 92 => 0x204, 114 => 0x1e, 122 => 0x204 },
    'digitalzoomon' => { 122 => 0x21b },
    'digitalzoomratio' => { 28 => 0xa404, 126 => 'DigitalZoomRatio' },
    'directory' => { 128 => 'Directory' },
    'discardobjects' => { 71 => 'DISC' },
    'disclaimer' => { 112 => 'Disclaimer' },
    'displayinfo' => { 116 => 0x3ef },
    'displayresolution' => { 48 => 'resd' },
    'displayxresolution' => { 46 => 0x4 },
    'displayxresolutionunit' => { 46 => 0x9 },
    'displayyresolution' => { 46 => 0x0 },
    'displayyresolutionunit' => { 46 => 0x8 },
    'dispose' => { 58 => 'dispose' },
    'distance1' => { 50 => 0x28 },
    'distance2' => { 50 => 0x2c },
    'distance3' => { 50 => 0x30 },
    'distance4' => { 50 => 0x34 },
    'distortioncorrection' => { 88 => 0x50b },
    'dngbackwardversion' => { 28 => 0xc613 },
    'dngcameraserialnumber' => { 28 => 0xc62f },
    'dnglensinfo' => { 28 => 0xc630 },
    'dngprivatedata' => { 28 => 0xc634 },
    'dngversion' => { 28 => 0xc612 },
    'documenthistory' => { 38 => 0xe7 },
    'documentid' => { 126 => 'DocumentID' },
    'documentname' => { 28 => 0x10d },
    'documentnotes' => { 38 => 0xe6 },
    'dof' => { 127 => 'DOF' },
    'donotshow' => { 62 => 0x5, 63 => 0x2 },
    'dotrange' => { 28 => 0x150 },
    'drivemode' => { 77 => 0x6, 123 => 0x3, 127 => 'DriveMode' },
    'dropbykeyword' => { 71 => 'DBYK' },
    'dropchunks' => { 71 => 'DROP' },
    'duotonehalftoninginfo' => { 116 => 0x3f6 },
    'duotoneimageinfo' => { 116 => 0x3fa },
    'duotonetransferfuncs' => { 116 => 0x3f9 },
    'easymode' => { 2 => 0xb },
    'editorialupdate' => { 38 => 0x8 },
    'editstatus' => { 38 => 0x7 },
    'edittagarray' => { 28 => 0xc366 },
    'effectivebw' => { 116 => 0x3fb },
    'effectivemaxaperture' => { 83 => 0x12 },
    'effectsvisible' => { 116 => 0x412 },
    'endpoints' => { 41 => 0x7d },
    'enhancement' => { 27 => 0x3016 },
    'envelopenumber' => { 28 => 0xc358, 39 => 0x28 },
    'envelopepriority' => { 39 => 0x3c },
    'enveloperecordversion' => { 39 => 0x0 },
    'epsonimageheight' => { 92 => 0x20c },
    'epsonimagewidth' => { 92 => 0x20b },
    'epsonsoftware' => { 92 => 0x20d },
    'epsoptions' => { 116 => 0x3fd },
    'equipment' => { 92 => 0x2010 },
    'equipmentversion' => { 89 => 0x0 },
    'error' => { 128 => 'Error' },
    'ettlii' => { 16 => 0xd },
    'excursiontolerance' => { 41 => 0x82 },
    'exif' => { 128 => 'EXIF' },
    'exif_profile' => { 58 => 'profile-exif', 112 => 'Raw profile type exif' },
    'exifcamerainfo' => { 38 => 0xe8 },
    'exifimageheight' => { 126 => 'PixelYDimension' },
    'exifimagelength' => { 28 => 0xa003 },
    'exifimagewidth' => { 28 => 0xa002, 126 => 'PixelXDimension' },
    'exifinformation' => { 22 => 0x300b },
    'exifoffset' => { 28 => 0x8769 },
    'exiftoolversion' => { 128 => 'ExifToolVersion' },
    'exifversion' => { 28 => 0x9000, 126 => 'ExifVersion' },
    'expirationdate' => { 38 => 0x25 },
    'expirationtime' => { 38 => 0x26 },
    'exportimage' => { 71 => 'eXPi' },
    'exposure' => { 28 => 0xfe51, 126 => 'Exposure' },
    'exposurebracketvalue' => { 84 => 0x19 },
    'exposurecompensation' => { 12 => 0x6, 18 => 0x0, 28 => 0x9204, 50 => 0x24, 77 => 0xd, 114 => 0x16, 123 => 0xc, 126 => 'ExposureBiasValue' },
    'exposuredifference' => { 84 => 0xe },
    'exposureindex' => { 28 => [0x9215,0xa215], 126 => 'ExposureIndex' },
    'exposureinfo' => { 22 => 0x1818 },
    'exposurelevelincrements' => { 14 => 0x6, 15 => 0x6, 16 => 0x5, 17 => 0x4 },
    'exposuremode' => { 28 => 0xa402, 77 => 0x1, 88 => 0x200, 123 => 0x8, 126 => 'ExposureMode' },
    'exposureprogram' => { 28 => 0x8822, 126 => 'ExposureProgram' },
    'exposuretime' => { 7 => 0x4, 12 => 0x16, 28 => 0x829a, 50 => 0x20, 53 => 0x38, 55 => 0x14, 56 => 0x10, 114 => 0x12, 126 => 'ExposureTime' },
    'exposurewarning' => { 29 => 0x1302 },
    'extender' => { 89 => 0x301 },
    'extenderfirmwareversion' => { 89 => 0x304 },
    'extenderserialnumber' => { 89 => 0x302 },
    'externalflash' => { 90 => 0x1201 },
    'extrasamples' => { 28 => 0x152 },
    'faxprofile' => { 28 => 0x192 },
    'faxrecvparams' => { 28 => 0x885c },
    'faxrecvtime' => { 28 => 0x885e },
    'faxsubaddress' => { 28 => 0x885d },
    'fileformat' => { 20 => 0x0, 39 => 0x14 },
    'filemodifydate' => { 128 => 'FileModifyDate' },
    'filename' => { 128 => 'FileName' },
    'filenumber' => { 5 => 0x1, 8 => 0x8, 22 => 0x1817 },
    'filenumbermemory' => { 77 => 0x1a },
    'filesize' => { 128 => 'FileSize' },
    'filesource' => { 28 => 0xa300, 126 => 'FileSource' },
    'filesystemversion' => { 84 => 0x1 },
    'filetype' => { 48 => 'ftyp', 128 => 'FileType' },
    'fileversion' => { 39 => 0x16 },
    'fillflashautoreduction' => { 14 => 0xe, 15 => 0xe, 17 => 0xa },
    'fillmethod' => { 74 => 0x2 },
    'fillorder' => { 28 => 0x10a },
    'filmcategory' => { 28 => 0xc35a },
    'filmgencode' => { 28 => 0xc35b },
    'filmproductcode' => { 28 => 0xc350 },
    'filmsize' => { 28 => 0xc35d },
    'filter' => { 27 => 0x3017, 60 => 0xb, 108 => 0xb },
    'finderdisplayduringexposure' => { 15 => 0x1 },
    'firmware' => { 123 => 0x17 },
    'firmwareversion' => { 92 => 0x207, 113 => 0x2 },
    'firmwareversion2' => { 89 => 0x100 },
    'firstobject' => { 61 => 0x0, 72 => 0x0, 75 => 0x0 },
    'firstobjectid' => { 70 => 0x0 },
    'fixtureidentifier' => { 38 => 0x16 },
    'flash' => { 28 => 0x9209, 56 => 0x22, 126 => 'Flash' },
    'flashactivity' => { 2 => 0x1c },
    'flashbias' => { 92 => 0x1023, 113 => 0x24 },
    'flashbits' => { 2 => 0x1d },
    'flashdevice' => { 92 => 0x1005 },
    'flashdistance' => { 27 => 0x2034 },
    'flashenergy' => { 28 => [0x920b,0xa20b], 126 => 'FlashEnergy' },
    'flashexposurebracketvalue' => { 84 => 0x18 },
    'flashexposurecomp' => { 12 => 0xf, 77 => 0x23, 84 => 0x12 },
    'flashexposurecompensation' => { 88 => 0x401 },
    'flashfired' => { 50 => 0x5d, 77 => 0x14, 126 => 'FlashFired' },
    'flashfiring' => { 16 => 0x6 },
    'flashfirmwareversion' => { 89 => 0x1004 },
    'flashfunction' => { 126 => 'FlashFunction' },
    'flashguidenumber' => { 19 => 0x0 },
    'flashinfo' => { 22 => 0x1813 },
    'flashintensity' => { 26 => 0x5 },
    'flashmode' => { 26 => 0x4, 50 => 0x5c, 55 => 0x27, 77 => 0x2, 84 => 0x87, 88 => 0x400, 92 => 0x1004, 114 => 0xc, 122 => 0x225, 126 => 'FlashMode' },
    'flashmodel' => { 89 => 0x1001 },
    'flashon' => { 127 => 'FlashOn' },
    'flashpixversion' => { 28 => 0xa000, 126 => 'FlashpixVersion' },
    'flashredeyemode' => { 126 => 'FlashRedEyeMode' },
    'flashreturn' => { 126 => 'FlashReturn' },
    'flashserialnumber' => { 89 => 0x1003 },
    'flashsetting' => { 84 => 0x8 },
    'flashstrength' => { 29 => 0x1011 },
    'flashsyncspeedav' => { 14 => 0x3, 16 => 0x2, 17 => 0x6 },
    'flashthreshold' => { 19 => 0x1 },
    'flashtype' => { 84 => 0x9, 89 => 0x1000, 127 => 'FlashType' },
    'flickerreduce' => { 122 => 0x218 },
    'fnumber' => { 12 => 0x15, 28 => 0x829d, 50 => 0x1e, 53 => 0x3c, 55 => 0x1c, 56 => 0x18, 114 => 0x13, 126 => 'FNumber' },
    'focallength' => { 6 => 0x1, 7 => 0xa, 27 => 0x1d, 28 => 0x920a, 77 => 0x12, 83 => 0xa, 114 => 0x1d, 126 => 'FocalLength' },
    'focallength35efl' => { 127 => 'FocalLength35efl' },
    'focallengthin35mmformat' => { 28 => 0xa405, 126 => 'FocalLengthIn35mmFilm' },
    'focalplanediagonal' => { 89 => 0x103, 92 => 0x205 },
    'focalplaneresolutionunit' => { 28 => [0x9210,0xa210], 126 => 'FocalPlaneResolutionUnit' },
    'focalplanexresolution' => { 28 => [0x920e,0xa20e], 126 => 'FocalPlaneXResolution' },
    'focalplanexsize' => { 6 => 0x2 },
    'focalplaneyresolution' => { 28 => [0x920f,0xa20f], 126 => 'FocalPlaneYResolution' },
    'focalplaneysize' => { 6 => 0x3 },
    'focaltype' => { 6 => 0x0, 7 => 0x2d },
    'focalunits' => { 2 => 0x19 },
    'focus' => { 85 => 0x8 },
    'focusarea' => { 77 => 0x31 },
    'focuscontinuous' => { 2 => 0x20 },
    'focusdistance' => { 77 => 0x13, 83 => 0x9, 90 => 0x305, 92 => 0x100c },
    'focusdistancelower' => { 12 => 0x14 },
    'focusdistanceupper' => { 12 => 0x13 },
    'focusinfo' => { 92 => 0x2050 },
    'focusinfoversion' => { 90 => 0x0 },
    'focusingscreen' => { 15 => 0x0 },
    'focusmode' => { 2 => 0x7, 26 => 0x3, 27 => [0x3003,0xd], 29 => 0x1021, 50 => 0x38, 77 => 0x30, 84 => 0x7, 88 => 0x301, 92 => 0x100b, 113 => 0x7, 114 => 0xd },
    'focusposition' => { 83 => 0x8, 114 => 0x10 },
    'focusprocess' => { 88 => 0x302 },
    'focussetting' => { 123 => 0x6 },
    'focustype' => { 2 => 0x12 },
    'focuswarning' => { 29 => 0x1301 },
    'foldername' => { 77 => 0x27 },
    'for' => { 117 => 'For' },
    'format' => { 126 => 'Format' },
    'fractalparameters' => { 109 => 'fRAc' },
    'fragmentlist' => { 48 => 'flst' },
    'fragmenttable' => { 48 => 'ftbl' },
    'frame' => { 71 => 'FRAM' },
    'framenumber' => { 28 => 0xc359, 114 => 0x29 },
    'framepriority' => { 71 => 'fPRI' },
    'free' => { 48 => 'free' },
    'freebytecounts' => { 28 => 0x121 },
    'freebytes' => { 22 => 0x1 },
    'freeoffsets' => { 28 => 0x120 },
    'fujiflashmode' => { 29 => 0x1010 },
    'gaincontrol' => { 28 => 0xa407, 126 => 'GainControl' },
    'gamma' => { 28 => 0xa500, 58 => 'gamma', 109 => 'gAMA' },
    'gammacompensatedvalue' => { 41 => 0x91 },
    'gamut' => { 35 => 'gamt' },
    'gdalmetadata' => { 28 => 0xa480 },
    'gdalnodata' => { 28 => 0xa481 },
    'geogangularunits' => { 31 => 0x806 },
    'geogangularunitsize' => { 31 => 0x807 },
    'geogazimuthunits' => { 31 => 0x80c },
    'geogcitation' => { 31 => 0x801 },
    'geogellipsoid' => { 31 => 0x808 },
    'geoggeodeticdatum' => { 31 => 0x802 },
    'geoginvflattening' => { 31 => 0x80b },
    'geoglinearunits' => { 31 => 0x804 },
    'geoglinearunitsize' => { 31 => 0x805 },
    'geogprimemeridian' => { 31 => 0x803 },
    'geogprimemeridianlong' => { 31 => 0x80d },
    'geographictype' => { 31 => 0x800 },
    'geogsemimajoraxis' => { 31 => 0x809 },
    'geogsemiminoraxis' => { 31 => 0x80a },
    'geotiffasciiparams' => { 28 => 0x87b1 },
    'geotiffdirectory' => { 28 => 0x87af },
    'geotiffdoubleparams' => { 28 => 0x87b0 },
    'geotiffversion' => { 31 => 0x1 },
    'gifapplicationextension' => { 109 => 'gIFx' },
    'gifgraphiccontrolextension' => { 109 => 'gIFg' },
    'gifplaintextextension' => { 109 => 'gIFt' },
    'globalaltitude' => { 116 => 0x419 },
    'globalangle' => { 116 => 0x40d },
    'globalparametersifd' => { 28 => 0x190 },
    'globalpixelsize' => { 71 => 'pHYg' },
    'gpsaltitude' => { 30 => 0x6, 126 => 'GPSAltitude' },
    'gpsaltituderef' => { 30 => 0x5, 126 => 'GPSAltitudeRef' },
    'gpsareainformation' => { 30 => 0x1c, 126 => 'GPSAreaInformation' },
    'gpsdatestamp' => { 30 => 0x1d },
    'gpsdatetime' => { 127 => 'GPSDateTime' },
    'gpsdestbearing' => { 30 => 0x18, 126 => 'GPSDestBearing' },
    'gpsdestbearingref' => { 30 => 0x17, 126 => 'GPSDestBearingRef' },
    'gpsdestdistance' => { 30 => 0x1a, 126 => 'GPSDestDistance' },
    'gpsdestdistanceref' => { 30 => 0x19, 126 => 'GPSDestDistanceRef' },
    'gpsdestlatitude' => { 30 => 0x14, 126 => 'GPSDestLatitude' },
    'gpsdestlatituderef' => { 30 => 0x13 },
    'gpsdestlongitude' => { 30 => 0x16, 126 => 'GPSDestLongitude' },
    'gpsdestlongituderef' => { 30 => 0x15 },
    'gpsdifferential' => { 30 => 0x1e, 126 => 'GPSDifferential' },
    'gpsdop' => { 30 => 0xb },
    'gpsimgdirection' => { 30 => 0x11, 126 => 'GPSImgDirection' },
    'gpsimgdirectionref' => { 30 => 0x10, 126 => 'GPSImgDirectionRef' },
    'gpsinfo' => { 28 => 0x8825 },
    'gpslatitude' => { 30 => 0x2, 126 => 'GPSLatitude' },
    'gpslatituderef' => { 30 => 0x1 },
    'gpslongitude' => { 30 => 0x4, 126 => 'GPSLongitude' },
    'gpslongituderef' => { 30 => 0x3 },
    'gpsmapdatum' => { 30 => 0x12, 126 => 'GPSMapDatum' },
    'gpsmeasuremode' => { 30 => 0xa },
    'gpsprocessingmethod' => { 30 => 0x1b, 126 => 'GPSProcessingMethod' },
    'gpssatellites' => { 30 => 0x8, 126 => 'GPSSatellites' },
    'gpsspeed' => { 30 => 0xd, 126 => 'GPSSpeed' },
    'gpsspeedref' => { 30 => 0xc, 126 => 'GPSSpeedRef' },
    'gpsstatus' => { 30 => 0x9, 126 => 'GPSStatus' },
    'gpstimestamp' => { 30 => 0x7, 126 => 'GPSTimeStamp' },
    'gpstrack' => { 30 => 0xf, 126 => 'GPSTrack' },
    'gpstrackref' => { 30 => 0xe, 126 => 'GPSTrackRef' },
    'gpsversionid' => { 30 => 0x0, 126 => 'GPSVersionID' },
    'gradation' => { 88 => 0x50f },
    'graphicstechnologystandardoutput' => { 48 => 'gtso' },
    'grayresponsecurve' => { 28 => 0x123 },
    'grayresponseunit' => { 28 => 0x122 },
    'graytrc' => { 35 => 'kTRC' },
    'greengain' => { 121 => 'Gg' },
    'greenhue' => { 126 => 'GreenHue' },
    'greenmatrixcolumn' => { 35 => 'gXYZ' },
    'greenprimary' => { 58 => 'green-primary' },
    'greensample' => { 60 => 0x11 },
    'greensaturation' => { 126 => 'GreenSaturation' },
    'greentrc' => { 35 => 'gTRC' },
    'greenx' => { 111 => 0x4 },
    'greeny' => { 111 => 0x5 },
    'gridguidesinfo' => { 116 => 0x408 },
    'gtcitation' => { 31 => 0x402 },
    'gtmodeltype' => { 31 => 0x400 },
    'gtrastertype' => { 31 => 0x401 },
    'halftonehints' => { 28 => 0x141 },
    'hcusage' => { 28 => 0x84ee },
    'headline' => { 38 => 0x69, 126 => 'Headline' },
    'highlight' => { 123 => 0xf },
    'history' => { 126 => 'History' },
    'historyaction' => { 126 => 'HistoryAction' },
    'historyinstanceid' => { 126 => 'HistoryInstanceID' },
    'historyparameters' => { 126 => 'HistoryParameters' },
    'historysoftwareagent' => { 126 => 'HistorySoftwareAgent' },
    'historywhen' => { 126 => 'HistoryWhen' },
    'hometowncity' => { 114 => 0x23 },
    'hometowncitycode' => { 114 => 0x1000 },
    'hometowndst' => { 114 => 0x25 },
    'hostcomputer' => { 28 => 0x13c },
    'hueadjustment' => { 84 => 0x92 },
    'hyperfocaldistance' => { 127 => 'HyperfocalDistance' },
    'icc_profile' => { 28 => 0x8773, 58 => 'profile-icc', 109 => 'iCCP', 112 => 'Raw profile type icc', 116 => 0x40f, 117 => 'BeginICCProfile' },
    'icc_untagged' => { 116 => 0x411 },
    'iccbased' => { 96 => 'ICCBased' },
    'iccprofile' => { 41 => 0x42 },
    'id' => { 58 => 'id' },
    'identifier' => { 126 => 'Identifier' },
    'idsbasevalue' => { 116 => 0x414 },
    'ifd0_offset' => { 86 => 0x1 },
    'imageadjustment' => { 84 => 0x80, 85 => 0x5 },
    'imageboundary' => { 84 => 0x16 },
    'imagecolorindicator' => { 28 => 0x84e7 },
    'imagecolorvalue' => { 28 => 0x84e9 },
    'imagedepth' => { 28 => 0x80e5 },
    'imagedescription' => { 22 => 0x2804, 28 => 0x10e, 126 => 'ImageDescription' },
    'imageformat' => { 22 => 0x1803 },
    'imageheader' => { 48 => 'ihdr', 109 => 'IHDR' },
    'imageheight' => { 1 => 0x8, 21 => 0x1, 28 => 0x101, 47 => 0x0, 58 => 'rows', 60 => 0x4, 67 => 0x4, 69 => 0x1, 108 => 0x4, 126 => 'ImageLength', 128 => 'ImageHeight' },
    'imagehistory' => { 28 => [0x9213,0xa213] },
    'imageid' => { 28 => 0x800d },
    'imageinfo' => { 22 => 0x1810 },
    'imagelayer' => { 28 => 0x87ac },
    'imagelength' => { 1 => 0x14 },
    'imagenumber' => { 28 => [0x9211,0xa211] },
    'imageoffset' => { 109 => 'oFFs' },
    'imageoptimization' => { 84 => 0xa9 },
    'imageorientation' => { 38 => 0x83 },
    'imageprintstatus' => { 28 => 0xc46e },
    'imageprocessing' => { 92 => 0x2040 },
    'imageprocessingversion' => { 91 => 0x0 },
    'imageprops' => { 22 => 0x300a },
    'imagequality' => { 113 => 0x1 },
    'imagequality2' => { 88 => 0x603 },
    'imageresources' => { 105 => 'ImageResources' },
    'imagerotated' => { 55 => 0x2a },
    'imagerotationstatus' => { 28 => 0xc363 },
    'imagesize' => { 127 => 'ImageSize' },
    'imagesourcedata' => { 28 => 0x935c },
    'imagesourceek' => { 28 => 0xc351 },
    'imagestabilization' => { 78 => 0x18 },
    'imagestabilizer' => { 113 => 0x1a },
    'imagetype' => { 38 => 0x82, 64 => 0x2 },
    'imageuniqueid' => { 28 => 0xa420, 126 => 'ImageUniqueID' },
    'imagewidth' => { 1 => 0x4, 21 => 0x0, 28 => 0x100, 47 => 0x4, 58 => 'columns', 60 => 0x0, 67 => 0x0, 69 => 0x0, 108 => 0x0, 126 => 'ImageWidth', 128 => 'ImageWidth' },
    'indexed' => { 28 => 0x15a },
    'indexedcolourtablecount' => { 116 => 0x416 },
    'info' => { 101 => 'Info' },
    'inknames' => { 28 => 0x14d },
    'inkset' => { 28 => 0x14c },
    'instructions' => { 126 => 'Instructions' },
    'instructionset' => { 48 => 'inst' },
    'intellectualgenre' => { 126 => 'IntellectualGenre' },
    'intellectualproperty' => { 48 => 'jp2i' },
    'interchangecolorspace' => { 41 => 0x40 },
    'intergraphflagregisters' => { 28 => 0x847f },
    'intergraphmatrix' => { 28 => 0x8480 },
    'intergraphpacketdata' => { 28 => 0x8474 },
    'interlace' => { 28 => 0x8829, 60 => 0xc, 67 => 0xb, 108 => 0xc },
    'internalflash' => { 77 => 0x2b, 90 => 0x1208 },
    'internationaltext' => { 109 => 'iTXt' },
    'interopindex' => { 28 => 0x1 },
    'interopoffset' => { 28 => 0xa005 },
    'interopversion' => { 28 => 0x2 },
    'intervallength' => { 77 => 0x10 },
    'intervalmode' => { 77 => 0x26 },
    'intervalnumber' => { 77 => 0x11 },
    'iptc-naa' => { 28 => 0x83bb },
    'iptc-naa2' => { 28 => 0x8568 },
    'iptc_profile' => { 58 => 'profile-iptc', 112 => 'Raw profile type iptc' },
    'iptcapplication' => { 40 => 0x2 },
    'iptcbitspersample' => { 41 => 0x56 },
    'iptcdata' => { 116 => 0x404 },
    'iptcenvelope' => { 40 => 0x1 },
    'iptcimageheight' => { 41 => 0x1e },
    'iptcimagerotation' => { 41 => 0x66 },
    'iptcimagewidth' => { 41 => 0x14 },
    'iptcnewsphoto' => { 40 => 0x3 },
    'iptcobjectdata' => { 40 => 0x8 },
    'iptcpicturenumber' => { 41 => 0xa },
    'iptcpixelheight' => { 41 => 0x32 },
    'iptcpixelwidth' => { 41 => 0x28 },
    'iptcpostobjectdata' => { 40 => 0x9 },
    'iptcpreobjectdata' => { 40 => 0x7 },
    'iso' => { 12 => 0x2, 27 => 0x14, 28 => 0x8827, 50 => 0x60, 53 => 0x4e, 55 => 0x1e, 56 => 0x1a, 84 => 0x2, 114 => 0x14, 126 => 'ISOSpeedRatings' },
    'isoexpansion' => { 16 => 0x7 },
    'isoselection' => { 84 => 0xf },
    'isosetting' => { 50 => 0x5e, 56 => 0x14, 77 => 0x24, 84 => 0x13 },
    'isospeedexpansion' => { 15 => 0x3 },
    'it8header' => { 28 => 0x84e2 },
    'iterationcount' => { 68 => 0x1 },
    'iterationendaction' => { 76 => 0x1 },
    'iterationmax' => { 76 => 0x6 },
    'iterationminmax' => { 68 => 0x6 },
    'iterations' => { 58 => 'iterations' },
    'ixusafpoint' => { 12 => 0xe },
    'jngheader' => { 71 => 'JHDR' },
    'jobid' => { 38 => 0xb8 },
    'jobref' => { 126 => 'JobRef' },
    'jobrefid' => { 126 => 'JobRefId' },
    'jobrefname' => { 126 => 'JobRefName' },
    'jobrefurl' => { 126 => 'JobRefUrl' },
    'jp2header' => { 48 => 'jp2h' },
    'jp2signature' => { 48 => ["jP\x1a\x1a",'jP  '] },
    'jpeg_quality' => { 116 => 0x406 },
    'jpegactables' => { 28 => 0x209 },
    'jpegdctables' => { 28 => 0x208 },
    'jpeglosslesspredictors' => { 28 => 0x205 },
    'jpegpointtransforms' => { 28 => 0x206 },
    'jpegproc' => { 28 => 0x200 },
    'jpegqtables' => { 28 => 0x207 },
    'jpegrestartinterval' => { 28 => 0x203 },
    'jpegtables' => { 28 => 0x15b },
    'jpgfromraw' => { 22 => 0x2007, 127 => 'JpgFromRaw' },
    'jpgfromrawlength' => { 28 => 0x202 },
    'jpgfromrawstart' => { 28 => 0x201 },
    'jumptoxpep' => { 116 => 0x41c },
    'keywords' => { 38 => 0x19, 99 => 'Keywords', 117 => 'Keywords', 126 => 'Keywords' },
    'kids' => { 103 => 'Kids' },
    'kodakbordersifd' => { 28 => 0xc36f },
    'kodakeffectsifd' => { 28 => 0xc36e },
    'kodakimageheight' => { 50 => 0xe, 52 => 0x70 },
    'kodakimagewidth' => { 50 => 0xc, 52 => 0x6c },
    'kodakmaker' => { 52 => 0x8 },
    'kodakmodel' => { 50 => 0x0, 52 => 0x28 },
    'label' => { 48 => 'lbl ', 58 => 'label' },
    'language' => { 126 => 'Language' },
    'languageidentifier' => { 38 => 0x87 },
    'lastfilenumber' => { 77 => 0x1b },
    'lastobject' => { 61 => 0x2, 72 => 0x2, 75 => 0x2 },
    'lastobjectid' => { 70 => 0x2 },
    'lasturl' => { 126 => 'LastURL' },
    'layersgroupinfo' => { 116 => 0x402 },
    'layerstateinfo' => { 116 => 0x400 },
    'lcdpanels' => { 15 => 0x8 },
    'leftmag' => { 70 => 0x9 },
    'lens' => { 28 => 0xfdea, 84 => 0x84, 89 => 0x201, 123 => 0xa, 126 => 'Lens', 127 => 'Lens' },
    'lens35efl' => { 127 => 'Lens35efl' },
    'lensafstopbutton' => { 14 => 0x11, 15 => 0x13, 16 => 0x10, 17 => 0x9 },
    'lensdata0100' => { 84 => 0x98 },
    'lensdata0101' => { 84 => 0x98 },
    'lensdata0201' => { 84 => 0x98 },
    'lensdataunknown' => { 84 => 0x98 },
    'lensdataversion' => { 82 => 0x0, 83 => 0x0 },
    'lensfirmwareversion' => { 89 => 0x204 },
    'lensfstops' => { 82 => 0x7, 83 => 0xc, 84 => 0x8b },
    'lensid' => { 78 => 0x10c, 82 => 0x6, 83 => 0xb },
    'lensserialnumber' => { 89 => 0x202 },
    'lensspec' => { 127 => 'LensSpec' },
    'lenstype' => { 2 => 0x16, 7 => 0xd, 84 => 0x83, 114 => 0x3f },
    'lightsource' => { 28 => 0x9208, 84 => 0x90, 126 => 'LightSource' },
    'lightsourcespecial' => { 122 => 0x21d },
    'linearizationtable' => { 28 => 0xc618 },
    'linearresponselimit' => { 28 => 0xc62e },
    'localcaption' => { 38 => 0x79 },
    'localdeltatype' => { 62 => 0x7 },
    'localizedcameramodel' => { 28 => 0xc615 },
    'location' => { 126 => 'Location' },
    'longexposurenoisereduction' => { 16 => 0x1, 17 => 0x1 },
    'longfocal' => { 2 => 0x17, 7 => 0x14 },
    'lookuptable' => { 41 => 0x50 },
    'loop' => { 71 => 'LOOP' },
    'luminance' => { 35 => 'lumi' },
    'luminancesmoothing' => { 126 => 'LuminanceSmoothing' },
    'macintoshprintinfo' => { 116 => 0x3e9 },
    'macro' => { 29 => 0x1020, 55 => 0x2b, 92 => 0x202, 122 => 0x202 },
    'macrofocus' => { 92 => 0x100e },
    'macromode' => { 2 => 0x1, 77 => 0xb, 88 => 0x300, 113 => 0x1c },
    'magnification' => { 28 => 0xc367 },
    'magnifyobject' => { 71 => 'MAGN' },
    'make' => { 23 => 0x0, 28 => 0x10f, 126 => 'Make' },
    'makeandmodel' => { 35 => 'mmod' },
    'makernote' => { 126 => 'MakerNote' },
    'makernotecanon' => { 28 => 0x927c },
    'makernotecasio' => { 28 => 0x927c },
    'makernotecasio2' => { 28 => 0x927c },
    'makernotefujifilm' => { 28 => 0x927c },
    'makernotekodak1a' => { 28 => 0x927c },
    'makernotekodak1b' => { 28 => 0x927c },
    'makernotekodak2' => { 28 => 0x927c },
    'makernotekodak3' => { 28 => 0x927c },
    'makernotekodak4' => { 28 => 0x927c },
    'makernotekodak5' => { 28 => 0x927c },
    'makernotekodak6a' => { 28 => 0x927c },
    'makernotekodak6b' => { 28 => 0x927c },
    'makernotekodakunknown' => { 28 => 0x927c },
    'makernotekyocera' => { 28 => 0x927c },
    'makernoteleica' => { 28 => 0x927c },
    'makernoteminolta' => { 28 => 0x927c },
    'makernotenikon' => { 28 => 0x927c },
    'makernotenikon2' => { 28 => 0x927c },
    'makernotenikon3' => { 28 => 0x927c },
    'makernoteoffset' => { 122 => 0xff },
    'makernoteolympus' => { 28 => 0x927c },
    'makernotepanasonic' => { 28 => 0x927c },
    'makernotepentax' => { 28 => 0x927c },
    'makernotericoh' => { 28 => 0x927c },
    'makernotericohtext' => { 28 => 0x927c },
    'makernotesafety' => { 28 => 0xc635 },
    'makernotesanyo' => { 28 => 0x927c },
    'makernotesigma' => { 28 => 0x927c },
    'makernotesony' => { 28 => 0x927c },
    'makernotetype' => { 119 => 0x1 },
    'makernoteunknown' => { 28 => 0x927c },
    'makernoteversion' => { 78 => 0x0, 92 => 0x0, 119 => 0x2 },
    'managedfrom' => { 126 => 'ManagedFrom' },
    'managedfromdocumentid' => { 126 => 'ManagedFromDocumentID' },
    'managedfrominstanceid' => { 126 => 'ManagedFromInstanceID' },
    'managedfrommanager' => { 126 => 'ManagedFromManager' },
    'managedfrommanagervariant' => { 126 => 'ManagedFromManagerVariant' },
    'managedfrommanageto' => { 126 => 'ManagedFromManageTo' },
    'managedfrommanageui' => { 126 => 'ManagedFromManageUI' },
    'managedfromrenditionclass' => { 126 => 'ManagedFromRenditionClass' },
    'managedfromrenditionparams' => { 126 => 'ManagedFromRenditionParams' },
    'managedfromversionid' => { 126 => 'ManagedFromVersionID' },
    'manager' => { 126 => 'Manager' },
    'managervariant' => { 126 => 'ManagerVariant' },
    'manageto' => { 126 => 'ManageTo' },
    'manageui' => { 126 => 'ManageUI' },
    'mandatorybackground' => { 59 => 0x6 },
    'manualfocusdistance' => { 84 => 0x85, 122 => 0x223 },
    'manualtv' => { 15 => 0x5 },
    'marked' => { 126 => 'Marked' },
    'masterdocumentid' => { 38 => 0xb9 },
    'mattcolor' => { 58 => 'matt-color' },
    'matte' => { 58 => 'matte' },
    'matteing' => { 28 => 0x80e3 },
    'maxaperture' => { 2 => 0x1a, 77 => 0x17 },
    'maxapertureatmaxfocal' => { 82 => 0xb, 83 => 0x10, 89 => 0x206 },
    'maxapertureatminfocal' => { 82 => 0xa, 83 => 0xf },
    'maxaperturevalue' => { 28 => 0x9205, 126 => 'MaxApertureValue' },
    'maxfocallength' => { 82 => 0x9, 83 => 0xe, 89 => 0x208 },
    'maximumdensityrange' => { 41 => 0x8c },
    'maximumobjectsize' => { 44 => 0x5f },
    'maxsamplevalue' => { 28 => 0x119 },
    'maxsubfilesize' => { 44 => 0x14 },
    'mcuversion' => { 82 => 0xc, 83 => 0x11 },
    'measuredev' => { 22 => 0x1814 },
    'measuredinfo' => { 22 => 0x3003 },
    'measurement' => { 35 => 'meas' },
    'measurementbacking' => { 36 => 0xc },
    'measurementflare' => { 36 => 0x1c },
    'measurementgeometry' => { 36 => 0x18 },
    'measurementilluminant' => { 36 => 0x20 },
    'measurementobserver' => { 36 => 0x8 },
    'mediablackpoint' => { 35 => 'bkpt' },
    'mediadata' => { 48 => 'mdat' },
    'mediawhitepoint' => { 35 => 'wtpt' },
    'menubuttondisplayposition' => { 14 => 0xb, 16 => 0xa },
    'menubuttonreturn' => { 17 => 0xb },
    'metadata' => { 107 => 'Metadata' },
    'metadatadate' => { 126 => 'MetadataDate' },
    'metadatanumber' => { 28 => 0xc365 },
    'meteringmode' => { 2 => 0x11, 28 => 0x9207, 50 => 0x1c, 77 => 0x7, 88 => 0x202, 114 => 0x17, 123 => 0x9, 126 => 'MeteringMode' },
    'minfocallength' => { 82 => 0x8, 83 => 0xd, 89 => 0x207 },
    'minoltaaperture' => { 77 => 0xa },
    'minoltacamerasettings' => { 78 => 0x3, 92 => 0x3 },
    'minoltacamerasettings2' => { 78 => 0xf00 },
    'minoltacamerasettingsold' => { 78 => 0x1, 92 => 0x1 },
    'minoltadate' => { 77 => 0x15 },
    'minoltaimagesize' => { 77 => 0x4, 78 => 0x103 },
    'minoltaiso' => { 77 => 0x8 },
    'minoltamodel' => { 77 => 0x25 },
    'minoltaquality' => { 77 => 0x5, 78 => [0x102,0x103], 92 => [0x102,0x103] },
    'minoltashutterspeed' => { 77 => 0x9 },
    'minoltatime' => { 77 => 0x16 },
    'minsamplevalue' => { 28 => 0x118 },
    'mirrorlockup' => { 14 => 0xc, 15 => 0xc, 16 => 0xb, 17 => 0x3 },
    'mngheader' => { 71 => 'MHDR' },
    'moddate' => { 126 => 'ModDate' },
    'model' => { 23 => 0x6, 28 => 0x110, 126 => 'Model' },
    'model2' => { 28 => 0x827d },
    'modelandversion' => { 28 => 0xc35c },
    'modeltiepoint' => { 28 => 0x8482 },
    'modeltransform' => { 28 => 0x85d8 },
    'modenumber' => { 28 => 0x195 },
    'modifiedsaturation' => { 88 => 0x504 },
    'modifydate' => { 28 => 0x132, 99 => 'ModDate', 109 => 'tIME', 117 => 'ModDate', 126 => 'ModifyDate' },
    'moirefilter' => { 28 => 0xfe58 },
    'montage' => { 58 => 'montage' },
    'moveobjects' => { 71 => 'MOVE' },
    'mpeg7binary' => { 48 => 'mp7b' },
    'namedcolor' => { 35 => 'ncol' },
    'namedcolor2' => { 35 => 'ncl2' },
    'nativedisplayinfo' => { 35 => 'ndin' },
    'nativeresolutionunit' => { 28 => 0xc37a },
    'nativexresolution' => { 28 => 0xc36c },
    'nativeyresolution' => { 28 => 0xc36d },
    'nefcurve1' => { 84 => 0x8c },
    'nefcurve2' => { 84 => 0x96 },
    'nefthumbnailsize' => { 84 => 0x99 },
    'nestlevel' => { 68 => 0x0 },
    'newbitdepth' => { 74 => 0x1 },
    'newcolortype' => { 74 => 0x0 },
    'newsphotoversion' => { 41 => 0x0 },
    'nickname' => { 126 => 'Nickname' },
    'nikoncaptureoffsets' => { 84 => 0xe0e },
    'nikonpreview' => { 84 => 0x11 },
    'noise' => { 28 => [0x920d,0xa20d] },
    'noisefilter2' => { 91 => 0x1010 },
    'noisereduction' => { 84 => 0x95, 88 => 0x50a, 113 => 0x2d },
    'nominalframecount' => { 69 => 0x4 },
    'nominallayercount' => { 69 => 0x3 },
    'nominalplaytime' => { 69 => 0x5 },
    'nullrecord' => { 22 => 0x0 },
    'numberlist' => { 48 => 'nlst' },
    'numberofcomponents' => { 47 => 0x8 },
    'numberofinks' => { 28 => 0x14e },
    'numcolors' => { 1 => 0x20 },
    'numimportantcolors' => { 1 => 0x24 },
    'numindexentries' => { 41 => 0x54 },
    'objectattributereference' => { 38 => 0x4 },
    'objectcycle' => { 38 => 0x4b },
    'objectdistance' => { 26 => 0x6, 27 => 0x2022 },
    'objectid' => { 63 => 0x0, 64 => 0x0 },
    'objectname' => { 38 => 0x5 },
    'objectpreviewdata' => { 38 => 0xca },
    'objectpreviewfileformat' => { 38 => 0xc8 },
    'objectpreviewfileversion' => { 38 => 0xc9 },
    'objectsizeannounced' => { 44 => 0x5a },
    'objecttypereference' => { 38 => 0x3 },
    'obsoletephotoshoptag1' => { 116 => 0x3fc },
    'obsoletephotoshoptag2' => { 116 => 0x3ff },
    'obsoletephotoshoptag3' => { 116 => 0x403 },
    'oceapplicationselector' => { 28 => 0xc428 },
    'oceidnumber' => { 28 => 0xc429 },
    'oceimagelogic' => { 28 => 0xc42a },
    'ocescanjobdesc' => { 28 => 0xc427 },
    'oecfcolumns' => { 126 => 'OECFColumns' },
    'oecfnames' => { 126 => 'OECFNames' },
    'oecfrows' => { 126 => 'OECFRows' },
    'oecfvalues' => { 126 => 'OECFValues' },
    'offsetorigin' => { 73 => 0xf },
    'offsetxy' => { 73 => 0x10 },
    'oldsubfiletype' => { 28 => 0xff },
    'olympusimageheight' => { 92 => 0x102f },
    'olympusimageheight2' => { 91 => 0x615 },
    'olympusimagewidth' => { 92 => 0x102e },
    'olympusimagewidth2' => { 91 => 0x614 },
    'onetouchwb' => { 92 => 0x302 },
    'opacity' => { 48 => 'opct' },
    'opiproxy' => { 28 => 0x15f },
    'opticalzoom' => { 55 => 0x20, 56 => 0x1c },
    'opticalzoomon' => { 122 => 0x219 },
    'opto-electricconvfactor' => { 28 => 0x8828, 126 => 'OECF' },
    'orderingrestrictions' => { 71 => 'ORDR' },
    'orientation' => { 28 => 0x112, 73 => 0xe, 126 => 'Orientation' },
    'originalfilename' => { 22 => 0x816, 54 => 0x20 },
    'originaltransmissionreference' => { 38 => 0x67 },
    'originatingprogram' => { 38 => 0x41 },
    'otherimagelength' => { 28 => 0x202 },
    'otherimagestart' => { 28 => 0x201 },
    'outputresponse' => { 35 => 'resp' },
    'owner' => { 126 => 'Owner' },
    'ownerid' => { 38 => 0xbc },
    'ownername' => { 8 => 0x9, 22 => 0x810, 28 => 0xfde8 },
    'packets' => { 58 => 'packets' },
    'page' => { 58 => 'page' },
    'pagecount' => { 103 => 'Count' },
    'pagename' => { 28 => 0x11d },
    'pagenumber' => { 28 => 0x129 },
    'pages' => { 107 => 'Pages' },
    'palette' => { 48 => 'pclr', 109 => 'PLTE' },
    'palettehistogram' => { 109 => 'hIST' },
    'panoramadirection' => { 9 => 0x5 },
    'panoramaframe' => { 9 => 0x2 },
    'panoramamode' => { 50 => 0x3c },
    'partialpalette' => { 71 => 'PPLT' },
    'pastclippingboundary' => { 73 => 0x19 },
    'pasteimage' => { 71 => 'PAST' },
    'pcscitation' => { 31 => 0xc01 },
    'pdfversion' => { 126 => 'PDFVersion' },
    'pentaximagesize' => { 114 => 0x9 },
    'pentaxmode' => { 114 => 0x1 },
    'photometricinterpretation' => { 28 => 0x106, 126 => 'PhotometricInterpretation' },
    'photoshop2colortable' => { 116 => 0x3eb },
    'photoshop2info' => { 116 => 0x3e8 },
    'photoshopdata' => { 117 => 'BeginPhotoshop' },
    'photoshopformat' => { 115 => 0x1 },
    'photoshopquality' => { 115 => 0x0 },
    'photoshopsettings' => { 28 => 0x8649 },
    'photoshopthumbnail' => { 116 => 0x40c },
    'physicalpixel' => { 109 => 'pHYs' },
    'pictinfo' => { 122 => 0x208 },
    'pictureinfo' => { 92 => 0x208 },
    'picturemode' => { 29 => 0x1031, 114 => 0xb },
    'pieceinfo' => { 100 => 'PieceInfo' },
    'pixelaspectratio' => { 21 => 0x2 },
    'pixelcalibration' => { 109 => 'pCAL' },
    'pixelintensityrange' => { 28 => 0x84eb },
    'pixelscale' => { 28 => 0x830e },
    'pixelspermeterx' => { 1 => 0x18 },
    'pixelspermetery' => { 1 => 0x1c },
    'pixelsperunitx' => { 110 => 0x0 },
    'pixelsperunity' => { 110 => 0x4 },
    'pixelunits' => { 110 => 0x8 },
    'planarconfiguration' => { 28 => 0x11c, 126 => 'PlanarConfiguration' },
    'planes' => { 1 => 0xc },
    'pngwarning' => { 112 => 'Warning' },
    'postscript2crd0' => { 35 => 'psd0' },
    'postscript2crd1' => { 35 => 'psd1' },
    'postscript2crd2' => { 35 => 'psd2' },
    'postscript2csa' => { 35 => 'ps2s' },
    'precaptureframes' => { 92 => 0x300 },
    'predictor' => { 28 => 0x13d },
    'preview0' => { 35 => 'pre0' },
    'preview1' => { 35 => 'pre1' },
    'preview2' => { 35 => 'pre2' },
    'previewfocalplanexresolution' => { 11 => 0x6 },
    'previewfocalplaneyresolution' => { 11 => 0x8 },
    'previewifd_offset' => { 86 => 0x2 },
    'previewimage' => { 27 => 0x2000, 28 => 0x927c, 78 => 0x81, 127 => 'PreviewImage' },
    'previewimagedata' => { 92 => 0x81 },
    'previewimageheight' => { 11 => 0x4 },
    'previewimageinfo' => { 8 => 0xb6 },
    'previewimagelength' => { 11 => 0x2, 27 => 0x3, 28 => [0x117,0x202], 78 => 0x89, 87 => 0x202, 88 => 0x102, 92 => [0x89,0x1037], 114 => 0x3 },
    'previewimagesize' => { 27 => 0x2, 114 => 0x2, 127 => 'PreviewImageSize' },
    'previewimagestart' => { 11 => 0x5, 27 => 0x4, 28 => [0x111,0x201], 78 => 0x88, 87 => 0x201, 88 => 0x101, 92 => [0x88,0x1036], 114 => 0x4 },
    'previewimagevalid' => { 88 => 0x100, 92 => 0x1035 },
    'previewimagewidth' => { 11 => 0x3 },
    'primarychromaticities' => { 28 => 0x13f, 109 => 'cHRM', 126 => 'PrimaryChromaticities' },
    'primaryplatform' => { 34 => 0x28 },
    'printflags' => { 116 => 0x3f3 },
    'printflagsinfo' => { 116 => 0x2710 },
    'printim' => { 27 => 0xe00, 28 => 0xc4a5, 78 => 0xe00, 84 => 0xe00, 92 => 0xe00, 113 => 0xe00, 114 => 0xe00, 119 => 0xe00, 122 => 0xe00, 124 => 0xe00, 125 => 0xe00 },
    'printquality' => { 28 => 0xc46c },
    'priority' => { 66 => 0x2 },
    'private' => { 94 => 'Private' },
    'processgeotiff' => { 127 => 'ProcessGeoTiff' },
    'producer' => { 99 => 'Producer', 126 => 'Producer' },
    'productid' => { 39 => 0x32 },
    'profile' => { 48 => 'prfl' },
    'profileclass' => { 34 => 0xc },
    'profilecmmtype' => { 34 => 0x4 },
    'profileconnectionspace' => { 34 => [0x14,0x44] },
    'profilecreator' => { 34 => 0x50 },
    'profiledatetime' => { 34 => 0x18 },
    'profiledescription' => { 35 => 'desc' },
    'profiledescriptionml' => { 35 => 'dscm' },
    'profilefilesignature' => { 34 => 0x24 },
    'profileheader' => { 35 => 'Header' },
    'profileid' => { 34 => 0x54 },
    'profilesequencedesc' => { 35 => 'pseq' },
    'profiletype' => { 28 => 0x191 },
    'profileversion' => { 34 => 0x8 },
    'programversion' => { 38 => 0x46 },
    'progressivescans' => { 115 => 0x2 },
    'projazimuthangle' => { 31 => 0xc16 },
    'projcentereasting' => { 31 => 0xc12 },
    'projcenterlat' => { 31 => 0xc11 },
    'projcenterlong' => { 31 => 0xc10 },
    'projcenternorthing' => { 31 => 0xc13 },
    'projcoordtrans' => { 31 => 0xc03 },
    'projectedcstype' => { 31 => 0xc00 },
    'projection' => { 31 => 0xc02 },
    'projfalseeasting' => { 31 => 0xc0a },
    'projfalsenorthing' => { 31 => 0xc0b },
    'projfalseorigineasting' => { 31 => 0xc0e },
    'projfalseoriginlat' => { 31 => 0xc0d },
    'projfalseoriginlong' => { 31 => 0xc0c },
    'projfalseoriginnorthing' => { 31 => 0xc0f },
    'projlinearunits' => { 31 => 0xc04 },
    'projlinearunitsize' => { 31 => 0xc05 },
    'projnatoriginlat' => { 31 => 0xc09 },
    'projnatoriginlong' => { 31 => 0xc08 },
    'projrectifiedgridangle' => { 31 => 0xc18 },
    'projscaleatcenter' => { 31 => 0xc15 },
    'projscaleatnatorigin' => { 31 => 0xc14 },
    'projstdparallel1' => { 31 => 0xc06 },
    'projstdparallel2' => { 31 => 0xc07 },
    'projstraightvertpolelong' => { 31 => 0xc17 },
    'promoteparent' => { 71 => 'PROM' },
    'province-state' => { 38 => 0x5f },
    'ps2crdvmsize' => { 35 => 'psvm' },
    'ps2renteringintent' => { 35 => 'ps2i' },
    'pstringcaption' => { 116 => 0x3f0 },
    'publisher' => { 126 => 'Publisher' },
    'quality' => { 2 => 0x3, 26 => 0x2, 27 => 0x3002, 29 => 0x1000, 50 => 0x9, 84 => 0x4, 85 => 0x3, 92 => 0x201, 114 => 0x8, 123 => 0x16 },
    'qualitymode' => { 27 => 0x8 },
    'quantizationmethod' => { 41 => 0x78 },
    'quickmaskinfo' => { 116 => 0x3fe },
    'quickshot' => { 122 => 0x213 },
    'rasterizedcaption' => { 38 => 0x7d },
    'rasterpadding' => { 28 => 0x84e3 },
    'rawandjpgrecording' => { 14 => 0x8 },
    'rawdata' => { 22 => 0x2005 },
    'rawdevcolorspace' => { 93 => 0x108 },
    'rawdevcontrastvalue' => { 93 => 0x106 },
    'rawdeveditstatus' => { 93 => 0x10b },
    'rawdevelopment' => { 92 => 0x2030 },
    'rawdevengine' => { 93 => 0x109 },
    'rawdevexposurebiasvalue' => { 93 => 0x100 },
    'rawdevgraypoint' => { 93 => 0x103 },
    'rawdevmemorycoloremphasis' => { 93 => 0x105 },
    'rawdevnoisereduction' => { 93 => 0x10a },
    'rawdevsaturationemphasis' => { 93 => 0x104 },
    'rawdevsettings' => { 93 => 0x10c },
    'rawdevsharpnessvalue' => { 93 => 0x107 },
    'rawdevversion' => { 93 => 0x0 },
    'rawdevwbfineadjustment' => { 93 => 0x102 },
    'rawdevwhitebalancevalue' => { 93 => 0x101 },
    'rawfile' => { 28 => 0xfe4c },
    'rawfilename' => { 126 => 'RawFileName' },
    'rawimagemode' => { 116 => 0x405 },
    'rawimagesize' => { 114 => 0x39 },
    'readerrequirements' => { 48 => 'rreq' },
    'recordid' => { 22 => 0x1804 },
    'recordingmode' => { 26 => 0x1 },
    'recordmode' => { 27 => 0x3000 },
    'recordshutterrelease' => { 122 => 0x217 },
    'redbalance' => { 79 => 0x0, 80 => 0x0, 81 => 0x0, 92 => 0x1017, 114 => 0x1c },
    'redbalanceauto' => { 13 => 0x0 },
    'redbalanceb&w' => { 13 => 0xe },
    'redbalancecloudy' => { 13 => 0x4 },
    'redbalancecustom' => { 13 => 0xc },
    'redbalancedaylight' => { 13 => 0x2 },
    'redbalanceflash' => { 13 => 0xa },
    'redbalancefluorescent' => { 13 => 0x8 },
    'redbalanceshade' => { 13 => 0x10 },
    'redbalancetungsten' => { 13 => 0x6 },
    'redbluebias' => { 91 => 0x100 },
    'redeyereduction' => { 127 => 'RedEyeReduction' },
    'redgain' => { 121 => 'Rg' },
    'redhue' => { 126 => 'RedHue' },
    'redmatrixcolumn' => { 35 => 'rXYZ' },
    'redprimary' => { 58 => 'red-primary' },
    'redsample' => { 60 => 0xd },
    'redsaturation' => { 126 => 'RedSaturation' },
    'redtrc' => { 35 => 'rTRC' },
    'reductionmatrix1' => { 28 => 0xc625 },
    'reductionmatrix2' => { 28 => 0xc626 },
    'redx' => { 111 => 0x2 },
    'redy' => { 111 => 0x3 },
    'referenceblackwhite' => { 28 => 0x214, 126 => 'ReferenceBlackWhite' },
    'referencedate' => { 38 => 0x2f },
    'referencenumber' => { 38 => 0x32 },
    'referenceservice' => { 38 => 0x2d },
    'relatedimagefileformat' => { 28 => 0x1000 },
    'relatedimagelength' => { 28 => 0x1002 },
    'relatedimagewidth' => { 28 => 0x1001 },
    'relatedsoundfile' => { 28 => 0xa004, 126 => 'RelatedSoundFile' },
    'relation' => { 126 => 'Relation' },
    'releasedate' => { 38 => 0x1e },
    'releasesetting' => { 22 => 0x1016 },
    'releasetime' => { 38 => 0x23 },
    'renderingintent' => { 34 => 0x40, 58 => 'rendering-intent' },
    'renditionclass' => { 126 => 'RenditionClass' },
    'renditionof' => { 126 => 'RenditionOf' },
    'renditionofdocumentid' => { 126 => 'RenditionOfDocumentID' },
    'renditionofinstanceid' => { 126 => 'RenditionOfInstanceID' },
    'renditionofmanager' => { 126 => 'RenditionOfManager' },
    'renditionofmanagervariant' => { 126 => 'RenditionOfManagerVariant' },
    'renditionofmanageto' => { 126 => 'RenditionOfManageTo' },
    'renditionofmanageui' => { 126 => 'RenditionOfManageUI' },
    'renditionofrenditionclass' => { 126 => 'RenditionOfRenditionClass' },
    'renditionofrenditionparams' => { 126 => 'RenditionOfRenditionParams' },
    'renditionofversionid' => { 126 => 'RenditionOfVersionID' },
    'renditionparams' => { 126 => 'RenditionParams' },
    'resaved' => { 122 => 0x21e },
    'resolution' => { 48 => 'res ', 58 => 'resolution' },
    'resolutioninfo' => { 116 => 0x3ed },
    'resolutionmode' => { 123 => 0x4 },
    'resolutionunit' => { 28 => 0x128, 87 => 0x128, 126 => 'ResolutionUnit' },
    'resources' => { 100 => 'Resources' },
    'resourcesneeded' => { 71 => 'nEED' },
    'revision' => { 121 => ['Rev','Rv'] },
    'ricohdatetime1' => { 120 => 0x4 },
    'ricohdatetime2' => { 120 => 0x5 },
    'ricohrr1subdir' => { 119 => 0x2001 },
    'ricohsubdir' => { 119 => 0x2001 },
    'rightmag' => { 70 => 0xb },
    'rights' => { 126 => 'Rights' },
    'roidescription' => { 48 => 'roid' },
    'rollguidelements' => { 28 => 0xc364 },
    'romoperationmode' => { 22 => 0x80d },
    'root' => { 101 => 'Root' },
    'rotation' => { 21 => 0x3 },
    'rowsperstrip' => { 28 => 0x116 },
    'safetyshiftinavortv' => { 14 => 0x10, 15 => 0x10, 16 => 0xf },
    'sampleformat' => { 28 => 0x153 },
    'samplesperpixel' => { 28 => 0x115, 126 => 'SamplesPerPixel' },
    'samplestructure' => { 41 => 0x5a },
    'sanyoquality' => { 122 => 0x201 },
    'sanyothumbnail' => { 122 => 0x100 },
    'saturation' => { 2 => 0xe, 26 => 0xd, 27 => 0x1f, 28 => [0xa409,0xfe55], 29 => 0x1003, 77 => 0x1f, 84 => [0x94,0xaa], 114 => 0x1f, 123 => 0x10, 126 => 'Saturation' },
    'saveid' => { 126 => 'SaveID' },
    'saveobjects' => { 71 => 'SAVE' },
    'sba_rgbshifts' => { 28 => 0xc35e },
    'sbaexposurerecord' => { 28 => 0xc361 },
    'sbainputimagebitdepth' => { 28 => 0xc360 },
    'sbainputimagecolorspace' => { 28 => 0xc35f },
    'scalefactor35efl' => { 127 => 'ScaleFactor35efl' },
    'scanningdirection' => { 41 => 0x64 },
    'scene' => { 58 => 'scene', 126 => 'Scene' },
    'scenecapturetype' => { 28 => 0xa406, 126 => 'SceneCaptureType' },
    'scenemode' => { 84 => 0x8f, 88 => 0x509 },
    'sceneselect' => { 122 => 0x21f },
    'scenetype' => { 28 => 0xa301, 126 => 'SceneType' },
    'screening' => { 35 => 'scrn' },
    'screeningdesc' => { 35 => 'scrd' },
    'securityclassification' => { 28 => [0x9212,0xa212] },
    'seekpoint' => { 71 => 'SEEK' },
    'self-timer' => { 2 => 0x2 },
    'self-timer2' => { 12 => 0x1d },
    'selftimer' => { 27 => 0x3001, 122 => 0x214 },
    'selftimermode' => { 28 => 0x882b },
    'selftimertime' => { 22 => 0x1806 },
    'sensingmethod' => { 28 => [0x9217,0xa217], 126 => 'SensingMethod' },
    'sensorbottomborder' => { 24 => 0x8 },
    'sensorcleaning' => { 17 => 0xd },
    'sensorheight' => { 24 => 0x2 },
    'sensorinfo' => { 22 => 0x1031 },
    'sensorleftborder' => { 24 => 0x5 },
    'sensorpixelsize' => { 84 => 0x9a },
    'sensorrightborder' => { 24 => 0x7 },
    'sensortopborder' => { 24 => 0x6 },
    'sensorwidth' => { 24 => 0x1 },
    'sequence' => { 88 => 0x600 },
    'sequencenumber' => { 12 => 0x9, 50 => 0x1d },
    'sequenceshotinterval' => { 122 => 0x224 },
    'sequentialshot' => { 122 => 0x20e },
    'serialnumber' => { 8 => 0xc, 22 => 0x180b, 28 => [0xc354,0xfde9], 84 => [0xa0,0x1d], 89 => 0x101, 92 => 0x101a, 113 => 0x25, 123 => 0x2, 126 => 'SerialNumber' },
    'serviceidentifier' => { 39 => 0x1e },
    'setbuttonfunction' => { 14 => 0x1, 17 => 0xc },
    'setfunctionwhenshooting' => { 16 => 0x0 },
    'shadingcompensation' => { 88 => 0x50c },
    'shadingcompensation2' => { 91 => 0x1012 },
    'shadow' => { 123 => 0xe },
    'shadows' => { 28 => 0xfe52, 126 => 'Shadows' },
    'shadowscale' => { 28 => 0xc633 },
    'shadowtint' => { 126 => 'ShadowTint' },
    'sharpness' => { 2 => 0xf, 26 => 0xb, 27 => 0x21, 28 => [0xa40a,0xfe56], 29 => 0x1001, 50 => 0x6b, 53 => 0x37, 77 => 0x21, 84 => 0x6, 114 => 0x21, 123 => 0x11, 126 => 'Sharpness' },
    'sharpnessfactor' => { 92 => [0x100f,0x102a] },
    'sharpnesssetting' => { 88 => 0x506 },
    'shootingmode' => { 84 => 0x89, 113 => 0x1f, 127 => 'ShootingMode' },
    'shootingrecord' => { 22 => 0x3002 },
    'shortdocumentid' => { 38 => 0xba },
    'shortfocal' => { 2 => 0x18, 7 => 0x12 },
    'showmode' => { 75 => 0x4 },
    'showobjects' => { 71 => 'SHOW' },
    'shutter-aelock' => { 14 => 0x4, 16 => 0x3, 17 => 0x2 },
    'shutteraelbutton' => { 15 => 0x4 },
    'shuttercount' => { 5 => 0x1, 84 => 0xa7 },
    'shuttercurtainhack' => { 127 => 'ShutterCurtainHack' },
    'shuttercurtainsync' => { 14 => 0xf, 15 => 0xf, 16 => 0xe, 17 => 0x8 },
    'shuttermode' => { 50 => 0x1b },
    'shutterreleasemethod' => { 22 => 0x1010 },
    'shutterreleasenocfcard' => { 14 => 0x2, 15 => 0x2, 17 => 0xf },
    'shutterreleasetiming' => { 22 => 0x1011 },
    'shutterspeed' => { 127 => 'ShutterSpeed' },
    'shutterspeedvalue' => { 28 => 0x9201, 126 => 'ShutterSpeedValue' },
    'signalnumber' => { 68 => 0xe },
    'signature' => { 58 => 'signature' },
    'significantbits' => { 109 => 'sBIT' },
    'similarityindex' => { 38 => 0xe4 },
    'simplicityprofile' => { 69 => 0x6 },
    'site' => { 28 => 0x84e0 },
    'sizemode' => { 44 => 0xa },
    'slices' => { 116 => 0x41a },
    'slowsync' => { 29 => 0x1030 },
    'smaxsamplevalue' => { 28 => 0x155 },
    'sminsamplevalue' => { 28 => 0x154 },
    'smoothingparameter1' => { 91 => 0x300 },
    'smoothingparameter2' => { 91 => 0x310 },
    'smoothingthreshold2' => { 91 => 0x610 },
    'smoothingthresholds' => { 91 => 0x600 },
    'smoothness' => { 28 => 0xfe57 },
    'snapshotid' => { 65 => 0x0 },
    'snapshotname' => { 65 => 0x2 },
    'software' => { 28 => 0x131, 112 => 'Software', 123 => 0x18, 126 => 'Software' },
    'softwareversion' => { 122 => 0x207 },
    'source' => { 38 => 0x73, 112 => 'Source', 126 => 'Source' },
    'sourceid' => { 62 => 0x0, 73 => 0xb },
    'sourceimagedirectory' => { 28 => 0xc418 },
    'sourceimagefilename' => { 28 => 0xc419 },
    'sourceimagevolumename' => { 28 => 0xc41a },
    'spatialfrequencyresponse' => { 28 => [0x920c,0xa20c], 126 => 'SpatialFrequencyResponse' },
    'spatialfrequencyresponsecolumns' => { 126 => 'SpatialFrequencyResponseColumns' },
    'spatialfrequencyresponsenames' => { 126 => 'SpatialFrequencyResponseNames' },
    'spatialfrequencyresponserows' => { 126 => 'SpatialFrequencyResponseRows' },
    'spatialfrequencyresponsevalues' => { 126 => 'SpatialFrequencyResponseValues' },
    'specialinstructions' => { 38 => 0x28 },
    'specialmode' => { 92 => 0x200, 122 => 0x200 },
    'spectralsensitivity' => { 28 => 0x8824, 126 => 'SpectralSensitivity' },
    'spotfocuspointx' => { 77 => 0x2d },
    'spotfocuspointy' => { 77 => 0x2e },
    'spothalftone' => { 116 => 0x413 },
    'spotmode' => { 113 => 0xf },
    'srgbrendering' => { 109 => 'sRGB' },
    'state' => { 126 => 'State' },
    'stonits' => { 28 => 0x923f },
    'stream' => { 97 => 'stream', 98 => 'stream' },
    'stripbytecounts' => { 28 => 0x117 },
    'stripoffsets' => { 28 => 0x111 },
    'striprowcounts' => { 28 => 0x22f },
    'sub-location' => { 38 => 0x5c },
    'subfile' => { 42 => 0xa },
    'subfiletype' => { 28 => 0xfe },
    'subifd' => { 28 => 0x14a },
    'subifd_offset' => { 86 => 0x3 },
    'subject' => { 99 => 'Subject', 117 => 'Subject', 126 => 'Subject' },
    'subjectarea' => { 126 => 'SubjectArea' },
    'subjectcode' => { 126 => 'SubjectCode' },
    'subjectdistance' => { 28 => 0x9206, 50 => 0x3e, 126 => 'SubjectDistance' },
    'subjectdistancerange' => { 28 => 0xa40c, 126 => 'SubjectDistanceRange' },
    'subjectlocation' => { 28 => [0x9214,0xa214], 126 => 'SubjectLocation' },
    'subjectprogram' => { 77 => 0x22 },
    'subjectreference' => { 38 => 0xc },
    'subsecdatetimeoriginal' => { 127 => 'SubSecDateTimeOriginal' },
    'subsectime' => { 28 => 0x9290 },
    'subsectimedigitized' => { 28 => 0x9292 },
    'subsectimeoriginal' => { 28 => 0x9291 },
    'suggestedpalette' => { 109 => 'sPLT' },
    'superimposeddisplay' => { 14 => 0xa, 16 => 0x9, 17 => 0xe },
    'supplementalcategories' => { 38 => 0x14, 126 => 'SupplementalCategories' },
    'supplementaltype' => { 41 => 0x37 },
    'switchtoregisteredafpoint' => { 15 => 0x12 },
    't4options' => { 28 => 0x124 },
    't6options' => { 28 => 0x125 },
    'targetaperture' => { 12 => 0x4 },
    'targetcompressionratio' => { 20 => 0x1 },
    'targetdeltatype' => { 73 => 0x2 },
    'targetdistancesetting' => { 22 => 0x1807 },
    'targetexposuretime' => { 12 => 0x5 },
    'targetimagetype' => { 22 => 0x100a },
    'targetprinter' => { 28 => 0x151 },
    'targetxy' => { 73 => 0x3 },
    'technology' => { 35 => 'tech' },
    'terminationaction' => { 71 => 'TERM', 76 => 0x0 },
    'terminationcondition' => { 68 => 0x5 },
    'textualdata' => { 109 => 'tEXt' },
    'thresholding' => { 28 => 0x107 },
    'thumbnailfilename' => { 22 => 0x817 },
    'thumbnailimage' => { 22 => 0x2008, 92 => 0x100, 127 => 'ThumbnailImage' },
    'thumbnaillength' => { 28 => 0x202 },
    'thumbnailoffset' => { 28 => 0x201 },
    'thumbnailresource' => { 116 => 0x409 },
    'thumbnails' => { 126 => 'Thumbnails' },
    'thumbnailsformat' => { 126 => 'ThumbnailsFormat' },
    'thumbnailsheight' => { 126 => 'ThumbnailsHeight' },
    'thumbnailsimage' => { 126 => 'ThumbnailsImage' },
    'thumbnailswidth' => { 126 => 'ThumbnailsWidth' },
    'tickspersecond' => { 69 => 0x2 },
    'tiff-epstandardid' => { 28 => [0x9216,0xa216] },
    'tiffthumbnail' => { 116 => 0x422 },
    'tilebytecounts' => { 28 => 0x145 },
    'tiledepth' => { 28 => 0x80e6 },
    'tilelength' => { 28 => 0x143 },
    'tileoffsets' => { 28 => 0x144 },
    'tilewidth' => { 28 => 0x142 },
    'time' => { 50 => 0x14, 53 => 0x10, 114 => 0x7 },
    'timecreated' => { 38 => 0x3c },
    'timesent' => { 39 => 0x50 },
    'timestamp' => { 22 => 0x180e },
    'timezone' => { 27 => 0x3006 },
    'timezonecode' => { 25 => 0x1 },
    'timezoneinfo' => { 25 => 0x2 },
    'timezoneoffset' => { 28 => 0x882a },
    'title' => { 99 => 'Title', 112 => 'Title', 117 => 'Title', 126 => 'Title' },
    'tonecomp' => { 84 => 0x81 },
    'tonecurve' => { 114 => 0x402 },
    'tonecurves' => { 114 => 0x403 },
    'topmag' => { 70 => 0xd },
    'totalzoom' => { 50 => 0x62 },
    'transferfunction' => { 28 => 0x12d, 126 => 'TransferFunction' },
    'transferrange' => { 28 => 0x156 },
    'transmissionreference' => { 126 => 'TransmissionReference' },
    'transparency' => { 109 => 'tRNS' },
    'transparencyindicator' => { 28 => 0x84ec },
    'transparentindex' => { 116 => 0x417 },
    'trapped' => { 99 => 'Trapped' },
    'tvvalue' => { 18 => 0x1 },
    'type' => { 126 => 'Type' },
    'ucrbg' => { 35 => 'bfd ' },
    'unicodealphanames' => { 116 => 0x415 },
    'uniquecameramodel' => { 28 => 0xc614 },
    'uniquedocumentid' => { 38 => 0xbb },
    'uniqueobjectname' => { 39 => 0x64 },
    'units' => { 58 => 'units' },
    'urgency' => { 38 => 0xa, 126 => 'Urgency' },
    'url' => { 48 => 'url ', 116 => 0x40b },
    'url_list' => { 116 => 0x41e },
    'usageterms' => { 126 => 'UsageTerms' },
    'useradjsba_rgbshifts' => { 28 => 0xc362 },
    'usercomment' => { 22 => 0x805, 28 => 0x9286, 126 => 'UserComment' },
    'userselectgrouptitle' => { 28 => 0xc355 },
    'usmlenselectronicmf' => { 15 => 0x7 },
    'uuid-geojp2' => { 48 => 'uuid' },
    'uuid-unknown' => { 48 => 'uuid' },
    'uuid-xmp' => { 48 => 'uuid' },
    'uuidinfo' => { 48 => 'uinf' },
    'uuidlist' => { 48 => 'ulst' },
    'validbits' => { 91 => 0x611, 92 => 0x102c },
    'variousmodes' => { 50 => 0x26 },
    'variousmodes2' => { 50 => 0x3a },
    'variprogram' => { 84 => 0xab },
    'version' => { 29 => 0x0, 126 => 'Version' },
    'versionid' => { 126 => 'VersionID' },
    'versioninfo' => { 116 => 0x421 },
    'versions' => { 126 => 'Versions' },
    'versionscomments' => { 126 => 'VersionsComments' },
    'versionsevent' => { 126 => 'VersionsEvent' },
    'versionseventaction' => { 126 => 'VersionsEventAction' },
    'versionseventinstanceid' => { 126 => 'VersionsEventInstanceID' },
    'versionseventparameters' => { 126 => 'VersionsEventParameters' },
    'versionseventsoftwareagent' => { 126 => 'VersionsEventSoftwareAgent' },
    'versionseventwhen' => { 126 => 'VersionsEventWhen' },
    'versionsmodifier' => { 126 => 'VersionsModifier' },
    'versionsmodifydate' => { 126 => 'VersionsModifyDate' },
    'versionsversion' => { 126 => 'VersionsVersion' },
    'versionyear' => { 28 => 0x194 },
    'verticalcitation' => { 31 => 0x1001 },
    'verticalcstype' => { 31 => 0x1000 },
    'verticaldatum' => { 31 => 0x1002 },
    'verticalunits' => { 31 => 0x1003 },
    'videocardgamma' => { 35 => 'vcgt' },
    'viewable' => { 60 => 0x1a },
    'viewingconddesc' => { 35 => 'vued' },
    'viewingcondilluminant' => { 37 => 0x8 },
    'viewingcondilluminanttype' => { 37 => 0x20 },
    'viewingconditions' => { 35 => 'view' },
    'viewingcondsurround' => { 37 => 0x14 },
    'vignetteamount' => { 126 => 'VignetteAmount' },
    'vignettemidpoint' => { 126 => 'VignetteMidpoint' },
    'voicememo' => { 122 => 0x216 },
    'wangannotation' => { 28 => 0x80a4 },
    'warning' => { 128 => 'Warning' },
    'watermark' => { 116 => 0x410 },
    'watermarktype' => { 49 => 0x8 },
    'webstatement' => { 126 => 'WebStatement' },
    'whitebalance' => { 12 => 0x7, 26 => 0x7, 27 => [0x19,0x2012], 28 => [0xa403,0xfe4e], 29 => 0x1002, 50 => 0x40, 55 => 0x1a, 77 => 0x3, 84 => 0x5, 85 => 0x7, 92 => 0x1015, 113 => 0x3, 114 => 0x19, 123 => 0x7, 126 => 'WhiteBalance' },
    'whitebalancebias' => { 27 => 0x2011, 113 => 0x23 },
    'whitebalancebracket' => { 88 => 0x502 },
    'whitebalancefinetune' => { 84 => 0xb },
    'whitebalancemode' => { 114 => 0x1a },
    'whitebalancetable' => { 8 => 0xa9, 22 => 0x10a9 },
    'whitebalancetemperature' => { 88 => 0x501 },
    'whitelevel' => { 28 => 0xc61d },
    'whitepoint' => { 28 => 0x13e, 58 => 'white-point', 114 => 0x201, 126 => 'WhitePoint' },
    'whitepointx' => { 111 => 0x0 },
    'whitepointy' => { 111 => 0x1 },
    'widefocuszone' => { 77 => 0x2f },
    'widerange' => { 122 => 0x20f },
    'workflowurl' => { 116 => 0x41b },
    'workingpath' => { 116 => 0x401 },
    'worldtimelocation' => { 114 => 0x22 },
    'writer-editor' => { 38 => 0x7a },
    'x3filllight' => { 123 => 0x12 },
    'xclippathunits' => { 28 => 0x158 },
    'xmag' => { 70 => 0x5 },
    'xmethod' => { 70 => 0x4 },
    'xml' => { 48 => 'xml ' },
    'xmldata' => { 116 => 0x3ea },
    'xmp' => { 102 => 'XML_stream', 109 => 'tXMP', 116 => 0x424, 117 => 'begin_xml_packet', 128 => 'XMP' },
    'xmp_profile' => { 58 => 'profile-xmp', 112 => 'Raw profile type xmp' },
    'xpauthor' => { 28 => 0x9c9d },
    'xpcomment' => { 28 => 0x9c9c },
    'xpkeywords' => { 28 => 0x9c9e },
    'xposition' => { 28 => 0x11e },
    'xpsubject' => { 28 => 0x9c9f },
    'xptitle' => { 28 => 0x9c9b },
    'xresolution' => { 28 => 0x11a, 87 => 0x11a, 126 => 'XResolution' },
    'xylocation' => { 63 => 0x4 },
    'ycbcrcoefficients' => { 28 => 0x211, 126 => 'YCbCrCoefficients' },
    'ycbcrpositioning' => { 28 => 0x213, 87 => 0x213 },
    'ycbcrsubsampling' => { 28 => 0x212, 126 => 'YCbCrSubSampling' },
    'yclippathunits' => { 28 => 0x159 },
    'ymag' => { 70 => 0x7 },
    'ymethod' => { 70 => 0x11 },
    'yposition' => { 28 => 0x11f },
    'yresolution' => { 28 => 0x11b, 87 => 0x11b, 126 => 'YResolution' },
    'zoom' => { 92 => 0x100d },
    'zoomedresolution' => { 2 => 0x24 },
    'zoomedresolutionbase' => { 2 => 0x25 },
    'zoomposition' => { 90 => 0x300 },
);

#++++ End automatically generated code ++++


#------------------------------------------------------------------------------
# find information for tag (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        &$writeProc();
                        @infoList = GetTagInfoList($table,$tagID);
                    }
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for all tag names

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2005, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
