#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::Canon::CameraInfo',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ColorInfoD30',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PictureInfo',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'actionadvised' => { 40 => 0x2a },
	'activearea' => { 36 => 0xc68d },
	'addoriginaldecisiondata' => { 20 => 0x11, 22 => 0x14 },
	'adjustmentmode' => { 80 => 0x15 },
	'advancedraw' => { 62 => 0x76a43203 },
	'advisory' => { 91 => 'Advisory' },
	'aebbracketvalue' => { 17 => 0x11 },
	'aebsequence' => { 18 => 0x9, 19 => 0x9, 20 => 0x8, 22 => 0x9, 23 => 0x7 },
	'aesetting' => { 1 => 0x21 },
	'afareas' => { 66 => 0x304 },
	'afassist' => { 18 => 0x5, 23 => 0x5 },
	'afassistbeam' => { 20 => 0x4, 21 => 0x4, 22 => 0x5 },
	'afmode' => { 80 => 0x5 },
	'afpoint' => { 1 => 0x13, 54 => 0x88 },
	'afpointactivationarea' => { 19 => 0x11, 22 => 0x11 },
	'afpointillumination' => { 19 => 0xa },
	'afpointregistration' => { 18 => 0x7 },
	'afpointselection' => { 19 => 0xb },
	'afpointselectionmethod' => { 20 => 0xc, 22 => 0xd },
	'afpointspotmetering' => { 19 => 0xd },
	'afpointsused' => { 14 => 0x16 },
	'afpointsused2' => { 17 => 0xe },
	'afpointsused20d' => { 14 => 0x1a },
	'afpointsused5d' => { 0 => 0x38 },
	'afsearch' => { 66 => 0x303 },
	'aiservotrackingsensitivity' => { 19 => 0x14 },
	'analogzoom' => { 46 => 0x1e },
	'antialiasstrength' => { 36 => 0xc632 },
	'aperturevalue' => { 36 => 0x9202, 86 => 'ApertureValue' },
	'app1_profile' => { 72 => 'Raw profile type APP1' },
	'applicationrecordversion' => { 40 => 0x0 },
	'armidentifier' => { 41 => 0x78 },
	'armversion' => { 41 => 0x7a },
	'artist' => { 36 => 0x13b, 72 => 'Artist', 90 => 'Artist' },
	'asshotwhitexy' => { 36 => 0xc629 },
	'assistbuttonfunction' => { 18 => 0xd },
	'audio' => { 73 => 0x20 },
	'audioduration' => { 40 => 0x99 },
	'audiooutcue' => { 40 => 0x9a },
	'audiosamplingrate' => { 40 => 0x97 },
	'audiosamplingresolution' => { 40 => 0x98 },
	'audiotype' => { 40 => 0x96 },
	'author' => { 72 => 'Author', 88 => 'Author' },
	'authorsposition' => { 89 => 'AuthorsPosition' },
	'autoafpoint' => { 74 => 0xf },
	'autobracket' => { 80 => 0x19 },
	'autobracketing' => { 38 => 0x1100 },
	'autoexposurebracketing' => { 17 => 0x10 },
	'autofocus' => { 68 => 0x209 },
	'autorotate' => { 17 => 0x1b },
	'auxiliarylens' => { 54 => 0x82 },
	'avvalue' => { 26 => 0x2 },
	'baseiso' => { 29 => 0x101c },
	'baselineexposure' => { 36 => 0xc62a },
	'baselinenoise' => { 36 => 0xc62b },
	'baselinesharpness' => { 36 => 0xc62c },
	'baseurl' => { 91 => 'BaseURL' },
	'bayergreensplit' => { 36 => 0xc62d },
	'bestqualityscale' => { 36 => 0xc65c },
	'bestshotmode' => { 34 => 0x3007 },
	'bitspercomponent' => { 42 => 0x87 },
	'bitspersample' => { 36 => 0x102, 90 => 'BitsPerSample' },
	'blacklevel' => { 70 => 0x1012 },
	'blackpoint' => { 74 => 0x200 },
	'bluebalance' => { 70 => 0x1018, 74 => 0x1b },
	'bluehue' => { 83 => 'BlueHue' },
	'bluesaturation' => { 83 => 'BlueSaturation' },
	'blurwarning' => { 38 => 0x1300 },
	'bodyfirmwareversion' => { 67 => 0x104 },
	'bracketmode' => { 8 => 0x3 },
	'bracketshotnumber' => { 8 => 0x5 },
	'bracketstep' => { 48 => 0xe },
	'bracketvalue' => { 8 => 0x4 },
	'brightness' => { 36 => 0xfe53, 48 => 0x2c, 83 => 'Brightness' },
	'brightnessadj' => { 57 => 0x0 },
	'brightnessvalue' => { 36 => 0x9203, 86 => 'BrightnessValue' },
	'bulbduration' => { 17 => 0x18 },
	'burstmode' => { 44 => 0xa },
	'burstmode2' => { 44 => 0x18 },
	'bwfilter' => { 48 => 0x2a },
	'bwmode' => { 70 => 0x203 },
	'by-line' => { 40 => 0x50 },
	'by-linetitle' => { 40 => 0x55 },
	'calibrationilluminant1' => { 36 => 0xc65a },
	'calibrationilluminant2' => { 36 => 0xc65b },
	'cameraid' => { 70 => 0x209, 79 => 0x209 },
	'cameraiso' => { 1 => 0x10 },
	'cameraserialnumber' => { 36 => 0xc62f },
	'camerasettings' => { 70 => 0x2020 },
	'camerasettingsversion' => { 66 => 0x0 },
	'cameratype' => { 70 => 0x207 },
	'canonexposuremode' => { 1 => 0x14 },
	'canonfiledescription' => { 29 => 0x805 },
	'canonfileinfo' => { 29 => 0x1093 },
	'canonfilelength' => { 11 => 0xe },
	'canonfirmwareversion' => { 11 => 0x7, 29 => 0x80b },
	'canonflashinfo' => { 29 => 0x1028 },
	'canonflashmode' => { 1 => 0x4 },
	'canonimageheight' => { 14 => 0x3 },
	'canonimageheightasshot' => { 14 => 0x5 },
	'canonimagesize' => { 1 => 0xa },
	'canonimagetype' => { 11 => 0x6, 29 => 0x815 },
	'canonimagewidth' => { 14 => 0x2 },
	'canonimagewidthasshot' => { 14 => 0x4 },
	'canonmodelid' => { 11 => 0x10 },
	'caption-abstract' => { 40 => 0x78 },
	'captionwriter' => { 89 => 'CaptionWriter' },
	'casioimagesize' => { 34 => 0x9 },
	'category' => { 40 => 0xf, 89 => 'Category' },
	'ccdisosensitivity' => { 34 => 0x3014 },
	'ccdsensitivity' => { 33 => 0x14, 56 => 0x6 },
	'celllength' => { 36 => 0x109 },
	'cellwidth' => { 36 => 0x108 },
	'certificate' => { 95 => 'Certificate' },
	'cfapattern' => { 36 => 0xa302 },
	'cfapatterncolumns' => { 86 => 'CFAPatternColumns' },
	'cfapatternrows' => { 86 => 'CFAPatternRows' },
	'cfapatternvalues' => { 86 => 'CFAPatternValues' },
	'chromablurradius' => { 36 => 0xc631 },
	'chromaticaberrationb' => { 83 => 'ChromaticAberrationB' },
	'chromaticaberrationr' => { 83 => 'ChromaticAberrationR' },
	'city' => { 40 => 0x5a, 89 => 'City' },
	'classifystate' => { 40 => 0xe1 },
	'codedcharacterset' => { 41 => 0x5a },
	'coloradjustment' => { 80 => 0x14 },
	'coloradjustmentmode' => { 79 => 0x210 },
	'colorbalance1' => { 54 => 0xc },
	'colorbalanceadj' => { 62 => 0x76a43202 },
	'colorbalanceblue' => { 48 => 0x1e },
	'colorbalancegreen' => { 48 => 0x1d },
	'colorbalancered' => { 48 => 0x1c },
	'colorbooster' => { 62 => 0x5f0e7d23 },
	'colorboostlevel' => { 58 => 0x1 },
	'colorboosttype' => { 58 => 0x0 },
	'colorcontrol' => { 70 => 0x102b },
	'coloreffect' => { 73 => 0x28 },
	'colorfilter' => { 48 => 0x29 },
	'colorhue' => { 6 => 0x2, 54 => 0x8d },
	'colormatrix' => { 7 => 0xa, 69 => 0x200, 70 => 0x1011 },
	'colormode' => { 34 => 0x3015, 44 => 0x66, 48 => 0x28, 49 => 0x101, 54 => 0x3, 56 => 0x4, 70 => 0x101 },
	'colormoirereduction' => { 63 => 0x5 },
	'colornoisereduction' => { 83 => 'ColorNoiseReduction' },
	'colorprofile' => { 48 => 0x33 },
	'colorrepresentation' => { 42 => 0x3c },
	'colorsequence' => { 42 => 0x41 },
	'colorspace' => { 6 => 0x3, 11 => 0xb4, 29 => 0x10b4, 36 => 0xa001, 66 => 0x507, 80 => 0xb, 86 => 'ColorSpace' },
	'colortempasshot' => { 3 => 0x1d, 4 => 0x1c, 5 => 0x43 },
	'colortempauto' => { 4 => 0x26, 5 => 0x48 },
	'colortempauto2' => { 3 => 0x22 },
	'colortempcloudy' => { 3 => 0x31, 4 => 0x35, 5 => 0x5c },
	'colortempcustom' => { 5 => 0x84 },
	'colortempcustom1' => { 3 => 0x45 },
	'colortempcustom2' => { 3 => 0x4a },
	'colortempdaylight' => { 3 => 0x27, 4 => 0x2b, 5 => 0x52 },
	'colortemperature' => { 7 => 0x9, 11 => 0xae, 16 => 0x9, 29 => 0x10ae },
	'colortempflash' => { 3 => 0x40, 4 => 0x49, 5 => 0x70 },
	'colortempfluorescent' => { 3 => 0x3b, 4 => 0x3f, 5 => 0x66 },
	'colortempkelvin' => { 4 => 0x44, 5 => 0x6b },
	'colortempmeasured' => { 5 => 0x4d },
	'colortemppc1' => { 4 => 0x94, 5 => 0x75 },
	'colortemppc2' => { 4 => 0x99, 5 => 0x7a },
	'colortemppc3' => { 4 => 0x9e, 5 => 0x7f },
	'colortempshade' => { 3 => 0x2c, 4 => 0x30, 5 => 0x57 },
	'colortemptungsten' => { 3 => 0x36, 4 => 0x3a, 5 => 0x61 },
	'colortempunknown' => { 4 => 0x21 },
	'colortempunknown10' => { 4 => 0x76 },
	'colortempunknown11' => { 4 => 0x7b },
	'colortempunknown12' => { 4 => 0x80 },
	'colortempunknown13' => { 4 => 0x85 },
	'colortempunknown14' => { 4 => 0x8a },
	'colortempunknown15' => { 4 => 0x8f },
	'colortempunknown16' => { 4 => 0xa3 },
	'colortempunknown2' => { 4 => 0x4e },
	'colortempunknown3' => { 4 => 0x53 },
	'colortempunknown4' => { 4 => 0x58 },
	'colortempunknown5' => { 4 => 0x5d },
	'colortempunknown6' => { 4 => 0x62 },
	'colortempunknown7' => { 4 => 0x67 },
	'colortempunknown8' => { 4 => 0x6c },
	'colortempunknown9' => { 4 => 0x71 },
	'colortone' => { 1 => 0x2a },
	'colortonefaithful' => { 0 => 0x107 },
	'colortonelandscape' => { 0 => 0x105 },
	'colortoneneutral' => { 0 => 0x106 },
	'colortoneportrait' => { 0 => 0x104 },
	'colortonestandard' => { 0 => 0x103 },
	'colortoneuserdef1' => { 0 => 0x109 },
	'colortoneuserdef2' => { 0 => 0x10a },
	'colortoneuserdef3' => { 0 => 0x10b },
	'comment' => { 37 => 'Comment', 72 => 'Comment' },
	'componentsconfiguration' => { 36 => 0x9101, 86 => 'ComponentsConfiguration' },
	'componentversion' => { 29 => 0x80c },
	'compressedbitsperpixel' => { 36 => 0x9102, 86 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 49 => 0x40, 70 => 0x40 },
	'compression' => { 36 => 0x103, 90 => 'Compression' },
	'compressionfactor' => { 66 => 0x50d },
	'compressionratio' => { 70 => 0x1034 },
	'contact' => { 40 => 0x76 },
	'contentlocationcode' => { 40 => 0x1a },
	'contentlocationname' => { 40 => 0x1b },
	'continuousdrive' => { 1 => 0x5 },
	'contrast' => { 1 => 0xd, 33 => 0xc, 34 => 0x20, 36 => [0xa408,0xfe54], 38 => 0x1004, 48 => 0x20, 70 => 0x1029, 73 => 0x2c, 74 => 0x20, 80 => 0xd, 83 => 'Contrast', 86 => 'Contrast' },
	'contrastfaithful' => { 0 => 0xec },
	'contrastlandscape' => { 0 => 0xea },
	'contrastmonochrome' => { 0 => 0xed },
	'contrastneutral' => { 0 => 0xeb },
	'contrastportrait' => { 0 => 0xe9 },
	'contrastsetting' => { 66 => 0x505 },
	'contraststandard' => { 0 => 0xe8 },
	'contrastuserdef1' => { 0 => 0xee },
	'contrastuserdef2' => { 0 => 0xef },
	'contrastuserdef3' => { 0 => 0xf0 },
	'contributor' => { 84 => 'contributor' },
	'converter' => { 36 => 0xfe4d, 56 => 0xb },
	'copyright' => { 36 => 0x8298, 72 => 'Copyright', 90 => 'Copyright' },
	'copyrightflag' => { 76 => 0x40a },
	'copyrightnotice' => { 40 => 0x74 },
	'coringfilter' => { 70 => 0x102d },
	'country' => { 89 => 'Country' },
	'country-primarylocationcode' => { 40 => 0x64 },
	'country-primarylocationname' => { 40 => 0x65 },
	'countrycode' => { 87 => 'CountryCode' },
	'coverage' => { 84 => 'coverage' },
	'crc32' => { 85 => 'crc32' },
	'createdate' => { 36 => 0x9004, 91 => 'CreateDate' },
	'creationdate' => { 88 => 'CreationDate' },
	'creationtime' => { 72 => 'Creation Time' },
	'creator' => { 84 => 'creator' },
	'creatorcontactinfociadrcity' => { 87 => 'CreatorContactInfoCiAdrCity' },
	'creatorcontactinfociadrctry' => { 87 => 'CreatorContactInfoCiAdrCtry' },
	'creatorcontactinfociadrextadr' => { 87 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcontactinfociadrpcode' => { 87 => 'CreatorContactInfoCiAdrPcode' },
	'creatorcontactinfociadrregion' => { 87 => 'CreatorContactInfoCiAdrRegion' },
	'creatorcontactinfociemailwork' => { 87 => 'CreatorContactInfoCiEmailWork' },
	'creatorcontactinfocitelwork' => { 87 => 'CreatorContactInfoCiTelWork' },
	'creatorcontactinfociurlwork' => { 87 => 'CreatorContactInfoCiUrlWork' },
	'creatortool' => { 91 => 'CreatorTool' },
	'credit' => { 40 => 0x6e, 89 => 'Credit' },
	'creditlinereq' => { 94 => 'CreditLineReq' },
	'cropbottom' => { 59 => 0x36 },
	'cropleft' => { 59 => 0x1e },
	'cropoutputscale' => { 59 => 0xbe },
	'cropright' => { 59 => 0x2e },
	'croptop' => { 59 => 0x26 },
	'curves' => { 62 => 0x76a43201 },
	'customrendered' => { 36 => 0xa401, 86 => 'CustomRendered' },
	'customsaturation' => { 66 => 0x503 },
	'd-lightinghq' => { 62 => 0x2175eb78 },
	'd-lightinghqselected' => { 62 => 0x6a6e36b6 },
	'd-lightinghs' => { 62 => 0xce5554aa },
	'd-lightinghsadjustment' => { 61 => 0x0 },
	'd-lightinghscolorboost' => { 60 => 0x2, 61 => 0x1 },
	'd-lightinghshighlight' => { 60 => 0x1 },
	'd-lightinghsshadow' => { 60 => 0x0 },
	'datacompressionmethod' => { 42 => 0x6e },
	'dataimprint' => { 48 => 0x34 },
	'date' => { 74 => 0x6, 84 => 'date' },
	'datecreated' => { 40 => 0x37, 89 => 'DateCreated' },
	'datesent' => { 41 => 0x46 },
	'datetime' => { 90 => 'DateTime' },
	'datetimedigitized' => { 86 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 32 => 0x0, 36 => 0x9003, 86 => 'DateTimeOriginal' },
	'datetimestamp' => { 44 => 0x64 },
	'decposition' => { 48 => 0x32 },
	'defaultcroporigin' => { 36 => 0xc61f },
	'defaultcropsize' => { 36 => 0xc620 },
	'defaultscale' => { 36 => 0xc61e },
	'derivedfromdocumentid' => { 93 => 'DerivedFromDocumentID' },
	'derivedfrominstanceid' => { 93 => 'DerivedFromInstanceID' },
	'derivedfrommanager' => { 93 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 93 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 93 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 93 => 'DerivedFromManageUI' },
	'derivedfromrenditionclass' => { 93 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 93 => 'DerivedFromRenditionParams' },
	'derivedfromversionid' => { 93 => 'DerivedFromVersionID' },
	'description' => { 72 => 'Description', 84 => 'description' },
	'destination' => { 41 => 0x5 },
	'destinationcity' => { 74 => 0x24 },
	'destinationcitycode' => { 74 => 0x1001 },
	'destinationdst' => { 74 => 0x26 },
	'devicesettingdescriptioncolumns' => { 86 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 86 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 86 => 'DeviceSettingDescriptionSettings' },
	'digitalcreationdate' => { 40 => 0x3e },
	'digitalcreationtime' => { 40 => 0x3f },
	'digitalgain' => { 16 => 0xb },
	'digitalzoom' => { 1 => 0xc, 33 => 0xa, 44 => 0x68, 48 => 0xc, 54 => 0x86, 56 => 0xa, 70 => 0x204, 74 => 0x1e, 79 => 0x204 },
	'digitalzoomon' => { 79 => 0x21b },
	'digitalzoomratio' => { 36 => 0xa404, 86 => 'DigitalZoomRatio' },
	'disclaimer' => { 72 => 'Disclaimer' },
	'displayaperture' => { 1 => 0x23 },
	'displayedunitsx' => { 77 => 0x2 },
	'displayedunitsy' => { 77 => 0x6 },
	'distance1' => { 44 => 0x28 },
	'distance2' => { 44 => 0x2c },
	'distance3' => { 44 => 0x30 },
	'distance4' => { 44 => 0x34 },
	'distortioncorrection' => { 66 => 0x50b },
	'dngbackwardversion' => { 36 => 0xc613 },
	'dnglensinfo' => { 36 => 0xc630 },
	'dngversion' => { 36 => 0xc612 },
	'document' => { 72 => 'Document' },
	'documenthistory' => { 40 => 0xe7 },
	'documentid' => { 93 => 'DocumentID' },
	'documentname' => { 36 => 0x10d },
	'documentnotes' => { 40 => 0xe6 },
	'dotrange' => { 36 => 0x150 },
	'drivemode' => { 48 => 0x6, 80 => 0x3 },
	'easymode' => { 1 => 0xb },
	'edgenoisereduction' => { 63 => 0x4 },
	'editorialupdate' => { 40 => 0x8 },
	'editstatus' => { 40 => 0x7 },
	'enhancedarktones' => { 57 => 0x8 },
	'enhancement' => { 34 => 0x3016 },
	'envelopenumber' => { 41 => 0x28 },
	'envelopepriority' => { 41 => 0x3c },
	'enveloperecordversion' => { 41 => 0x0 },
	'epsonimageheight' => { 70 => 0x20c },
	'epsonimagewidth' => { 70 => 0x20b },
	'epsonsoftware' => { 70 => 0x20d },
	'equipment' => { 70 => 0x2010 },
	'equipmentversion' => { 67 => 0x0 },
	'ettlii' => { 20 => 0xd, 21 => 0x7, 22 => 0xe },
	'excursiontolerance' => { 42 => 0x82 },
	'exif_profile' => { 72 => 'Raw profile type exif' },
	'exifcamerainfo' => { 40 => 0xe8 },
	'exifimageheight' => { 86 => 'PixelYDimension' },
	'exifimagelength' => { 36 => 0xa003 },
	'exifimagewidth' => { 36 => 0xa002, 86 => 'PixelXDimension' },
	'exifversion' => { 36 => 0x9000, 86 => 'ExifVersion' },
	'expirationdate' => { 40 => 0x25 },
	'expirationtime' => { 40 => 0x26 },
	'exposure' => { 36 => 0xfe51, 83 => 'Exposure' },
	'exposurebracketvalue' => { 54 => 0x19 },
	'exposurecompensation' => { 17 => 0x6, 26 => 0x0, 36 => 0x9204, 44 => 0x24, 48 => 0xd, 74 => 0x16, 80 => 0xc, 86 => 'ExposureBiasValue' },
	'exposuredifference' => { 54 => 0xe },
	'exposureindex' => { 36 => 0xa215, 86 => 'ExposureIndex' },
	'exposurelevelincrements' => { 18 => 0x6, 19 => 0x6, 20 => 0x5, 21 => 0x5, 22 => 0x6, 23 => 0x4 },
	'exposuremode' => { 36 => 0xa402, 48 => 0x1, 66 => 0x200, 80 => 0x8, 86 => 'ExposureMode' },
	'exposureprogram' => { 36 => 0x8822, 86 => 'ExposureProgram' },
	'exposuretime' => { 0 => 0x4, 17 => 0x16, 36 => 0x829a, 44 => 0x20, 46 => 0x38, 74 => 0x12, 86 => 'ExposureTime' },
	'exposurewarning' => { 38 => 0x1302 },
	'extender' => { 67 => 0x301 },
	'extenderfirmwareversion' => { 67 => 0x304 },
	'extenderserialnumber' => { 67 => 0x302 },
	'externalflash' => { 68 => 0x1201 },
	'ffid' => { 85 => 'ffid' },
	'fileformat' => { 28 => 0x0, 41 => 0x14 },
	'filemodifydate' => { 37 => 'FileModifyDate' },
	'filenumber' => { 8 => 0x1, 11 => 0x8, 29 => 0x1817 },
	'filenumbermemory' => { 48 => 0x1a },
	'filesource' => { 36 => 0xa300, 86 => 'FileSource' },
	'fileversion' => { 41 => 0x16 },
	'fillflashautoreduction' => { 18 => 0xe, 19 => 0xe, 23 => 0xa },
	'fillorder' => { 36 => 0x10a },
	'filter' => { 34 => 0x3017 },
	'filtereffect' => { 8 => 0xe },
	'filtereffectmonochrome' => { 0 => 0xff },
	'finderdisplayduringexposure' => { 19 => 0x1 },
	'firmware' => { 80 => 0x17 },
	'firmwarerevision' => { 0 => 0xa4 },
	'firmwareversion' => { 54 => 0x1, 73 => 0x2 },
	'firmwareversion2' => { 67 => 0x100 },
	'fixtureidentifier' => { 40 => 0x16 },
	'flash' => { 36 => 0x9209 },
	'flashactivity' => { 1 => 0x1c },
	'flashbias' => { 73 => 0x24 },
	'flashbits' => { 1 => 0x1d },
	'flashdevice' => { 70 => 0x1005 },
	'flashdistance' => { 34 => 0x2034 },
	'flashenergy' => { 36 => 0xa20b, 86 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 54 => 0x18 },
	'flashexposurecomp' => { 17 => 0xf, 48 => 0x23, 54 => 0x12 },
	'flashexposurecompensation' => { 66 => 0x401 },
	'flashfired' => { 44 => 0x5d, 48 => 0x14, 86 => 'FlashFired' },
	'flashfiring' => { 20 => 0x6, 22 => 0x7 },
	'flashfirmwareversion' => { 67 => 0x1004 },
	'flashfunction' => { 86 => 'FlashFunction' },
	'flashguidenumber' => { 17 => 0xd, 27 => 0x0 },
	'flashintensity' => { 33 => 0x5 },
	'flashmode' => { 33 => 0x4, 44 => 0x5c, 48 => 0x2, 54 => 0x87, 66 => 0x400, 70 => 0x1004, 74 => 0xc, 79 => 0x225, 86 => 'FlashMode' },
	'flashmodel' => { 67 => 0x1001 },
	'flashpixversion' => { 36 => 0xa000, 86 => 'FlashpixVersion' },
	'flashredeyemode' => { 86 => 'FlashRedEyeMode' },
	'flashreturn' => { 86 => 'FlashReturn' },
	'flashserialnumber' => { 67 => 0x1003 },
	'flashsetting' => { 54 => 0x8 },
	'flashstrength' => { 38 => 0x1011 },
	'flashsyncspeedav' => { 18 => 0x3, 20 => 0x2, 21 => 0x2, 22 => 0x3, 23 => 0x6 },
	'flashthreshold' => { 27 => 0x1 },
	'flashtype' => { 54 => 0x9, 67 => 0x1000 },
	'flickerreduce' => { 79 => 0x218 },
	'fliphorizontal' => { 62 => 0x76a43206 },
	'fnumber' => { 17 => 0x15, 36 => 0x829d, 44 => 0x1e, 46 => 0x3c, 74 => 0x13, 86 => 'FNumber' },
	'focallength' => { 0 => 0xa, 10 => 0x1, 34 => 0x1d, 36 => 0x920a, 48 => 0x12, 74 => 0x1d, 86 => 'FocalLength' },
	'focallengthin35mmformat' => { 36 => 0xa405, 86 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 67 => 0x103, 70 => 0x205 },
	'focalplaneresolutionunit' => { 36 => 0xa210, 86 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 36 => 0xa20e, 86 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 10 => 0x2 },
	'focalplaneyresolution' => { 36 => 0xa20f, 86 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 10 => 0x3 },
	'focaltype' => { 0 => 0x2d, 10 => 0x0 },
	'focalunits' => { 1 => 0x19 },
	'focus' => { 56 => 0x8 },
	'focusarea' => { 48 => 0x31 },
	'focuscontinuous' => { 1 => 0x20 },
	'focusdistance' => { 48 => 0x13, 68 => 0x305 },
	'focusdistancelower' => { 17 => 0x14 },
	'focusdistanceupper' => { 17 => 0x13 },
	'focusinfo' => { 70 => 0x2050 },
	'focusinfoversion' => { 68 => 0x0 },
	'focusingscreen' => { 19 => 0x0, 22 => 0x0 },
	'focusmode' => { 1 => 0x7, 33 => 0x3, 34 => [0x3003,0xd], 38 => 0x1021, 44 => 0x38, 48 => 0x30, 54 => 0x7, 66 => 0x301, 73 => 0x7, 74 => 0xd },
	'focusposition' => { 74 => 0x10 },
	'focusprocess' => { 66 => 0x302 },
	'focusrange' => { 1 => 0x12 },
	'focussetting' => { 80 => 0x6 },
	'focuswarning' => { 38 => 0x1301 },
	'foldername' => { 48 => 0x27 },
	'format' => { 84 => 'format' },
	'framenumber' => { 74 => 0x29 },
	'freebytes' => { 29 => 0x1 },
	'fujiflashmode' => { 38 => 0x1010 },
	'gaincontrol' => { 36 => 0xa407, 86 => 'GainControl' },
	'gamma' => { 36 => 0xa500 },
	'gammacompensatedvalue' => { 42 => 0x91 },
	'globalaltitude' => { 76 => 0x419 },
	'globalangle' => { 76 => 0x40d },
	'gpsaltitude' => { 39 => 0x6, 86 => 'GPSAltitude' },
	'gpsaltituderef' => { 39 => 0x5, 86 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 39 => 0x1c, 86 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 39 => 0x1d },
	'gpsdestbearing' => { 39 => 0x18, 86 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 39 => 0x17, 86 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 39 => 0x1a, 86 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 39 => 0x19, 86 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 39 => 0x14, 86 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 39 => 0x13 },
	'gpsdestlongitude' => { 39 => 0x16, 86 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 39 => 0x15 },
	'gpsdifferential' => { 39 => 0x1e, 86 => 'GPSDifferential' },
	'gpsdop' => { 39 => 0xb, 86 => 'GPSDOP' },
	'gpsimgdirection' => { 39 => 0x11, 86 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 39 => 0x10, 86 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 39 => 0x2, 86 => 'GPSLatitude' },
	'gpslatituderef' => { 39 => 0x1 },
	'gpslongitude' => { 39 => 0x4, 86 => 'GPSLongitude' },
	'gpslongituderef' => { 39 => 0x3 },
	'gpsmapdatum' => { 39 => 0x12, 86 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 39 => 0xa, 86 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 39 => 0x1b, 86 => 'GPSProcessingMethod' },
	'gpssatellites' => { 39 => 0x8, 86 => 'GPSSatellites' },
	'gpsspeed' => { 39 => 0xd, 86 => 'GPSSpeed' },
	'gpsspeedref' => { 39 => 0xc, 86 => 'GPSSpeedRef' },
	'gpsstatus' => { 39 => 0x9, 86 => 'GPSStatus' },
	'gpstimestamp' => { 39 => 0x7, 86 => 'GPSTimeStamp' },
	'gpstrack' => { 39 => 0xf, 86 => 'GPSTrack' },
	'gpstrackref' => { 39 => 0xe, 86 => 'GPSTrackRef' },
	'gpsversionid' => { 39 => 0x0, 86 => 'GPSVersionID' },
	'gradation' => { 66 => 0x50f },
	'grayresponseunit' => { 36 => 0x122 },
	'greenhue' => { 83 => 'GreenHue' },
	'greensaturation' => { 83 => 'GreenSaturation' },
	'halftonehints' => { 36 => 0x141 },
	'headline' => { 40 => 0x69, 89 => 'Headline' },
	'highlight' => { 80 => 0xf },
	'historyaction' => { 93 => 'HistoryAction' },
	'historyinstanceid' => { 93 => 'HistoryInstanceID' },
	'historyparameters' => { 93 => 'HistoryParameters' },
	'historysoftwareagent' => { 93 => 'HistorySoftwareAgent' },
	'historywhen' => { 93 => 'HistoryWhen' },
	'hometowncity' => { 74 => 0x23 },
	'hometowncitycode' => { 74 => 0x1000 },
	'hometowndst' => { 74 => 0x25 },
	'hostcomputer' => { 36 => 0x13c },
	'hueadjustment' => { 54 => 0x92 },
	'icc_profile' => { 72 => ['Raw profile type icc','Raw profile type icm'] },
	'identifier' => { 84 => 'identifier', 91 => 'Identifier' },
	'imageadjustment' => { 54 => 0x80, 56 => 0x5 },
	'imageboundary' => { 54 => 0x16 },
	'imagedatasize' => { 54 => 0xa2 },
	'imagedescription' => { 36 => 0x10e, 90 => 'ImageDescription' },
	'imagedustoff' => { 62 => 0xfe443a45 },
	'imageheight' => { 36 => 0x101, 90 => 'ImageLength' },
	'imageoptimization' => { 54 => 0xa9 },
	'imageorientation' => { 40 => 0x83 },
	'imageprocessing' => { 70 => 0x2040 },
	'imageprocessingversion' => { 69 => 0x0 },
	'imagequality' => { 73 => 0x1 },
	'imagequality2' => { 66 => 0x603 },
	'imagestabilization' => { 1 => 0x22 },
	'imagestabilizer' => { 73 => 0x1a },
	'imagetype' => { 40 => 0x82 },
	'imageuniqueid' => { 36 => 0xa420, 86 => 'ImageUniqueID' },
	'imagewidth' => { 36 => 0x100, 90 => 'ImageWidth' },
	'inkset' => { 36 => 0x14c },
	'instructions' => { 89 => 'Instructions' },
	'intellectualgenre' => { 87 => 'IntellectualGenre' },
	'interchangecolorspace' => { 42 => 0x40 },
	'internalflash' => { 48 => 0x2b, 68 => 0x1208 },
	'interopindex' => { 36 => 0x1 },
	'interopversion' => { 36 => 0x2 },
	'intervallength' => { 48 => 0x10 },
	'intervalmode' => { 48 => 0x26 },
	'intervalnumber' => { 48 => 0x11 },
	'iptc-naa' => { 36 => 0x83bb },
	'iptc_profile' => { 72 => 'Raw profile type iptc' },
	'iptcbitspersample' => { 42 => 0x56 },
	'iptcimageheight' => { 42 => 0x1e },
	'iptcimagerotation' => { 42 => 0x66 },
	'iptcimagewidth' => { 42 => 0x14 },
	'iptcpicturenumber' => { 42 => 0xa },
	'iptcpixelheight' => { 42 => 0x32 },
	'iptcpixelwidth' => { 42 => 0x28 },
	'iso' => { 17 => 0x2, 34 => 0x14, 36 => 0x8827, 44 => 0x60, 46 => 0x4e, 54 => 0x2, 74 => 0x14, 86 => 'ISOSpeedRatings' },
	'isoexpansion' => { 20 => 0x7, 22 => 0x8 },
	'isoselection' => { 54 => 0xf },
	'isosetting' => { 44 => 0x5e, 48 => 0x24, 54 => 0x13 },
	'isospeedexpansion' => { 19 => 0x3 },
	'jobid' => { 40 => 0xb8 },
	'jobrefid' => { 92 => 'JobRefId' },
	'jobrefname' => { 92 => 'JobRefName' },
	'jobrefurl' => { 92 => 'JobRefUrl' },
	'jpgfromraw' => { 29 => 0x2007, 35 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 36 => 0x202 },
	'jpgfromrawstart' => { 36 => 0x201 },
	'keywords' => { 40 => 0x19, 88 => 'Keywords' },
	'kodakimageheight' => { 44 => 0xe, 45 => 0x70 },
	'kodakimagewidth' => { 44 => 0xc, 45 => 0x6c },
	'kodakmaker' => { 45 => 0x8 },
	'kodakmodel' => { 44 => 0x0, 45 => 0x28 },
	'label' => { 72 => 'Label', 91 => 'Label' },
	'language' => { 84 => 'language' },
	'languageidentifier' => { 40 => 0x87 },
	'lastfilenumber' => { 48 => 0x1b },
	'lasturl' => { 93 => 'LastURL' },
	'lcddisplayreturntoshoot' => { 22 => 0x12 },
	'lcdpanels' => { 19 => 0x8 },
	'lcheditor' => { 62 => 0x8ae85e },
	'lens' => { 36 => 0xfdea, 54 => 0x84, 80 => 0xa, 81 => 'Lens' },
	'lensafstopbutton' => { 18 => 0x11, 19 => 0x13, 20 => 0x10, 22 => 0x13, 23 => 0x9 },
	'lensdata0100' => { 54 => 0x98 },
	'lensdata0101' => { 54 => 0x98 },
	'lensdata0201' => { 54 => 0x98 },
	'lensdataversion' => { 53 => 0x0 },
	'lensfirmwareversion' => { 67 => 0x204 },
	'lensfstops' => { 53 => 0x7, 54 => 0x8b },
	'lensid' => { 49 => 0x10c },
	'lensidnumber' => { 53 => 0x6 },
	'lensserialnumber' => { 67 => 0x202 },
	'lenstype' => { 0 => 0xd, 1 => 0x16, 11 => 0x95, 54 => 0x83, 67 => 0x201, 74 => 0x3f },
	'license' => { 82 => 'license' },
	'licensetype' => { 85 => 'licensetype' },
	'lightsource' => { 36 => 0x9208, 54 => 0x90, 86 => 'LightSource' },
	'lightsourcespecial' => { 79 => 0x21d },
	'linearresponselimit' => { 36 => 0xc62e },
	'localcaption' => { 40 => 0x79 },
	'localizedcameramodel' => { 36 => 0xc615 },
	'location' => { 87 => 'Location' },
	'longexposurenoisereduction' => { 20 => 0x1, 21 => 0x1, 22 => 0x2, 23 => 0x1 },
	'longfocal' => { 0 => 0x14, 1 => 0x17 },
	'luminancesmoothing' => { 83 => 'LuminanceSmoothing' },
	'macro' => { 38 => 0x1020, 70 => 0x202, 79 => 0x202 },
	'macromode' => { 1 => 0x1, 48 => 0xb, 66 => 0x300, 73 => 0x1c },
	'make' => { 30 => 0x0, 36 => 0x10f, 72 => 'Make', 90 => 'Make' },
	'makernote' => { 86 => 'MakerNote' },
	'makernotecanon' => { 36 => 0x927c },
	'makernotecasio' => { 36 => 0x927c },
	'makernotecasio2' => { 36 => 0x927c },
	'makernotefujifilm' => { 36 => 0x927c },
	'makernotejvc' => { 36 => 0x927c },
	'makernotejvctext' => { 36 => 0x927c },
	'makernotekodak1a' => { 36 => 0x927c },
	'makernotekodak1b' => { 36 => 0x927c },
	'makernotekodak2' => { 36 => 0x927c },
	'makernotekodak3' => { 36 => 0x927c },
	'makernotekodak4' => { 36 => 0x927c },
	'makernotekodak5' => { 36 => 0x927c },
	'makernotekodak6a' => { 36 => 0x927c },
	'makernotekodak6b' => { 36 => 0x927c },
	'makernotekodakunknown' => { 36 => 0x927c },
	'makernotekyocera' => { 36 => 0x927c },
	'makernoteleica' => { 36 => 0x927c },
	'makernoteminolta' => { 36 => 0x927c },
	'makernotenikon' => { 36 => 0x927c },
	'makernotenikon2' => { 36 => 0x927c },
	'makernotenikon3' => { 36 => 0x927c },
	'makernoteoffset' => { 79 => 0xff },
	'makernoteolympus' => { 36 => 0x927c },
	'makernotepanasonic' => { 36 => 0x927c },
	'makernotepanasonic2' => { 36 => 0x927c },
	'makernotepentax' => { 36 => 0x927c },
	'makernotericoh' => { 36 => 0x927c },
	'makernotericohtext' => { 36 => 0x927c },
	'makernotesafety' => { 36 => 0xc635 },
	'makernotesanyo' => { 36 => 0x927c },
	'makernotesigma' => { 36 => 0x927c },
	'makernotesony' => { 36 => 0x927c },
	'makernotesonysr2' => { 36 => 0x927c },
	'makernotesonysrf' => { 36 => 0x927c },
	'makernotetype' => { 78 => 0x1 },
	'makernoteunknown' => { 36 => 0x927c },
	'makernoteversion' => { 49 => 0x0, 70 => 0x0, 78 => 0x2 },
	'managedfromdocumentid' => { 93 => 'ManagedFromDocumentID' },
	'managedfrominstanceid' => { 93 => 'ManagedFromInstanceID' },
	'managedfrommanager' => { 93 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 93 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 93 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 93 => 'ManagedFromManageUI' },
	'managedfromrenditionclass' => { 93 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 93 => 'ManagedFromRenditionParams' },
	'managedfromversionid' => { 93 => 'ManagedFromVersionID' },
	'manager' => { 93 => 'Manager' },
	'managervariant' => { 93 => 'ManagerVariant' },
	'manageto' => { 93 => 'ManageTo' },
	'manageui' => { 93 => 'ManageUI' },
	'manualfocusdistance' => { 54 => 0x85, 79 => 0x223 },
	'manualtv' => { 19 => 0x5 },
	'marked' => { 95 => 'Marked' },
	'maskedareas' => { 36 => 0xc68e },
	'masterdocumentid' => { 40 => 0xb9 },
	'maxaperture' => { 1 => 0x1a, 48 => 0x17 },
	'maxapertureatmaxfocal' => { 53 => 0xb, 67 => 0x206 },
	'maxapertureatminfocal' => { 53 => 0xa },
	'maxaperturevalue' => { 36 => 0x9205, 86 => 'MaxApertureValue' },
	'maxfocallength' => { 53 => 0x9, 67 => 0x208 },
	'maximumdensityrange' => { 42 => 0x8c },
	'maxpagesizeh' => { 96 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 96 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 96 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 36 => 0x119 },
	'mcuversion' => { 53 => 0xc },
	'measuredev' => { 29 => 0x1814 },
	'menubuttondisplayposition' => { 18 => 0xb, 20 => 0xa, 22 => 0xb },
	'menubuttonreturn' => { 23 => 0xb },
	'metadatadate' => { 91 => 'MetadataDate' },
	'meteringmode' => { 1 => 0x11, 36 => 0x9207, 44 => 0x1c, 48 => 0x7, 66 => 0x202, 74 => 0x17, 80 => 0x9, 86 => 'MeteringMode' },
	'minaperture' => { 1 => 0x1b },
	'minfocallength' => { 53 => 0x8, 67 => 0x207 },
	'minoltaaperture' => { 48 => 0xa },
	'minoltacamerasettings' => { 49 => 0x3, 70 => 0x3 },
	'minoltacamerasettingsold' => { 49 => 0x1, 70 => 0x1 },
	'minoltadate' => { 48 => 0x15 },
	'minoltaimagesize' => { 48 => 0x4, 49 => 0x103 },
	'minoltaiso' => { 48 => 0x8 },
	'minoltamodel' => { 48 => 0x25 },
	'minoltaquality' => { 48 => 0x5, 49 => [0x102,0x103], 70 => [0x102,0x103] },
	'minoltashutterspeed' => { 48 => 0x9 },
	'minoltatime' => { 48 => 0x16 },
	'minsamplevalue' => { 36 => 0x118 },
	'mirrorlockup' => { 18 => 0xc, 19 => 0xc, 20 => 0xb, 21 => 0x6, 22 => 0xc, 23 => 0x3 },
	'moddate' => { 88 => 'ModDate' },
	'model' => { 30 => 0x6, 36 => 0x110, 72 => 'Model', 90 => 'Model' },
	'modifiedcolortemp' => { 12 => 0x9 },
	'modifieddigitalgain' => { 12 => 0xb },
	'modifiedparamflag' => { 9 => 0x1 },
	'modifiedpicturestyle' => { 12 => 0xa },
	'modifiedsaturation' => { 66 => 0x504 },
	'modifiedsensorbluelevel' => { 12 => 0x5 },
	'modifiedsensorredlevel' => { 12 => 0x4 },
	'modifiedsharpness' => { 12 => 0x2 },
	'modifiedsharpnessfreq' => { 12 => 0x3 },
	'modifiedtonecurve' => { 12 => 0x1 },
	'modifiedwhitebalance' => { 12 => 0x8 },
	'modifiedwhitebalanceblue' => { 12 => 0x7 },
	'modifiedwhitebalancered' => { 12 => 0x6 },
	'modifydate' => { 36 => 0x132, 91 => 'ModifyDate' },
	'moirefilter' => { 36 => 0xfe58 },
	'monthdaycreated' => { 44 => 0x12, 46 => 0xe },
	'nefthumbnailsize' => { 54 => 0x99 },
	'newsphotoversion' => { 42 => 0x0 },
	'nickname' => { 91 => 'Nickname' },
	'nikoncaptureversion' => { 54 => 0xe09 },
	'nikonpreview' => { 54 => 0x11 },
	'noisefilter2' => { 69 => 0x1010 },
	'noisereduction' => { 8 => 0x8, 54 => 0x95, 62 => 0x753dcbc0, 66 => 0x50a, 73 => 0x2d },
	'noisereductionintensity' => { 63 => 0x9 },
	'noisereductionmethod' => { 63 => 0x11 },
	'noisereductionsharpness' => { 63 => 0xd },
	'npages' => { 96 => 'NPages' },
	'nullrecord' => { 29 => 0x0 },
	'numindexentries' => { 42 => 0x54 },
	'objectattributereference' => { 40 => 0x4 },
	'objectcycle' => { 40 => 0x4b },
	'objectdistance' => { 33 => 0x6, 34 => 0x2022 },
	'objectname' => { 40 => 0x5 },
	'objectpreviewdata' => { 40 => 0xca },
	'objectpreviewfileformat' => { 40 => 0xc8 },
	'objectpreviewfileversion' => { 40 => 0xc9 },
	'objecttypereference' => { 40 => 0x3 },
	'oecfcolumns' => { 86 => 'OECFColumns' },
	'oecfnames' => { 86 => 'OECFNames' },
	'oecfrows' => { 86 => 'OECFRows' },
	'oecfvalues' => { 86 => 'OECFValues' },
	'oldsubfiletype' => { 36 => 0xff },
	'olympusimageheight' => { 70 => 0x102f },
	'olympusimageheight2' => { 69 => 0x615 },
	'olympusimagewidth' => { 70 => 0x102e },
	'olympusimagewidth2' => { 69 => 0x614 },
	'onetouchwb' => { 70 => 0x302 },
	'opticalzoomon' => { 79 => 0x219 },
	'orientation' => { 36 => 0x112, 90 => 'Orientation' },
	'originalfilename' => { 29 => 0x816, 47 => 0x20 },
	'originalrawfiledata' => { 36 => 0xc68c },
	'originalrawfilename' => { 36 => 0xc68b },
	'originaltransmissionreference' => { 40 => 0x67 },
	'originatingprogram' => { 40 => 0x41 },
	'os' => { 85 => 'os' },
	'outputheight' => { 59 => 0xce },
	'outputheightinches' => { 59 => 0x96 },
	'outputpixels' => { 59 => 0xd6 },
	'outputresolution' => { 59 => 0xb6 },
	'outputwidth' => { 59 => 0xc6 },
	'outputwidthinches' => { 59 => 0x8e },
	'owner' => { 95 => 'Owner' },
	'ownerid' => { 40 => 0xbc },
	'ownername' => { 11 => 0x9, 29 => 0x810, 36 => 0xfde8 },
	'pagename' => { 36 => 0x11d },
	'pagenumber' => { 36 => 0x129 },
	'panoramadirection' => { 13 => 0x5 },
	'panoramaframe' => { 13 => 0x2 },
	'panoramamode' => { 44 => 0x3c },
	'pdfversion' => { 88 => 'PDFVersion' },
	'pentaximagesize' => { 74 => 0x9 },
	'pentaxmode' => { 74 => 0x1 },
	'pf0customfuncregistration' => { 25 => 0x1 },
	'pf10retainprogramshift' => { 25 => 0xb },
	'pf13drivepriority' => { 25 => 0xe },
	'pf14disablefocussearch' => { 25 => 0xf },
	'pf15disableafassistbeam' => { 25 => 0x10 },
	'pf16autofocuspointshoot' => { 25 => 0x11 },
	'pf17disableafpointsel' => { 25 => 0x12 },
	'pf18enableautoafpointsel' => { 25 => 0x13 },
	'pf19continuousshootspeed' => { 25 => 0x14 },
	'pf19shootingspeedhigh' => { 24 => 0xa },
	'pf19shootingspeedlow' => { 24 => 0x9 },
	'pf1disableshootingmodes' => { 25 => 0x2 },
	'pf1value' => { 24 => 0x1 },
	'pf20limitcontinousshots' => { 25 => 0x15 },
	'pf20maxcontinousshots' => { 24 => 0xb },
	'pf21enablequietoperation' => { 25 => 0x16 },
	'pf23felocktime' => { 24 => 0xd },
	'pf23postreleasetime' => { 24 => 0xe },
	'pf23settimerlengths' => { 25 => 0x18 },
	'pf23shutterbuttontime' => { 24 => 0xc },
	'pf24lightlcdduringbulb' => { 25 => 0x19 },
	'pf25aemode' => { 24 => 0xf },
	'pf25afmode' => { 24 => 0x12 },
	'pf25afpointsel' => { 24 => 0x13 },
	'pf25colormatrix' => { 24 => 0x17 },
	'pf25defaultclearsettings' => { 25 => 0x1a },
	'pf25drivemode' => { 24 => 0x11 },
	'pf25imagesize' => { 24 => 0x14 },
	'pf25meteringmode' => { 24 => 0x10 },
	'pf25parameters' => { 24 => 0x16 },
	'pf25wbmode' => { 24 => 0x15 },
	'pf26shortenreleaselag' => { 25 => 0x1b },
	'pf27reversedialrotation' => { 25 => 0x1c },
	'pf27value' => { 24 => 0x18 },
	'pf28noquickdialexpcomp' => { 25 => 0x1d },
	'pf29quickdialswitchoff' => { 25 => 0x1e },
	'pf2disablemeteringmodes' => { 25 => 0x3 },
	'pf2value' => { 24 => 0x2 },
	'pf30enlargementmode' => { 25 => 0x1f },
	'pf31originaldecisiondata' => { 25 => 0x20 },
	'pf3manualexposuremetering' => { 25 => 0x4 },
	'pf3value' => { 24 => 0x3 },
	'pf4exposuretimelimits' => { 25 => 0x5 },
	'pf4exposuretimemax' => { 24 => 0x5 },
	'pf4exposuretimemin' => { 24 => 0x4 },
	'pf5aperturelimits' => { 25 => 0x6 },
	'pf5aperturemax' => { 24 => 0x7 },
	'pf5aperturemin' => { 24 => 0x6 },
	'pf6presetshootingmodes' => { 25 => 0x7 },
	'pf7bracketcontinuousshoot' => { 25 => 0x8 },
	'pf8bracketshots' => { 24 => 0x8 },
	'pf8setbracketshots' => { 25 => 0x9 },
	'pf9changebracketsequence' => { 25 => 0xa },
	'photoeffect' => { 1 => 0x28 },
	'photoeffects' => { 62 => 0xab5eca5e },
	'photoeffectsblue' => { 64 => 0x8 },
	'photoeffectsgreen' => { 64 => 0x6 },
	'photoeffectsred' => { 64 => 0x4 },
	'photoeffectstype' => { 64 => 0x0 },
	'photometricinterpretation' => { 36 => 0x106, 90 => 'PhotometricInterpretation' },
	'photoshopquality' => { 75 => 0x0 },
	'pictinfo' => { 79 => 0x208 },
	'picturemode' => { 38 => 0x1031, 74 => 0xb },
	'picturenumber' => { 0 => 0xd0 },
	'picturestyle' => { 0 => 0x6c, 16 => 0xa },
	'planarconfiguration' => { 36 => 0x11c, 90 => 'PlanarConfiguration' },
	'pngwarning' => { 72 => 'Warning' },
	'precaptureframes' => { 70 => 0x300 },
	'predictor' => { 36 => 0x13d },
	'previewfocalplanexresolution' => { 15 => 0x6 },
	'previewfocalplaneyresolution' => { 15 => 0x8 },
	'previewimage' => { 34 => 0x2000, 35 => 'PreviewImage', 36 => 0x927c, 49 => 0x81 },
	'previewimagedata' => { 74 => 0x2000 },
	'previewimageheight' => { 15 => 0x4 },
	'previewimagelength' => { 15 => 0x2, 34 => 0x3, 36 => [0x117,0x202], 49 => 0x89, 55 => 0x202, 66 => 0x102, 70 => 0x1037, 74 => 0x3 },
	'previewimagesize' => { 34 => 0x2, 74 => 0x2 },
	'previewimagestart' => { 15 => 0x5, 34 => 0x4, 36 => [0x111,0x201], 49 => 0x88, 55 => 0x201, 66 => 0x101, 70 => 0x1036, 74 => 0x4 },
	'previewimagevalid' => { 66 => 0x100, 70 => 0x1035 },
	'previewimagewidth' => { 15 => 0x3 },
	'previewquality' => { 15 => 0x1 },
	'primarychromaticities' => { 36 => 0x13f, 90 => 'PrimaryChromaticities' },
	'printim' => { 33 => 0xe00, 36 => 0xc4a5 },
	'producer' => { 88 => 'Producer' },
	'productid' => { 41 => 0x32 },
	'programversion' => { 40 => 0x46 },
	'province-state' => { 40 => 0x5f },
	'publisher' => { 84 => 'publisher' },
	'quality' => { 1 => 0x3, 33 => 0x2, 34 => 0x3002, 38 => 0x1000, 44 => 0x9, 54 => 0x4, 56 => 0x3, 70 => 0x201, 74 => 0x8, 80 => 0x16 },
	'qualitymode' => { 34 => 0x8 },
	'quantizationmethod' => { 42 => 0x78 },
	'quickshot' => { 79 => 0x213 },
	'rasterizedcaption' => { 40 => 0x7d },
	'rating' => { 91 => 'Rating' },
	'rawandjpgrecording' => { 18 => 0x8 },
	'rawdatauniqueid' => { 36 => 0xc65d },
	'rawdevcolorspace' => { 71 => 0x108 },
	'rawdevcontrastvalue' => { 71 => 0x106 },
	'rawdeveditstatus' => { 71 => 0x10b },
	'rawdevelopment' => { 70 => 0x2030 },
	'rawdevengine' => { 71 => 0x109 },
	'rawdevexposurebiasvalue' => { 71 => 0x100 },
	'rawdevgraypoint' => { 71 => 0x103 },
	'rawdevmemorycoloremphasis' => { 71 => 0x105 },
	'rawdevnoisereduction' => { 71 => 0x10a },
	'rawdevsaturationemphasis' => { 71 => 0x104 },
	'rawdevsettings' => { 71 => 0x10c },
	'rawdevsharpnessvalue' => { 71 => 0x107 },
	'rawdevversion' => { 71 => 0x0 },
	'rawdevwbfineadjustment' => { 71 => 0x102 },
	'rawdevwhitebalancevalue' => { 71 => 0x101 },
	'rawfile' => { 36 => 0xfe4c },
	'rawfilename' => { 83 => 'RawFileName' },
	'rawimagesize' => { 74 => 0x39 },
	'rawjpgheight' => { 31 => 0x4 },
	'rawjpginfo' => { 29 => 0x10b5 },
	'rawjpgquality' => { 8 => 0x6, 31 => 0x1 },
	'rawjpgsize' => { 8 => 0x7, 31 => 0x2 },
	'rawjpgwidth' => { 31 => 0x3 },
	'recordid' => { 29 => 0x1804 },
	'recordingmode' => { 33 => 0x1 },
	'recordmode' => { 34 => 0x3000 },
	'recordshutterrelease' => { 79 => 0x217 },
	'redbalance' => { 70 => 0x1017, 74 => 0x1c },
	'redbluebias' => { 69 => 0x100 },
	'redhue' => { 83 => 'RedHue' },
	'redsaturation' => { 83 => 'RedSaturation' },
	'referenceblackwhite' => { 36 => 0x214, 90 => 'ReferenceBlackWhite' },
	'referencedate' => { 40 => 0x2f },
	'referencenumber' => { 40 => 0x32 },
	'referenceservice' => { 40 => 0x2d },
	'relatedimagelength' => { 36 => 0x1002 },
	'relatedimagewidth' => { 36 => 0x1001 },
	'relatedsoundfile' => { 36 => 0xa004, 86 => 'RelatedSoundFile' },
	'relation' => { 84 => 'relation' },
	'releasedate' => { 40 => 0x1e },
	'releasesetting' => { 29 => 0x1016 },
	'releasetime' => { 40 => 0x23 },
	'renditionclass' => { 93 => 'RenditionClass' },
	'renditionofdocumentid' => { 93 => 'RenditionOfDocumentID' },
	'renditionofinstanceid' => { 93 => 'RenditionOfInstanceID' },
	'renditionofmanager' => { 93 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 93 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 93 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 93 => 'RenditionOfManageUI' },
	'renditionofrenditionclass' => { 93 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 93 => 'RenditionOfRenditionParams' },
	'renditionofversionid' => { 93 => 'RenditionOfVersionID' },
	'renditionparams' => { 93 => 'RenditionParams' },
	'resaved' => { 79 => 0x21e },
	'resolutionmode' => { 80 => 0x4 },
	'resolutionunit' => { 36 => 0x128, 43 => 0x2, 90 => 'ResolutionUnit' },
	'reuseallowed' => { 94 => 'ReuseAllowed' },
	'revision' => { 85 => 'revision' },
	'ricohrr1subdir' => { 78 => 0x2001 },
	'ricohsubdir' => { 78 => 0x2001 },
	'rights' => { 84 => 'rights' },
	'romoperationmode' => { 29 => 0x80d },
	'rotation' => { 62 => 0x76a43207 },
	'rowsperstrip' => { 36 => 0x116 },
	'safetyshiftinavortv' => { 18 => 0x10, 19 => 0x10, 20 => 0xf, 22 => 0x10 },
	'samplesperpixel' => { 36 => 0x115, 90 => 'SamplesPerPixel' },
	'samplestructure' => { 42 => 0x5a },
	'sanyoquality' => { 79 => 0x201 },
	'sanyothumbnail' => { 79 => 0x100 },
	'saturation' => { 1 => 0xe, 6 => 0x1, 33 => 0xd, 34 => 0x1f, 36 => [0xa409,0xfe55], 38 => 0x1003, 48 => 0x1f, 54 => [0x94,0xaa], 74 => 0x1f, 80 => 0x10, 83 => 'Saturation', 86 => 'Saturation' },
	'saturationfaithful' => { 0 => 0xfe },
	'saturationlandscape' => { 0 => 0xfc },
	'saturationneutral' => { 0 => 0xfd },
	'saturationportrait' => { 0 => 0xfb },
	'saturationstandard' => { 0 => 0xfa },
	'saturationuserdef1' => { 0 => 0x100 },
	'saturationuserdef2' => { 0 => 0x101 },
	'saturationuserdef3' => { 0 => 0x102 },
	'saveid' => { 93 => 'SaveID' },
	'scaledresolution' => { 59 => 0x9e },
	'scanningdirection' => { 42 => 0x64 },
	'scene' => { 87 => 'Scene' },
	'scenecapturetype' => { 36 => 0xa406, 86 => 'SceneCaptureType' },
	'scenemode' => { 54 => 0x8f, 66 => 0x509 },
	'sceneselect' => { 79 => 0x21f },
	'scenetype' => { 36 => 0xa301, 86 => 'SceneType' },
	'self-timer' => { 1 => 0x2 },
	'self-timer2' => { 17 => 0x1d },
	'selftimer' => { 34 => 0x3001, 79 => 0x214 },
	'selftimermode' => { 36 => 0x882b },
	'selftimertime' => { 29 => 0x1806 },
	'sensingmethod' => { 36 => 0xa217, 86 => 'SensingMethod' },
	'sensorbluelevel' => { 16 => 0x5 },
	'sensorcleaning' => { 23 => 0xd },
	'sensorpixelsize' => { 54 => 0x9a },
	'sensorredlevel' => { 16 => 0x4 },
	'sequence' => { 66 => 0x600 },
	'sequencenumber' => { 17 => 0x9, 44 => 0x1d },
	'sequenceshotinterval' => { 79 => 0x224 },
	'sequentialshot' => { 79 => 0x20e },
	'serialnumber' => { 11 => 0xc, 29 => 0x180b, 36 => 0xfde9, 54 => 0xa0, 67 => 0x101, 70 => [0x404,0x101a], 73 => 0x25, 80 => 0x2, 81 => 'SerialNumber' },
	'serialnumberformat' => { 11 => 0x15, 29 => 0x183b },
	'serviceidentifier' => { 41 => 0x1e },
	'setbuttoncrosskeysfunc' => { 21 => 0x0 },
	'setbuttonfunction' => { 18 => 0x1, 23 => 0xc },
	'setfunctionwhenshooting' => { 20 => 0x0, 22 => 0x1 },
	'shadingcompensation' => { 66 => 0x50c },
	'shadingcompensation2' => { 69 => 0x1012 },
	'shadow' => { 80 => 0xe },
	'shadows' => { 36 => 0xfe52, 83 => 'Shadows' },
	'shadowscale' => { 36 => 0xc633 },
	'shadowtint' => { 83 => 'ShadowTint' },
	'sharpness' => { 1 => 0xf, 16 => 0x2, 33 => 0xb, 34 => 0x21, 36 => [0xa40a,0xfe56], 38 => 0x1001, 44 => 0x6b, 46 => 0x37, 48 => 0x21, 54 => 0x6, 74 => 0x21, 80 => 0x11, 83 => 'Sharpness', 86 => 'Sharpness' },
	'sharpnessfactor' => { 70 => 0x102a },
	'sharpnessfaithful' => { 0 => 0xf5 },
	'sharpnessfrequency' => { 16 => 0x3 },
	'sharpnesslandscape' => { 0 => 0xf3 },
	'sharpnessmonochrome' => { 0 => 0xf6 },
	'sharpnessneutral' => { 0 => 0xf4 },
	'sharpnessportrait' => { 0 => 0xf2 },
	'sharpnesssetting' => { 66 => 0x506 },
	'sharpnessstandard' => { 0 => 0xf1 },
	'sharpnessuserdef1' => { 0 => 0xf7 },
	'sharpnessuserdef2' => { 0 => 0xf8 },
	'sharpnessuserdef3' => { 0 => 0xf9 },
	'shootingmode' => { 54 => 0x89, 73 => 0x1f },
	'shortdescription' => { 85 => 'shortdescription' },
	'shortdocumentid' => { 40 => 0xba },
	'shortfocal' => { 0 => 0x12, 1 => 0x18 },
	'shortownername' => { 0 => 0xac },
	'shutter-aelock' => { 18 => 0x4, 20 => 0x3, 21 => 0x3, 22 => 0x4, 23 => 0x2 },
	'shutteraelbutton' => { 19 => 0x4 },
	'shuttercount' => { 8 => 0x1 },
	'shuttercurtainsync' => { 18 => 0xf, 19 => 0xf, 20 => 0xe, 21 => 0x8, 22 => 0xf, 23 => 0x8 },
	'shuttermode' => { 44 => 0x1b },
	'shutterreleasemethod' => { 29 => 0x1010 },
	'shutterreleasenocfcard' => { 18 => 0x2, 19 => 0x2, 23 => 0xf },
	'shutterreleasetiming' => { 29 => 0x1011 },
	'shutterspeedvalue' => { 36 => 0x9201, 86 => 'ShutterSpeedValue' },
	'similarityindex' => { 40 => 0xe4 },
	'slowshutter' => { 17 => 0x8 },
	'slowsync' => { 38 => 0x1030 },
	'smoothingparameter1' => { 69 => 0x300 },
	'smoothingparameter2' => { 69 => 0x310 },
	'smoothingthreshold2' => { 69 => 0x610 },
	'smoothingthresholds' => { 69 => 0x600 },
	'smoothness' => { 36 => 0xfe57 },
	'software' => { 36 => 0x131, 72 => 'Software', 80 => 0x18, 90 => 'Software' },
	'softwareversion' => { 79 => 0x207 },
	'source' => { 40 => 0x73, 72 => 'Source', 84 => 'source', 89 => 'Source' },
	'sourceresolution' => { 59 => 0xae },
	'spatialfrequencyresponsecolumns' => { 86 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 86 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 86 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 86 => 'SpatialFrequencyResponseValues' },
	'specialinstructions' => { 40 => 0x28 },
	'specialmode' => { 70 => 0x200, 79 => 0x200 },
	'spectralsensitivity' => { 36 => 0x8824, 86 => 'SpectralSensitivity' },
	'spotfocuspointx' => { 48 => 0x2d },
	'spotfocuspointy' => { 48 => 0x2e },
	'spotmode' => { 73 => 0xf },
	'state' => { 89 => 'State' },
	'sub-location' => { 40 => 0x5c },
	'subfiletype' => { 36 => 0xfe },
	'subject' => { 84 => 'subject' },
	'subjectarea' => { 86 => 'SubjectArea' },
	'subjectcode' => { 87 => 'SubjectCode' },
	'subjectdistance' => { 36 => 0x9206, 44 => 0x3e, 86 => 'SubjectDistance' },
	'subjectdistancerange' => { 36 => 0xa40c, 86 => 'SubjectDistanceRange' },
	'subjectlocation' => { 36 => [0x9214,0xa214], 86 => 'SubjectLocation' },
	'subjectprogram' => { 48 => 0x22 },
	'subjectreference' => { 40 => 0xc },
	'subsectime' => { 36 => 0x9290 },
	'subsectimedigitized' => { 36 => 0x9292 },
	'subsectimeoriginal' => { 36 => 0x9291 },
	'superimposeddisplay' => { 18 => 0xa, 20 => 0x9, 22 => 0xa, 23 => 0xe },
	'supplementalcategories' => { 40 => 0x14, 89 => 'SupplementalCategories' },
	'supplementaltype' => { 42 => 0x37 },
	'switchtoregisteredafpoint' => { 19 => 0x12 },
	'targetaperture' => { 17 => 0x4 },
	'targetcompressionratio' => { 28 => 0x1 },
	'targetdistancesetting' => { 29 => 0x1807 },
	'targetexposuretime' => { 17 => 0x5 },
	'targetimagetype' => { 29 => 0x100a },
	'textinfo' => { 70 => 0x208 },
	'thresholding' => { 36 => 0x107 },
	'thumbnailfilename' => { 29 => 0x817 },
	'thumbnailimage' => { 29 => 0x2008, 35 => 'ThumbnailImage', 70 => 0x100 },
	'thumbnaillength' => { 36 => 0x202 },
	'thumbnailoffset' => { 36 => 0x201 },
	'thumbnailsformat' => { 91 => 'ThumbnailsFormat' },
	'thumbnailsheight' => { 91 => 'ThumbnailsHeight' },
	'thumbnailsimage' => { 91 => 'ThumbnailsImage' },
	'thumbnailswidth' => { 91 => 'ThumbnailsWidth' },
	'tilelength' => { 36 => 0x143 },
	'tilewidth' => { 36 => 0x142 },
	'time' => { 74 => 0x7 },
	'timecreated' => { 40 => 0x3c, 44 => 0x14, 46 => 0x10 },
	'timesent' => { 41 => 0x50 },
	'timestamp' => { 0 => 0x11c, 72 => 'TimeStamp' },
	'timezone' => { 34 => 0x3006 },
	'timezonecode' => { 32 => 0x1 },
	'timezoneinfo' => { 32 => 0x2 },
	'timezoneoffset' => { 36 => 0x882a },
	'title' => { 72 => 'Title', 84 => 'title' },
	'tonecomp' => { 54 => 0x81 },
	'tonecurve' => { 16 => 0x1, 74 => 0x402 },
	'tonecurves' => { 74 => 0x403 },
	'toningeffect' => { 8 => 0xf },
	'toningeffectmonochrome' => { 0 => 0x108 },
	'totalzoom' => { 44 => 0x62 },
	'transferfunction' => { 90 => 'TransferFunction' },
	'transmissionreference' => { 89 => 'TransmissionReference' },
	'tvvalue' => { 26 => 0x1 },
	'type' => { 84 => 'type' },
	'uniquecameramodel' => { 36 => 0xc614 },
	'uniquedocumentid' => { 40 => 0xbb },
	'uniqueobjectname' => { 41 => 0x64 },
	'unsharp1color' => { 65 => 0x13 },
	'unsharp1halowidth' => { 65 => 0x19 },
	'unsharp1intensity' => { 65 => 0x17 },
	'unsharp1threshold' => { 65 => 0x1b },
	'unsharp2color' => { 65 => 0x2e },
	'unsharp2halowidth' => { 65 => 0x34 },
	'unsharp2intensity' => { 65 => 0x32 },
	'unsharp2threshold' => { 65 => 0x36 },
	'unsharp3color' => { 65 => 0x49 },
	'unsharp3halowidth' => { 65 => 0x4f },
	'unsharp3intensity' => { 65 => 0x4d },
	'unsharp3threshold' => { 65 => 0x51 },
	'unsharp4color' => { 65 => 0x64 },
	'unsharp4halowidth' => { 65 => 0x6a },
	'unsharp4intensity' => { 65 => 0x68 },
	'unsharp4threshold' => { 65 => 0x6c },
	'unsharpcount' => { 65 => 0x0 },
	'unsharpmask' => { 62 => 0x76a43200 },
	'urgency' => { 40 => 0xa, 89 => 'Urgency' },
	'url' => { 72 => 'URL', 76 => 0x40b },
	'usageterms' => { 95 => 'UsageTerms' },
	'usercomment' => { 29 => 0x805, 36 => 0x9286, 86 => 'UserComment' },
	'userdef1picturestyle' => { 0 => 0x10c },
	'userdef2picturestyle' => { 0 => 0x10e },
	'userdef3picturestyle' => { 0 => 0x110 },
	'usmlenselectronicmf' => { 19 => 0x7 },
	'validbits' => { 69 => 0x611, 70 => 0x102c },
	'variousmodes' => { 44 => 0x26 },
	'variousmodes2' => { 44 => 0x3a },
	'variprogram' => { 54 => 0xab },
	'version' => { 38 => 0x0, 83 => 'Version' },
	'versionid' => { 93 => 'VersionID' },
	'versionscomments' => { 93 => 'VersionsComments' },
	'versionseventaction' => { 93 => 'VersionsEventAction' },
	'versionseventinstanceid' => { 93 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 93 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 93 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 93 => 'VersionsEventWhen' },
	'versionsmodifier' => { 93 => 'VersionsModifier' },
	'versionsmodifydate' => { 93 => 'VersionsModifyDate' },
	'versionsversion' => { 93 => 'VersionsVersion' },
	'vignetteamount' => { 83 => 'VignetteAmount' },
	'vignettecontrol' => { 62 => 0x76a43205 },
	'vignettecontrolintensity' => { 62 => 0xac6bd5c0 },
	'vignettemidpoint' => { 83 => 'VignetteMidpoint' },
	'voicememo' => { 79 => 0x216 },
	'wb_rbgglevels' => { 50 => 0x0 },
	'wb_rgbglevels' => { 52 => 0x0 },
	'wb_rggblevels' => { 51 => 0x0 },
	'wb_rggblevelsasshot' => { 3 => 0x19, 4 => 0x18, 5 => 0x3f },
	'wb_rggblevelsauto' => { 2 => 0x0, 3 => 0x1e, 4 => 0x22, 5 => 0x44 },
	'wb_rggblevelscloudy' => { 2 => 0xc, 3 => 0x2d, 4 => 0x31, 5 => 0x58 },
	'wb_rggblevelscustom' => { 2 => 0x1c, 5 => 0x80 },
	'wb_rggblevelscustom1' => { 3 => 0x41 },
	'wb_rggblevelscustom2' => { 3 => 0x46 },
	'wb_rggblevelsdaylight' => { 2 => 0x4, 3 => 0x23, 4 => 0x27, 5 => 0x4e },
	'wb_rggblevelsflash' => { 2 => 0x18, 3 => 0x3c, 4 => 0x45, 5 => 0x6c },
	'wb_rggblevelsfluorescent' => { 2 => 0x14, 3 => 0x37, 4 => 0x3b, 5 => 0x62 },
	'wb_rggblevelskelvin' => { 2 => 0x20, 4 => 0x40, 5 => 0x67 },
	'wb_rggblevelsmeasured' => { 5 => 0x49 },
	'wb_rggblevelspc1' => { 4 => 0x90, 5 => 0x71 },
	'wb_rggblevelspc2' => { 4 => 0x95, 5 => 0x76 },
	'wb_rggblevelspc3' => { 4 => 0x9a, 5 => 0x7b },
	'wb_rggblevelsshade' => { 2 => 0x8, 3 => 0x28, 4 => 0x2c, 5 => 0x53 },
	'wb_rggblevelstungsten' => { 2 => 0x10, 3 => 0x32, 4 => 0x36, 5 => 0x5d },
	'wb_rggblevelsunknown' => { 4 => 0x1d },
	'wb_rggblevelsunknown10' => { 4 => 0x72 },
	'wb_rggblevelsunknown11' => { 4 => 0x77 },
	'wb_rggblevelsunknown12' => { 4 => 0x7c },
	'wb_rggblevelsunknown13' => { 4 => 0x81 },
	'wb_rggblevelsunknown14' => { 4 => 0x86 },
	'wb_rggblevelsunknown15' => { 4 => 0x8b },
	'wb_rggblevelsunknown16' => { 4 => 0x9f },
	'wb_rggblevelsunknown2' => { 4 => 0x4a },
	'wb_rggblevelsunknown3' => { 4 => 0x4f },
	'wb_rggblevelsunknown4' => { 4 => 0x54 },
	'wb_rggblevelsunknown5' => { 4 => 0x59 },
	'wb_rggblevelsunknown6' => { 4 => 0x5e },
	'wb_rggblevelsunknown7' => { 4 => 0x63 },
	'wb_rggblevelsunknown8' => { 4 => 0x68 },
	'wb_rggblevelsunknown9' => { 4 => 0x6d },
	'wbbracketmode' => { 8 => 0x9 },
	'wbbracketvalueab' => { 8 => 0xc },
	'wbbracketvaluegm' => { 8 => 0xd },
	'wbshiftab' => { 16 => 0xc },
	'wbshiftgm' => { 16 => 0xd },
	'webstatement' => { 95 => 'WebStatement' },
	'whitebalance' => { 16 => 0x8, 17 => 0x7, 33 => 0x7, 34 => [0x19,0x2012], 36 => [0xa403,0xfe4e], 38 => 0x1002, 44 => 0x40, 48 => 0x3, 54 => 0x5, 56 => 0x7, 73 => 0x3, 74 => 0x19, 80 => 0x7, 83 => 'WhiteBalance', 86 => 'WhiteBalance' },
	'whitebalanceadj' => { 62 => 0x76a43204 },
	'whitebalancebias' => { 34 => 0x2011, 73 => 0x23 },
	'whitebalanceblue' => { 16 => 0x7 },
	'whitebalancebracket' => { 66 => 0x502 },
	'whitebalancefinetune' => { 54 => 0xb },
	'whitebalancemode' => { 74 => 0x1a },
	'whitebalancered' => { 16 => 0x6 },
	'whitebalancetemperature' => { 66 => 0x501 },
	'whitepoint' => { 36 => 0x13e, 74 => 0x201, 90 => 'WhitePoint' },
	'widefocuszone' => { 48 => 0x2f },
	'widerange' => { 79 => 0x20f },
	'worldtimelocation' => { 74 => 0x22 },
	'writer-editor' => { 40 => 0x7a },
	'x3filllight' => { 80 => 0x12 },
	'xmp' => { 37 => 'XMP' },
	'xmp_profile' => { 72 => 'Raw profile type xmp' },
	'xpauthor' => { 36 => 0x9c9d },
	'xpcomment' => { 36 => 0x9c9c },
	'xpkeywords' => { 36 => 0x9c9e },
	'xposition' => { 36 => 0x11e },
	'xpsubject' => { 36 => 0x9c9f },
	'xptitle' => { 36 => 0x9c9b },
	'xresolution' => { 36 => 0x11a, 43 => 0x3, 77 => 0x0, 90 => 'XResolution' },
	'ycbcrcoefficients' => { 36 => 0x211, 90 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 36 => 0x213 },
	'ycbcrsubsampling' => { 36 => 0x212, 90 => 'YCbCrSubSampling' },
	'yearcreated' => { 44 => 0x10, 46 => 0xc },
	'yposition' => { 36 => 0x11f },
	'yresolution' => { 36 => 0x11b, 43 => 0x5, 77 => 0x4, 90 => 'YResolution' },
	'zoomposition' => { 68 => 0x300 },
	'zoomsourcewidth' => { 1 => 0x24 },
	'zoomtargetwidth' => { 1 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'adobephotoshop' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'afaperture' => 1,
	'afcp_iptc' => 1,
	'afpointsused1d' => 1,
	'album' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphasample' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'applicationnotes' => 1,
	'archivallocation' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'asshoticcprofile' => 1,
	'asshotneutral' => 1,
	'asshotpreprofilematrix' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiocodecdescription' => 1,
	'audiocodecname' => 1,
	'audiofileurl' => 1,
	'audiosourceurl' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbytespersec' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitdepth' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'calibrationdatetime' => 1,
	'camerabacktype' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofile' => 1,
	'cameraprofileversion' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canoncamerainfo' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canoncustomfunctions10d' => 1,
	'canoncustomfunctions1d' => 1,
	'canoncustomfunctions20d' => 1,
	'canoncustomfunctions350d' => 1,
	'canoncustomfunctions5d' => 1,
	'canoncustomfunctionsd30' => 1,
	'canoncustomfunctionsd60' => 1,
	'canoncustomfunctionsunknown' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonpanorama' => 1,
	'canonpictureinfo' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'codec' => 1,
	'codeclist' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colorinfod30' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colormatrix2' => 1,
	'colormodesetting' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortype' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composer' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressedtext' => 1,
	'compressiontype' => 1,
	'compressor' => 1,
	'compressorid' => 1,
	'concreteflag' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'consecutivebadfaxlines' => 1,
	'containerformat' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contiguouscodestream' => 1,
	'copyrighturl' => 1,
	'cpuversions' => 1,
	'crdinfo' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crs' => 1,
	'currentbitrate' => 1,
	'currenticcprofile' => 1,
	'currentpreprofilematrix' => 1,
	'currenttime' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datapackets' => 1,
	'datareference' => 1,
	'datatype' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dealeridnumber' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'directory' => 1,
	'discardobjects' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'dngprivatedata' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'duration' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectivemaxaperture' => 1,
	'effectsvisible' => 1,
	'encodedby' => 1,
	'encodersettings' => 1,
	'encoding' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'engineer' => 1,
	'epsoptions' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'exif' => 1,
	'exifinfo' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposureinfo' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extrasamples' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileid' => 1,
	'filename' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'filesize' => 1,
	'filetype' => 1,
	'fillmethod' => 1,
	'filmcategory' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmsize' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashinfo' => 1,
	'flashon' => 1,
	'focallength35efl' => 1,
	'focuspos' => 1,
	'for' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'genre' => 1,
	'genreid' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'gpsdatetime' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'highlightendpoints' => 1,
	'hyperfocaldistance' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'imagebounds' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imagehistory' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagenumber' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesize' => 1,
	'imagesourcedata' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'index' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputprofile' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner ' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'jfifversion' => 1,
	'jngheader' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'kids' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'languagelist' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensaperturerange' => 1,
	'lensdataunknown' => 1,
	'lensfocalrange' => 1,
	'lensspec' => 1,
	'lightness' => 1,
	'lights' => 1,
	'linearizationtable' => 1,
	'list' => 1,
	'localdeltatype' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loop' => 1,
	'loopstyle' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxbitrate' => 1,
	'maximumobjectsize' => 1,
	'maxpacketsize' => 1,
	'maxsubfilesize' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaindex' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'metadata' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'mimetype' => 1,
	'minf' => 1,
	'minoltacamerasettings2' => 1,
	'minpacketsize' => 1,
	'mngheader' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'multiquality' => 1,
	'musiciancredits' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'namelength' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nefcurve1' => 1,
	'nefcurve2' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numsampleframes' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'opacity' => 1,
	'opiproxy' => 1,
	'opticalzoom' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originallyricist' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'padding' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pages' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pentaxtags' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'photoeffectsdata' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'picture' => 1,
	'pieceinfo' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'planes' => 1,
	'play counter' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'private' => 1,
	'proccessinginfo' => 1,
	'producednotice' => 1,
	'product' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecopyright' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'properties' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'quickmaskinfo' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdatarotation' => 1,
	'rawimagemode' => 1,
	'readerrequirements' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'redadjust' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'relatedimagefile' => 1,
	'relatedimagefileformat' => 1,
	'renderingintent' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolution' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'rgb_profile' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'sampleformat' => 1,
	'samplerate' => 1,
	'samplesize' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalefactor35efl' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'scriptcommand' => 1,
	'securityclassification' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorheight' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortemperature' => 1,
	'sensortopborder' => 1,
	'sensorwidth' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stbl' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stonits' => 1,
	'stream' => 1,
	'streambitrateprops' => 1,
	'streamnumber' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd_offset' => 1,
	'subscriptioncontentid' => 1,
	'subsecdatetimeoriginal' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'technician' => 1,
	'technology' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'text' => 1,
	'textualdata' => 1,
	'thumbnailresource' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlesortorder' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'track' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'trackmodifydate' => 1,
	'tracknumber' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapped' => 1,
	'ucrbg' => 1,
	'unicodealphanames' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'uuid-geojp2' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'vbrpeak' => 1,
	'vendorid' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecname' => 1,
	'videoframerate' => 1,
	'videoheight' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grbglevels' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitelevel' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'wide' => 1,
	'windowlocation' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'writer' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmpbj' => 1,
	'xmpmm' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        &$writeProc();
                        @infoList = GetTagInfoList($table,$tagID);
                    }
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2006, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
