CREATE TABLE func_import_new_work(
    topic_uuid VARCHAR(40) NOT NULL,
    offset INTEGER NOT NULL,
    start INTEGER NOT NULL,
    stop INTEGER NOT NULL,
    start_comment TEXT,
    stop_comment TEXT
);


CREATE TRIGGER
    func_import_new_work_bi_1
BEFORE INSERT ON
    func_import_new_work
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.topic_uuid,
        NEW.offset,
        NEW.start,
        NEW.stop,
        NEW.start_comment,
        NEW.stop_comment
    );

    INSERT INTO
        func_new_work(
            change_id,
            topic_id,
            offset,
            start,
            stop,
            start_comment,
            stop_comment
        )
    SELECT
        currval('changes'),
        t.id,
        NEW.offset,
        NEW.start,
        NEW.stop,
        NEW.start_comment,
        NEW.stop_comment
    FROM
        topics t
    WHERE
        t.uuid = NEW.topic_uuid
    ;

    SELECT RAISE(IGNORE);
END;
