CREATE TABLE hubs (
    id INTEGER NOT NULL PRIMARY KEY,
    location VARCHAR NOT NULL UNIQUE,
    hash VARCHAR, -- TODO remove
    num_changes INTEGER, -- TODO remove
    FOREIGN KEY (id) REFERENCES projects(id) ON DELETE CASCADE
);


CREATE TRIGGER
    hubs_bd_1
BEFORE DELETE ON
    hubs
FOR EACH ROW
BEGIN
    SELECT debug( 
        OLD.id
    );

    /*
        The following is necessary, because although FK relationships
        do result in the remove of rows from hubs_tomerge, the deletion
        of rows from hub_deltas just inserts more rows.
    */

    DELETE FROM
        hub_deltas
    WHERE
        hub_id = OLD.id
    ;

END;


CREATE TRIGGER
    hubs_ad_1
AFTER DELETE ON
    hubs
FOR EACH ROW
BEGIN
    SELECT debug(
        OLD.id
    );

    DELETE FROM
        topics
    WHERE
        id = OLD.id
    ;

END;
