CREATE TABLE projects_tomerge(
    project_id INTEGER NOT NULL UNIQUE,
    title INTEGER DEFAULT 0,
    project_status_id INTEGER DEFAULT 0,
    resolve INTEGER,
    FOREIGN KEY(project_id) REFERENCES projects(id) ON DELETE CASCADE
);


CREATE TRIGGER
    projects_tomerge_bu_2
BEFORE UPDATE OF
    resolve
ON
    projects_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1 AND
    OLD.title != 0
BEGIN

    SELECT debug(
        OLD.project_id
    );

    UPDATE
        projects
    SET
        title = (
            SELECT
                project_deltas.title
            FROM
                project_deltas
            INNER JOIN
                changes
            ON
                changes.id = project_deltas.change_id
            WHERE
                project_deltas.project_id = OLD.project_id AND
                project_deltas.title IS NOT NULL
            ORDER BY
                changes.mtime DESC,
                changes.uuid
            LIMIT
                1
        )
    WHERE
        id = OLD.project_id
    ;

END;

CREATE TRIGGER
    projects_tomerge_bu_1
BEFORE UPDATE OF
    resolve
ON
    projects_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1 AND
    OLD.project_status_id != 0
BEGIN

    SELECT debug(
        OLD.project_id
    );

    UPDATE
        projects
    SET
        project_status_id = (
            SELECT
                project_deltas.project_status_id
            FROM
                project_deltas
            INNER JOIN
                changes
            ON
                changes.id = project_deltas.change_id
            WHERE
                project_deltas.project_id = OLD.project_id AND
                project_deltas.project_status_id IS NOT NULL
            ORDER BY
                changes.mtime DESC,
                changes.uuid
            LIMIT
                1
        )
    WHERE
        id = OLD.project_id
    ;

END;


CREATE TRIGGER
    projects_tomerge_au_1
AFTER UPDATE OF
    resolve
ON
    projects_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1
BEGIN

    SELECT debug(
        OLD.project_id
    );

    DELETE FROM
        projects_tomerge
    WHERE
        project_id = OLD.project_id
    ;

END;
