CREATE TABLE topics_tomerge(
    topic_id INTEGER NOT NULL UNIQUE,
    parent_id INTEGER DEFAULT 0,
    name INTEGER DEFAULT 0,
    resolve INTEGER,
    FOREIGN KEY(topic_id) REFERENCES topics(id) ON DELETE CASCADE
);


CREATE TRIGGER
    topics_tomerge_bu_2
BEFORE UPDATE OF
    resolve
ON
    topics_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1 AND
    OLD.parent_id != 0
BEGIN

    SELECT debug(
        OLD.topic_id
    );

    UPDATE
        topics
    SET
        parent_id = (
            SELECT
                td.parent_id
            FROM
                topic_deltas td
            INNER JOIN
                changes c
            ON
                c.id = td.change_id
            WHERE
                td.topic_id = OLD.topic_id AND
                td.parent_id IS NOT NULL
            ORDER BY
                c.mtime DESC,
                c.uuid
            LIMIT
                1
        )
    WHERE
        id = OLD.topic_id
    ;

END;


CREATE TRIGGER
    topics_tomerge_bu_1
BEFORE UPDATE OF
    resolve
ON
    topics_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1 AND
    OLD.name != 0
BEGIN

    SELECT debug(
        OLD.topic_id
    );

    UPDATE
        topics
    SET
        name = (
            SELECT
                td.name
            FROM
                topic_deltas td
            INNER JOIN
                changes c
            ON
                c.id = td.change_id
            WHERE
                td.topic_id = OLD.topic_id AND
                td.name IS NOT NULL
            ORDER BY
                c.mtime DESC,
                c.uuid
            LIMIT
                1
        )
    WHERE
        id = OLD.topic_id
    ;

END;


CREATE TRIGGER
    topics_tomerge_au_1
AFTER UPDATE OF
    resolve
ON
    topics_tomerge
FOR EACH ROW WHEN
    NEW.resolve = 1
BEGIN

    SELECT debug(
        OLD.topic_id
    );

    UPDATE
        topics
    SET
        mtime = (
            SELECT
                c.mtime
            FROM
                topic_deltas td
            INNER JOIN
                changes c
            ON
                c.id = td.change_id
            WHERE
                td.topic_id = OLD.topic_id
            ORDER BY
                c.mtime DESC,
                c.uuid
            LIMIT
                1
        )
    WHERE
        id = OLD.topic_id
    ;

    DELETE FROM
        topics_tomerge
    WHERE
        topic_id = OLD.topic_id
    ;

END;
