package Spp::AtomToValue;
=head1 NAME

Spp::AtomToValue - The great new Spp::AtomToValue!

=head1 VERSION

Version 0.01

=cut

our $VERSION = '0.01';


=head1 SYNOPSIS

Quick summary of what the module does.

Perhaps a little code snippet.

    use Spp::AtomToValue;

    my $foo = Spp::AtomToValue->new();
    ...

=head1 EXPORT

atom_to_value atoms_to_value

=cut

use Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(atom_to_value atoms_to_value);

use 5.020;
use Carp qw(croak);
use experimental qw(switch autoderef);
use Spp::Tools;

## reflect Spp atom to Perl value
sub atom_to_value {
  my $atom = shift;
  my $type = type($atom);
  my $value = value($atom);
  given ($type) {
    when ('nil')   { return ['nil']   }
    when ('true')  { return ['true']  }
    when ('false') { return ['false'] }
    when ('int')   { return $value + 0}
    when ('str')   { return $value    }
    when ('array') { return atoms_to_value($value)    }
    when ('hash')  { return hash_to_value($value)     }
    default { error("Could not get atom value $type") }
  }
}

sub atoms_to_value {
  my $atoms = shift;
  my $values = [];
  for my $atom (@{$atoms}) {
    push $values, atom_to_value($atom);
  }
  return $values;
}

sub hash_to_value {
  my $hashref = shift;
  my $hash_value = {};
  for my $pair (@{$hashref}) {
    my ($key, $value) = @{$pair};
    my $key_value = atom_to_value($key);
    my $value_value = atom_to_value($value);
    $hash_value->{$key} = $value;
  }
  return $hash_value;
}

1;
