/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $aux1.P */

/* **********************************************************************
$aux1_export([$roundtosq/2,$get_compiletime/2,$message1/1, $output_msg/3,
	      $umsg/1,$name_aslfile/2,disj_targ_label/2,$gensym_pred/2,
	      $logical_or/3,$concat_atom/3]).

$aux1_use($name,[$name/2,_]).
$aux1_use($blist,[$append/3,$member/2,$member1/2]).
$aux1_use($bio,[$writename/1,$writeqname/1,$put/1,$nl/0,$tab/1,$tell/1,
	$telling/1,$told/0,$get/1,$get0/1,$see/1,$seeing/1,$seen/0]).
$aux1_use($glob,[_,_,$gensym/2]).
********************************************************************** *


/* convert a round list to a square list */

$roundtosq(','(F,R),[F|Tr]) :- !, $roundtosq(R,Tr).
$roundtosq(X,[X]) :- !.
$roundtosq(true,[]).

$get_compiletime(CTime,Time) :- CTime0 is (CTime + 5)/1000.0,
	$name(CTime0,N0),
	$get_2dec_places(N0,N1),
	$name(Time,N1).

$get_2dec_places([46|L],[46,D0,D1]) :-
	$length(L,N),
	(N >= 2 ->
		L = [D0,D1|_] ;
		(N =:= 1 -> (L = [D0], D1 = 48) ;
			    (D0 = 48, D1 = 48)
		)
	).
$get_2dec_places([X|L],[X|L0]) :- X =\= 46, $get_2dec_places(L,L0).
$get_2dec_places([],[]).

$message1(Opts) :- $member1(v,Opts), !,
		  $writename(' - translation phase commenced'),nl.
$message1(_).

$output_msg(P,N,Opts) :-
      (($member1(v,Opts),
        !,
        $telling(X), $tell(user),
	$tab(15),
        $writename('translating : '),
	$writename(P), $writename('/'), $writename(N), $nl, $told,
	$tell(X)
       ) ;
       true
      ).

$umsg( Text ) :- $telling( File ), $tell( user ),
	$umsg0( Text ), $nl, $told, $tell( File).

$umsg0([]) :- !.
$umsg0([H|T]) :- !, $writename(H), $writename(' '), $umsg0(T).
$umsg0(Atom) :- $writename(Atom).

$name_aslfile(InFile, AslFile) :-
	$name(InFile,InFileName), $append(InFileName, ".asl", OutFile1Name),
	$name(AslFile, OutFile1Name).

$disj_targ_label(Label,Name) :- $name(Label,Name1), $name(Name,[100|Name1]).

$gen_label((Lab, -1, N)) :- $gennum(N), $disj_targ_label(N,Lab).

$gensym_pred(P,NP) :-
	$name(P, Pname),
	$gensym('_#',N2),
	$name(N2,Nname2),
	$append(Pname, Nname2, NPname), 
	$name(NP,NPname).

$logical_or(X,Y,Z) :-
	((X =:= 1, Z = 1) ;
	 (X =\= 1,
	  ((Y =:= 1, Z = 1) ;
	   (Y =\= 1, Z = 0)
	  )
	 )
	).

$concat_atom(L1,L2,L3) :-
	$name(L1,L1name), $name(L2,L2name),
	$append(L1name,L2name,L3name),$name(L3,L3name).

/* ---------------------------------------------------------------------- */

