/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $cond1.P */

/*  This file contains predicates that handle conditional statements.  At
    this point, this is limited to the branches of a disjunct with mutually
    exclusive tests, e.g. ">=" and "<".			*/

/* **********************************************************************
$cond1_export([$cond/5,$get_test/3,$complementary/3,$inline_neg/2]).

$cond1_use($meta,[_,$univ/2,$length/2]).
$cond1_use($compare,['$=='/2,_,_,_,_,_,_]).
********************************************************************** */

$cond(A1,B1,T1,TPart,FPart) :-
	$get_test(A1,T1,TPart), $get_test(B1,T2,FPart),
	$univ(T1,[Op1 | Args1]), $univ(T2,[Op2 | Args2]),
	'$=='(Args1,Args2),
	$length(Args1,Arity), 
	$complementary(Op1,Arity,Op2).

$get_test(','(not(Test0),Rest),Test1,Rest) :-
	$inline_neg(Test0,Test1),
	!.
$get_test(','(Test0,Rest),Test,','(Rest0,Rest)) :-
	!,
	$get_test(Test0,Test,Rest0).
$get_test(Test,Test,true).


$complementary('<',2, '>=').
$complementary('>=',2, '<').
$complementary('=<',2, '>').
$complementary('>',2, '=<').
$complementary('=:=',2, '=\=').
$complementary('=\=',2, '=:=').
$complementary(var,1, nonvar).
$complementary(nonvar,1, var).


$inline_neg('>'(A,B), '=<'(A,B)).
$inline_neg('>='(A,B), '<'(A,B)).
$inline_neg('=<'(A,B),'>'(A,B)).
$inline_neg('<'(A,B),'>='(A,B)).
$inline_neg('=='(A,B), '\=='(A,B)).
$inline_neg('\=='(A,B), '=='(A,B)).
$inline_neg('=:='(A,B),'=\='(A,B)).
$inline_neg('=\='(A,B),'=:='(A,B)).
$inline_neg(var(X),nonvar(X)).
$inline_neg(nonvar(X),var(X)).
$inline_neg(fail, true).
$inline_neg(true, fail).

/* ------------------------------ $cond1.P ------------------------------ */

