/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $eval1.P */

/* **********************************************************************
$eval1_export([$eval_exp/7,$eval_arithreloptab/4,$arithrelop/1]).

$eval1_use($computil1,[_,$hold/3,$release/3,$getreg/2,
	_,_,_,_,_,_,_,_,_,$occ/2,_,_,_,$alloc_reg/3,_,$release_if_done0/5]).
$eval1_use($bmeta,[_,_,_,$number/1,_,_,_,_,_]).
$eval1_use($aux1,[_,_,_,_,$umsg/1,_,_,_,_]).
$eval1_use($blist,[_,_,$member1/2]).
$eval1_use($inst1,[$varinst/8,_,_,_,_]).
********************************************************************** */

:- mode($eval_exp,8,[nv,d,d,d,d,d,d,c]).

/* the 8th argument of $eval_exp/8 is a flag that indicates whether
   or not the register in which the value of the expression is
   computed will be overwritten: if the value of this flag is 1,
   then the register is guaranteed to not be overwritten.  		*/

$eval_exp(A,B,C,D,E,F,G) :- $eval_exp(A,B,C,D,E,F,G,0).

$eval_exp([N],R,[Inst|Pil],Pil,_,Tin,Tout,_) :-
    !, $eval_const(N,R,Inst,Tin,Tout).
$eval_exp(v(_,Prag),R,Pil,Pilr,_,Tin,Tout,Nowrite) :-
    !,
    $eval_var(Prag,R,Pil,Pilr,Tin,Tout,Nowrite).
$eval_exp([BinOp,E1,E2],R,Pil,Pilr,HoldR,Tin,Tout,Nowrite) :-
    $eval_binop(BinOp),
    !,
    $eval_binop(BinOp,E1,E2,R,Pil,Pilr,HoldR,Tin,Tout,Nowrite).
$eval_exp([mod,E1,E2],R,Pil,Pilr,HoldR,Tin,Tout,Nowrite) :-
    !,
    $eval_exp(E1,R0,Pil,Pilm0,HoldR,Tin,Tmid,0),
    $eval_exp(E2,R1,Pilm0,Pilm1,HoldR,Tmid,Tmid1,Nowrite),
    $getreg(Tmid1,R),
    Pilm1 = [movreg(R0,R),idivreg(R1,R0),mulreg(R1,R0),subreg(R0,R)|Pilr],
    $release_if_done0(E1,R0,HoldR,Tmid1,Tmid2),
    $release_if_done0(E2,R1,HoldR,Tmid2,Tout).
$eval_exp(['+',E2],R,Pil,Pilr,HoldR,Tin,Tout,Nowrite) :- /* unary plus */
    !,
    $eval_exp(E2,R,Pil,Pilr,HoldR,Tin,Tout,Nowrite).
$eval_exp(['-',E2],R,Pil,Pilr,HoldR,Tin,Tout,_) :- /* unary minus */
    !,
    $getreg(Tin,R), $hold(R,Tin,Tmid1),
    Pil = [putnumcon(0,R)|Pilm],
    $eval_exp(E2,R1,Pilm,[subreg(R1,R)|Pilr],HoldR,Tmid1,Tmid2,1),
    $release(R,Tmid2,Tmid3),
    $release_if_done0(E2,R1,HoldR,Tmid3,Tout).
$eval_exp(['\',Arg],R,Pil,Pilr,HoldR,Tin,Tout,Nowrite) :-
    !,
    $eval_exp(Arg,R,Pil,[negate(R)|Pilr],HoldR,Tin,Tout,Nowrite).
$eval_exp(['.', Arg, [[]] ],R,Pil,Pilr,HoldR,Tin,Tout,Nowrite) :-
    !,
    $eval_exp(Arg,R,Pil,Pilr,HoldR,Tin,Tout,Nowrite).
$eval_exp([Op|_],1,[fail|Pilr],Pilr,HoldR,T,T,_) :-
    $umsg(['*** error: unknown operator in arithmetic expression: ', Op]).

:- mode($eval_binoptab,4,[c,d,d,d]).

$eval_binoptab(+,R1,R2,addreg(R2,R1)).
$eval_binoptab(-,R1,R2,subreg(R2,R1)).
$eval_binoptab(*,R1,R2,mulreg(R2,R1)).
$eval_binoptab(/,R1,R2,divreg(R2,R1)).
$eval_binoptab('//',R1,R2,idivreg(R2,R1)).
$eval_binoptab('/\',R1,R2,and(R2,R1)).
$eval_binoptab('\/',R1,R2,or(R2,R1)).
$eval_binoptab('<<',R1,R2,lshiftl(R2,R1)).
$eval_binoptab('>>',R1,R2,lshiftr(R2,R1)).

:- mode($eval_binop,1,[c]).

$eval_binop('+').
$eval_binop('-').
$eval_binop('*').
$eval_binop('/').
$eval_binop('//').
$eval_binop('/\').
$eval_binop('\/').
$eval_binop('<<').
$eval_binop('>>').

:- mode($arithrelop,1,[c]).

$arithrelop('<').
$arithrelop('=<').
$arithrelop('>').
$arithrelop('>=').
$arithrelop('=:=').
$arithrelop('=\=').

:- mode($eval_arithreloptab,4,[d,c,d,d]).
:- index($eval_arithreloptab,4,2).

$eval_arithreloptab(R,<,Label,jumpge(R,Label)).
$eval_arithreloptab(R,=<,Label,jumpgt(R,Label)).
$eval_arithreloptab(R,>=,Label,jumplt(R,Label)).
$eval_arithreloptab(R,>,Label,jumple(R,Label)).
$eval_arithreloptab(R,=:=,Label,jumpnz(R,Label)).
$eval_arithreloptab(R,=\=,Label,jumpz(R,Label)).

$eval_const(N,R,Inst,Tin,Tout) :-
	$number(N) ->
	   ($getreg(Tin,R),
	    $hold(R,Tin,Tout),
	    (integer(N) -> Inst = putnumcon(N,R) ; Inst = putfloatcon(N,R))
	   ) ;
	   ($umsg(['*** Error: non-numeric constant in numeric expression: ',N,' ***']),
	    Inst = fail, Tin = Tout, R = 0
	   ).

$eval_var(Prag,R,Pil,Pilr,Tin,Tout,Nowrite) :-
    $alloc_reg(Prag,Tin,Tmid),
    (($occ(Prag,s),
      $eval_numgetinst(Prag,R,Pil,Pilr,Tmid,Tout,Nowrite)) ;
     ($umsg('*** Error: unbound variable in arithmetic expression ***'),
      Pil = [fail|Pilr], R = 0, Tmid = Tout
     )
    ).

$eval_binop(Op,E1,E2,R1,Pil,Pilr,HoldR,Tin,Tout,_) :-
    $eval_exp(E1,R1,Pil,Pilm,HoldR,Tin,Tmid1,0),
    $eval_exp(E2,R2,Pilm,[Inst|Pilr],HoldR,Tmid1,Tmid2,1),
    $eval_binoptab(Op,R1,R2,Inst),
    $release_if_done0(E2,R2,HoldR,Tmid2,Tout).

$eval_numgetinst(vrec(t,_,Loc,Misc),R,Pil,Pilr,Tin,Tout,Nowrite) :-
	!,
	($member1(tail,Misc) ; Nowrite =:= 1) ->
	     (R = Loc, Pil = Pilr,
	      ($member(tail,Misc) -> Tin = Tout ; $hold(R,Tin,Tout))
	     ) ;
	     ($getreg(Tin,R),
	      $hold(R,Tin,Tout),
	      Pil = [movreg(Loc,R)|Pilr]
	     ).
$eval_numgetinst(vrec(T0,L,Loc,_),R,Pil,Pilr,Tin,Tout,_) :-
	$getreg(Tin,R), $hold(R,Tin,Tout),
	(T0 = p -> T = d ; T = T0),
	$varinst(b,L,T,Loc,R,Pil,Pilr,Tout).

$eval_power2(N0,N,K0,K) :-
	((N0 =:= N, K0 = K) ;
	 (N0 =\= N, N0 < N, N1 is N0 << 1, K1 is K0+1,
	  $eval_power2(N1,N,K1,K)
	 )
	).

/* end $eval1.P ***********************************/
