/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $inprog1.P */

/* **********************************************************************

$inprog1_export([$inprog0/2]).

$inprog1_use($targlist1,[$thead/8,_,_]).
$inprog1_use($convrhs1,[$convrhs/12]).
$inprog1_use($blist,[$append/3,_,$member1/2]).
$inprog1_use($flatten1,[$add_uni_hdr/6,_]).
$inprog1_use($procclp1,[$procclp/2,_]).
$inprog1_use($meta,[_,_,$length/2]).
$inprog1_use($computil1,[_,_,_,_,$max/3,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]).
$inprog1_use($inline1,[$inline/2]).

********************************************************************** */

$inprog0([],_) :- !.
$inprog0([C1|Rest], Prog) :- $inprog01(C1, Rest, Prog).

$inprog01(fact(Fact,_), ClRest, Prog) :-
	$inprog(Fact,Prog,Clprag),
	$inprog0(ClRest,Prog).
$inprog01(rule(H,B,_,_), ClRest, Prog) :-
	$inprog((H :- B),Prog,Clprag),
	$inprog0(ClRest,Prog).

$inprog(Clause,Prog,Clprag) :-
    Clprag=[St|_], St = st(Clist,Vlist),
    (Clause = (Head :- Goalsr) ->
	($thead(Head,VidTbl,Prog,Targs,Oldclauses,Vlist,UniList,BindList),
	 $convrhs(Goalsr,Tgoals,VidTbl,1,_,St,1,_,BindList,NFlag,AFlag,1),
	 $member1(c(1,A,ClP),Clist), A1 is A+1,
	 $member1(nv(NV),ClP), 
	 $member1(alloc(AFlag),ClP),
	 $member1(normalize(NFlag),ClP)
	) ;
        ($thead(Clause,VidTbl,Prog,Targs,Oldclauses,Vlist,UniList,_),
	 A1 = 0, NV = 0, Tgoals = nil
	)
    ),
    $add_uni_hdr(UniList,A1,NV,Vlist,Tgoals,VGoals),
    $inp_get_chunk_lastgoals(VGoals,1,_,LastGoals),
    $member1(clause(Targs,VGoals,Clprag),Oldclauses),
    $procclp(Clprag,LastGoals).


$inp_get_chunk_lastgoals(nil,N,N,[]) :- !.
$inp_get_chunk_lastgoals(and(C1,_,C2),N0,N2,L) :-
	!,
	$inp_get_chunk_lastgoals(C1,N0,N1,L0),
	$append(L0,L1,L),
	$inp_get_chunk_lastgoals(C2,N1,N2,L1).
$inp_get_chunk_lastgoals(or(C1,_,C2),N0,N2,L) :-
	!,
	$inp_get_chunk_lastgoals(C1,N0,N1a,L0),
	$append(L0,L1,L),
	$inp_get_chunk_lastgoals(C2,N0,N1b,L1),
	$max(N1a,N1b,N2).
$inp_get_chunk_lastgoals(if_then_else(T,_,C1,C2),N0,N2,L) :-
	!,
	$inp_get_chunk_lastgoals(C1,N0,N1a,L0),
	$inp_get_chunk_lastgoals(C2,N0,N1b,L1),
	$max(N1a,N1b,N2),
	$append(L0,L1,L).
$inp_get_chunk_lastgoals('_call'(P,Args,_),N,N,[]) :-
	$length(Args,Arity),
	$inline(P,Arity),
	!.
$inp_get_chunk_lastgoals(Call,N0,N1,[chunk(N0,Call)]) :- N1 is N0 + 1.

/* ---------------------------- $inprog1.P ---------------------------- */

