/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* opcode.P */

/* instruction name <=> opcode mapping 
   see file sim/dispatch.c
   THESE FILES MUST MATCH !

   strip off extra junk before and after the table definition, then
   use this filter :

   main()
   { 
      char   buff[256], *p, *q;
      int    i = 0;

      while( gets( buff ) ) {
         p = q = &buff[26];
         while( *q != ',' )  q++;
         *q = '\0';

         printf( "$opcode( %-20s, %2d ).\n", p, i++ );
      }
   }
*/

$opcode_export( [ $opcode/2, $opcode/3, $instruction/2 ] ).

$opcode(X,Y) :- $opcode(X,Y,_).

$opcode( getpvar             ,  0, pss).
$opcode( getpval             ,  1, pss ).
$opcode( getstrv             ,  2, sl ).
$opcode( gettval             ,  3, pss ).
$opcode( getcon              ,  4, sl ).
$opcode( getnil              ,  5, s ).
$opcode( getstr              ,  6, sl ).
$opcode( getlist             ,  7, s ).
$opcode( unipvar             ,  8, s ).
$opcode( unipval             ,  9, s ).
$opcode( unitvar             , 10, s ).
$opcode( unitval             , 11, s ).
$opcode( unicon              , 12, pl ).
$opcode( uninil              , 13, p ).
$opcode( getnumcon           , 14, sl ).
$opcode( putnumcon           , 15, sl ).
$opcode( putpvar             , 16, pss ).
$opcode( putpval             , 17, pss ).
$opcode( puttvar             , 18, pss ).
$opcode( putstrv             , 19, sl ).
$opcode( putcon              , 20, sl ).
$opcode( putnil              , 21, s ).
$opcode( putstr              , 22, sl ).
$opcode( putlist             , 23, s ).
$opcode( bldpvar             , 24, s ).
$opcode( bldpval             , 25, s ).
$opcode( bldtvar             , 26, s ).
$opcode( bldtval             , 27, s ).
$opcode( bldcon              , 28, pl ).
$opcode( bldnil              , 29, p ).
$opcode( uninumcon           , 30, pl ).
$opcode( bldnumcon           , 31, pl ).
$opcode( getfloatcon         , 32, sf ).
$opcode( putfloatcon         , 33, sf ).
$opcode( unifloatcon         , 34, pf ).
$opcode( bldfloatcon         , 35, pf ).
$opcode( test_unifiable      , 36, sss ).
$opcode( getlist_k           , 37, s ).
$opcode( getlist_k_tvar_tvar , 38, sss ).
$opcode( getlist_tvar_tvar   , 39, sss ).
$opcode( getcomma            , 40, s ).
$opcode( getcomma_tvar_tvar  , 41, sss ).
$opcode( trymeelse           , 42, sl ).
$opcode( retrymeelse         , 43, sl ).
$opcode( trustmeelsefail     , 44, s ).
$opcode( try                 , 45, sl ).
$opcode( retry               , 46, sl ).
$opcode( trust               , 47, sl ).
$opcode( getpbreg            , 48, s ).
$opcode( gettbreg            , 49, s ).
$opcode( putpbreg            , 50, s ).
$opcode( puttbreg            , 51, s ).
$opcode( switchonterm        , 52, saa ).
$opcode( arg                 , 53, sss ).
$opcode( arg0                , 54, sss ).
$opcode( switchonbound       , 55, saa ).
$opcode( switchonlist        , 56, saa ).
$opcode( get_tag             , 57, pss ).
$opcode( movreg              , 58, pss ).
$opcode( negate              , 59, s ).
$opcode( and                 , 60, pss ).
$opcode( or                  , 61, pss ).
$opcode( lshiftl             , 62, pss ).
$opcode( lshiftr             , 63, pss ).
$opcode( addreg              , 64, pss ).
$opcode( subreg              , 65, pss ).
$opcode( mulreg              , 66, pss ).
$opcode( divreg              , 67, pss ).
$opcode( idivreg             , 68, pss ).
$opcode( putdval             , 69, pss ).
$opcode( putuval             , 70, pss ).
$opcode( call                , 71, bba ).
$opcode( allocate            , 72, s ).
$opcode( deallocate          , 73, p ).
$opcode( proceed             , 74, p ).
$opcode( execute             , 75, pl ).
$opcode( calld               , 76, bba ).
$opcode( jump                , 77, pl ).
$opcode( jumpz               , 78, as ).
$opcode( jumpnz              , 79, as ).
$opcode( jumplt              , 80, as ).
$opcode( jumple              , 81, as ).
$opcode( jumpgt              , 82, as ).
$opcode( jumpge              , 83, as ).
$opcode( fail                , 84, p ).
$opcode( noop                , 85, p ).
$opcode( halt                , 86, p ).
$opcode( builtin             , 87, s ).
$opcode( endfile             , 88, pl ).
$opcode( hash                , 89, s ).
$opcode( getival             , 90, sl ).
$opcode( jumptbreg           , 91, sl ).
$opcode( unexec              , 92, pww ).
$opcode( unexeci             , 93, pww ).
$opcode( executev            , 94, pw ).

$instruction( OpName, Instr ) :-
          $opcode( OpName, Instr ).
