/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $procarglist1.P */

/* **********************************************************************
$procarglist1_export([$proc_arg_list1/10]).

$procarglist1_use($computil1,[_,_,_,_,_,_,_,_,_,_,_,_,$type/2,
		$occ/2,_,$misc/2,_,_,_,_]).
$procarglist1_use($blist,[_,_,$member1/2,$not_member1/2]).
$procarglist1_use($listutil1,[_,_,_,_,_,_,$member2/2,_]).
$procarglist1_use($prococcbody1,[_,_,$proc_alloc_pvars/3]).
********************************************************************** */


$proc_arg_list([],_, _, _, [],E,E,N,N,_).
$proc_arg_list([A1|ARest],LastLit,Vlist,Seen,[N1|NRest],E1,E2,NPin,NPout,Prag) :-
	$proc_occ_arg(A1,LastLit,Vlist,Seen,N1,E1,E2a,NPin,NPmid,Prag),
	$proc_arg_list(ARest,LastLit,Vlist,Seen,NRest,E2a,E2,NPmid,NPout,Prag).

$proc_occ_arg(v(Vid, Prag),LastLit,Vlist,Seen,v(Vid,Nprag),
				OEncs,NEncs,NPin,NPout,ClPrag) :-
     $proc_mark_occ(Vid,Prag,Seen),
     $type(Prag,VType),
     $proc_occ_v(VType,Vid,Prag,LastLit,Vlist,OEncs,NEncs,NPin,NPout,Nprag).
$proc_occ_arg([Str|Args],LastLit,Vlist,Seen,[Str|Nargs],E1,E2,NPin,NPout,Prag) :-
	$proc_occ_str(Args,LastLit,Vlist,Seen,Nargs,E1,E2,NPin,NPout,Prag).

$proc_occ_v(t,Vid,Prag,LastLit,Vlist,OEncs,NEncs,NP,NP,Nprag) :-
     $proc_mark_lastocc(Vid,Prag,Nprag,Vlist,OEncs,NEncs).
$proc_occ_v(vh,_,Prag,_,_,Encs,Encs,NP,NP,Prag).
$proc_occ_v(p,Vid,Prag,LastLit,Vlist,Encs,Encs,NPin,NPout,Nprag) :-
     (LastLit =:= 1 ->
          (Prag = vrec(p,Occ,Loc,Misc),
           $member1(firstocc(Firstlit,Context),Misc),
	   $proc_pvartype(Firstlit,Context,Occ,T),
	   Nprag = vrec(T,Occ,Loc,Misc)
	  ) ;
	  Nprag = Prag
     ),
     $proc_alloc_pvars(Nprag,NPin,NPout).

$proc_occ_str([],_, _, _, [],E,E,N,N,_).
$proc_occ_str([A1|ARest],LastLit,Vlist,Seen,[N1|NRest],E1,E2,NPin,NPout,Prag) :-
	$proc_occ_arg(A1,LastLit,Vlist,Seen,N1,E1,E2a,NPin,NPmid,Prag),
	$proc_arg_list(ARest,LastLit,Vlist,Seen,NRest,E2a,E2,NPmid,NPout,Prag).

$proc_mark_occ(Vid,Prag,Seen) :-
	$member2(Vid,Seen) ->
		$occ(Prag,s) ;
		($occ(Prag,f), $member1(Vid,Seen)).

$proc_mark_lastocc(Vid,Prag1,Prag2,Vlist,OldEncs,NewEncs) :-
	$proc_get_numocc(Vid,Vlist,N),
	$proc_chklastocc(Vid,N,OldEncs,NewEncs,Prag1,Prag2).

$proc_pvartype(N,t,s,u) :- N > 0, !.
$proc_pvartype(N,C,s,d) :- (N = 0 ; C = s), !.
$proc_pvartype(_,_,f,p).


$proc_get_numocc(Vid, Vlist, N) :-
	$member1(v(Vid,Occlist),Vlist),
	$member1(o(_,_,_,_,_,P),Occlist),
	$misc(P,Misc), $member1(numocc(N),Misc).

$proc_chklastocc(Vid,N,E1,E2,P1,P2) :-
	$proc_update_occ(Vid,E1,E2,CurrOcc),
	((CurrOcc =:= N,
	  P1 = vrec(T,Occ,Loc,Misc1), P2 = vrec(T,Occ,Loc,[tail|Misc1])) ;
	 (CurrOcc =\= N, P2 = P1)).

:- index($proc_update_occ,4,2).

$proc_update_occ(Vid,[], [nocc(Vid,1)],1).
$proc_update_occ(Vid,[nocc(Vid,N)|R],[nocc(Vid,N1)|R],N1) :- N1 is N + 1.
$proc_update_occ(Vid,[nocc(V1,N1)|R],[nocc(V1,N1)|R1],N) :-
		not(Vid = V1), $proc_update_occ(Vid,R,R1,N).


/* end procarglist1.P *******************************************/
