/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $prococc1.P */

/* **********************************************************************
$prococc1_export([$proc_occ/2]).

$prococc1_use($blist,[_,_,$member1/2]).
$prococc1_use($procarglist1,[$proc_arg_list1/10]).
$prococc1_use($prococcbody1,[$proc_occ_body/10,$list_pvars/2,_]).
$prococc1_use($normvarocc1,[$normalize_var_occ/7]).
$prococc1_use($listutil1,[_,_,_,_,_,_,_,$closetail/1]).
$prococc1_use($glob,[_,$gennum/1,_]).
$prococc1_use($procclp1,[_,$getnumlits/3]).
********************************************************************** */


/* 	"$proc_occ" and predicates it calls fills in pragma information
	 about occurrences of variables (first/subsequent).		*/

$proc_occ([], []) :- !.
$proc_occ([preddef(P, N, ClList, Prag)|RestPred],
	 [preddef(P, N, NClList, Prag)|NRestPred]) :-
		$proc_occ1(P,N,ClList, NClList),
		$proc_occ(RestPred, NRestPred).

:- index($proc_occ1, 4, 3).

$proc_occ1(_,_,[], []).
$proc_occ1(Pred,Arity,[clause(Args, Body, P)|RestClause],
		     [clause(Nargs, NBody, P)|NRestClause]) :-
  	$member1(st(Clist,Vlist), P),
	$proc_arg_list(Args,0,Vlist,Seen,Nargs,[],Encs1,1,NP1,[]),
	$list_pvars(Args,Pvars_head),
	(($member1(c(1,_,ClP),Clist), $prococc_norm_clause(ClP)) ->
	      $normalize_var_occ(Body,Body2,Pvars_head,[],_,_,_) ;
	      Body2 = Body
	),
	$proc_occ_body(Body2,1,Vlist,Seen,_,NBody,Encs1,_,NP1,Npvars),
	$proc_clause(Pred, Arity,P,Npvars),
	$proc_occ1(Pred,Arity,RestClause, NRestClause).

$prococc_norm_clause(ClPrag) :-
	$member1(normalize(NFlag),ClPrag), !,
	NFlag =:= 1.
$prococc_alloc_clause(ClPrag) :-
	$member1(alloc(AFlag),ClPrag), !,
	AFlag =:= 1.


$proc_clause(Pred,Arity,Prag,NPvars) :-
	$member1(st(Clist,_),Prag),
	$getnumlits(Clist,0,Numlits),
	$gennum(N),
	$member1(label((Pred,Arity,N)),Prag),
	$proc_clause1(Prag,Numlits,NPvars),
	$closetail(Prag),
	!.

$proc_clause1(Prag,Numlits,NPvars) :-
	$member1(st(Clist,_),Prag),$member1(c(_,_,ClPrag),Clist),
	(Numlits >= 2 ; NPvars > 2 ; $prococc_alloc_clause(ClPrag)),
	!,
	ARSize is NPvars + 1, $mark_arsize(Clist,ARSize),
	$member1(all(y),Prag).
$proc_clause1(Prag,Numlits,NPvars) :- $member1(all(n),Prag).


$mark_arsize([],_).
$mark_arsize([c(_,_,ClPrag)|CRest],N) :-
	$member1(nv(N),ClPrag), $mark_arsize(CRest,N).

:- mode $proc_occ_body(+,++,?,?,?,?,?,?,?,?).

$proc_occ_body(and(C1,P,C2),LastLit,Vlist,Seen,TVar,
	       and(NC1,P,NC2),E1,E2,NPin,NPout) :-
	!,
	$proc_occ_body(C1,0,Vlist,Seen,TV1,NC1,E1,E2a,NPin,NPmid),
	$append(TV1,TV2,TVar),
	$proc_occ_body(C2,LastLit,Vlist,Seen,TV2,NC2,E2a,E2,NPmid,NPout).
$proc_occ_body(or(C1,P,C2),LastLit,Vlist,Seen,[],or(NC1,P,NC2),E1,E2,NPin,NPout) :-
	!,
	$length1(Seen,N),
	$prococc_allocpvarsl(P,NPin,NPmid),
	$proc_occ_body(C1,LastLit,Vlist,Seen,_,NC1,E1,E2a,NPmid,NPmid1),
	$prefix_list(Seen,N,Seen1),
	$proc_occ_body(C2,LastLit,Vlist,Seen1,_,NC2,E2a,E2,NPmid,NPmid2),
	$max(NPmid1,NPmid2,NPout).
$proc_occ_body(if_then_else(Ti,Pi,G1i,G2i),LastLit,Vlist,Seen,TVars,
	      if_then_else(To,Po,G1o,G2o),E1,E2,NPin,NPout) :-
	!,
	$prococc_allocpvarsl(Pi,NPin,NPmid),
	$proc_occ_body(Ti,0,Vlist,Seen,TV0,To,E1,E2a,NPmid,NPmid1),
	$length1(Seen,N),
	$append(TV0,TV1,TV1a),
	$proc_occ_body(G1i,LastLit,Vlist,Seen,TV1,G1o,E2a,E2b,NPmid1,NPmid2),
	$prefix_list(Seen,N,Seen1),
	$append(TV1a,TV2,TVars),
	Po = [tvars(TV2)|Pi],			/* temps of else-branch */
	$proc_occ_body(G2i,LastLit,Vlist,Seen1,TV2,G2o,E2b,E2,NPmid2,NPout).
$proc_occ_body(nil,_,_,_,[],nil,E,E,N,N) :- !.
$proc_occ_body('_call'(P,Args,Prag),LastLit,Vlist,Seen,TVars,
	       '_call'(P,NArgs,Prag),E1,E2,NPin,NPout) :-
	(LastLit =:= 1 -> $member1(lastlit,Prag) ; true),
	$prococc_allocpvarsl(Prag,NPin,NPmid),
 	$closetail(Prag),
	$prococc_list_tvars(Args,TVars),
	$proc_arg_list(Args,LastLit,Vlist,Seen,NArgs,E1,E2,NPmid,NPout,Prag).

$prococc_allocpvarsl(Prag,Nin,Nout) :-
	$member1(pvars(PV),Prag) ->
	     $prococc_allocpvarsl1(PV,Nin,Nout) ;
	     Nin = Nout.

$prococc_allocpvarsl1([],N,N).
$prococc_allocpvarsl1([v(_,Prag)|VRest],Nin,Nout) :-
	$proc_alloc_pvars(Prag,Nin,Nmid),
	$prococc_allocpvarsl1(VRest,Nmid,Nout).

$list_pvars(G,L) :- $list_pvars0(G,L), $closetail(L).

$list_pvars0([],_).
$list_pvars0([v(Vid,Prag)|RestArgs],L) :-
	$type(Prag,T),
	((T ?= p ; T ?= u ; T ?= d) ->
	     $union_vars2(Vid,Prag,L) ;
	     true
	),
	$list_pvars0(RestArgs,L).
$list_pvars0([Str|RestArgs],L) :-
	Str = [_|SArgs],
	(SArgs ?= [] ->
	     $list_pvars0(RestArgs,L) ;
	     ($list_pvars0(SArgs,L1),
	      $list_pvars0(RestArgs,L2),
	      $union_varsets(L1,L2,L)
	     )
	).

$prococc_list_tvars([],[]).
$prococc_list_tvars([v(Vid,Prag)|ARest],[Vid|VRest]) :-
	$type(Prag,t),
	!,
	$prococc_list_tvars(ARest,VRest).
$prococc_list_tvars([A|ARest],Vars) :- $prococc_list_tvars(ARest,Vars).


$proc_alloc_pvars(Prag,N,N1) :-
	$loc(Prag,Loc),
	((nonvar(Loc), N1 = N) ;
	 (var(Loc), N1 is N + 1, Loc = N1)
	).


/* end prococc1.P *************************************************/
