/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $tindex1.P */

/* **********************************************************************
$tindex1_export([$tindex/2]).

$tindex1_use($blist,[_,_,$member1/2]).
$tindex1_use($meta,[_,$univ/2,_]).
$tindex1_use($bmeta,[_,_,_,_,_,_,_,$arg/3,_]).

$tindex1_use($aux1,[_,_,_,_,_,_,_,$gensym_pred/2,_]).
********************************************************************** */


$tindex(Pred,NPred) :-
	Pred = pred(P,N,CFlag,CutFlag,Clauses,Prag),
	((N > 0, Clauses ?= [_,_|_]) ->    % at least 2 clauses, to make
					   % indexing worthwhile.
	     ($member1(index(Narg),Prag),
	      $tindex1(P,N,Clauses,Prag,Narg,NPred)
	     ) ;
	     NPred = [Pred]
	).

$tindex1(P, N, Clauses, Prag, Narg, NClauses) :-
	$tindex_getarg(Clauses, Narg, Arglist),
	$tindex_split_arg_clau(Arglist, Narglist),
	(Narglist ?= [_] ->
	     NClauses = [pred(P,N,0,0,Clauses,Prag)] ;
	     $tindex_newclau(P, N, Narg, Prag, Narglist, Clauses, NClauses)
	).

$tindex_getarg([], _, []).
$tindex_getarg([C1|Rest], N, [T|Restargt]) :-
	(C1 = fact(Head,_); 
	 C1 = rule(Head,_,_,_)),
	$arg(N, Head, Arg),
	((var(Arg), T = v); 
	 (nonvar(Arg), T = b)
	),
	$tindex_getarg(Rest, N, Restargt).

$tindex_split_arg_clau([], []).
$tindex_split_arg_clau([T|Rest], [AList1|ARList]) :-
	$tindex_split_arg_clau1(T, [T|Rest], NRest, AList1),
	$tindex_split_arg_clau(NRest, ARList).

:- index($tindex_split_arg_clau1, 4, 2).

$tindex_split_arg_clau1(T, [], [], []).
$tindex_split_arg_clau1(T1, [T1|ARest], NARest, [T1|NA]) :-
	$tindex_split_arg_clau1(T1, ARest, NARest, NA).
$tindex_split_arg_clau1(_, Rest, Rest, []).

$tindex_newclau(Pname, Arity, Narg, Prag, Arglist, 
		Clauses, [pred(Pname,Arity,0,0,Clist2,Prag)|Clist3]) :-
	$tindex_genpred(Pname,Arity,Narg,Prag,Arglist,Clauses,Clist1,Clist3),
	$tindex_varargs(Arity, 0, Vargs),
	$tindex_genclau1(Clist1, Pname, Vargs, Clist2).

:- index($tindex_genpred, 8, 5).

$tindex_genpred(_,_,_,_,[],[],[],[]).
$tindex_genpred(P, N, Narg,Prag,[Part1|RAlist],[C1|RC],[C1|NCl1],Clist3) :-
	Part1 = [_], 
	$tindex_genpred(P, N, Narg,Prag, RAlist, RC, NCl1, Clist3).
$tindex_genpred(P, N, Narg, Prag,[Part1|RAlist],Clauses, Clist1, Clist3) :-
	Part1 = [v|_], 
	$tindex_part1(Part1, Clauses, RC, Clist1, NCl1),
	$tindex_genpred(P, N, Narg,Prag, RAlist, RC, NCl1,Clist3).
$tindex_genpred(P, N, Narg, Prag,[Part1|RAlist],Clauses,
		[(Pred, N)|NCl1], [pred(Pred,N,0,0,NClist,Prag)|NCl3]) :-
	$gensym_pred(P, Pred),
	((symtype('_$mode'(_,_,_),ModeDef), ModeDef > 0,
	  '_$mode'(P,N,Mode)
	 ) ->
	     assert('_$mode'(Pred,N,Mode)) ;  /* new pred inherits mode */
	     true
	),
	$tindex_newclau1(Part1, Pred, Clauses, RC, NClist),
	$tindex_genpred(P, N, Narg,Prag, RAlist, RC, NCl1,NCl3).

$tindex_part1([], RC, RC, [], []).
$tindex_part1([_|RA], [C1|RClauses], RC, [C1|Clist1], NCl1) :-
	$tindex_part1(RA, RClauses, RC, Clist1, NCl1).

$tindex_newclau1([], P, RC, RC, []).
$tindex_newclau1([_|RA], P, [C|Rest], RC, [NC|NRest]) :-
     (C = fact(H,_) ->
          NC = fact(NewHead,_) ;
	  (C = rule(H,B,X,Y), NC = rule(NewHead,B,X,Y))
     ),
     $univ(H,[_|Args]), $univ(NewHead,[P|Args]),
     $tindex_newclau1(RA, P, Rest, RC, NRest).

$tindex_varargs(N,M,L) :-
	((N =< M, L = []) ;
	 (N > M,  M1 is M + 1, L = [_|Rest], $tindex_varargs(N,M1,Rest))
	).

$tindex_genclau1([],_,_,[]).
$tindex_genclau1([Part1|RP], P, Vargs, [C1|RC]) :-
	(
	 (Part1 ?= fact(_,_); Part1 ?= rule(_,_,_,_)) ->
	      C1 = Part1 ;
	      (Part1 = (Pred, N),
	       C1 = rule(H,B,_,_),
	       $univ(H,[P|Vargs]),
	       $univ(B,[Pred|Vargs])
	      )
	),
	$tindex_genclau1(RP, P, Vargs, RC).


/* ------------------------------ $tindex1.P ------------------------------ */

