/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $translate1.P */

/* **********************************************************************
$translate1_export([$translateasm/3,$translate/3]).

$translate1_use($blist,[_,$member/2,$member1/2]).
$translate1_use($inprog1,[$inprog0/2]).
$translate1_use($preprocess1,[$preprocess0/3]).
$translate1_use($prococc1,[$proc_occ/2]).
$translate1_use($tprog1,[$tprog/3]).
$translate1_use($peephole1,[$comp_peepopt/2]).
$translate1_use($asm1,[$asm/3,$asm_PIL/2]).
$translate1_use($io,[$write/1,$writeq/1,_,_]).
$translate1_use($bio,[_,_,_,$nl/0,_,_,_,_,_,_,_,_,_]).
$translate1_use($listutil1,[_,_,_,_,_,_,_,$closetail/1]).
********************************************************************** */


$translateasm(PredDef,Opts,Prag,Mode,Preds) :-
	$factor(PredDef,Mode,NPredDef),
	$preprocess0(NPredDef,Prag,PredList),
	$translateasm0(PredList,Opts,Preds),
	!.

$translateasm0(PredDefs,Opts,Preds) :-
	$member(PredBlk, PredDefs),
	$translateasm1(PredBlk,Opts,Pil,[]),
	$process_PIL1(Pil,Preds),
	fail.
$translateasm0(_,_,_).

$translateasm1([],Opts,Pil,Pil).
$translateasm1([pred(P,N,_,_,Clauses,Prag)|PRest],Opts,Pil,Pilr) :-
	$translateasm2(P,N,Clauses,Opts,Prag,Pil,Pilm),
	!,
	$translateasm1(PRest,Opts,Pilm,Pilr).

$translateasm2(P,N,Clauses,Opts,Prag,Pil,Pilr) :-
	$inprog0(Clauses,Prog),
	$transl_procpredprag(Prog),
	$proc_occ(Prog,NProg),
	($member1(t,Opts) -> Prag1 = [trace|Prag] ; Prag1 = Prag),
	$tprog(NProg,Pil,Pilr,Prag1).

$translate(PredDef,Opts,Prag,Mode,Preds) :-
      $factor(PredDef,Mode,NPredDef),
      $preprocess0(NPredDef,Prag,ClauseList),
      $translate0(ClauseList,Opts,Preds),
      !.

$translate0(PredDefs,Opts,Preds) :-
	$member(PredBlk,PredDefs),
	$translate1(PredBlk,Opts,Pil,[]),
	$process_PIL2(Pil,Preds),
	fail.
$translate0(_,_,_).


$translate1([],_,Pil,Pil).
$translate1([pred(P,N,_,_,Clauses,Prag)|PRest],Opts,Pil,Pilr) :-
	$translate2(P,N,Clauses,Opts,Prag,Pil,Pilm),
	!,
	$translate1(PRest,Opts,Pilm,Pilr).

$translate2(P,N,ClList,Opts,Prag,Pil,Pilr) :-
      $inprog0(ClList,Prog),
      $transl_procpredprag(Prog),
      $proc_occ(Prog,NProg),
      ($member1(t,Opts) -> Prag1 = [trace|Prag] ; Prag1 = Prag),
      $tprog(NProg,Pil,Pilr,Prag1).


$transl_procpredprag([]).
$transl_procpredprag([preddef(_,_,Clauses,Prag)|Rest]) :-
    $closetail(Clauses),
    $transl_procpredprag(Rest).

$transl_write_PIL([]).
$transl_write_PIL([Inst|Rest]) :-
	$transl_write_inst(Inst),
	$transl_write_PIL(Rest).

$transl_write_inst(Inst) :- $writeq(Inst), $write('.'), $nl.

$process_PIL1(Pil,Preds) :- 
	$comp_peepopt(Pil,Pil1,Preds),
	$asm_PIL(Pil1,Opts),
	!.
$process_PIL2(Pil,Preds) :-
	$comp_peepopt(Pil,Pil1,Preds),
	$transl_write_PIL(Pil1),
	!.

/* ---------------------------- $translate1.P ---------------------------- */

