/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* emode.P */

emode(P,N,Mode) :-
    (symtype('_$emode'(_,_,_),K), K > 0, '_$mode'(P,N,Mode1)) ->
       (Mode = Mode1 ->
          (print('*** warning: multiple emode declarations for '),
           print(P), print('/'), print(N), $nl
          ) ;
          (print('*** Error: multiple distinct emode declarations for '),
           print(P), print('/'), print(N), $nl
          )
       ) ;
         ($length(Mode,N) ->
          ($mkemode(Mode,IMode,P,N),
          $asserti('_$emode'(P,N,IMode),1)
          ) ;
          (print('*** declared emode '), print(Mode), print(' for '), print(P),
           print('/'), print(N), print(' does not match predicate arity'), $nl
          )
       ).

$mkemode([],[],_,_).
$mkemode([M|MRest], [IM|IRest],P,N) :-
    ($mkemode1(M,IM) ->
        true ;
        ($writename('*** Unknown mode '),
         $write(M),
         $write(' in '), $write(P), $write('/'), $write(N),
         $write(' ***'),
         $nl,
         IM = 0
        )
    ),
    $mkemode(MRest,IRest,P,N).

$mkemode1('c', 2).
$mkemode1('nv', 1).
$mkemode1('d', 0).
$mkemode1('f', -1).
$mkemode1('++', 2).
$mkemode1('+', 1).
$mkemode1('?', 0).
$mkemode1('-', -1).

