/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $blist.P */

$blist_export([$append/3,$member/2,$memberchk/2,$not_memberchk/2]).

$append([],X,X).
$append([H|L1],L2,[H|L3]) :- $append(L1,L2,L3).

$member(X,[X|L]).
$member(X,[Y|L]) :- $member(X,L).

$memberchk(X,[Y|Z]) :- X = Y -> true ; $memberchk(X,Z).

$not_memberchk(X,L) :-
     L ?= [] ->
          true ;
	  (L = [Y|L1], X \= Y, $not_memberchk(X,L1)).

