/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $buff.P */

$buff_export([$alloc_perm/2,$alloc_heap/2,$trimbuff/3,$buff_code/4,$symtype/2,
		$substring/6,$subnumber/6,$subdelim/6,$conlength/2,
		$pred_undefined/1, $hashval/3]).

$alloc_perm(Size, Buff) :- $alloc_buff(Size,Buff,0,0,0).

$alloc_heap(Size, Buff) :- $alloc_buff(Size,Buff,1,0,0).

/* Type 0: perm, 1: heap, 2: from Supbuff */
$alloc_buff(Size,Buff,Type,Supbuff,Retcode) :- 
	$alloc_buff1(Size,Buff,Type,Supbuff,Retcode),
	(Retcode =\= 0 -> 
		$writename('alloc failed'),$nl,fail;
		true).
$alloc_buff1(Size,Buff,Type,Supbuff,Retcode) :- '_$builtin'(76).

$trimbuff(Size,Buff,Type) :- '_$builtin'(79).
$trimbuff(Size,Buff,Type,Supbuff) :- '_$builtin'(79).

$buff_code(Buff,Offset,Disc,Term) :- '_$builtin'(77).

/* Type = 0: no ep, 1: dynamic, 2: ep to compiled code, 3: buffer */
$symtype(Term,Type) :- '_$builtin'(42).

$substring(Dir,NumBytes,Const,Locin,Buff,Locout) :- '_$builtin'(51).

$subnumber(Dir,NumBytes,NumCon,Locin,Buff,Locout) :- '_$builtin'(52).

$subdelim(Dir,Delim,Const,Locin,Buff,Locout) :- '_$builtin'(53).

$conlength(Const,Len) :- print(Const), '_$builtin'(54).

$pred_undefined(Term) :- 
	$symtype(Term,D),
	(D=:=0;
	 D=\=0,D=:=3).

$hashval(Arg, Size, Hashval) :- '_$builtin'(43).

/* These routines put numbers into buffers in internet format */
$buff_putnum_n(Buff,Loc,Len,Num) :-
	Len =< 1 -> 
		$buff_code(Buff,Loc,30 /*pb*/ ,Num)
	/* else */ ;
		Byte is Num /\ 255,
		Rest is Num >> 8,
		Nlen is Len-1,Sloc is Loc+Nlen,
		$buff_code(Buff,Sloc,30 /*pb*/ ,Byte),
		$buff_putnum_n(Buff,Loc,Nlen,Rest).

$buff_getnum_n(Buff,Loc,Len,Num) :-
	Len =< 1 -> 
		$buff_code(Buff,Loc,31 /*gb*/ ,Num)
	/*else*/ ;
		Nlen is Len-1,Sloc is Loc+Nlen,
		$buff_code(Buff,Sloc,31,Byte),
		$buff_getnum_n(Buff,Loc,Nlen,Rest),
		Num is (Rest << 8) + Byte.

