/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $consult.P */

/* consult(Filename) consults the named file for interpretation.
   The second (optional) parameter to consult is a list of options.
   A `v' means verbose. An `e' means expand macros.  `t' means put trace
   points on any untraced predicate in the file being consulted. `q'
   means do a "quick" consult.
	(Macros are clauses with ::-. They are evaluated, if possible,
	at compile time. They MUST be PURE Horn clauses)
   The third (optional) parameter is used to return a list of
   predicate/arity pairs that were defined by the consult. This list
   can be passed to trace/1 so that they can be traced.
*/

$consult_export([$consult/1,$consult/2,$consult/3,$consult_list/1]).

/* $consult_use($blist,[$append/3,$member/2,$memberchk/2]).
   $consult_use($bio,[$writename/1,$writeqname/1,$put/1,$nl/0,$tab/1,
	$tell/1,$tell/2,$telling/1,$told/0,$get/1,$get0/1,$see/1,$seeing/1,
	$seen/0]).
   $consult_use($assert,[$assert/1,$asserti/2,$assert_union/2,$assert_call_s/1,
		$assert_get_prref/2,$assert_put_prref/2,$assert_abolish_i/1]).
   $consult_use($getclauses,[$getclauses/2,$getclauses/3,_]).
   $consult_use($bmeta,[$atom/1,$atomic/1,$integer/1,$number/1,$structure/1,
	$functor0/2,$bldstr/3,$arg/3,$arity/2,$real/1,$floor/2]).
   $consult_use($mac,[$macexp/3]).
*/

$consult(File) :- $consult(File,[e]).

$consult(File,Opts) :- not(not($consult(File,Opts,_))). /* side-effects only*/

$consult(File,Opts,Predlist) :-
	$atomic(File) ->
	     ($consultable(File) ->
	      	($getclauses(File,Clslist,Predlist),!,
	     	 $macexp(Clslist,Opts,Nclslist),
	     	 $consult_s(File,Nclslist,Opts),
	     	 $symtype('_$traced_preds'(_),Tr),
	     	 (Tr > 0 -> $consult_untrace(Predlist) ; true),
	     	 ($memberchk(t,Opts) -> $consult_trace(Predlist) ; true),
	      	 !
	     	) ;
		($print('** No such file: '), $print(File), $nl)
	     ) ;
	     ($print('** Illegal filename '), $print(File),
	      $print(' for consult: filename must be atomic'), $nl
	     ).

$consultable(user).
$consultable(File) :- $exists(File).

$consult_s(File,Clslist,Opts) :-
/*  Clslist is list of terms: pred(Pred,Arity,_,_,ClauseList)
	where Clauselist is a list of terms:
	fact(Fact,CpyFlagRest) or rule(Head,Body,CpyFlag,CpyFlagRest) */

	$member(pred(Pred,Arity,_,_,Clauselist),Clslist),
	$bldstr(Pred,Arity,Call),$consult_abolish(Call),	
	($member(v,Opts)->
	  $tab(15),$writename('including : '),$writename(Pred),
	  $writename('/'),$writename(Arity),$nl
	;
	  true),
	$consult_islist(Clauselist),
	$member(Factorrule,Clauselist),
	$consult_assert(Factorrule),
	fail.
$consult_s(_,_,_).

$consult_islist([]) :- !.
$consult_islist([_|Tail]) :- $consult_islist(Tail).

$consult_abolish(Goal) :- $buff_code(Goal,0,11,0).

$consult_assert(fact(Fact,_)) :- $assert(Fact).
$consult_assert(rule(Head,Body,_,_)) :-	$assert((Head:-Body)).

$consult_untrace([]).
$consult_untrace(['/'(P,N)|Prest]) :-
	('_$traced_preds'(P/N) ->
		($retract('_$traced_preds'(P/N)), trace(P/N)) ;
		true
	),
	$consult_untrace(Prest).

$consult_trace(L) :-
	$symtype('_$traced_preds'(_),N),
	(N > 0 -> $consult_trace1(L) ; trace(L)).

$consult_trace1([]).
$consult_trace1([P|Prest]) :-
	('_$traced_preds'(P) -> true ; trace(P)),
	$consult_trace1(Prest).

$consult_list([]).
$consult_list([H|T]) :- $consult_list1(H), $consult_list(T).

$consult_list1('-'(File)) :- !, $consult(File).
$consult_list1(File) :- $consult(File).

/* ------------------------------ $consult.P ------------------------------ */

