/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona,1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */

$currsym_export([$current_predicate/2,$current_predicate/3,$predicate_property/2,
		 $predicate_property/3, $current_functor/2,
		 $current_functor/3,$current_atom/1,$current_atom/2]).

$currsym_use($buff, [_,_,_,_,$symtype/2,_,_,_,_,_,_]).
$currsym_use($bmeta,[$atom/1,_,_,_,_,$functor0/2,_,_,_,_,_,$mkstr/3,_]).


$current_predicate(X,Y) :- $current_predicate(X,Y,_,0).
$current_predicate(X,Y,ShowAll) :- $current_predicate(X,Y,_,ShowAll).

$predicate_property(Pred,Prop) :- $predicate_property(Pred,Prop,0).

$predicate_property(Pred,interpreted,ShowAll) :-
     $current_predicate(_,Pred,1,ShowAll).
$predicate_property(Pred,compiled,ShowAll) :- 
     $current_predicate(_,Pred,2,ShowAll).

$current_predicate(X,Y,Type,ShowAll) :-
     (Type = 1 /* asserted */ ; Type = 2 /* compiled */ ),
     (var(Y) ->
          ($current_symbol(0,0,Type,0,X0,Y),
	   ((nonvar(X) ; ShowAll > 0) ->
	        true ;
		($external_symbol(X0), not($internal_pred(Y)))
	   ),
	   X0 = X
          ) ;
	  ($symtype(Y, Type),
	   $functor0(Y,X)
	  )
     ).

$current_functor(X,Y) :- $current_functor(X,Y,0).

$current_functor(X,Y,ShowAll) :-
     $current_symbol(0,0,0,0,X0,Y0),
     (ShowAll > 0 ->
         true ;
	 $external_symbol(X0)
     ),
     X0 = X,
     Y0 = Y.
$current_functor(X,Y,ShowAll) :- $current_predicate(X,Y,ShowAll).

$current_atom(X) :- $current_atom(X,0).

$current_atom(X,ShowAll) :-
     $current_symbol(0,0,0,0,X0,_),
     (ShowAll > 0 ->
         true ;
	 $external_symbol(X0)
     ),
     $atom(X0),
     X = X0.

$current_symbol(CurrBucket,CurrElt,Type,OldP,X,Y) :-
     $stlookup(CurrBucket,CurrElt,Type,OldP,NewBucket,NewElt,Psc),
     (($mkstr(Psc,Y,_),
       $functor0(Y,X)
      ) ;
      $current_symbol(NewBucket,NewElt,Type,1,X,Y)
     ).

$stlookup(A,B,C,D,E,F,G) :- '_$builtin'(14).

/* a symbol is considered an external symbol if its name does not begin
   with $ or _$.
*/

$external_symbol(X) :-
     $name(X,Xname),
     not( (Xname = [0'$ | _] ;
           Xname = [0'_, 0'$|_]
	  )
	).

$internal_pred(define_mod(_,_)).
$internal_pred(load(_)).
$internal_pred(writename(_)).
$internal_pred(writeqname(_)).
$internal_pred(put(_)).
$internal_pred(nl).
$internal_pred(tab(_)).
$internal_pred(tell(_)).
$internal_pred(telling(_)).
$internal_pred(told).
$internal_pred(get(_)).
$internal_pred(get0(_)).
$internal_pred(see(_)).
$internal_pred(seeing(_)).
$internal_pred(seen).
$internal_pred(write(_)).
$internal_pred(writeq(_)).
$internal_pred(display(_)).
$internal_pred(print(_)).
$internal_pred(print_al(_,_)).
$internal_pred(print_ar(_,_)).
$internal_pred(errmsg(_)).
$internal_pred(assert(_)).
$internal_pred(asserta(_)).
$internal_pred(asserta(_,_)).
$internal_pred(assertz(_)).
$internal_pred(assertz(_,_)).
$internal_pred(assert(_,_)).
$internal_pred(asserti(_,_)).
$internal_pred(assert(_,_,_,_)).
$internal_pred(assert_union(_,_)).
$internal_pred(atom(_)).
$internal_pred(atomic(_)).
$internal_pred(integer(_)).
$internal_pred(number(_)).
$internal_pred(structure(_)).
$internal_pred(functor0(_,_)).
$internal_pred(bldstr(_,_,_)).
$internal_pred(arg(_,_,_)).
$internal_pred(arity(_,_)).
$internal_pred(real(_)).
$internal_pred(float(_)).
$internal_pred(is_buffer(_)).
$internal_pred(functor(_,_,_)).
$internal_pred('=..'(_,_)).
$internal_pred(length(_,_)).
$internal_pred(name(_,_)).
$internal_pred(name0(_,_)).
$internal_pred(read(_)).
$internal_pred(read(_,_)).
$internal_pred('='(_,_)).
$internal_pred('<'(_,_)).
$internal_pred('=<'(_,_)).
$internal_pred('>='(_,_)).
$internal_pred('>'(_,_)).
$internal_pred('=:='(_,_)).
$internal_pred('=\='(_,_)).
$internal_pred(is(_,_)).
$internal_pred(eval(_,_)).
$internal_pred(var(_)).
$internal_pred(nonvar(_)).
$internal_pred(fail).
$internal_pred(true).
$internal_pred(halt).
$internal_pred(repeat).
$internal_pred(break).
$internal_pred(abort).
$internal_pred('?='(_,_)).
$internal_pred('\='(_,_)).
$internal_pred(cputime(_)).
$internal_pred(syscall(_,_,_)).
$internal_pred(system(_)).
$internal_pred(globalset(_)).
$internal_pred(gennum(_)).
$internal_pred(gensym(_,_)).
$internal_pred('=='(_,_)).
$internal_pred('\=='(_,_)).
$internal_pred('@=<'(_,_)).
$internal_pred('@<'(_,_)).
$internal_pred('@>'(_,_)).
$internal_pred('@>='(_,_)).
$internal_pred(compare(_,_,_)).
$internal_pred(debug).
$internal_pred(nodebug).
$internal_pred(trace(_)).
$internal_pred(untrace(_)).
$internal_pred(spy(_)).
$internal_pred(nospy(_)).
$internal_pred(debugging).
$internal_pred(tracepreds(_)).
$internal_pred(spypreds(_)).
$internal_pred(retract(_)).
$internal_pred(abolish(_)).
$internal_pred(abolish(_,_)).
$internal_pred(retractall(_)).
$internal_pred(consult(_)).
$internal_pred(consult(_,_)).
$internal_pred(consult(_,_,_)).
$internal_pred(alloc_perm(_,_)).
$internal_pred(alloc_heap(_,_)).
$internal_pred(trimbuff(_,_,_)).
$internal_pred(symtype(_,_)).
$internal_pred(substring(_,_,_,_,_,_)).
$internal_pred(subnumber(_,_,_,_,_,_)).
$internal_pred(subdelim(_,_,_,_,_,_)).
$internal_pred(conlength(_,_)).
$internal_pred(pred_undefined(_)).
$internal_pred(defint_call(_,_,_,_)).
$internal_pred(setof(_,_,_)).
$internal_pred(bagof(_,_,_)).
$internal_pred(findall(_,_,_)).
$internal_pred(sort(_,_)).
$internal_pred(keysort(_,_)).
$internal_pred(compile).
$internal_pred(compile(_)).
$internal_pred(compile(_,_)).
$internal_pred(compile(_,_,_)).
$internal_pred(compile(_,_,_,_)).
$internal_pred(getclauses(_,_)).
$internal_pred(getclauses(_,_,_)).
$internal_pred(attach(_,_)).
$internal_pred(expand_term(_,_)).
$internal_pred(append(_,_,_)).
$internal_pred(member(_,_)).
$internal_pred(et(_)).
$internal_pred(noet(_)).
$internal_pred(et_star(_)).
$internal_pred(et_points(_)).
$internal_pred(et_remove(_)).
$internal_pred(et_answers(_,_)).
$internal_pred(et_calls(_,_)).
$internal_pred(floatc(_,_,_)).
$internal_pred(exp(_,_)).
$internal_pred(square(_,_)).
$internal_pred(sin(_,_)).
$internal_pred(floor(_,_)).
$internal_pred(count(_)).
$internal_pred(time(_)).
$internal_pred(nocount(_)).
$internal_pred(notime(_)).
$internal_pred(profiling).
$internal_pred(prof_reset(_)).
$internal_pred(resetcount(_)).
$internal_pred(resettime(_)).
$internal_pred(profile).
$internal_pred(noprofile).
$internal_pred(timepreds(_)).
$internal_pred(countpreds(_)).
$internal_pred(prof_stats(_)).
$internal_pred(prof_stats).
$internal_pred(statistics).
$internal_pred(statistics(_,_)).
$internal_pred(dcg(_,_)).
$internal_pred(phrase(_,_)).
$internal_pred(phrase(_,_,_)).
$internal_pred(portray_term(_)).
$internal_pred(portray_clause(_)).
$internal_pred(clause(_,_)).
$internal_pred(clause(_,_,_)).
$internal_pred(listing(_)).
$internal_pred(instance(_,_)).
$internal_pred(listing).
$internal_pred(erase(_)).
$internal_pred(recorda(_,_,_)).
$internal_pred(recordz(_,_,_)).
$internal_pred(recorded(_,_,_)).
$internal_pred(current_predicate(_,_)).
$internal_pred(predicate_property(_,_)).
$internal_pred(current_functor(_,_)).
$internal_pred(current_atom(_)).
$internal_pred(loaded_mods(_)).
$internal_pred(defined_mods(_,_)).
$internal_pred(call(_)).
$internal_pred(','(_,_)).
$internal_pred(','(_,_,_,_)).
$internal_pred(';'(_,_)).
$internal_pred(not(_)).
$internal_pred('->'(_,_)).
$internal_pred('\+'(_)).
$internal_pred('$hashval'/3).
$internal_pred(hashval/3).

/* ------------------------------ $currsyms.P ------------------------------ */

