/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $defint.P */

$defint_export([$defint_call/4]).

/* $defint_use($bmeta,[$atom/1,$atomic/1,$integer/1,$number/1,$structure/1,
	$functor0/2,$bldstr/3,$arg/3,$arity/2,$real/1,$floor/2]).
   $defint_use($buff,
	[$alloc_perm/2,$alloc_heap/2,$trimbuff/3,$buff_code/4,$symtype/2,
		$substring/6,$subnumber/6,$subdelim/6,$conlength/2,
		$pred_undefined/1, $hashval/3]).
*/

$defint_call(Predterm,Arity,Genclfact,Introutine) :- 
	$arity(Genclfact,Arity1),
	(Arity=:=Arity1,
	    $defint_ercept(Predterm,Arity,Genclfact,Introutine)
	;
	 Arity=\=Arity1,
	    $defint_erpret(Predterm,Arity,Genclfact,Introutine)
	).

$defint_erpret(Predterm,Arity,Genclfact,'_$interp'(_,_)) :- !,
	/* for Predterm = p(X,Y) , 
	   and Genclfact = cl$p(_,_,_),
	   generate code for:
		p(A1,A2) :- _$savecp(CP),cl$p(A1,A2,B),_$interp(B,CP).
	*/
	Arity1 is Arity+1,	/* no-op if not! */
	$arity(Genclfact,Arity1),
	$alloc_perm(56,Buff),
        $opcode( allocate,   Op1 ),
	$opcode( getpbreg,   Op2 ),
	$opcode( putpvar,    Op3 ),
	$opcode( call,       Op4 ),
	$opcode( putuval,    Op5 ),
	$opcode( deallocate, Op6 ),
	$opcode( execute,    Op7 ),
	$buff_code(Buff,0,14 /*ptv*/ ,Buff), /* set back-ptr */
	$defint_code_list([Op1,0,		/* allocate		*/
			   Op2,2, 		/* getpbreg(2)		*/
			   Op3,0,3,Arity1,	/* putpvar(3,Arity+1)	*/
			   Op4,4 		/* call cl$??,4		*/
			  ],Buff,4),
	$buff_code(Buff,24,0 /*ppsc*/ ,Genclfact),
	$defint_code_list([Op5,0,3,1,		/* putuval(3,1)		*/
			   Op5,0,2,2,		/* putuval(2,2)		*/
			   Op6,0,		/* deallocate		*/
			   Op7,0		/* execute(_$interp)	*/
			  ],Buff,28),
	$buff_code(Buff,52,0 /*ppsc*/ ,'_$interp'(_,_)),
	$buff_code(Predterm,0,9 /*pep*/ ,Buff).

$defint_erpret(Predterm,Arity,Genclfact,'_$call'(_)) :- !,
	/* for Predterm = p(X,Y) , 
	   and Genclfact = cl$p(_,_,_),
	   generate code for:
		p(A1,A2) :- cl$p(A1,A2,B),_$call(B).
	*/
	$arity(Genclfact,Arity1),
	Arity1 is Arity+1, /* no-op if not! */
	$alloc_perm(44,Buff),
	$opcode( allocate,   Op1 ),
	$opcode( putpvar,    Op2 ),
	$opcode( call,       Op3 ),
	$opcode( putuval,    Op4 ),
	$opcode( deallocate, Op5 ),
	$opcode( execute,    Op6 ),
	$buff_code(Buff,0,14 /*ptv*/ ,Buff), /* set back-ptr */
	$defint_code_list([Op1,0,		/* allocate		*/
			   Op2,0,2,Arity1,	/* putpvar(2,Arity+1)	*/
			   Op3,3 		/* call cl$??,3		*/
			  ],Buff,4),
	$buff_code(Buff,20,0 /*ppsc*/ ,Genclfact),
	$defint_code_list([Op4,0,2,1,		/* putuval(2,1)		*/
			   Op5,0,		/* deallocate		*/
			   Op6,0		/* execute(_$call)	*/
			  ],Buff,24),
	$buff_code(Buff,40,0 /*ppsc*/ ,'_$call'(_)),
	$buff_code(Predterm,0,9 /*pep*/ ,Buff).

$defint_erpret(Predterm,Arity,Genclfact,Interprout) :- 
	/* for Predterm = p(X,Y) , 
	   and Genclfact = cl$p(_,_,_),
	   and Interprout = _$interpgoal(_,_)
	   generate instruction: unexeci cl$p,_$interpgoal
	*/
	$arity(Genclfact,Arity1),
	Arity1 is Arity+1, /* fail if not! */
	$alloc_perm(16,Buff),
	$buff_code(Buff,0,14 /*ptv*/ ,Buff), /* set back-ptr */
        $opcode( unexeci, UnxiOp ),
	$buff_code(Buff, 4, 3 /*ps*/ , UnxiOp ),
	$buff_code(Buff, 6, 3 /*ps*/ , 0 ),
	$buff_code(Buff, 8, 0 /*ppsc*/ ,Genclfact),
	$buff_code(Buff,12, 0 /*ppsc*/ ,Interprout),
	$buff_code(Predterm,0,9 /*pep*/ ,Buff).

$defint_ercept(Predterm,Arity,Genclfact,Interprout) :-
	/* for Predterm = p(X,Y) , 
	   and Genclfact = code$p(_,_),
	   and Interprout = _$traceintercept(_)
	   defines p(X,Y) :- _$traceintercept(code$p(X,Y)) by
	    	generating instruction: unexec code$p,_$traceintercept
	*/
	$arity(Genclfact,Arity),	/* error if not same arity */
	$alloc_perm(16,Buff),
	$buff_code(Buff,0,14 /*ptv*/ ,Buff), /* set back-ptr */
        $opcode( unexec, UnxOp ),
	$buff_code(Buff, 4, 3 /*ps*/ , UnxOp ),
	$buff_code(Buff, 6, 3 /*ps*/ , 0 ),
	$buff_code(Buff, 8, 0 /*ppsc*/ ,Genclfact),
	$buff_code(Buff,12, 0 /*ppsc*/ ,Interprout),
	$buff_code(Predterm,0,9 /*pep*/ ,Buff).

$defint_code_list([],_,_).
$defint_code_list([Byte|Rest],Buff,Loc) :-
	$buff_code(Buff,Loc,3 /*ps*/ ,Byte),
	Nextloc is Loc+2,
	$defint_code_list(Rest,Buff,Nextloc).
