/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $glob.P */

$glob_export([$globalset/1,$gennum/1,$gensym/2]).

/* 
$glob_use($bmeta,[$atom/1,$atomic/1,$integer/1,$number/1,$structure/1,
                  $functor0/2,$bldstr/3,$arg/3,$arity/2,$real/1,$floor/2]).
$glob_use($buff,[$alloc_perm/2,$alloc_heap/2,$trimbuff/3,$buff_code/4,
                 $symtype/2,$substring/6,$subnumber/6,$subdelim/6,$conlength/2,
		 $pred_undefined/1, $hashval/3]).
$glob_use($call,[call/1,'_$interp'/2,'_$call'/1]).
$glob_use($name,[$name/2,$name0/2]).
*/

$globalset(Place) :- 
	arg(1,Place,Value),
	$globalset(Place,Value).

$globalset(Place,Value) :-
	$symtype(Place,D),
	$globalsetinit(Place,D), 
	$globalset1(Place,Value).

$globalsetinit(_,1):- !. /* already initted */
$globalsetinit(_,3) :- !,fail. /* cannot use a buffer */
$globalsetinit(Place,_) :- /* init it */
	$alloc_perm(16,Buff),
	$buff_code(Buff,  0, 14 /*ptv*/ ,Buff), /* set back-ptr */
	$buff_code(Buff,  6,  3 /*ps*/ ,1),	/* set register num */
        $opcode( proceed, ProOp ),
	$buff_code(Buff, 12,  3 /*ps*/ , ProOp  /*proceed*/),
	$buff_code(Buff, 14,  3 /*ps*/ , 0),
	$buff_code(Place, 0,  9 /*pep*/, Buff).

$globalset1(Place,Value) :- 
	integer(Value) -> 
	     ($opcode( getnumcon, GetNOp ),
              $buff_code(Place, 0, 7 /*gepb*/ ,Buff),
	      $buff_code(Buff,  4, 3 /*ps*/   ,GetNOp /*getnumcon*/),
	      $buff_code(Buff,  8, 2 /*pn*/   ,Value)
	     ) ;
	(real(Value) ->
	     ($opcode( getfloatcon, GetFOp ),
              $buff_code(Place, 0,  7 /*gepb*/ ,Buff),
	      $buff_code(Buff,  4,  3 /*ps*/   ,GetFOp /*getfloatcon*/),
	      $buff_code(Buff,  8, 27 /*pf*/   ,Value)
	     ) ;
	($atom(Value) ->
	     ($opcode( getcon, GetCOp ),
              $buff_code(Place, 0, 7 /*gepb*/ ,Buff),
	      $buff_code(Buff,  4, 3 /*ps*/   ,GetCOp /*getcon*/),
	      $buff_code(Buff,  8, 1 /*pppsc*/,Value)
	     ) ;
	     ($opcode( getival, GetIvOp ),
              $buff_code(Place, 0,  7 /*gepb*/ ,Buff),  /* var(Value) */
	      $buff_code(Buff,  4,  3 /*ps*/   ,GetIvOp /*getival*/),
	      $buff_code(Buff,  6,  3 /*ps*/   ,1),
	      $buff_code(Buff,  8, 12 /*fv*/   ,0),
	      '_$call'(Place)
	     )
	)).

$gennum(0) :-
	$pred_undefined($globalgennum(_)),
	$globalset($globalgennum(1)),!. 
$gennum(N) :- 
	$globalgennum(N),
	N1 is N+1,
	$globalset($globalgennum(N1)).

$gensym(X,Y) :- $gennum(N),
	$name(X,Xname), $name(N,Nname), $glob_append(Xname,Nname,Yname),
	$name(Y,Yname).

$glob_append([],L,L).
$glob_append([X|L1],L2,[X|L3]) :- $glob_append(L1,L2,L3).
