/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $inlines.P */

$inlines_export(['='/2,'<'/2,'=<'/2,'>='/2,'>'/2,'=:='/2,
	'=\='/2,is/2,eval/2,'_$savecp'/1,'_$cutto'/1,var/1,nonvar/1,
	fail/0,true/0,halt/0,'?='/2,'\='/2]).

/* $inlines_use($bmeta,[$atom/1,$atomic/1,$integer/1,$number/1,$structure/1,
	$functor0/2,$bldstr/3,$arg/3,$arity/2,$real/1,$floor/2]).
*/

'='(X,X).
'<'(X,Y) :- eval(X,X1),eval(Y,Y1),X1<Y1.
'=<'(X,Y) :- eval(X,X1),eval(Y,Y1),X1=<Y1.
'>='(X,Y) :- eval(X,X1),eval(Y,Y1),X1>=Y1.
'>'(X,Y) :- eval(X,X1),eval(Y,Y1),X1>Y1.
'=:='(X,Y) :- eval(X,X1),eval(Y,Y1),X1 =:= Y1.
'=\='(X,Y) :- eval(X,X1),eval(Y,Y1),X1 =\= Y1.
is(Head, Expr) :- eval(Expr, Head).

eval(X, Y) :- var(X), !, write('Integer required'), fail.
eval(X, Y) :- $number(X), X=Y.
eval([X], X) :- $number(X).
eval('+'(X,Y), Res) :- eval(X, Res1), eval(Y, Res2), Res is Res1 + Res2.
eval('-'(X,Y), Res) :- eval(X, Res1), eval(Y, Res2), Res is Res1 - Res2.
eval('*'(X,Y), Res) :- eval(X, Res1), eval(Y, Res2), Res is Res1 * Res2.
eval('/'(X,Y), Res) :- eval(X, Res1), eval(Y, Res2), Res is Res1 / Res2.
eval('//'(X,Y), Res) :- eval(X, Res1), eval(Y, Res2), Res is Res1 // Res2.
eval(mod(X,Y), Res) :- eval(X, Res1), eval(Y, Res2), Res is Res1 mod Res2.
eval('-'(X), Res) :- eval(X, Res1), Res is -(Res1).
eval('/\'(X,Y), Res) :- eval(X, Res1), eval(Y, Res2), Res is Res1 /\ Res2.
eval('\/'(X,Y), Res) :- eval(X, Res1), eval(Y, Res2), Res is Res1 \/ Res2.
eval('<<'(X,Y), Res) :- eval(X, Res1), eval(Y, Res2), Res is Res1 << Res2.
eval('>>'(X,Y), Res) :- eval(X, Res1), eval(Y, Res2), Res is Res1 >> Res2.
eval('\'(X), Res) :- eval(X, Res1), Res is '\'(Res1).


'_$savecp'(C) :- '_$savecp'(D),D=C.
'_$cutto'(C) :- '_$cutto'(C).
/* builtin must be compiled */

var(X) :- '_$builtin'(64).
nonvar(X) :- '_$builtin'(65).

/* when they really are inlines then use the following
var(X) :- var(X).
nonvar(X) :- nonvar(X). */

fail :- fail.
true.
halt :- halt.

'?='(X,Y) :- X ?= Y.

'\='(X,Y) :- X \= Y.

