/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* io.P */

$io_export([$write/1,$writeq/1,$display/1,$print/1,$print_al/2,$print_ar/2,
	    $errmsg/1]).

/* $io_use($bio,[$writename/1,$writeqname/1,$put/1,$nl/0,$tab/1,
	$tell/1,$tell/2,$telling/1,$told/0,$get/1,$get0/1,$see/1,$seeing/1,
	$seen/0]).
   $io_use($bmeta,[$atom/1,$atomic/1,$integer/1,$number/1,$structure/1,
	$functor0/2,$bldstr/3,$arg/3,$arity/2,$real/1,$floor/2]).
*/

$write(T) :- $write(T,999).

$write(T,_) :- var(T), !, $writename(T).
$write([],_) :- !, $writename([]).
$write([X|Y],_) :- !, $put(0'[), $write(X,999), $writetail(Y).
$write(T,Prec) :- $structure(T), !, $functor0(T, P), $arity(T, N), 
  (N=:=1 ->
    ($read_curr_op(Opprec,fx,P) ->
	Nprec is Opprec-1,$writepreop(P,T,Prec,Opprec,Nprec);
     $read_curr_op(Opprec,fy,P) ->
	$writepreop(P,T,Prec,Opprec,Opprec);
     $read_curr_op(Opprec,xf,P) ->
	Nprec is Opprec-1,$writepostop(P,T,Prec,Opprec,Nprec);
     $read_curr_op(Opprec,yf,P) ->
	$writepostop(P,T,Prec,Opprec,Opprec);
	$writestr(P,N,T)
    );
   N=:=2 ->
    ($read_curr_op(Opprec,xfx,P) ->
	Nprec is Opprec-1,$writebinop(P,T,Prec,Opprec,Nprec,Nprec);
     $read_curr_op(Opprec,xfy,P) ->
	Nprec is Opprec-1,$writebinop(P,T,Prec,Opprec,Nprec,Opprec);
     $read_curr_op(Opprec,yfx,P) ->
	Nprec is Opprec-1,$writebinop(P,T,Prec,Opprec,Opprec,Nprec);
	$writestr(P,N,T)
    );
   $writestr(P,N,T)
  ).

$write(T,_) :- $writename(T).

$writestr(P,N,T) :-
        $writename(P), $put(0'(), arg(1, T, X), $write(X,999),
        $writearg(T, N, 1), $put(0')).

$writebinop(Op,Term,Oldp,Curp,Newlp,Newrp) :- 
	arg(1,Term,Arg1),
	arg(2,Term,Arg2),
	(Curp > Oldp -> 
		$put(0'(),
		$write(Arg1,Newlp),$tab(1),$writename(Op),
		$tab(1),$write(Arg2,Newrp),
		$put(0'))
	      ;
		$write(Arg1,Newlp),$tab(1),$writename(Op),
		$tab(1),$write(Arg2,Newrp)
	).


$writepreop(Op,Term,Oldp,Curp,Newp) :- 
	arg(1,Term,Arg),
	(Curp > Oldp -> 
		$put(0'(),
		$writename(Op),$tab(1),$write(Arg,Newp),
		$put(0'))
	      ;
		$writename(Op),$tab(1),$write(Arg,Newp)
	).

$writepostop(Op,Term,Oldp,Curp,Newp) :- 
	arg(1,Term,Arg),
	(Curp > Oldp -> 
		$put(0'(),
		$write(Arg,Newp),$tab(1),$writename(Op),
		$put(0'))
	      ;
		$write(Arg,Newp),$tab(1),$writename(Op)
	).

$writearg(T, N, N) :- !.
$writearg(T, N, M) :- L is M + 1, $put(0',), arg(L, T, X),
        $write(X,999), $writearg(T, N, L).

$writetail(X) :- var(X), ! , $put(0'|), $writename(X), $put(0']).
$writetail([X|Y]) :- !, $put(0',), $write(X,999), $writetail(Y).
$writetail([]) :- !, $put(0']).
$writetail(X) :- $put(0'|), $write(X,999), $put(0']).


$writeq(T) :- var(T), !, $writeqname(T).
$writeq((X,Y)) :- !, $put(40), $writeq(X), $put(44), $writeqcommatail(Y).
    $writeqcommatail(X) :- var(X), ! , $writeqname(X), $put(41).
    $writeqcommatail((X,Y)) :- !, $writeq(X), $put(44), $writeqcommatail(Y).
    $writeqcommatail(X) :- $writeq(X), $put(41).
$writeq([]) :- !, $writeqname([]).
$writeq([X|Y]) :- !, $put(91), $writeq(X), $writeqtail(Y).
    $writeqtail(X) :- var(X), ! , $put(124),
			$writeqname(X), $put(93).
    $writeqtail([X|Y]) :- !, $put(44),
                           $writeq(X), $writeqtail(Y).
    $writeqtail([]) :- !, $put(93).
    $writeqtail(X) :- $put(124),
			$writeq(X), $put(93).
$writeq(T) :- $structure(T), !, $functor0(T, P), $arity(T, N), 
        $writeqname(P), $put(40), arg(1, T, X), $writeq(X),
        $writeqarg(T, N, 1), $put(41).
    $writeqarg(T, N, N) :- !.
    $writeqarg(T, N, M) :- L is M + 1, $put(44), arg(L, T, X),
        $writeq(X), $writeqarg(T, N, L).
$writeq((':-')) :- !, $put(40), $writeqname((':-')), $put(41).
$writeq(T) :- $writeqname(T).

$display(X) :- $telling(OStr), $tell(user), $write(X), $told, $tell(OStr).

$print(X) :-
     var(X) ->
          $write(X) ;
	  ($symtype(portray(_),PType),
           (PType > 0 ->
               portray(X) ;
	       $write(X)
	   )
	  ).

$print_al(N,A) :-
    integer(N) ->
	($conlength(A,ALen),
	 (ALen >= N -> NTab is 0 ; NTab is N - ALen),
	 $print(A),
	 $tab(NTab)
	) ;
	$errmsg('*** illegal input to print_al ***').

$print_ar(N,A) :-
    integer(N) ->
	($conlength(A,ALen),
	 (ALen >= N -> NTab is 0 ; NTab is N - ALen),
	 $tab(NTab),
	 $print(A)
	) ;
	$errmsg('*** illegal input to print_ar ***').

$errmsg(X) :-
     $telling(CurrOut), $tell(stderr), $write(X), $nl, $told, $tell(CurrOut).

/* ------------------------------ $io.P ------------------------------ */
