/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $meta.P */

$meta_export([$functor/3,$univ/2,$length/2]).

/* $meta_use($bmeta,[$atom/1,$atomic/1,$integer/1,$number/1,$structure/1,
	$functor0/2,$bldstr/3,$arg/3,$arity/2,$real/1,$floor/2]).
*/

$univ(X, [H|T]) :- nonvar(X), !, $functor(X, H, N), $arglist(X, T, N, N).
$univ(X, [X]) :- $atomic(X).
$univ(X, [H|T]) :- $atom(H), $length(T, N), N > 0, 
			$bldstr(H, N, X), $arglist(X, T, N, N).
$arglist(X, [], 0, N) :- !.
$arglist(X, [Y|Z], I, N) :- K is I - 1,
				J is N - K,
				arg(J, X, Y), 
				$arglist(X, Z, K, N).

$functor(T, F, 0) :- $atomic(T), !, T=F.
$functor(T, F, 0) :- $number(F), !, T=F.
$functor(T, F, N) :- nonvar(T), !, $functor0(T, F), $arity(T, N).
$functor(T, F, N) :- $bldstr(F, N, T).

$length(L,N) :- nonvar(L),$length(L,0,N).

$length([],N,N).
$length([_|L],M,N) :- M1 is M+1, $length(L,M1,N).

