/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $o.P */

$o_export([$write/1,$writeq/1,$display/1,$print/1,$print_al/2, $print_ar/2]).

$o_use($bio,[$writename/1,$writeqname/1,$put/1,$nl/0,$tab/1,
	$tell/1,$telling/1,$told/0,$get/1,$get0/1,$see/1,$seeing/1,$seen/0]).

$o_use($bmeta,[$atom/1,$atomic/1,$integer/1,$number/1,$structure/1,
	$functor0/2,$bldstr/3,$arg/3,$arity/2,$real/1,$floor/2]).

$o_use($meta,[$functor/3,$univ/2,$length/2]).

$write(T) :- var(T), !, $writename(T).
$write((X,Y)) :- !, $put(40), $write(X), $writecommatail(Y).
    $writecommatail(X) :- var(X), ! , $writename(X), $put(41).
    $writecommatail((X,Y)) :- !, $put(44), $write(X), $writecommatail(Y).
    $writecommatail(X) :- $put(44), $write(X), $put(41).
$write([]) :- !, $writename([]).
$write([X|Y]) :- !, $put(91), $write(X), $writetail(Y).
    $writetail(X) :- var(X), ! , $put(124), $writename(X), $put(93).
    $writetail([X|Y]) :- !, $put(44), $write(X), $writetail(Y).
    $writetail([]) :- !, $put(93).
    $writetail(X) :- $put(124), $write(X), $put(93).
$write(T) :- $structure(T), !, $functor0(T, P), $arity(T, N), 
        $writename(P), $put(40), arg(1, T, X), $write(X),
        $writearg(T, N, 1), $put(41).
    $writearg(T, N, N) :- !.
    $writearg(T, N, M) :- L is M + 1, $put(44), arg(L, T, X),
        $write(X), $writearg(T, N, L).
$write(T) :- $writename(T).


$writeq(T) :- var(T), !, $writeqname(T).
$writeq((X,Y)) :- !, $put(40), $writeq(X), $writeqcommatail(Y).
    $writeqcommatail(X) :- var(X), ! , $writeqname(X), $put(41).
    $writeqcommatail((X,Y)) :- !, $put(44), $writeq(X), $writeqcommatail(Y).
    $writeqcommatail(X) :- $put(44), $writeq(X), $put(41).
$writeq([]) :- !, $writeqname([]).
$writeq([X|Y]) :- !, $put(91), $writeq(X), $writeqtail(Y).
    $writeqtail(X) :- var(X), ! , $put(124),
			$writeqname(X), $put(93).
    $writeqtail([X|Y]) :- !, $put(44),
                           $writeq(X), $writeqtail(Y).
    $writeqtail([]) :- !, $put(93).
    $writeqtail(X) :- $put(124),
			$writeq(X), $put(93).
$writeq(T) :- $structure(T), !, $functor0(T, P), $arity(T, N), 
        $writeqname(P), $put(40), arg(1, T, X), $writeq(X),
        $writeqarg(T, N, 1), $put(41).
    $writeqarg(T, N, N) :- !.
    $writeqarg(T, N, M) :- L is M + 1, $put(44), arg(L, T, X),
        $writeq(X), $writeqarg(T, N, L).
$writeq((':-')) :- !, $put(40), $writeqname((':-')), $put(41).
$writeq(T) :- $writeqname(T).


$display(X) :- $write(X).


$print(X) :- telling(Fi),tell(user),write(X),tell(Fi).

$print_al(N,A) :-
    integer(N) ->
	($conlength(A,ALen),
	 (ALen >= N -> NTab is 0 ; NTab is N - ALen),
	 $print(A),
	 $tab(NTab)
	) ;
	($print('*** illegal input to print_al ***'), $nl).

$print_ar(N,A) :-
    integer(N) ->
	($conlength(A,ALen),
	 (ALen >= N -> NTab is 0 ; NTab is N - ALen),
	 $tab(NTab),
	 $print(A)
	) ;
	($print('*** illegal input to print_ar ***'), $nl).

/* ------------------------------ $o.P ------------------------------ */
