/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona,1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */

$portray_export([$portray_term/1,$portray_clause/1]).

$portray_use($name,[$name/2,_]).
$portray_use($io,[$write/1,_,_,_,_,_]).

$portray_term(T) :- not(not($portray_term(T,0,_))).

$portray_term(X,N,N1) :-
     $portray_namevars(X,N,N1),
     $write(X).

$portray_namevars(X,N,N1) :-
	var(X), !,
	$name(N,Nname),
	$append("V",Nname,XName),
	$name(X,XName),
	N1 is N + 1.
$portray_namevars(A,N,N) :- atomic(A), !.
$portray_namevars(Str,N,N1) :-
	$arity(Str,Arity),
	$portray_namevars_str(1,Arity,Str,N,N1).

$portray_namevars_str(Arg,Arity,Str,N0,N1) :-
	Arg > Arity ->
	     N1 = N0 ;
	     (arg(Arg,Str,Sub),
	      $portray_namevars(Sub,N0,N2),
	      NextArg is Arg + 1,
	      $portray_namevars_str(NextArg,Arity,Str,N2,N1)
	     ).

$portray_clause(Clause) :- not(not($portray_clause(Clause,0,_))).

$portray_clause((H :- B),N0,N2) :-
	!,
	$portray_term(H,N0,N1),
	(B ?= true ->
	     true ;
	     ($write(' :- '),
	      ($portray_CompoundGoal(B) -> ($nl, T = 4) ; T = 0),
	      $portray_body(B,T,4,N1,N2)
	     )
	),
	$write('.'),
	$nl.
$portray_clause(Fact,N1,N2) :-
	$portray_term(Fact),
	$write('.'),
	$nl.

$portray_body(','(G1,G2),LT,RT,N0,N2) :-
    !,
    ($portray_CompoundGoal(G1) ->
         ($tab(LT), $write('('), T1 = 0) ;
	 T1 = LT
    ),
    $portray_body(G1,T1,RT,N0,N1), 
    ($portray_CompoundGoal(G1) ->
         ($nl, $tab(LT), $write(')')) ;
	 true
    ),
    $write(','), $nl,
    (($portray_CompoundGoal(G2), G2 \= ','(_,_)) ->
         Parens = 1 ; Parens = 0
    ),
    (Parens =:= 1 ->
         ($tab(LT), $write('('), T2 = 0) ;
	 T2 = RT
    ),
    $portray_body(G2,T2,RT,N1,N2),
    (Parens =:= 1 ->
         ($nl, $tab(LT), $write(')')) ;
	 true
    ).
$portray_body(';'('->'(If,Then),Else),LT,RT,N0,N2) :-
    !,
    ($portray_CompoundGoal(If) ->
         ($tab(LT), $write('('),
	  $portray_conj(If,N0,N1),
	  $write(')')
	 ) ;
	 $portray_body(If,LT,RT,N0,N1)
    ),
    $write(' ->'), $nl,
    T1 is RT + 4,
    $portray_body(';'(Then,Else),T1,T1,N1,N2).
$portray_body(';'(G1,G2),LT,RT,N0,N2) :-
    !,
    ($portray_CompoundGoal(G1) ->
         ($tab(LT), $write('('), T1 = 0) ;
	 T1 = LT
    ),
    $portray_body(G1,T1,RT,N0,N1), 
    ($portray_CompoundGoal(G1) ->
         ($nl, $tab(LT), $write(')')) ;
	 true
    ),
    $write(' ;'), $nl,
    (($portray_CompoundGoal(G2), G2 \= ';'(_,_)) ->
          Parens = 1 ; Parens = 0
    ),
    (Parens =:= 1 ->
         ($tab(LT), $write('('), $nl, T2 is LT + 1) ;
	 T2 = LT
    ),
    $portray_body(G2,T2,RT,N1,N2),
    (Parens =:= 1 ->
         ($nl, $tab(LT), $write(')')) ;
	 true
    ).
$portray_body(C,T,_,N0,N1) :-
    $tab(T),
    $portray_term(C,N0,N1).

$portray_conj(','(C1,C2),N0,N1) :-
     !,
     $portray_conj(C1,N0,N2),
     $write(', '),
     $portray_conj(C2,N2,N1).
$portray_conj(';'('->'(If,Then),Else),N0,N1) :-
     !,
     $write('( '),
     $portray_conj(If,N0,N2), $write(' -> '),
     $portray_conj(Then,N2,N3), $write(' ; '),
     $portray_conj(Else,N3,N1), $write(' )').
$portray_conj(';'(C1,C2),N0,N1) :-
     !,
     $write('( '),
     $portray_conj(C1,N0,N2), $write(' ;'),
     $portray_conj(C2,N2,N1), $write(' )').
$portray_conj('->'(C1,C2),N0,N1) :-
     !,
     $write('( '),
     $portray_conj(C1,N0,N2), $write(' -> '),
     $portray_conj(C2,N2,N1), $write(' )').
$portray_conj(Lit,N0,N1) :- $portray_term(Lit,N0,N1).

$portray_CompoundGoal(','(_,_)).
$portray_CompoundGoal(';'(_,_)).
$portray_CompoundGoal('->'(_,_)).

/* --------------------------- $portray.P --------------------------- */

