/************************************************************************
*									*
* The SB-Prolog System							*
* Copyright SUNY at Stony Brook, 1986; University of Arizona, 1987	*
*									*
************************************************************************/

/*-----------------------------------------------------------------
SB-Prolog is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the SB-Prolog General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
SB-Prolog, but only under the conditions described in the
SB-Prolog General Public License.   A copy of this license is
supposed to have been given to you along with SB-Prolog so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies. 
------------------------------------------------------------------ */
/* $prorc.P */

/* This file is called when $readloop is initializing the system.
   It gives the user a chance to set up the defined_mods/2 predicate
   so that the standard system (or some other) predicates will be
   automatically loaded on need. 
   Use $define_mod(Modname,Implist) to specify default loading of Modname
   when a predicate in Implist is invoked. Implist must correspond to
   the export list of Modname.
*/

$prorc :- $prorc_bio,$prorc_io,$prorc_assert,$prorc_bmeta,$prorc_meta,
	$prorc_name,$prorc_read,$prorc_inlines,$prorc_osys,$prorc_glob,
	$prorc_compare,$prorc_deb,$prorc_retr,$prorc_consult,$prorc_buff,
	$prorc_defint,$prorc_setof,$prorc_db,$prorc_compile,$prorc_mod,
	$prorc_prag,$prorc_blist,$prorc_listutil1,$prorc_mac, $prorc_et,
	$prorc_arith, $prorc_prof, $prorc_stat, $prorc_dcg, $prorc_portray,
	$prorc_decompile, $prorc_record, $prorc_currsyms, $prorc_opcode,
	$prorc_funrel.

/* $prorc_init_sys :-
	$define_mod('$init_sys',[define_mod/2,load/1,$load_mod/1]),
	$define_mod('$init_sys',[$define_mod/2,$load/1,$load_mod/1]), */

$prorc_bio :-
	$define_mod($bio,[writename/1,writeqname/1,put/1,nl/0,tab/1,
		tell/1,tell/2,telling/1,told/0,get/1,get0/1,see/1,seeing/1,
		seen/0,_]),
	$define_mod($bio,[$writename/1,$writeqname/1,$put/1,$nl/0,$tab/1,
		$tell/1,$tell/2,$telling/1,$told/0,$get/1,$get0/1,$see/1,
		$seeing/1,$seen/0,$write4/1]).

$prorc_io :-
	$define_mod($io,[write/1,writeq/1,display/1,print/1,print_al/2,
			print_ar/2,errmsg/1]),
	$define_mod($io,[$write/1,$writeq/1,$display/1,$print/1,
			$print_al/2,$print_ar/2,$errmsg/1]).

$prorc_assert :-
	$define_mod($assert,[assert/1,asserta/1,asserta/2,assertz/1,assertz/2,
		assert/2,asserti/2,assert/4,assert_union/2, $assert_call_s/1,
		$assert_get_prref/2,$assert_put_prref/2,$assert_abolish_i/1]),
	$define_mod($assert,[$assert/1,$asserta/1,$asserta/2,$assertz/1,$assertz/2,
		$assert/2,$asserti/2,$assert/4,$assert_union/2,$assert_call_s/1,
		$assert_get_prref/2,$assert_put_prref/2,$assert_abolish_i/1]).

$prorc_bmeta :-
	$define_mod($bmeta,[atom/1,atomic/1,integer/1,number/1,
	   structure/1,functor0/2,bldstr/3,arg/3,arity/2,real/1,
	   float/1, _,is_buffer/1]),
	$define_mod($bmeta,[$atom/1,$atomic/1,$integer/1,$number/1,
	   $structure/1,$functor0/2,$bldstr/3,$arg/3,$arity/2,$real/1,
	   $float/1,$mkstr/3, $is_buffer/1]).

$prorc_meta :-
	$define_mod($meta,[functor/3,'=..'/2,length/2]),
	$define_mod($meta,[$functor/3,$univ/2,$length/2]).

$prorc_name :-
	$define_mod($name,[name/2,name0/2]),
	$define_mod($name,[$name/2,$name0/2]).

$prorc_read :-
	$define_mod($read,[read/1,read/2]),
	$define_mod($read,[$read/1,$read/2]).

$prorc_inlines :-
	$define_mod($inlines,['='/2,'<'/2,'=<'/2,'>='/2,'>'/2,'=:='/2,
	'=\='/2,is/2,eval/2,'_$savecp'/1,'_$cutto'/1,var/1,nonvar/1,
	fail/0,true/0,halt/0,'?='/2,'\='/2]).

$prorc_osys :-
	$define_mod($osys,[cputime/1,syscall/3,$system/2,system/1]),
	$define_mod($osys,[$cputime/1,$syscall/3,$system/2,$system/1]).

$prorc_glob :-
	$define_mod($glob,[globalset/1,gennum/1,gensym/2]),
	$define_mod($glob,[$globalset/1,$gennum/1,$gensym/2]).

$prorc_compare :-
	$define_mod($compare,['=='/2,'\=='/2,'@=<'/2,'@<'/2,'@>'/2,'@>='/2,
		compare/3]),
	$define_mod($compare,['$=='/2,_,_,_,_,_,$compare/3]).

$prorc_deb :-
	$define_mod($deb,[debug/0,nodebug/0,trace/1,untrace/1,
		(spy)/1,(nospy)/1,trace/0,untrace/0,debugging/0,tracepreds/1,spypreds/1]),
	$define_mod($deb,[$debug/0,$nodebug/0,$trace/1,$untrace/1,
		($spy)/1,($nospy)/1,$trace/0,$untrace/0,$debugging/0,$deb_tracepreds/1,$deb_spypreds/1]).

$prorc_retr :-
	$define_mod($retr,[retract/1,abolish/1,abolish/2,$update/2,
		$retractall/1]),
	$define_mod($retr,[$retract/1,$abolish/1,abolish/2,_,retractall/1]).

$prorc_consult :-
	$define_mod($consult,[consult/1,consult/2,consult/3,_]),
	$define_mod($consult,[$consult/1,$consult/2,$consult/3,$consult_list/1]).

$prorc_buff :-
	$define_mod($buff,[alloc_perm/2,alloc_heap/2,trimbuff/3,_,
		symtype/2,
		substring/6,subnumber/6,subdelim/6,conlength/2,
		pred_undefined/1, hashval/3]),
	$define_mod($buff,[$alloc_perm/2,$alloc_heap/2,$trimbuff/3,
		$buff_code/4,$symtype/2,
		$substring/6,$subnumber/6,$subdelim/6,$conlength/2,
		$pred_undefined/1, $hashval/3]).

$prorc_defint :-
	$define_mod($defint,[defint_call/4]),
	$define_mod($defint,[$defint_call/4]).

$prorc_setof :-
	$define_mod($setof,[setof/3,bagof/3,findall/3,sort/2,_]),
	$define_mod($setof,[$setof/3,$bagof/3,$findall/3,$sort/2,$keysort/3]).

$prorc_db :-
	$define_mod($db,[$db_new_prref/1,$db_assert_fact/5,
		$db_assert_fact/7, $db_add_clref/5,
		$db_call_prref/2,$db_call_prref_s/2,$db_call_prref_s/3,
		$db_call_clref/2,$db_get_clauses/3,$db_kill_clause/1]).

$prorc_compile :-
	$define_mod($compile,[compile/0,compile/1,compile/2,compile/3,
		compile/4]),
	$define_mod($compile,[$compile/0,$compile/1,$compile/2,$compile/3,
		$compile/4]).

$prorc_mod :-
	$define_mod($getclauses,[getclauses/2,getclauses/3,attach/2,expand_term/2]),
	$define_mod($getclauses,[$getclauses/2,$getclauses/3,$attach/2,$expand_term/2]).

$prorc_prag :-
	$define_mod($prag,[get_prag/2]),
	$define_mod($prag,[$get_prag/2]).

$prorc_blist :-
	$define_mod($blist,[$append/3,$member/2,$memberchk/2,$not_memberchk/2]),
	$define_mod($blist,[_,_,$member1/2,$not_member1/2]).

$prorc_listutil1 :-
	$define_mod($listutil1,[$reverse/2,$merge/3,$absmember/2,$absmerge/3,
		$nthmember/3,$nthmember1/3,$member2/2,$closetail/1]).

$prorc_mac :-
	$define_mod($mac,[$macexp/3]).

$prorc_et :-
	$define_mod($et, [et/1,noet/1,et_star/1,et_points/1,
	    et_remove/1,et_answers/2,et_calls/2]).
$prorc_arith :-
	$define_mod($arith,[$floatc/3,$exp/2,$square/2,$sin/2,$floor/2]),
	$define_mod($arith,[floatc/3,exp/2,square/2,sin/2,floor/2]).


$prorc_prof :-
	$define_mod($prof, [$count/1,$time/1,$nocount/1,$notime/1,
		$profiling/0,$prof_reset/1, $prof_resetcount/1,
		$prof_resettime/1,$profile/0,$noprofile/0,$timepreds/1,
		$countpreds/1, $prof_stats/0, $prof_stats/1]),
	$define_mod($prof, [count/1,time/1,nocount/1,notime/1,
		profiling/0,prof_reset/1,resetcount/1,
		resettime/1,profile/0,noprofile/0,timepreds/1,
		countpreds/1,prof_stats/0, prof_stats/1]).

$prorc_stat :-
	$define_mod($statistics,[$statistics/0,$statistics/2]),
	$define_mod($statistics,[statistics/0,statistics/2]).

$prorc_dcg :-
	$define_mod($dcg, [$dcg/2,$phrase/2,$phrase/3]),
	$define_mod($dcg, [dcg/2,phrase/2,phrase/3]).

$prorc_portray :-
	$define_mod($portray,[$portray_term/1,$portray_clause/1]),
	$define_mod($portray,[portray_term/1,portray_clause/1]).

$prorc_decompile :-
	$define_mod($decompile,[$clause/2,$clause/3,$listing/1,$instance/2,$listing/0]),
	$define_mod($decompile,[clause/2,clause/3,listing/1,instance/2,listing/0]).

$prorc_record :-
	$define_mod($record,[erase/1,recorda/3,recordz/3,recorded/3]),
	$define_mod($record,[$erase/1,$recorda/3,$recordz/3,$recorded/3]).

$prorc_currsyms :-
	$define_mod($currsym,[$current_predicate/2,$current_predicate/3,
		    $predicate_property/2,$predicate_property/3,$current_functor/2,
		    $current_functor/3,$current_atom/1,$current_atom/2]),
	$define_mod($currsym,[current_predicate/2,$current_predicate/3,
		    predicate_property/2,$predicate_property/3,current_functor/2,
		    $current_functor/3,current_atom/1,$current_atom/2]).

$prorc_opcode :- $define_mod($opcode,[$opcode/2,$opcode/3,$instruction/2]).

$prorc_funrel :- $define_mod($funrel,[$fun_rel/2,$expand_body/2]).

